/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.validation;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.ConnectorConnectionPool;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.enterprise.config.serverbeans.JmsService;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.validation.DomainMgr;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.validation.StringManagerHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.PrintStream;
import java.util.Vector;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

public class DomainXmlVerifier {
    public ConfigContext configContext;
    public DomainMgr domainMgr;
    public String domainFile;
    public boolean error;
    public boolean debug = false;
    public static int count = 0;
    PrintStream _out;
    static Logger _logger = LogDomains.getLogger((String)"javax.enterprise.system.tools.verifier");
    static LocalStringManagerImpl smh;

    public DomainXmlVerifier(String file) throws Exception {
        this(file, System.out);
    }

    public DomainXmlVerifier(String file, PrintStream out) throws Exception {
        this._out = out;
        this.domainFile = file;
        this.configContext = ConfigFactory.createConfigContext((String)file);
        this.configContext.refresh();
        this.domainMgr = new DomainMgr(this.configContext, true);
        this.error = false;
    }

    public DomainMgr getDomainMgr() {
        return this.domainMgr;
    }

    public ConfigContext getConfigContext() {
        return this.configContext;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public void output(Result result) {
        String element = result.getAssertion();
        String key = result.getTestName();
        if (!result.getErrorDetails().toString().equals("[]")) {
            this.error = true;
            this.out("Element  : " + element);
            if (key != null) {
                this.out("Key      : " + key);
            }
            Vector error = result.getErrorDetails();
            for (int i = 0; i < error.size(); ++i) {
                if (i == 0) {
                    this.out("Error    : " + error.get(i));
                    continue;
                }
                if (i <= 0) continue;
                this.out("           " + error.get(i));
            }
            this.out("");
            ++count;
        }
    }

    public void check(ConfigBean configBean) {
        ConfigContextEvent cce = new ConfigContextEvent(this.getConfigContext(), "PRE_ADD_CHANGE", configBean.toString(), (Object)configBean, "VALIDATE");
        cce.setClassObject((Object)configBean.parent());
        Result result = this.domainMgr.check(cce);
        if (result != null) {
            this.output(result);
        }
    }

    public void checkUnique(ConfigBean configBean) {
        try {
            Domain domain = (Domain)this.configContext.getRootConfigBean();
            Resources resource = domain.getResources();
            this.checkDuplicate("connector-connection-pool", (ConfigBean[])resource.getConnectorConnectionPool(), "name");
            ConnectorConnectionPool[] connpool = resource.getConnectorConnectionPool();
            for (int i = 0; i < connpool.length; ++i) {
                this.checkDuplicate("security-map", (ConfigBean[])connpool[i].getSecurityMap(), "name");
            }
            Applications applications = domain.getApplications();
            Configs configs = domain.getConfigs();
            this.checkDuplicate("config", (ConfigBean[])configs.getConfig(), "name");
            Config[] config = configs.getConfig();
            for (int i = 0; i < config.length; ++i) {
                HttpService httpservice = config[i].getHttpService();
                this.checkDuplicate("http-listener", (ConfigBean[])httpservice.getHttpListener(), "id");
                this.checkDuplicate("virtual-server", (ConfigBean[])httpservice.getVirtualServer(), "id");
                IiopService iiopservice = config[i].getIiopService();
                this.checkDuplicate("iiop-listener", (ConfigBean[])iiopservice.getIiopListener(), "id");
                AdminService adminservice = config[i].getAdminService();
                this.checkDuplicate("jmx-connector", (ConfigBean[])adminservice.getJmxConnector(), "name");
                JmsService jmsservice = config[i].getJmsService();
                this.checkDuplicate("jms-host", (ConfigBean[])jmsservice.getJmsHost(), "name");
                SecurityService securityservice = config[i].getSecurityService();
                this.checkDuplicate("audit-module", (ConfigBean[])securityservice.getAuditModule(), "name");
                this.checkDuplicate("auth-realm", (ConfigBean[])securityservice.getAuthRealm(), "name");
                this.checkDuplicate("jacc-provider", (ConfigBean[])securityservice.getJaccProvider(), "name");
            }
            Servers servers = domain.getServers();
            this.checkDuplicate("server", (ConfigBean[])servers.getServer(), "name");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void checkDuplicate(String elementName, ConfigBean[] cb, String attr) {
        Result result = new Result();
        result.setAssertion(elementName);
        for (int i = 0; i < cb.length - 1; ++i) {
            String name = cb[i].getAttributeValue(attr);
            for (int j = i + 1; j < cb.length; ++j) {
                if (!name.equals(cb[j].getAttributeValue(attr))) continue;
                result.failed("Duplicate Element : " + cb[j] + "(" + attr + "=" + name + ")");
                this.output(result);
            }
        }
    }

    public void preOrder(ConfigBean configBean) {
        if (configBean != null) {
            this.check(configBean);
            ConfigBean[] configBean1 = configBean.getAllChildBeans();
            if (configBean1 != null) {
                for (int j = 0; j < configBean1.length; ++j) {
                    if (configBean1[j] == null) continue;
                    this.preOrder(configBean1[j]);
                }
            }
        }
    }

    public void out(String out) {
        if (count < 50) {
            this._out.println(out);
        } else if (count >= 50 && this.debug) {
            this._out.println(out);
        }
    }

    public boolean validate() {
        try {
            this.checkUnique(this.configContext.getRootConfigBean());
            this.preOrder(this.configContext.getRootConfigBean());
            if (!this.error) {
                this._out.println("All Tests Passed, domain.xml is valid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.error;
    }

    public boolean invokeConfigValidator() {
        boolean failed = false;
        try {
            failed = this.validate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return failed;
    }

    public static void main(String[] args) throws ConfigException {
        File f;
        int i = 0;
        if (args.length < 1) {
            System.out.println("Usage : verify-domain-xml [--verbose] domain_xml_file");
            return;
        }
        boolean isDebug = false;
        if (args[i].startsWith("--verbose")) {
            if (args.length == 1) {
                System.out.println("Usage : verify-domain-xml [--verbose]  domain_xml_file");
                return;
            }
            isDebug = true;
            ++i;
        }
        if (!(f = new File(args[i])).exists()) {
            System.out.println("Error Config file: " + args[i] + " is not found");
            return;
        }
        String file = args[i];
        boolean fileCheck = false;
        boolean classCheck = false;
        try {
            DomainXmlVerifier validator = new DomainXmlVerifier(file);
            if (isDebug) {
                validator.debug = true;
            }
            validator.invokeConfigValidator();
        }
        catch (ConfigException ce) {
            Throwable cause;
            for (cause = ce.getCause(); cause != null && !(cause instanceof SAXParseException); cause = cause.getCause()) {
            }
            if (cause != null) {
                System.out.println("XML: " + cause.getMessage());
            } else {
                ce.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        StringManagerHelper.setLocalStringsManager(DomainXmlVerifier.class);
        smh = StringManagerHelper.getLocalStringsManager();
    }
}

