/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.SMFService;
import com.sun.enterprise.admin.servermgmt.ServiceHandler;
import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMFServiceHandler
implements ServiceHandler {
    private static final StringManager sm = StringManager.getManager(SMFServiceHandler.class);
    private boolean trace = false;

    @Override
    public void createService(Map<String, String> params) throws RuntimeException {
        SMFService smf = new SMFService(params);
        boolean success = false;
        try {
            smf.isConfigValid();
            if (this.trace) {
                this.printOut(smf.toString());
            }
            this.testPlatform();
            this.validateManifest(smf.getManifestFilePath());
            this.tokenReplaceTemplateAtDestination(smf);
            this.validateService(smf);
            success = this.importService(smf);
        }
        catch (Exception e) {
            if (!success) {
                this.cleanupManifest(smf);
            }
            throw new RuntimeException(e);
        }
    }

    private void testPlatform() throws Exception {
        if (!OS.isSolaris10()) {
            String os = System.getProperty("os.name");
            String vr = System.getProperty("os.version");
            String msg = sm.getString("notSolaris10", (Object)os, (Object)vr);
            throw new IllegalArgumentException(msg);
        }
    }

    private void validateManifest(String manifestPath) throws Exception {
        File manifest = new File(manifestPath);
        if (manifest.exists()) {
            String msg = sm.getString("smfManifestExists", (Object)manifest.getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        if (manifest.getParentFile().exists()) {
            String msg = sm.getString("smfManifestFolderExists", (Object)manifest.getParentFile().getAbsolutePath());
            throw new IllegalArgumentException(msg);
        }
        manifest.getParentFile().mkdirs();
        if (this.trace) {
            this.printOut("Manifest validated: " + manifestPath);
        }
    }

    private void tokenReplaceTemplateAtDestination(SMFService smf) throws Exception {
        LineTokenReplacer tr = new LineTokenReplacer(this.map2Set(smf.tokensAndValues()));
        tr.replace(smf.getManifestFileTemplatePath(), smf.getManifestFilePath());
        if (this.trace) {
            this.printOut("Manifest configured: " + smf.getManifestFilePath());
        }
    }

    private TokenValueSet map2Set(Map<String, String> map) throws Exception {
        HashSet<TokenValue> set = new HashSet<TokenValue>();
        Set<String> keys = map.keySet();
        for (String key : keys) {
            String value = map.get(key);
            TokenValue tv = new TokenValue(key, value);
            set.add(tv);
        }
        TokenValueSet tvset = new TokenValueSet(set);
        return tvset;
    }

    private void validateService(SMFService smf) throws Exception {
        String[] cmda = new String[]{"svccfg", "validate", smf.getManifestFilePath()};
        ProcessExecutor pe = new ProcessExecutor(cmda);
        pe.execute();
        if (this.trace) {
            this.printOut("Validated the SMF Service: " + smf.getFQSN() + " using: " + "svccfg");
        }
    }

    private boolean importService(SMFService smf) throws Exception {
        String[] cmda = new String[]{"svccfg", "import", smf.getManifestFilePath()};
        ProcessExecutor pe = new ProcessExecutor(cmda);
        pe.execute();
        if (this.trace) {
            this.printOut("Imported the SMF Service: " + smf.getFQSN());
        }
        return true;
    }

    private void cleanupManifest(SMFService smf) throws RuntimeException {
        File failedServiceNode;
        File manifest = new File(smf.getManifestFilePath());
        if (manifest.exists()) {
            manifest.delete();
            manifest.deleteOnExit();
            if (this.trace) {
                this.printOut("Attempted deleting failed service manifest: " + manifest.getAbsolutePath());
            }
        }
        if ((failedServiceNode = manifest.getParentFile()).exists()) {
            failedServiceNode.delete();
            failedServiceNode.deleteOnExit();
            if (this.trace) {
                this.printOut("Attempted deleting failed service folder: " + failedServiceNode.getAbsolutePath());
            }
        }
    }

    private void printOut(String s) {
        System.out.println(s);
    }

    @Override
    public void setTrace(boolean trace) {
        this.trace = trace;
    }
}

