/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.util.ProcessExecutor;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMFService {
    public static final String DATE_CREATED_TN = "DATE_CREATED";
    public static final String SERVICE_NAME_TN = "NAME";
    public static final String SERVICE_TYPE_TN = "TYPE";
    public static final String CFG_LOCATION_TN = "LOCATION";
    public static final String ENTITY_NAME_TN = "ENTITY_NAME";
    public static final String FQSN_TN = "FQSN";
    public static final String AS_ADMIN_PATH_TN = "AS_ADMIN_PATH";
    public static final String AS_ADMIN_USER_TN = "AS_ADMIN_USER";
    public static final String AS_ADMIN_PASSWORD_TN = "AS_ADMIN_PASSWORD";
    public static final String AS_ADMIN_MASTERPASSWORD_TN = "AS_ADMIN_MASTERPASSWORD";
    public static final String PASSWORD_FILE_PATH_TN = "PASSWORD_FILE_PATH";
    public static final String TIMEOUT_SECONDS_TN = "TIMEOUT_SECONDS";
    public static final String OS_USER_TN = "OS_USER";
    public static final String PRIVILEGES_TN = "PRIVILEGES";
    public static final String TIMEOUT_SECONDS_DV = "0";
    public static final String AS_ADMIN_USER_DEF_VAL = "admin";
    public static final String SVCCFG = "svccfg";
    public static final String SP_DELIMITER = ":";
    public static final String PRIVILEGES_DEFAULT_VAL = "basic";
    public static final String NETADDR_PRIV_VAL = "net_privaddr";
    public static final String BASIC_NETADDR_PRIV_VAL = "basic,net_privaddr";
    public static final String START_INSTANCES_TN = "START_INSTANCES";
    public static final String START_INSTANCES_DEFAULT_VAL = Boolean.TRUE.toString();
    public static final String NO_START_INSTANCES_PROPERTY = "startinstances=false";
    public static final String MANIFEST_HOME = "/var/svc/manifest/application/SUNWappserver/";
    private static final String NULL_VALUE = "null";
    private static final String SERVICE_NAME_PREFIX = "application/SUNWappserver/";
    private static final StringManager sm = StringManager.getManager(SMFService.class);
    private static final String nullArgMsg = sm.getString("null_arg");
    private static final String MANIFEST_FILE_SUFFIX = "-service-smf.xml";
    private static final String MANIFEST_FILE_TEMPL_SUFFIX = "-service-smf.xml.template";
    private final Map<String, String> pairs;

    public SMFService() {
        this.pairs = new HashMap<String, String>();
        this.init();
    }

    public SMFService(Map<String, String> tv) {
        if (tv == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        this.pairs = new HashMap<String, String>(tv);
    }

    public String getName() {
        return this.pairs.get(SERVICE_NAME_TN);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        String fullName = SERVICE_NAME_PREFIX + name;
        if (this.serviceNameExists(fullName)) {
            String msg = sm.getString("serviceNameExists", (Object)fullName);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(SERVICE_NAME_TN, fullName);
    }

    public AppserverServiceType getType() {
        return AppserverServiceType.valueOf(this.pairs.get(SERVICE_TYPE_TN));
    }

    public void setType(AppserverServiceType type) {
        this.pairs.put(SERVICE_TYPE_TN, type.toString());
    }

    public String getDate() {
        return this.pairs.get(DATE_CREATED_TN);
    }

    public void setDate(String date) {
        if (date == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        this.pairs.put(DATE_CREATED_TN, date);
    }

    public String getLocation() {
        return this.pairs.get(CFG_LOCATION_TN);
    }

    public void setLocation(String cfgLocation) {
        if (cfgLocation == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        File cf = FileUtils.safeGetCanonicalFile(new File(cfgLocation));
        this.pairs.put(CFG_LOCATION_TN, cf.getParent());
        this.pairs.put(ENTITY_NAME_TN, cf.getName());
    }

    public String getFQSN() {
        return this.pairs.get(FQSN_TN);
    }

    public void setFQSN() {
        assert (!NULL_VALUE.equals(this.pairs.get(SERVICE_NAME_TN))) : "Internal: Caller tried to call this method before setName()";
        String underscored = this.pairs.get(ENTITY_NAME_TN) + this.pairs.get(CFG_LOCATION_TN).replace('/', '_');
        this.pairs.put(FQSN_TN, underscored);
    }

    public String getAsadminPath() {
        return this.pairs.get(AS_ADMIN_PATH_TN);
    }

    public void setAsadminPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        if (!new File(path).exists()) {
            String msg = sm.getString("doesNotExist", (Object)path);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(AS_ADMIN_PATH_TN, path);
    }

    public String getPasswordFilePath() {
        return this.pairs.get(PASSWORD_FILE_PATH_TN);
    }

    public void setPasswordFilePath(String path) {
        HashMap<String, String> tv;
        if (path == null) {
            throw new IllegalArgumentException(nullArgMsg);
        }
        String msg = null;
        if (!new File(path).exists()) {
            msg = sm.getString("doesNotExist", (Object)path);
            throw new IllegalArgumentException(msg);
        }
        String cp = FileUtils.safeGetCanonicalPath(new File(path));
        if (!this.fileContainsToken(cp, AS_ADMIN_USER_TN, tv = new HashMap<String, String>())) {
            msg = sm.getString("missingParamsInFile", (Object)cp, (Object)AS_ADMIN_USER_TN);
            throw new IllegalArgumentException(msg);
        }
        if (!this.fileContainsToken(cp, AS_ADMIN_PASSWORD_TN, tv)) {
            msg = sm.getString("missingParamsInFile", (Object)cp, (Object)AS_ADMIN_PASSWORD_TN);
            throw new IllegalArgumentException(msg);
        }
        if (!this.fileContainsToken(path, AS_ADMIN_MASTERPASSWORD_TN, tv)) {
            msg = sm.getString("missingParamsInFile", (Object)cp, (Object)AS_ADMIN_MASTERPASSWORD_TN);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(AS_ADMIN_USER_TN, (String)tv.get(AS_ADMIN_USER_TN));
        this.pairs.put(PASSWORD_FILE_PATH_TN, cp);
    }

    public int getTimeoutSeconds() {
        int to = Integer.parseInt(this.pairs.get(TIMEOUT_SECONDS_TN));
        return to;
    }

    public void setTimeoutSeconds(int number) {
        Integer to = new Integer(number);
        if (to < 0) {
            String msg = sm.getString("invalidTO", (Object)number);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(TIMEOUT_SECONDS_TN, to.toString());
    }

    public String getOSUser() {
        return this.pairs.get(OS_USER_TN);
    }

    public void setOSUser() {
        String user = System.getProperty("user.name");
        if (!this.canCreateManifest()) {
            String msg = sm.getString("noPermissionToCreateManifest", (Object)user, (Object)MANIFEST_HOME);
            throw new IllegalArgumentException(msg);
        }
        StringBuilder auths = new StringBuilder();
        if (!this.isUserSmfAuthorized(user, auths)) {
            String msg = sm.getString("noSmfAuth", (Object)user, (Object)auths);
            throw new IllegalArgumentException(msg);
        }
        this.pairs.put(OS_USER_TN, user);
    }

    public String getServiceProperties() {
        return this.pairs.get(PRIVILEGES_TN);
    }

    public void setServiceProperties(String cds) {
        if (cds != null) {
            Set<String> props = this.ps2Pairs(cds);
            if (props.contains(NETADDR_PRIV_VAL)) {
                this.pairs.put(PRIVILEGES_TN, BASIC_NETADDR_PRIV_VAL);
            }
            if (props.contains(NO_START_INSTANCES_PROPERTY)) {
                this.pairs.put(START_INSTANCES_TN, Boolean.FALSE.toString());
            }
        }
    }

    public boolean isConfigValid() {
        Set<String> keys = this.pairs.keySet();
        for (String k : keys) {
            boolean aNullValue = NULL_VALUE.equals(this.pairs.get(k));
            if (!aNullValue) continue;
            String msg = sm.getString("smfTokenNeeded", (Object)k, (Object)this.pairs.get(k));
            throw new RuntimeException(msg);
        }
        File mf = new File(this.getManifestFileTemplatePath());
        if (!mf.exists()) {
            String msg = sm.getString("serviceTemplateNotFound", (Object)this.getManifestFileTemplatePath());
            throw new RuntimeException(msg);
        }
        return true;
    }

    public Map<String, String> tokensAndValues() {
        return new HashMap<String, String>(this.pairs);
    }

    public String getManifestFilePath() {
        String fqsn = this.getFQSN();
        if (NULL_VALUE.equals(fqsn)) {
            String msg = sm.getString("serviceNameInvalid", (Object)fqsn);
            throw new RuntimeException(msg);
        }
        String fn = MANIFEST_HOME + fqsn + "/" + this.getType().toString() + MANIFEST_FILE_SUFFIX;
        return fn;
    }

    public String getManifestFileTemplatePath() {
        if (NULL_VALUE.equals(this.getType().toString())) {
            String msg = sm.getString("serviceTypeNotSet");
            throw new RuntimeException(msg);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("com.sun.aas.installRoot"));
        if (sb.charAt(sb.length() - 1) == '/') {
            sb.setLength(sb.length() - 1);
        }
        sb.append("/lib/install/templates/");
        sb.append(this.getType().toString());
        sb.append(MANIFEST_FILE_TEMPL_SUFFIX);
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String[] ka = new String[this.pairs.size()];
        Arrays.sort(this.pairs.keySet().toArray(ka));
        for (String n : ka) {
            sb.append(n).append("=").append(this.pairs.get(n)).append(System.getProperty("line.separator"));
        }
        return sb.toString();
    }

    private void init() {
        this.pairs.put(DATE_CREATED_TN, new Date().toString());
        this.pairs.put(SERVICE_NAME_TN, NULL_VALUE);
        this.pairs.put(SERVICE_TYPE_TN, NULL_VALUE);
        this.pairs.put(CFG_LOCATION_TN, NULL_VALUE);
        this.pairs.put(ENTITY_NAME_TN, NULL_VALUE);
        this.pairs.put(FQSN_TN, NULL_VALUE);
        this.pairs.put(START_INSTANCES_TN, START_INSTANCES_DEFAULT_VAL);
        this.pairs.put(AS_ADMIN_PATH_TN, NULL_VALUE);
        this.pairs.put(AS_ADMIN_USER_TN, AS_ADMIN_USER_DEF_VAL);
        this.pairs.put(PASSWORD_FILE_PATH_TN, NULL_VALUE);
        this.pairs.put(TIMEOUT_SECONDS_TN, TIMEOUT_SECONDS_DV);
        this.pairs.put(OS_USER_TN, NULL_VALUE);
        this.pairs.put(PRIVILEGES_TN, PRIVILEGES_DEFAULT_VAL);
    }

    private Set<String> ps2Pairs(String cds) {
        StringTokenizer p = new StringTokenizer(cds, SP_DELIMITER);
        HashSet<String> tokens = new HashSet<String>();
        while (p.hasMoreTokens()) {
            tokens.add(p.nextToken());
        }
        return tokens;
    }

    private boolean canCreateManifest() {
        File mh = new File(MANIFEST_HOME);
        boolean ok = true;
        if (!mh.exists()) {
            ok = mh.mkdirs();
        }
        if (ok && !mh.canWrite()) {
            ok = false;
        }
        return ok;
    }

    private boolean isUserSmfAuthorized(String user, StringBuilder auths) {
        boolean authorized = false;
        String path2Auths = "auths";
        String at = ",";
        String AUTH1 = "solaris.*";
        String AUTH2 = "solaris.smf.*";
        String AUTH3 = "solaris.smf.modify";
        if (System.getProperty("PATH_2_AUTHS") != null) {
            path2Auths = System.getProperty("PATH_2_AUTHS");
        }
        if (System.getProperty("AUTH_TOKEN") != null) {
            at = System.getProperty("AUTH_TOKEN");
        }
        try {
            String[] cmd = new String[]{path2Auths, user};
            ProcessExecutor pe = new ProcessExecutor(cmd);
            pe.setExecutionRetentionFlag(true);
            pe.execute();
            auths.append(pe.getLastExecutionOutput());
            StringTokenizer st = new StringTokenizer(pe.getLastExecutionOutput(), at);
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t != null) {
                    t = t.trim();
                }
                if (!"solaris.*".equals(t) && !"solaris.smf.*".equals(t) && !"solaris.smf.modify".equals(t)) continue;
                authorized = true;
                break;
            }
            return authorized;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean fileContainsToken(String path, String t, Map<String, String> tv) throws RuntimeException {
        BufferedInputStream bis = null;
        try {
            boolean present = false;
            bis = new BufferedInputStream(new FileInputStream(path));
            Properties p = new Properties();
            p.load(bis);
            if (p.containsKey(t)) {
                tv.put(t, (String)p.get(t));
                present = true;
            }
            boolean bl = present;
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception ee) {}
            }
        }
    }

    private boolean serviceNameExists(String sn) {
        boolean exists = false;
        try {
            String[] cmd = new String[]{"svcs", sn};
            ProcessExecutor pe = new ProcessExecutor(cmd);
            pe.setExecutionRetentionFlag(true);
            pe.execute();
            exists = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exists;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AppserverServiceType {
        Domain,
        NodeAgent;

    }
}

