/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.stats.spi;

import com.sun.enterprise.admin.monitor.stats.CountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.JVMThreadStats;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatistic;
import com.sun.enterprise.admin.monitor.stats.MutableCountStatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StatisticImpl;
import com.sun.enterprise.admin.monitor.stats.StringStatistic;
import com.sun.enterprise.admin.monitor.stats.StringStatisticImpl;
import com.sun.enterprise.util.i18n.StringManager;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import javax.management.j2ee.statistics.CountStatistic;
import javax.management.j2ee.statistics.Statistic;

public class JVMThreadStatsImpl
implements JVMThreadStats {
    private GenericStatsImpl baseStatsImpl;
    private static final String STATS_INTERFACE_NAME = "com.sun.enterprise.admin.monitor.stats.JVMThreadStats";
    private ThreadMXBean bean;
    private MutableCountStatistic curThreadCpuTime;
    private MutableCountStatistic daemonThreadCount;
    private MutableCountStatistic peakThreadCount;
    private MutableCountStatistic threadCount;
    private MutableCountStatistic totalStartedThreadCount;
    final long initTime = System.currentTimeMillis();
    static String DELIMITER = ",";
    private static final StringManager localStrMgr = StringManager.getManager(JVMThreadStatsImpl.class);

    public JVMThreadStatsImpl() {
        try {
            this.baseStatsImpl = new GenericStatsImpl(STATS_INTERFACE_NAME, (Object)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.bean = ManagementFactory.getThreadMXBean();
        this.initializeStatistics();
    }

    public StringStatistic getAllThreadIds() {
        long[] ids = this.bean.getAllThreadIds();
        String idString = new String();
        for (int i = 0; i < ids.length; ++i) {
            idString = idString.concat(String.valueOf(ids[i]));
            idString = idString.concat(DELIMITER);
        }
        return new StringStatisticImpl(idString, localStrMgr.getString("monitor.stats.live_threads"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.live_threads_desc"), this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getCurrentThreadCPUTime() {
        this.curThreadCpuTime.setCount(this.bean.getCurrentThreadCpuTime());
        return (CountStatistic)this.curThreadCpuTime.unmodifiableView();
    }

    public CountStatistic getDaemonThreadCount() {
        this.daemonThreadCount.setCount(this.bean.getDaemonThreadCount());
        return (CountStatistic)this.daemonThreadCount.unmodifiableView();
    }

    public StringStatistic getMonitorDeadlockedThreads() {
        long[] ids = this.bean.findMonitorDeadlockedThreads();
        String idString = new String();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                idString = idString.concat(String.valueOf(ids[i]));
                idString = idString.concat(DELIMITER);
            }
        }
        if (ids == null || ids.length == 0) {
            idString = idString.concat(localStrMgr.getString("monitor.stats.no_thread_deadlock"));
        }
        return new StringStatisticImpl(idString, localStrMgr.getString("monitor.stats.dlocked_threads"), localStrMgr.getString("monitor.stats.string_units"), localStrMgr.getString("monitor.stats.dlocked_threads_desc"), this.initTime, System.currentTimeMillis());
    }

    public CountStatistic getPeakThreadCount() {
        this.peakThreadCount.setCount(this.bean.getPeakThreadCount());
        return (CountStatistic)this.peakThreadCount.unmodifiableView();
    }

    public CountStatistic getThreadCount() {
        this.threadCount.setCount(this.bean.getThreadCount());
        return (CountStatistic)this.threadCount.unmodifiableView();
    }

    public CountStatistic getTotalStartedThreadCount() {
        this.totalStartedThreadCount.setCount(this.bean.getTotalStartedThreadCount());
        return (CountStatistic)this.totalStartedThreadCount.unmodifiableView();
    }

    public Statistic[] getStatistics() {
        return this.baseStatsImpl.getStatistics();
    }

    public Statistic getStatistic(String str) {
        return this.baseStatsImpl.getStatistic(str);
    }

    public String[] getStatisticNames() {
        return this.baseStatsImpl.getStatisticNames();
    }

    private void initializeStatistics() {
        CountStatisticImpl c = new CountStatisticImpl(localStrMgr.getString("thread_cpu_time"), localStrMgr.getString("monitor.stats.nano_sec_units"), localStrMgr.getString("thread_cpu_time_desc"));
        this.curThreadCpuTime = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.daemon_thread_count"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.daemon_thread_count_desc"));
        this.daemonThreadCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.peak_thread_count"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.peak_thread_count_desc"));
        this.peakThreadCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.thread_count"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.thread_count_desc"));
        this.threadCount = new MutableCountStatisticImpl(c);
        c = new CountStatisticImpl(localStrMgr.getString("monitor.stats.started_thread_count"), StatisticImpl.DEFAULT_UNIT, localStrMgr.getString("monitor.stats.started_thread_count_desc"));
        this.totalStartedThreadCount = new MutableCountStatisticImpl(c);
    }
}

