/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.monitor.callflow;

import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.EndTimeTO;
import com.sun.enterprise.admin.monitor.callflow.TableAccessObject;
import com.sun.enterprise.admin.monitor.callflow.TransferObject;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EndTimeAccessObjectImpl
extends AbstractTableAccessObject {
    private static final Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    private static EndTimeAccessObjectImpl _singletonET;

    private EndTimeAccessObjectImpl() {
        String serverName = super.getServerInstanceName();
        this.tableName = "END_TIME_TBL" + serverName.toUpperCase();
    }

    public static TableAccessObject getInstance() {
        if (_singletonET == null) {
            _singletonET = new EndTimeAccessObjectImpl();
        }
        return _singletonET;
    }

    public boolean insert(PreparedStatement pstmt, TransferObject[] transferObject) {
        if (pstmt == null) {
            return false;
        }
        boolean result = false;
        try {
            for (int i = 0; i < transferObject.length; ++i) {
                EndTimeTO endTimeTO = (EndTimeTO)transferObject[i];
                pstmt.setString(1, endTimeTO.getRequestId());
                pstmt.setLong(2, endTimeTO.getTimeStamp());
                pstmt.setString(3, endTimeTO.getContainerTypeOrApplicationType());
                pstmt.addBatch();
            }
            int[] updated = pstmt.executeBatch();
            result = updated.length == transferObject.length;
        }
        catch (BatchUpdateException bue) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", bue);
            result = false;
        }
        catch (SQLException se) {
            logger.log(Level.FINE, "Error inserting data into CallFlow tables", se);
            result = false;
        }
        return result;
    }

    public boolean dropTable(Connection connection) {
        this.con = connection;
        return super.createStatmentAndExecuteUpdate("drop table END_TIME_TBL", "END_TIME_TBL");
    }

    public boolean createTable(Connection connection) {
        this.con = connection;
        return super.createTable(" create table END_TIME_TBL ( REQUEST_ID VARCHAR(255)  NOT NULL  , TIME_STAMP BIGINT  NOT NULL  , CONT_TYPE_OR_APP_TYPE VARCHAR(20)  NOT NULL  ,  primary key (REQUEST_ID , TIME_STAMP , CONT_TYPE_OR_APP_TYPE))", "END_TIME_TBL");
    }

    public String getInsertSQL() {
        String newsql = super.updateSqlWithTableName(" INSERT INTO END_TIME_TBL VALUES  (  ?, ?, ?   ) ", "END_TIME_TBL");
        return newsql;
    }

    public String getDeleteSQL() {
        String newsql = super.updateSqlWithTableName(" DELETE  FROM END_TIME_TBL WHERE REQUEST_ID =  ? ", "END_TIME_TBL");
        return newsql;
    }
}

