/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.common;

import com.sun.enterprise.admin.common.exception.PortInUseException;
import com.sun.enterprise.admin.util.Debug;
import com.sun.enterprise.admin.util.SOMLocalStringsManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;

public class NetUtil {
    public static final int kMaxPortNo = 65535;
    private static Random random = new Random();
    private static SOMLocalStringsManager localizedStrMgr = SOMLocalStringsManager.getManager(NetUtil.class);

    public static void checkPortAvailability(int port) throws PortInUseException {
        ServerSocket trialSocket = null;
        try {
            trialSocket = new ServerSocket(port);
        }
        catch (IOException ioe) {
            String msg = localizedStrMgr.getString("admin.common.port_in_use", new String(port + ""));
            throw new PortInUseException(msg);
        }
        finally {
            try {
                if (trialSocket != null) {
                    trialSocket.close();
                }
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static boolean isPortAvalable(int portNo) {
        boolean available = true;
        try {
            NetUtil.checkPortAvailability(portNo);
        }
        catch (Exception e) {
            available = false;
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFreePort() {
        Class<NetUtil> clazz = NetUtil.class;
        synchronized (NetUtil.class) {
            for (int i = 0; i < 1024; ++i) {
                int nextInt = random.nextInt(65535);
                if (nextInt <= 1024 || !NetUtil.isPortAvalable(nextInt)) continue;
                // ** MonitorExit[var0] (shouldn't be in output)
                return nextInt;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return 0;
        }
    }
}

