/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.tree;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.enterprise.tools.admingui.tree.IndexTreeModel;
import com.sun.enterprise.tools.admingui.tree.IndexTreeNode;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.management.ObjectName;
import org.w3c.dom.Element;

public class DynamicTreeNode
extends IndexTreeNode
implements Serializable {
    private Map webServiceKeyMap = new HashMap();

    public DynamicTreeNode(IndexTreeNode parent, String type, String name, IndexTreeModel model) {
        super(parent, type, name, model);
    }

    protected void ensureChildren() {
        block4: {
            if (this.dynamicChild == null) {
                return;
            }
            if (!this.getRefresh()) {
                return;
            }
            try {
                HashSet newNames = new HashSet();
                this.updateKids(this.dynamicChild, newNames);
                this.removeDeletedNodes(newNames);
            }
            catch (Exception ex) {
                if (!Util.isLoggableINFO()) break block4;
                Util.logINFO("ERROR in IndexTreeNode.ensureChildren.", ex);
            }
        }
        this.setRefresh(false);
    }

    private void updateKids(Element element, HashSet newNames) {
        HashMap params = new HashMap();
        this.loadParams(element, params);
        Object[] objs = this.getChildObjectNames(params);
        if (objs == null) {
            return;
        }
        if (objs instanceof ObjectName[]) {
            ObjectName[] objectNames = (ObjectName[])objs;
            for (int i = 0; i < objectNames.length; ++i) {
                if (!this.isChildValid(objectNames[i])) continue;
                String name = null;
                String attributeName = (String)params.get("attributeName");
                String attrNameMethod = (String)params.get("attrNameMethod");
                if (attributeName != null && attributeName.length() > 0) {
                    name = (String)MBeanUtil.getAttribute(objectNames[i], attributeName);
                } else if (attrNameMethod != null && attrNameMethod.length() > 0) {
                    name = (String)MBeanUtil.invoke(objectNames[i], attrNameMethod, null, null);
                }
                if (name == null) {
                    name = objectNames[i].toString();
                }
                newNames.add(name);
                this.createNode(element, name, objectNames[i]);
            }
        } else if (objs instanceof String[]) {
            String[] objectNames = (String[])objs;
            String isWebService = (String)params.get("isWebService");
            for (int i = 0; i < objectNames.length; ++i) {
                String name = objectNames[i];
                newNames.add(name);
                IndexTreeNode node = this.createNode(element, name, objectNames[i]);
                if (node == null || isWebService == null || !isWebService.equals("true")) continue;
                node.setAttribute("webServiceKey", this.webServiceKeyMap.get(name));
                node.setAttribute("webServiceName", name);
            }
        } else {
            if (Util.isLoggableINFO()) {
                NonSyncStringBuffer buf = new NonSyncStringBuffer();
                buf.append("Illegal type for tree processing:\n");
                buf.append("    TYPE: " + objs.getClass().getName() + "\n");
                buf.append("    OBJECT NAME: " + params.get("objectName") + "\n");
                buf.append("    METHOD NAME: " + params.get("methodName") + "\n");
                Util.logINFO(buf.toString());
            }
            throw new RuntimeException("Illegal type for tree processing");
        }
    }

    private Object[] getChildObjectNames(HashMap params) {
        String objectName = (String)params.get("objectName");
        String isWebService = (String)params.get("isWebService");
        Object[] o = null;
        if (isWebService != null && isWebService.equals("true")) {
            String appName;
            String fullName;
            String name;
            this.webServiceKeyMap.clear();
            String attributeName = (String)params.get("attributeName");
            Map m = (Map)MBeanUtil.getAttribute(objectName, attributeName);
            HashSet<String> names = new HashSet<String>();
            HashSet<String> duplicateNames = new HashSet<String>();
            for (Map.Entry entry : m.entrySet()) {
                name = (String)entry.getValue();
                this.webServiceKeyMap.put(name, (String)entry.getKey());
                if (names.add(name)) continue;
                duplicateNames.add(name);
                fullName = (String)entry.getKey();
                appName = fullName.substring(0, fullName.indexOf(35));
                names.add(name + " (" + appName + ")");
                this.webServiceKeyMap.put(name + " (" + appName + ")", (String)entry.getKey());
            }
            for (Map.Entry entry : m.entrySet()) {
                name = (String)entry.getValue();
                if (!duplicateNames.contains(name)) continue;
                names.remove(name);
                fullName = (String)entry.getKey();
                appName = fullName.substring(0, fullName.indexOf(35));
                names.add(name + " (" + appName + ")");
                this.webServiceKeyMap.put(name + " (" + appName + ")", (String)entry.getKey());
            }
            o = names.toArray(new String[m.size()]);
        } else {
            if (objectName == null || objectName.length() == 0) {
                throw new RuntimeException("Object name parameter is required for tree node: " + this.getName());
            }
            objectName = this.replaceTokens(objectName);
            String methodName = (String)params.get("methodName");
            if (methodName == null || methodName.length() == 0) {
                throw new RuntimeException("Method name parameter is required for tree node: " + this.getName());
            }
            String passParams = (String)params.get("passParams");
            Object[] paramsArray = null;
            String[] typesArray = null;
            if (passParams != null && passParams.equals("false")) {
                paramsArray = null;
                typesArray = null;
            } else {
                paramsArray = new Object[1];
                typesArray = new String[1];
                String paramData = (String)params.get("paramData");
                paramsArray[0] = this.replaceTokens(paramData);
                typesArray[0] = (String)params.get("paramType");
                if (typesArray[0] == null) {
                    typesArray[0] = "java.lang.String";
                }
                if (typesArray[0].equals("boolean") || typesArray[0].equals("java.lang.Boolean")) {
                    paramsArray[0] = new Boolean(paramsArray[0].toString());
                } else if (typesArray[0].equals("int") || typesArray[0].equals("java.lang.Integer")) {
                    paramsArray[0] = new Integer(paramsArray[0].toString());
                }
            }
            o = (Object[])MBeanUtil.invoke(objectName, methodName, paramsArray, typesArray);
        }
        return o;
    }
}

