/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.html.OptionList;
import com.sun.appserv.management.base.QueryMgr;
import com.sun.appserv.management.config.EJBModuleConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.config.RegistryLocationConfig;
import com.sun.appserv.management.config.TransformationRuleConfig;
import com.sun.appserv.management.config.WebModuleConfig;
import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.ext.wsmgmt.WebServiceEndpointInfo;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.j2ee.WebServiceEndpoint;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.MBeanUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCActionTableDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.CCAddRemoveDescriptor;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCAddRemoveModelInterface;
import com.sun.web.ui.taglib.pagetitle.CCPageTitleTag;
import com.sun.web.ui.view.addremove.CCAddRemove;
import java.io.File;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.servlet.http.HttpSession;

public class WebServiceHandler {
    public static final String DOMAIN_ROOT_OBJ_NAME = "amx:j2eeType=X-DomainRoot,name=amx";
    public static final String WS_MGR_ATTR_NAME = "WebServiceMgrObjectName";
    public static final String WS_MGR_OBJ_NAME = "amx:j2eeType=X-WebServiceMgr,name=na";
    public static final String GETWSNAMES_METHOD = "getWebServiceEndpointInfo";
    public static final String WSNAMESMAP_ATTR_NAME = "WebServiceEndpointKeys";
    public static final String GETWSENDPOINTSET_METHOD = "getWebServiceEndpointObjectNameSet";
    public static final String RESET_STATS_METHOD = "resetStats";
    public static final String APP_CONFIG_OBJ_NAME = "com.sun.appserv:type=applications,category=config";
    public static final String IS_STANDALONE = "IsAppStandAloneModule";
    public static final String TYPE = "ServiceImplType";
    public static final String APP_NAME = "AppID";
    public static final String SERVLET_TYPE = "SERVLET";
    public static final String J2EE_APPLICATION = "j2ee-application";
    public static final String WEB_MODULE = "web-module";
    public static final String EJB_MODULE = "ejb-module";
    private static final String J2EE_TYPE = "j2eeType";
    private static final String APPL_NAME = "appName";
    private static final String WS_NAME = "wsName";

    public void loadWebServiceGeneralTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableDescriptor ccDesc = (CCActionTableDescriptor)((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        CCActionTableModelInterface model = ccDesc.getModel();
        ((DefaultModel)model).clear();
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        ObjectName webServiceMgr = (ObjectName)handlerCtx.getInputValue("webServiceMgrObjectName");
        String getWSNames = (String)handlerCtx.getInputValue("getWSNamesMethodName");
        Map wsNames = (Map)handlerCtx.getInputValue("wsNamesMap");
        String[] fullName = wsNames.keySet().toArray(new String[wsNames.size()]);
        if (wsNames == null || wsNames.isEmpty()) {
            return;
        }
        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = modelNamesList.toArray(new String[modelNamesList.size()]);
        }
        for (int i = 0; i < fullName.length; ++i) {
            model.appendRow();
            Object[] paramsArray = new Object[]{fullName[i]};
            String[] typesArray = new String[]{"java.lang.Object"};
            Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, getWSNames, paramsArray, typesArray);
            for (int j = 0; j < modelNames.length; ++j) {
                String col = (String)displayNamesList.get(j);
                Object obj = wsiMap.get(modelNames[j]);
                String val = "";
                if (obj instanceof String) {
                    val = (String)obj;
                } else if (obj instanceof Boolean) {
                    val = obj.toString();
                }
                if (col.equals("name")) {
                    val = (String)wsNames.get(fullName[i]);
                } else if (col.equals("wsdl")) {
                    val = new File(val).getName();
                } else if (col.equals("webServiceKey")) {
                    val = fullName[i];
                }
                model.setValue(col, (Object)val);
            }
        }
    }

    public void loadMessagesTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        Set epSet = (Set)handlerCtx.getInputValue("endpointObjNameSet");
        String filterValue = (String)handlerCtx.getInputValue("filterValue");
        if (filterValue == null) {
            filterValue = "allItemsOption";
        }
        if (epSet == null || epSet.isEmpty()) {
            return;
        }
        ObjectName endpointObjName = (ObjectName)epSet.toArray()[0];
        Map[] msgsMap = (Map[])MBeanUtil.getAttribute(endpointObjName, "MessagesInHistory");
        if (msgsMap == null || msgsMap.length == 0) {
            return;
        }
        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = modelNamesList.toArray(new String[modelNamesList.size()]);
        }
        String success = Util.getMessage("common.Success");
        String failed = Util.getMessage("common.Failed");
        for (int i = 0; i < msgsMap.length; ++i) {
            Object ob = msgsMap[i].get("FaultCode");
            if (!(ob == null && filterValue.equals("Success") || ob != null && filterValue.equals("Failed")) && !filterValue.equals("allItemsOption")) continue;
            model.appendRow();
            for (int j = 0; j < modelNames.length; ++j) {
                String col = (String)displayNamesList.get(j);
                Object obj = msgsMap[i].get(modelNames[j]);
                String val = "";
                if (obj instanceof String) {
                    val = (String)obj;
                } else if (obj instanceof Integer) {
                    val = obj.toString();
                }
                if (col.equals("timeStampFormatted")) {
                    Long L = new Long(val);
                    long l = L;
                    Date date = new Date(l);
                    val = date.toString();
                } else if (col.equals("size")) {
                    val = msgsMap[i].get("RequestSize") + "b / " + msgsMap[i].get("ResponseSize") + "b";
                } else if (col.equals("response")) {
                    val = obj == null ? success : failed;
                } else if (col.endsWith("endpointObjName")) {
                    val = endpointObjName.toString();
                } else if (col.endsWith("callFlow")) {
                    String callFlow = (String)msgsMap[i].get("CallFlowEnabled");
                    Boolean isCallFlowEnabled = Boolean.valueOf(callFlow);
                    val = isCallFlowEnabled != false ? Util.getMessage("webServiceMessages.callFlow") : "";
                }
                model.setValue(col, (Object)val);
            }
        }
    }

    public void getMsgContent(RequestContext ctx, HandlerContext handlerCtx) {
        String endpointObjName = (String)handlerCtx.getInputValue("endpointObjName");
        String msgID = (String)handlerCtx.getInputValue("msgID");
        String type = (String)handlerCtx.getInputValue("type");
        Map[] msgsMap = (Map[])MBeanUtil.getAttribute(endpointObjName, "MessagesInHistory");
        String content = null;
        for (int i = 0; i < msgsMap.length; ++i) {
            String id = msgsMap[i].get("MessageID").toString();
            if (!id.equals(msgID)) continue;
            if (type.equals("request")) {
                content = (String)msgsMap[i].get("RequestContent");
                break;
            }
            content = (String)msgsMap[i].get("ResponseContent");
            break;
        }
        handlerCtx.setOutputValue("content", content);
    }

    public void beginMsgViewerTitleDisplay(RequestContext ctx, HandlerContext handlerCtx) {
        CCPageTitleTag tag = (CCPageTitleTag)handlerCtx.getEvent().getSource();
        String type = (String)handlerCtx.getInputValue("type");
        String title = "";
        title = type.equals("request") ? Util.getMessage("webServiceMessageDetail.Request") : Util.getMessage("webServiceMessageDetail.Response");
        tag.setPageTitleText(title);
    }

    public void getApplicationLinkNextPage(RequestContext ctx, HandlerContext handlerCtx) {
        String isStandAlone = (String)handlerCtx.getInputValue("isStandAlone");
        String type = (String)handlerCtx.getInputValue("type");
        if (isStandAlone.equals("false")) {
            handlerCtx.setOutputValue("nextPage", (Object)"enterpriseApplicationsEdit");
        } else if (type.equals(SERVLET_TYPE)) {
            handlerCtx.setOutputValue("nextPage", (Object)"webApplicationsEdit");
        } else {
            handlerCtx.setOutputValue("nextPage", (Object)"ejbModulesEdit");
        }
    }

    public void displayWebServiceInfo(RequestContext ctx, HandlerContext handlerCtx) {
        ArrayList displayNamesList = (ArrayList)handlerCtx.getInputValue("displayNames");
        ArrayList modelNamesList = (ArrayList)handlerCtx.getInputValue("attributeNames");
        ObjectName webServiceMgr = (ObjectName)handlerCtx.getInputValue("webServiceMgrObjectName");
        String getWSNames = (String)handlerCtx.getInputValue("getWSNamesMethodName");
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        Map wsNames = (Map)handlerCtx.getInputValue("wsNamesMap");
        String displayName = (String)wsNames.get(webServiceKey);
        Object[] paramsArray = new String[]{webServiceKey};
        String[] typesArray = new String[]{"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, getWSNames, paramsArray, typesArray);
        String[] modelNames = null;
        if (modelNamesList != null) {
            modelNames = modelNamesList.toArray(new String[modelNamesList.size()]);
        }
        DescriptorContainerView view = (DescriptorContainerView)handlerCtx.getView();
        String type = (String)wsiMap.get(TYPE);
        for (int j = 0; j < modelNames.length; ++j) {
            String displayField = (String)displayNamesList.get(j);
            Object obj = wsiMap.get(modelNames[j]);
            String val = null;
            if (obj instanceof String) {
                val = (String)obj;
            } else if (obj instanceof Boolean) {
                val = obj.toString();
            }
            if (displayField.equals("name")) {
                val = displayName;
            } else if (displayField.equals("wsdl") || displayField.equals("mapping")) {
                if (val != null) {
                    val = new File(val).getName();
                }
            } else if (displayField.equals("webservices")) {
                val = "webservices.xml";
            } else if (displayField.equals("j2eeDescriptor")) {
                val = type.equals(SERVLET_TYPE) ? "web.xml" : "ejb-jar.xml";
            } else if (displayField.equals("sunDescriptor")) {
                val = type.equals(SERVLET_TYPE) ? "sun-web.xml" : "sun-ejb-jar.xml";
            } else if (displayField.equals("implClass") && val == null) {
                val = (String)wsiMap.get("ServiceImplName");
            }
            view.setDisplayFieldValue(displayField, (Object)val);
        }
    }

    public void getDeploymentDescriptorLocation(RequestContext ctx, HandlerContext handlerCtx) {
        String location;
        block8: {
            String appName = (String)handlerCtx.getInputValue("application");
            String moduleName = (String)handlerCtx.getInputValue("moduleName");
            String isStandAlone = (String)handlerCtx.getInputValue("isStandAlone");
            String implType = (String)handlerCtx.getInputValue("implType");
            String descriptorType = (String)handlerCtx.getInputValue("descriptorType");
            String descriptor = null;
            descriptor = implType.equals(SERVLET_TYPE) ? (descriptorType.equals("j2ee") ? "web.xml" : "sun-web.xml") : (descriptorType.equals("j2ee") ? "ejb-jar.xml" : "sun-ejb-jar.xml");
            String[] descriptors = null;
            location = null;
            if (isStandAlone.equals("false")) {
                String[] modules = (String[])MBeanUtil.invoke(APP_CONFIG_OBJ_NAME, "getModuleComponents", new Object[]{appName}, new String[]{"java.lang.String"});
                if (modules != null) {
                    for (int i = 0; i < modules.length; ++i) {
                        try {
                            String subComponentName = new ObjectName(modules[i]).getKeyProperty("name");
                            if (!subComponentName.equals(moduleName)) continue;
                            descriptors = this.getDescriptors(appName, subComponentName);
                            for (int j = 0; descriptors != null && j < descriptors.length; ++j) {
                                int index = descriptors[j].lastIndexOf(File.separator) + 1;
                                String name = descriptors[j].substring(index);
                                if (!name.equals(descriptor)) continue;
                                location = descriptors[j];
                                break block8;
                            }
                            break;
                        }
                        catch (MalformedObjectNameException e) {
                            e.printStackTrace();
                        }
                    }
                }
            } else {
                descriptors = this.getDescriptors(appName, null);
                for (int j = 0; descriptors != null && j < descriptors.length; ++j) {
                    int index = descriptors[j].lastIndexOf(File.separator) + 1;
                    String name = descriptors[j].substring(index);
                    if (!name.equals(descriptor)) continue;
                    location = descriptors[j];
                    break;
                }
            }
        }
        handlerCtx.setOutputValue("location", location);
    }

    private String[] getDescriptors(String appName, String subComponent) {
        String[] descriptors = (String[])MBeanUtil.invoke(APP_CONFIG_OBJ_NAME, "getDeploymentDescriptorLocations", new Object[]{appName, subComponent}, new String[]{"java.lang.String", "java.lang.String"});
        return descriptors;
    }

    public void getWsEndpointObjectName(RequestContext ctx, HandlerContext handlerCtx) {
        String key = (String)handlerCtx.getInputValue("webServiceKeyName");
        ObjectName webServiceMgr = (ObjectName)MBeanUtil.getAttribute(DOMAIN_ROOT_OBJ_NAME, WS_MGR_ATTR_NAME);
        Object[] paramsArray = new Object[]{key};
        String[] typesArray = new String[]{"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, GETWSNAMES_METHOD, paramsArray, typesArray);
        Boolean isStandAlone = (Boolean)wsiMap.get(IS_STANDALONE);
        String appName = (String)wsiMap.get(APP_NAME);
        String implType = (String)wsiMap.get(TYPE);
        String type = "";
        type = isStandAlone.booleanValue() ? (implType.equals(SERVLET_TYPE) ? WEB_MODULE : EJB_MODULE) : J2EE_APPLICATION;
        String name = key.substring(key.indexOf(35) + 1);
        String wsEndpointObjName = "com.sun.appserv:type=web-service-endpoint,name=" + name + "," + type + "=" + appName + ",category=config";
        handlerCtx.setOutputValue("wsEndpointObjectName", (Object)wsEndpointObjName);
        if (!MBeanUtil.isValidMBean(wsEndpointObjName)) {
            AttributeList list = new AttributeList();
            list.add(new Attribute("jbi-enabled", "true"));
            list.add(new Attribute("max-history-size", "25"));
            list.add(new Attribute("monitoring", "OFF"));
            list.add(new Attribute("name", name));
            Object[] params = new Object[]{list};
            String[] signature = new String[]{"javax.management.AttributeList"};
            String objName = "com.sun.appserv:type=" + type + ",name=" + appName + ",category=config";
            MBeanUtil.invoke(objName, "createWebServiceEndpoint", params, signature);
        }
    }

    public void getServerList(RequestContext ctx, HandlerContext handlerCtx) {
        Set wsEndpointSet = (Set)handlerCtx.getInputValue("wsEndpointSet");
        ArrayList<String> serverRootList = new ArrayList<String>();
        for (ObjectName wsEndpoint : wsEndpointSet) {
            ObjectName wsMonitor = (ObjectName)MBeanUtil.getAttribute(wsEndpoint, "MonitoringPeerObjectName");
            if (wsMonitor == null) continue;
            String serverRoot = wsMonitor.getKeyProperty("X-ServerRootMonitor");
            serverRootList.add(serverRoot);
        }
        String[] servers = serverRootList.toArray(new String[serverRootList.size()]);
        handlerCtx.setOutputValue("serverList", (Object)servers);
    }

    public void getWsMonitorsList(RequestContext ctx, HandlerContext handlerCtx) {
        Set wsEndpointSet = (Set)handlerCtx.getInputValue("wsEndpointSet");
        String selectedServer = (String)handlerCtx.getInputValue("selectedServer");
        ArrayList<ObjectName> wsMonitorsList = new ArrayList<ObjectName>();
        ArrayList<String> serverRootList = new ArrayList<String>();
        for (ObjectName wsEndpoint : wsEndpointSet) {
            ObjectName wsMonitor = (ObjectName)MBeanUtil.getAttribute(wsEndpoint, "MonitoringPeerObjectName");
            if (wsMonitor == null) continue;
            String serverRoot = wsMonitor.getKeyProperty("X-ServerRootMonitor");
            wsMonitorsList.add(wsMonitor);
            serverRootList.add(serverRoot);
        }
        if (wsMonitorsList.size() != 0) {
            handlerCtx.setOutputValue("displayServer", (Object)(selectedServer == null ? (String)serverRootList.get(0) : selectedServer));
        }
        handlerCtx.setOutputValue("wsMonitorsList", wsMonitorsList);
        String[] test = serverRootList.toArray(new String[serverRootList.size()]);
        handlerCtx.setOutputValue("serverRoot", (Object)test);
        handlerCtx.setOutputValue("hasMonitors", (Object)(wsMonitorsList.size() == 0 ? new Boolean("false") : new Boolean("true")));
    }

    public void loadWsStatisticsTable(RequestContext ctx, HandlerContext handlerCtx) {
        String nm;
        View view = handlerCtx.getView();
        ViewDescriptor desc = null;
        if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
            desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
        } else {
            DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
            desc = descView.getViewDescriptor();
        }
        String bundle = "com.sun.enterprise.tools.admingui.resources.Resources";
        List wsMonitorsList = (List)handlerCtx.getInputValue("wsMonitorsList");
        String filter = (String)handlerCtx.getInputValue("filterValue");
        if (wsMonitorsList.size() == 0) {
            return;
        }
        if (Util.isEmpty(filter)) {
            filter = "server";
        }
        ObjectName wsMonitor = null;
        for (int i = 0; i < wsMonitorsList.size() && !(nm = (wsMonitor = (ObjectName)wsMonitorsList.get(i)).getKeyProperty("X-ServerRootMonitor")).equals(filter); ++i) {
        }
        if (wsMonitor == null) {
            wsMonitor = (ObjectName)wsMonitorsList.get(0);
        }
        try {
            CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
            if (model == null) {
                throw new FrameworkException("WebSErviceHandler.loadWsStatisticsTable: No Model Specified.", desc, view);
            }
            ((DefaultModel)model).clear();
            model.beforeFirst();
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.lastRespTime"));
            Object[] lastR = new String[]{"" + MBeanUtil.getAttribute(wsMonitor, "ResponseTime_Count")};
            model.setValue("value", (Object)Util.getMessage("webServiceMonitorStatistics.ms", lastR));
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.avgRespTime"));
            Object[] tt = new String[]{"" + MBeanUtil.getAttribute(wsMonitor, "AverageResponseTime_Count")};
            model.setValue("value", (Object)Util.getMessage("webServiceMonitorStatistics.ms", tt));
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.minRespTime"));
            Object[] min = new String[]{"" + MBeanUtil.getAttribute(wsMonitor, "MinResponseTime_Count")};
            model.setValue("value", (Object)Util.getMessage("webServiceMonitorStatistics.ms", min));
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.maxRespTime"));
            Object[] max = new String[]{"" + MBeanUtil.getAttribute(wsMonitor, "MaxResponseTime_Count")};
            model.setValue("value", (Object)Util.getMessage("webServiceMonitorStatistics.ms", max));
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.Throughput"));
            Double dd = (Double)MBeanUtil.getAttribute(wsMonitor, "Throughput_Current");
            NumberFormat numberformat = NumberFormat.getInstance();
            numberformat.setMinimumFractionDigits(2);
            Object[] put = new String[]{numberformat.format(dd)};
            model.setValue("value", (Object)Util.getMessage("webServiceMonitorStatistics.reqPerSec", put));
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.Faults"));
            model.setValue("value", (Object)("" + MBeanUtil.getAttribute(wsMonitor, "TotalFaults_Count")));
            model.appendRow();
            model.setValue("statistic", (Object)Util.getMessage("webServiceMonitorStatistics.totalSuccess"));
            model.setValue("value", (Object)("" + MBeanUtil.getAttribute(wsMonitor, "TotalNumSuccess_Count")));
        }
        catch (Exception ex) {
            throw new FrameworkException("loadWsStatisticsTable: Loading error. ", (Throwable)ex, desc, view);
        }
    }

    public void wsResetData(RequestContext ctx, HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        String serverName = (String)handlerCtx.getInputValue("serverName");
        ObjectName wsEndpoint = this.getWsEndpoint(webServiceKey, serverName);
        WebServiceMgr wsm = AMXUtil.getAMXProxyFactory().getDomainRoot().getWebServiceMgr();
        Set endpointSet = wsm.getWebServiceEndpointSet((Object)webServiceKey, serverName);
        if (!endpointSet.isEmpty()) {
            Iterator it = endpointSet.iterator();
            WebServiceEndpoint endpoint = (WebServiceEndpoint)it.next();
            endpoint.resetStats();
        }
    }

    public void getWsLastResetTime(RequestContext ctx, HandlerContext handlerCtx) {
        String serverName;
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        ObjectName wsEndpoint = this.getWsEndpoint(webServiceKey, serverName = (String)handlerCtx.getInputValue("serverName"));
        if (wsEndpoint != null) {
            Long lastResetTime = (Long)MBeanUtil.getAttribute(wsEndpoint, "LastResetTime");
            handlerCtx.setOutputValue("time", (Object)lastResetTime.toString());
        } else {
            handlerCtx.setOutputValue("time", (Object)"");
        }
    }

    public void removeWsRTGraphFromSession(RequestContext ctx, HandlerContext handlerCtx) {
        String suffix = (String)handlerCtx.getInputValue("suffix");
        HttpSession session = ctx.getRequest().getSession();
        session.removeAttribute("wsResponseTimeRTChart" + suffix);
        session.removeAttribute("wsThroughputRTChart" + suffix);
        session.removeAttribute("wsAuthRTChart" + suffix);
        session.removeAttribute("wsCountRTChart" + suffix);
    }

    public void loadPublishTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        String registryCol = (String)handlerCtx.getInputValue("registryCol");
        Map registryMap = WebServiceHandler.getRegistryLocationConfigMap(webServiceKey);
        if (registryMap != null && !registryMap.isEmpty()) {
            for (RegistryLocationConfig registry : registryMap.values()) {
                model.appendRow();
                model.setValue(registryCol, (Object)registry.getConnectorResourceJNDIName());
            }
        }
    }

    public void processWebServiceKeyName(RequestContext ctx, HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("key");
        String replaceWith = (String)handlerCtx.getInputValue("replaceWith");
        String converted = webServiceKey.replaceAll("@", replaceWith);
        handlerCtx.setOutputValue("converted", (Object)converted);
    }

    public void publishToRegistry(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        String childName = (String)handlerCtx.getInputValue("addRemoveChildName");
        View view = handlerCtx.getView();
        DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
        ViewDescriptor vd = descView.getViewDescriptor();
        ViewDescriptor propSheet = vd.getChildDescriptor("webServicePublishToRegistry");
        ViewDescriptor desc = propSheet.getChildDescriptor(childName);
        CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)desc;
        CCAddRemove addRemoveChild = (CCAddRemove)addRemoveDesc.getView(ctx);
        CCAddRemoveModelInterface model = addRemoveDesc.getModel();
        OptionList selectedOptions = model.getSelectedOptionList(addRemoveChild);
        if (selectedOptions == null) {
            selectedOptions = model.getSelectedOptionList();
        }
        String[] registries = null;
        if (selectedOptions != null) {
            registries = new String[selectedOptions.size()];
            for (int i = 0; i < registries.length; ++i) {
                registries[i] = selectedOptions.getValue(i);
            }
        }
        if (registries != null && registries.length > 0) {
            String lbhost = (String)handlerCtx.getInputValue("lbhost");
            String lbport = (String)handlerCtx.getInputValue("lbport");
            String lbsslport = (String)handlerCtx.getInputValue("lbsslport");
            String categories = (String)handlerCtx.getInputValue("categories");
            String description = (String)handlerCtx.getInputValue("description");
            String organization = (String)handlerCtx.getInputValue("organization");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("LBHost", lbhost);
            map.put("LBPort", lbport);
            map.put("LBSecurePort", lbsslport);
            map.put("Categories", categories);
            map.put("Description", description);
            map.put("Organization", organization);
            WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
            wsm.publishToRegistry(registries, webServiceKey, map);
        }
    }

    public void unpublishFromRegistry(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        String registryCol = (String)handlerCtx.getInputValue("registryCol");
        String[] registries = null;
        try {
            registries = this.getSelectedRows(registryCol, model);
        }
        catch (ModelControlException mce) {
            ViewDescriptor vd = handlerCtx.getViewDescriptor();
            String childName = (String)vd.getParameter("tableChildName");
            ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
            throw new FrameworkException("Error while unpublishing: '" + webServiceKey.toString() + "from " + model.getValue(registryCol).toString() + "'", (Throwable)mce, tableDescriptor, null);
        }
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        wsm.unpublishFromRegistry(registries, webServiceKey);
    }

    public void setAddRemoveAvailableRegistriesList(RequestContext ctx, HandlerContext handlerCtx) {
        ViewDescriptor vd = handlerCtx.getViewDescriptor();
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        String[] registries = wsm.listRegistryLocations();
        if (registries != null && registries.length > 0) {
            CCAddRemoveDescriptor addRemoveDesc = (CCAddRemoveDescriptor)vd;
            CCAddRemoveModelInterface model = addRemoveDesc.getModel();
            model.setAvailableOptionList(new OptionList(registries, registries));
        }
    }

    public void loadRegistriesTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        String[] registries = wsm.listRegistryLocations();
        if (registries != null) {
            for (int i = 0; i < registries.length; ++i) {
                model.appendRow();
                model.setValue("registryName", (Object)registries[i]);
            }
        }
    }

    public void addRegistry(RequestContext ctx, HandlerContext handlerCtx) {
        String jndiName = (String)handlerCtx.getInputValue("jndiName");
        String registryType = (String)handlerCtx.getInputValue("registryType");
        String publishURL = (String)handlerCtx.getInputValue("publishURL");
        String queryURL = (String)handlerCtx.getInputValue("queryURL");
        String userName = (String)handlerCtx.getInputValue("userName");
        String password = (String)handlerCtx.getInputValue("password");
        String description = (String)handlerCtx.getInputValue("description");
        HashMap<String, String> map = new HashMap<String, String>();
        String type = "ebxml";
        type = registryType.equalsIgnoreCase("uddi") ? "uddi" : "ebxml";
        map.put("LifeCycleManagerURL", publishURL);
        if (!Util.isEmpty(queryURL)) {
            map.put("QueryManagerURL", queryURL);
        }
        if (!Util.isEmpty(userName)) {
            map.put("username", userName);
        }
        if (!Util.isEmpty(password)) {
            map.put("password", password);
        }
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        wsm.addRegistryConnectionResources(jndiName, description, type, map);
    }

    public void removeSelectedRegistries(RequestContext ctx, HandlerContext handlerCtx) throws ModelControlException {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String[] selectedRegistries = this.getSelectedRows("registryName", model);
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        for (int i = 0; i < selectedRegistries.length; ++i) {
            wsm.removeRegistryConnectionResources(selectedRegistries[i]);
        }
    }

    public void loadTransformationRulesTableModel(RequestContext ctx, HandlerContext handlerCtx) {
        String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        ((DefaultModel)model).clear();
        List ruleList = WebServiceHandler.getTransformationRuleConfigList(webServiceKey);
        if (ruleList != null && !ruleList.isEmpty()) {
            for (TransformationRuleConfig rule : ruleList) {
                model.appendRow();
                model.setValue("ruleName", (Object)rule.getName());
                if (rule.getEnabled()) {
                    model.setValue("ruleStatus", (Object)Util.getMessage("common.Enabled"));
                } else {
                    model.setValue("ruleStatus", (Object)Util.getMessage("common.Disabled"));
                }
                model.setValue("ruleFile", (Object)rule.getRuleFileLocation());
                model.setValue("applyTo", (Object)rule.getApplyTo());
            }
        }
    }

    public void applyTransformationRulesTableAction(RequestContext ctx, HandlerContext handlerCtx) {
        block5: {
            WebServiceEndpointConfig endpointConfig;
            String[] rules;
            String action;
            block7: {
                Map ruleMap;
                block6: {
                    String webServiceKey = (String)handlerCtx.getInputValue("webServiceKey");
                    String ruleNameCol = (String)handlerCtx.getInputValue("ruleNameCol");
                    action = (String)handlerCtx.getInputValue("action");
                    CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
                    rules = null;
                    try {
                        rules = this.getSelectedRows(ruleNameCol, model);
                    }
                    catch (ModelControlException mce) {
                        ViewDescriptor vd = handlerCtx.getViewDescriptor();
                        String childName = (String)vd.getParameter("tableChildName");
                        ViewDescriptor tableDescriptor = vd.getChildDescriptor(childName);
                        throw new FrameworkException("Error while getting selected transformation rules: '" + model.getValue(ruleNameCol).toString() + "'", (Throwable)mce, tableDescriptor, null);
                    }
                    endpointConfig = WebServiceHandler.getWebServiceEndpointConfig(webServiceKey);
                    if (endpointConfig == null) break block5;
                    ruleMap = endpointConfig.getTransformationRuleConfigMap();
                    if (!action.equals("enable")) break block6;
                    for (int i = 0; i < rules.length; ++i) {
                        TransformationRuleConfig rule = (TransformationRuleConfig)ruleMap.get(rules[i]);
                        rule.setEnabled(true);
                    }
                    break block5;
                }
                if (!action.equals("disable")) break block7;
                for (int i = 0; i < rules.length; ++i) {
                    TransformationRuleConfig rule = (TransformationRuleConfig)ruleMap.get(rules[i]);
                    rule.setEnabled(false);
                }
                break block5;
            }
            if (!action.equals("remove")) break block5;
            for (int i = 0; i < rules.length; ++i) {
                endpointConfig.removeTransformationRuleConfig(rules[i]);
            }
        }
    }

    private String[] getSelectedRows(String col, CCActionTableModelInterface model) throws ModelControlException {
        ArrayList<String> arrList = new ArrayList<String>();
        model.setSelectionType("multiple");
        model.beforeFirst();
        while (model.next()) {
            if (!model.isRowSelected()) continue;
            arrList.add(model.getValue(col).toString());
        }
        return arrList.toArray(new String[arrList.size()]);
    }

    public void getWebServiceDisplayName(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        String name = (String)wsm.getWebServiceEndpointKeys().get(webServiceKey);
        handlerCtx.setOutputValue("webServiceName", (Object)name);
    }

    public void isStandAlone(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        WebServiceEndpointInfo wsi = wsm.getWebServiceEndpointInfo(webServiceKey);
        handlerCtx.setOutputValue("isStandAlone", (Object)("" + wsi.isAppStandaloneModule()));
    }

    public void getAppID(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        WebServiceEndpointInfo info = wsm.getWebServiceEndpointInfo(webServiceKey);
        handlerCtx.setOutputValue("appID", (Object)("" + info.getAppID()));
    }

    public void isSecure(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        WebServiceEndpointInfo info = wsm.getWebServiceEndpointInfo(webServiceKey);
        handlerCtx.setOutputValue("isSecure", (Object)info.isSecure());
    }

    public void getFileContent(RequestContext ctx, HandlerContext handlerCtx) {
        Object webServiceKey = handlerCtx.getInputValue("webServiceKey");
        String fileKey = (String)handlerCtx.getInputValue("fileKey");
        WebServiceMgr wsm = AMXUtil.getDomainRoot().getWebServiceMgr();
        WebServiceEndpointInfo info = wsm.getWebServiceEndpointInfo(webServiceKey);
        Map wsiMap = info.asMap();
        String content = (String)wsiMap.get(fileKey);
        String type = info.getServiceImplType();
        if (fileKey.equals("j2eeDescriptorFile")) {
            content = type.equals(SERVLET_TYPE) ? info.getWebXML() : info.getEJBXML();
        } else if (fileKey.equals("sunDescriptorFile")) {
            content = type.equals(SERVLET_TYPE) ? info.getSunWebXML() : info.getSunEJBXML();
        }
        handlerCtx.setOutputValue("fileContent", (Object)content);
    }

    private ObjectName getWsEndpoint(String webServiceKey, String serverName) {
        Object[] params = new Object[]{webServiceKey, serverName};
        String[] types = new String[]{"java.lang.Object", "java.lang.String"};
        Set endpointSet = (Set)MBeanUtil.invoke(WS_MGR_OBJ_NAME, GETWSENDPOINTSET_METHOD, params, types);
        Iterator it = endpointSet.iterator();
        return endpointSet.isEmpty() ? null : (ObjectName)it.next();
    }

    private static Map getWebServiceEndpointInfoMap(String key) {
        ObjectName webServiceMgr = (ObjectName)MBeanUtil.getAttribute(DOMAIN_ROOT_OBJ_NAME, WS_MGR_ATTR_NAME);
        Object[] paramsArray = new Object[]{key};
        String[] typesArray = new String[]{"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, GETWSNAMES_METHOD, paramsArray, typesArray);
        return wsiMap;
    }

    private static Object getWebServiceAttribute(String key, String attribute) {
        ObjectName webServiceMgr = (ObjectName)MBeanUtil.getAttribute(DOMAIN_ROOT_OBJ_NAME, WS_MGR_ATTR_NAME);
        Object[] paramsArray = new Object[]{key};
        String[] typesArray = new String[]{"java.lang.Object"};
        Map wsiMap = (Map)MBeanUtil.invoke(webServiceMgr, GETWSNAMES_METHOD, paramsArray, typesArray);
        return wsiMap.get(attribute);
    }

    private static RegistryLocationConfig getRegistryLocationConfig(String webServiceKey, String registryName) {
        return (RegistryLocationConfig)WebServiceHandler.getRegistryLocationConfigMap(webServiceKey).get(registryName);
    }

    private static Map getRegistryLocationConfigMap(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = WebServiceHandler.getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getRegistryLocationConfigMap();
    }

    public static TransformationRuleConfig createTransformationRuleConfig(String webServiceKey, String ruleName, boolean enabled, String applyTo, String ruleFileLocation, Map map) {
        WebServiceEndpointConfig wseConfig = WebServiceHandler.getWebServiceEndpointConfig(webServiceKey);
        if (wseConfig == null) {
            wseConfig = WebServiceHandler.createWebServiceEndpointConfig(webServiceKey);
        }
        return wseConfig.createTransformationRuleConfig(ruleName, ruleFileLocation, enabled, applyTo, map);
    }

    private static TransformationRuleConfig getTransformationRuleConfig(String webServiceKey, String ruleKey) {
        return (TransformationRuleConfig)WebServiceHandler.getTransformationRuleConfigMap(webServiceKey).get(ruleKey);
    }

    private static Map getTransformationRuleConfigMap(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = WebServiceHandler.getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getTransformationRuleConfigMap();
    }

    private static List getTransformationRuleConfigList(String webServiceKey) {
        WebServiceEndpointConfig wseConfig = WebServiceHandler.getWebServiceEndpointConfig(webServiceKey);
        return wseConfig == null ? null : wseConfig.getTransformationRuleConfigList();
    }

    private static WebServiceEndpointConfig createWebServiceEndpointConfig(String webServiceKey) {
        Map m = WebServiceHandler.getAMXWebServiceInfo(webServiceKey);
        String appJ2EEType = (String)m.get(J2EE_TYPE);
        String appName = (String)m.get(APPL_NAME);
        String name = (String)m.get(WS_NAME);
        String appConfigObjName = "amx:j2eeType=" + appJ2EEType + "," + "name" + "=" + appName;
        Set appConfigSet = null;
        QueryMgr queryMgr = AMXUtil.getQueryMgr();
        try {
            appConfigSet = queryMgr.queryPatternSet(new ObjectName(appConfigObjName));
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        if (appConfigSet.size() > 1) {
            throw new RuntimeException("More than 1 MBean returned from QueryMgr.queryPatternSet(" + appConfigObjName + ")");
        }
        if (appConfigSet.size() == 0) {
            throw new RuntimeException("No MBean returned from QueryMgr.queryPatternSet(" + appConfigObjName + ") for application " + appName);
        }
        Iterator it = appConfigSet.iterator();
        Object config = null;
        if (it.hasNext()) {
            config = it.next();
        }
        WebServiceEndpointConfig wec = null;
        if (config instanceof J2EEApplicationConfig) {
            wec = ((J2EEApplicationConfig)config).createWebServiceEndpointConfig(name, null);
        } else if (config instanceof WebModuleConfig) {
            wec = ((WebModuleConfig)config).createWebServiceEndpointConfig(name, null);
        } else if (config instanceof EJBModuleConfig) {
            wec = ((EJBModuleConfig)config).createWebServiceEndpointConfig(name, null);
        }
        return wec;
    }

    private static WebServiceEndpointConfig getWebServiceEndpointConfig(String webServiceKey) {
        Map m = WebServiceHandler.getAMXWebServiceInfo(webServiceKey);
        String appJ2EEType = (String)m.get(J2EE_TYPE);
        String appName = (String)m.get(APPL_NAME);
        String name = (String)m.get(WS_NAME);
        String wsEndpointConfigObjName = "amx:" + appJ2EEType + "=" + appName + "," + J2EE_TYPE + "=" + "X-WebServiceEndpointConfig" + "," + "name" + "=" + name;
        QueryMgr queryMgr = AMXUtil.getQueryMgr();
        Set amxSet = null;
        try {
            amxSet = queryMgr.queryPatternSet(new ObjectName(wsEndpointConfigObjName));
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        if (amxSet.size() > 1) {
            throw new RuntimeException("More than 1 MBean returned from QueryMgr.queryPatternSet(" + wsEndpointConfigObjName + ")");
        }
        Iterator it = amxSet.iterator();
        WebServiceEndpointConfig wec = null;
        if (it.hasNext()) {
            wec = (WebServiceEndpointConfig)it.next();
        }
        return wec;
    }

    private static Map getAMXWebServiceInfo(String webServiceKey) {
        Map m = WebServiceHandler.getWebServiceEndpointInfoMap(webServiceKey);
        Boolean isStandAlone = (Boolean)m.get(IS_STANDALONE);
        String implType = (String)m.get(TYPE);
        String appName = (String)m.get(APP_NAME);
        String name = webServiceKey.substring(webServiceKey.indexOf(35) + 1);
        String appJ2EEType = null;
        if (isStandAlone.booleanValue()) {
            if (implType.equals(SERVLET_TYPE)) {
                appJ2EEType = "X-WebModuleConfig";
            } else if (implType.equals("EJB")) {
                appJ2EEType = "X-EJBModuleConfig";
            }
        } else {
            appJ2EEType = "X-J2EEApplicationConfig";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(APPL_NAME, appName);
        map.put(WS_NAME, name);
        map.put(J2EE_TYPE, appJ2EEType);
        return map;
    }
}

