/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui.handlers;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBase;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.SelectableGroup;
import com.sun.appserv.management.monitor.CallFlowMonitor;
import com.sun.appserv.management.monitor.ServerRootMonitor;
import com.sun.enterprise.tools.admingui.util.AMXUtil;
import com.sun.enterprise.tools.admingui.util.Util;
import com.sun.enterprise.tools.guiframework.exception.FrameworkException;
import com.sun.enterprise.tools.guiframework.view.DescriptorContainerView;
import com.sun.enterprise.tools.guiframework.view.HandlerContext;
import com.sun.enterprise.tools.guiframework.view.descriptors.ViewDescriptor;
import com.sun.enterprise.tools.guiframework.view.event.BeforeCreateEvent;
import com.sun.enterprise.tools.jsfext.component.ComponentUtil;
import com.sun.web.ui.component.Tree;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.view.html.CCOption;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.faces.component.UIComponent;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CallFlowHandler {
    private static boolean PROVIDE_DEMO_DATA = false;
    private static String DEMO_INSTANCE_NAME = "demo";
    private static String SUCCESS = "success";
    private static String FAILED = "failed";
    private static String[] ADMIN_APP_PREFIX = new String[]{"uri:/asadmin/", "uri:/admingui/", "uri:/images/", "uri:/js/", "uri:/redirect.html", "uri:/com_sun_web_ui/", "uri:/favicon.ico", "uri:/web1/"};
    private static final String LOCALHOST = "127.0.0.1";
    private static final String END_TIMESTAMP_KEY = "end_timestamp";
    static int democount = 0;

    public void loadCallFlowDataTable(RequestContext ctx, HandlerContext handlerCtx) {
        block10: {
            View view = handlerCtx.getView();
            ViewDescriptor desc = null;
            if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
                desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
            } else {
                DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
                desc = descView.getViewDescriptor();
            }
            CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
            if (model == null) {
                throw new FrameworkException("loadCallFlowDataTable: No Model Specified.", desc, handlerCtx.getView());
            }
            String instanceName = (String)handlerCtx.getInputValue("instanceName");
            String filterValue = (String)handlerCtx.getInputValue("filterValue");
            try {
                ((DefaultModel)model).clear();
                model.beforeFirst();
                model.setRowSelectionType("multiple");
                CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
                if (cfm == null) {
                    return;
                }
                List listOfMap = cfm.queryRequestInformation();
                if (listOfMap == null || listOfMap.isEmpty()) {
                    if (PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName)) {
                        listOfMap = this.queryDemoRequestInformation();
                    } else {
                        return;
                    }
                }
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ctx.getRequest().getLocale());
                for (Map oneRow : listOfMap) {
                    if (filterValue != null && !this.includeRequest(oneRow, filterValue)) continue;
                    this.populateOneRow(model, oneRow, dateFormat);
                }
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block10;
                Util.logFINE(ex);
            }
        }
    }

    private void populateOneRow(CCActionTableModelInterface model, Map oneRow, DateFormat dateFormat) {
        String app = (String)oneRow.get("ApplicationName");
        if (!Util.isEmpty(app)) {
            for (int i = 0; i < ADMIN_APP_PREFIX.length; ++i) {
                if (!app.toLowerCase().startsWith(ADMIN_APP_PREFIX[i])) continue;
                return;
            }
        }
        model.appendRow();
        String ms = (String)oneRow.get("TimeStampMillis");
        if (!Util.isEmpty(ms)) {
            Date date = new Date(Long.parseLong(ms));
            String formattedTime = dateFormat.format(date);
            model.setValue("timeStampFormatted", (Object)formattedTime);
        }
        model.setValue("requestId", oneRow.get("RequestID"));
        String clientHost = (String)oneRow.get("ClientHost");
        if (LOCALHOST.equals(clientHost)) {
            clientHost = Util.getMessage("CallFlow.localhost");
        }
        model.setValue("clientHost", (Object)clientHost);
        model.setValue("user", oneRow.get("User"));
        model.setValue("application", oneRow.get("ApplicationName"));
        model.setValue("startContainer", (Object)Util.getMessage((String)oneRow.get("RequestType")));
        String responseTime = (String)oneRow.get("ResponseTime");
        String resp = this.convertNanoToMs(responseTime);
        model.setValue("responseTime", (Object)resp);
        model.setValue("hiddenResponseTime", (Object)resp);
        String status = this.getStatus(oneRow);
        if (SUCCESS.equals(status)) {
            model.setValue("response", (Object)Util.getMessage("common.Success"));
        } else {
            model.setValue("response", (Object)Util.getMessage("common.Failed"));
        }
    }

    public void populateFilterMenu(RequestContext ctx, HandlerContext handlerCtx) {
        SelectableGroup dropDownChild = (SelectableGroup)handlerCtx.getView();
        OptionList optionList = new OptionList();
        optionList.add((Option)new CCOption(Util.getMessage("common.Success"), SUCCESS));
        optionList.add((Option)new CCOption(Util.getMessage("common.Failed"), FAILED));
        optionList.add((Option)new CCOption(Util.getMessage("REMOTE_WEB"), "REMOTE_WEB"));
        optionList.add((Option)new CCOption(Util.getMessage("REMOTE_WEB_SERVICE"), "REMOTE_WEB_SERVICE"));
        optionList.add((Option)new CCOption(Util.getMessage("REMOTE_EJB"), "REMOTE_EJB"));
        optionList.add((Option)new CCOption(Util.getMessage("TIMER_EJB"), "TIMER_EJB"));
        optionList.add((Option)new CCOption(Util.getMessage("REMOTE_ASYNC_MESSAGE"), "REMOTE_ASYNC_MESSAGE"));
        dropDownChild.setOptions(optionList);
    }

    public void getCallFlowStackMaps(com.sun.enterprise.tools.jsfext.event.handlers.HandlerContext handlerCtx) {
        block4: {
            String requestId = (String)handlerCtx.getInputValue("requestId");
            String instanceName = (String)handlerCtx.getInputValue("instanceName");
            CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
            if (cfm == null) {
                return;
            }
            try {
                List listOfMap = cfm.queryCallStackForRequest(requestId);
                if ((listOfMap == null || listOfMap.size() == 0) && PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName)) {
                    listOfMap = this.getDemoCallFlowStack(requestId);
                }
                handlerCtx.setOutputValue("callStackMap", listOfMap);
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block4;
                Util.logFINE(ex);
            }
        }
    }

    public void createCallFlowStackTree(com.sun.enterprise.tools.jsfext.event.handlers.HandlerContext handlerCtx) {
        UIComponent parent = (UIComponent)handlerCtx.getInputValue("parent");
        List content = (List)handlerCtx.getInputValue("content");
        CallFlowStackTreeDS dataSource = new CallFlowStackTreeDS(content);
        Tree tree = dataSource.createJSFTree(parent);
        handlerCtx.setOutputValue("tree", tree);
    }

    public void getCallFlowDetail(RequestContext ctx, HandlerContext handlerCtx) {
        block7: {
            String requestId = (String)handlerCtx.getInputValue("requestId");
            String instanceName = (String)handlerCtx.getInputValue("instanceName");
            CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
            if (cfm == null) {
                return;
            }
            try {
                Map oneRow;
                List listOfMap = cfm.queryCallStackForRequest(requestId);
                if ((listOfMap == null || listOfMap.size() == 0) && PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName)) {
                    listOfMap = this.getDemoCallFlowStack(requestId);
                }
                if ((oneRow = this.getRow("RequestStart", listOfMap)) == null) {
                    return;
                }
                String ms = (String)oneRow.get("TimeStampMillis");
                DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ctx.getRequest().getLocale());
                Date date = new Date(Long.parseLong(ms));
                String formattedTime = dateFormat.format(date);
                handlerCtx.setOutputValue("timeStamp", (Object)formattedTime);
                handlerCtx.setOutputValue("startContainer", oneRow.get("RequestType"));
                oneRow = this.getRow("MethodStart", listOfMap);
                if (oneRow == null) {
                    return;
                }
                handlerCtx.setOutputValue("application", oneRow.get("ApplicationName"));
                oneRow = this.getLastRow("MethodEnd", listOfMap);
                if (oneRow == null) {
                    return;
                }
                String except = (String)oneRow.get("Exception");
                handlerCtx.setOutputValue("exception", (Object)except);
                handlerCtx.setOutputValue("callStackMap", (Object)listOfMap);
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block7;
                Util.logFINE(ex);
            }
        }
    }

    public void loadCallStackTable(RequestContext ctx, HandlerContext handlerCtx) {
        block9: {
            View view = handlerCtx.getView();
            ViewDescriptor desc = null;
            if (handlerCtx.getEvent() instanceof BeforeCreateEvent) {
                desc = ((BeforeCreateEvent)handlerCtx.getEvent()).getViewDescriptor();
            } else {
                DescriptorContainerView descView = (DescriptorContainerView)((ViewBase)view).getParentViewBean();
                desc = descView.getViewDescriptor();
            }
            CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("model");
            if (model == null) {
                throw new FrameworkException("loadCallFlowDataTable: No Model Specified.", desc, handlerCtx.getView());
            }
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, ctx.getRequest().getLocale());
            try {
                ((DefaultModel)model).clear();
                model.beforeFirst();
                List listOfMap = (List)handlerCtx.getInputValue("callStackMap");
                if (listOfMap == null || listOfMap.isEmpty()) {
                    return;
                }
                ArrayList<Map> tmpList = new ArrayList<Map>();
                for (int i = 0; i < listOfMap.size(); ++i) {
                    Map oneRow = (Map)listOfMap.get(i);
                    String type = (String)oneRow.get("CallStackRowType");
                    if ("MethodStart".equals(type)) {
                        tmpList.add(oneRow);
                    }
                    if (!"MethodEnd".equals(type)) continue;
                    int lastIndex = tmpList.size() - 1;
                    Map methodStart = (Map)tmpList.get(lastIndex);
                    methodStart.put(END_TIMESTAMP_KEY, oneRow.get("TimeStamp"));
                    tmpList.remove(lastIndex);
                }
                int sequence = 1;
                for (int i = 0; i < listOfMap.size(); ++i) {
                    Map oneRow = (Map)listOfMap.get(i);
                    String type = (String)oneRow.get("CallStackRowType");
                    if (!"MethodStart".equals(type)) continue;
                    this.populateOneDetailRow(model, oneRow, dateFormat, sequence++);
                }
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block9;
                Util.logFINE(ex);
            }
        }
    }

    private void populateOneDetailRow(CCActionTableModelInterface model, Map oneRow, DateFormat dateFormat, int sequence) {
        model.appendRow();
        model.setValue("container", oneRow.get("ContainerType"));
        model.setValue("module", oneRow.get("ModuleName"));
        model.setValue("method", oneRow.get("MethodName"));
        model.setValue("component", oneRow.get("ComponentName"));
        model.setValue("sequence", (Object)sequence);
    }

    public void clearCallFlowData(RequestContext ctx, HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        if (Util.isEmpty(instanceName)) {
            throw new FrameworkException("CallFlowHandler:clearCallFlowData(): No instanceName specified");
        }
        CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
        if (cfm == null) {
            return;
        }
        cfm.clearData();
    }

    public void setCallFlowConfig(RequestContext ctx, HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        Boolean enabled = new Boolean((String)handlerCtx.getInputValue("enabled"));
        String callerIpFilter = (String)handlerCtx.getInputValue("callerIpFilter");
        String callerPrincipalFilter = (String)handlerCtx.getInputValue("callerPrincipalFilter");
        CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
        if (cfm != null) {
            cfm.setEnabled(enabled.booleanValue());
            cfm.setCallerIPFilter(callerIpFilter);
            cfm.setCallerPrincipalFilter(callerPrincipalFilter);
        }
    }

    public void getTimeSpendInfo(RequestContext ctx, HandlerContext handlerCtx) {
        block4: {
            String instanceName = (String)handlerCtx.getInputValue("instanceName");
            String requestId = (String)handlerCtx.getInputValue("requestId");
            CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
            if (cfm == null) {
                return;
            }
            try {
                Map timeSpendMap = cfm.queryPieInformation(requestId);
                if ((timeSpendMap == null || timeSpendMap.size() <= 0) && PROVIDE_DEMO_DATA && DEMO_INSTANCE_NAME.equals(instanceName)) {
                    timeSpendMap = this.getDemoTimeSpendMap(requestId);
                }
                handlerCtx.setOutputValue("timeSpendMap", (Object)timeSpendMap);
            }
            catch (Exception ex) {
                if (!Util.isLoggableFINE()) break block4;
                Util.logFINE(ex);
            }
        }
    }

    public void getTimeSpendValues(RequestContext ctx, HandlerContext handlerCtx) {
        Map timeSpendMap = (Map)handlerCtx.getInputValue("timeSpendMap");
        Boolean aa = timeSpendMap.containsKey("EJB_CONTAINER");
        handlerCtx.setOutputValue("hasEjbContainer", (Object)aa);
        aa = timeSpendMap.containsKey("EJB_APPLICATION");
        handlerCtx.setOutputValue("hasEjbApp", (Object)aa);
        aa = timeSpendMap.containsKey("WEB_CONTAINER");
        handlerCtx.setOutputValue("hasWebContainer", (Object)aa);
        aa = timeSpendMap.containsKey("WEB_APPLICATION");
        handlerCtx.setOutputValue("hasWebApp", (Object)aa);
        aa = timeSpendMap.containsKey("ORB_CONTAINER");
        handlerCtx.setOutputValue("hasOrbContainer", (Object)aa);
        float total = 0.0f;
        for (String key : timeSpendMap.keySet()) {
            total += Float.parseFloat((String)timeSpendMap.get(key));
        }
        AttributeList attrsList = new AttributeList();
        for (String key : timeSpendMap.keySet()) {
            String value = (String)timeSpendMap.get(key);
            float xx = Float.parseFloat(value);
            float yy = xx / total;
            float percent = yy * 100.0f;
            NumberFormat numberformat = NumberFormat.getInstance();
            numberformat.setMinimumFractionDigits(2);
            Object[] args = new Object[]{numberformat.format(percent), this.convertNanoToMs(value)};
            String result = Util.getMessage("callFlowDetail.percentMs", args);
            attrsList.add(new Attribute(key, result));
        }
        handlerCtx.setOutputValue("valueList", (Object)attrsList);
    }

    public void deleteCallFlowRequests(RequestContext ctx, HandlerContext handlerCtx) {
        CCActionTableModelInterface model = (CCActionTableModelInterface)handlerCtx.getInputValue("tableModel");
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        ArrayList<Object> list = new ArrayList<Object>();
        model.setRowSelectionType("multiple");
        try {
            model.beforeFirst();
            while (model.next()) {
                boolean selected = model.isRowSelected();
                if (!selected) continue;
                String res = (String)model.getValue("requestId");
                list.add(model.getValue("requestId"));
                model.setRowSelected(false);
            }
            if (!list.isEmpty()) {
                String[] param = list.toArray(new String[list.size()]);
                CallFlowMonitor cfm = this.getCallFlowMonitor(instanceName);
                cfm.deleteRequestIDs(param);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new FrameworkException("Unable to delete CallFlow Requests: ", (Throwable)ex);
        }
    }

    private CallFlowMonitor getCallFlowMonitor(String instanceName) {
        Map serverRootMonitorMap = AMXUtil.getDomainRoot().getMonitoringRoot().getServerRootMonitorMap();
        ServerRootMonitor serverRootMonitor = (ServerRootMonitor)serverRootMonitorMap.get(instanceName);
        if (serverRootMonitor == null) {
            return null;
        }
        CallFlowMonitor cfm = serverRootMonitor.getCallFlowMonitor();
        return cfm;
    }

    private boolean includeRequest(Map oneRow, String filter) {
        if (filter == null || "".equals(filter)) {
            return true;
        }
        String status = this.getStatus(oneRow);
        String container = (String)oneRow.get("RequestType");
        return filter.equalsIgnoreCase(status) || filter.equalsIgnoreCase(container);
    }

    private String getStatus(Map oneRow) {
        String error = (String)oneRow.get("Exception");
        return Util.isEmpty(error) ? SUCCESS : FAILED;
    }

    private Map getRow(String callStackType, List listOfMap) {
        String type;
        Map oneRow = null;
        for (int i = 0; i < listOfMap.size() && !callStackType.equals(type = (String)(oneRow = (Map)listOfMap.get(i)).get("CallStackRowType")); ++i) {
        }
        return oneRow;
    }

    private Map getLastRow(String callStackType, List listOfMap) {
        String type;
        Map oneRow = null;
        for (int i = listOfMap.size() - 1; i >= 0 && !callStackType.equals(type = (String)(oneRow = (Map)listOfMap.get(i)).get("CallStackRowType")); --i) {
        }
        return oneRow;
    }

    private String convertFromNano(String ms, DateFormat dateFormat) {
        long ns = Long.parseLong(ms);
        long ns1 = ns / 1000000L;
        Date dd = new Date(ns1);
        String formattedTime = dateFormat.format(dd);
        return formattedTime;
    }

    private String convertNanoToMs(String nano) {
        float ns = Float.parseFloat(nano);
        float ns1 = ns / 1000000.0f;
        NumberFormat numberformat = NumberFormat.getInstance();
        numberformat.setMinimumFractionDigits(2);
        String str = numberformat.format(ns1);
        return str;
    }

    private List queryDemoRequestInformation() {
        ArrayList listOfMap = new ArrayList();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("RequestID", "23458989");
        hashMap.put("TimeStamp", "" + System.nanoTime());
        hashMap.put("ClientHost", "138.243.150.122");
        hashMap.put("User", "Mary");
        hashMap.put("RequestType", "web");
        hashMap.put("Status", "true");
        hashMap.put("ResponseTime", "34");
        hashMap.put("ApplicationName", "testApp");
        listOfMap.add(hashMap);
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        hashMap2.put("RequestID", "28881999");
        hashMap2.put("TimeStamp", "" + System.nanoTime());
        hashMap2.put("ClientHost", "138.243.140.111");
        hashMap2.put("User", "Peter");
        hashMap2.put("RequestType", "ejb");
        hashMap2.put("Status", "true");
        hashMap2.put("ResponseTime", "69");
        hashMap2.put("ApplicationName", "testApp");
        listOfMap.add(hashMap2);
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        hashMap3.put("RequestID", "55551111");
        hashMap3.put("TimeStamp", "" + System.nanoTime());
        hashMap3.put("ClientHost", "299.288.277.266");
        hashMap3.put("User", "another-user");
        hashMap3.put("RequestType", "iiop");
        hashMap3.put("Status", "false");
        hashMap3.put("ResponseTime", "44");
        hashMap3.put("ApplicationName", "another-app");
        listOfMap.add(hashMap3);
        HashMap<String, String> hashMap4 = new HashMap<String, String>();
        hashMap4.put("RequestID", "38881999");
        hashMap4.put("TimeStamp", "" + System.nanoTime());
        hashMap4.put("ClientHost", "178.244.140.111");
        hashMap4.put("User", "admin");
        hashMap4.put("RequestType", "ejb");
        hashMap4.put("Status", "false");
        hashMap4.put("ResponseTime", "20");
        hashMap4.put("ApplicationName", "testApp");
        listOfMap.add(hashMap4);
        return listOfMap;
    }

    private List getDemoCallFlowStack(String requestId) {
        ArrayList listOfMap = new ArrayList();
        HashMap<String, String> hMap = new HashMap<String, String>();
        hMap.put("RequestID", "RequestID_1");
        hMap.put("RequestType", "REMOTE_EJB");
        hMap.put("TimeStamp", "10");
        hMap.put("CallStackRowType", "RequestStart");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("ModuleName", "Module_Name_1");
        hMap.put("MethodName", "Method_Name_1");
        hMap.put("Exception", "");
        hMap.put("ComponentName", "Component_Name_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("ApplicationName", "APP_NAME");
        hMap.put("ContainerType", "SERVLET");
        hMap.put("TimeStamp", "11");
        hMap.put("CallStackRowType", "MethodStart");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("ModuleName", "Module_Name_2");
        hMap.put("MethodName", "Method_Name_2");
        hMap.put("Exception", "");
        hMap.put("ComponentName", "Component_Name_2");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("ApplicationName", "APP_NAME");
        hMap.put("ContainerType", "SERVLET");
        hMap.put("TimeStamp", "12");
        hMap.put("CallStackRowType", "MethodStart");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("Exception", "exe_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStamp", "13");
        hMap.put("CallStackRowType", "MethodEnd");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("Status", "false");
        hMap.put("Exception", "exe_1");
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStamp", "14");
        hMap.put("CallStackRowType", "MethodEnd");
        listOfMap.add(hMap);
        hMap = new HashMap();
        hMap.put("RequestID", "RequestID_1");
        hMap.put("TimeStamp", "15");
        hMap.put("CallStackRowType", "RequestEnd");
        listOfMap.add(hMap);
        return listOfMap;
    }

    private Map getDemoTimeSpendMap(String id) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (democount == 0) {
            hashMap.put("WEB_CONTAINER", "10");
            hashMap.put("WEB_APPLICATION", "30");
            hashMap.put("EJB_CONTAINER", "15");
            hashMap.put("EJB_APPLICATION", "40");
            hashMap.put("ORB_CONTAINER", "5");
        } else if (democount == 1) {
            hashMap.put("WEB_CONTAINER", "20");
            hashMap.put("WEB_APPLICATION", "10");
            hashMap.put("EJB_CONTAINER", "15");
            hashMap.put("EJB_APPLICATION", "30");
        } else if (democount == 2) {
            hashMap.put("WEB_CONTAINER", "20");
            hashMap.put("WEB_APPLICATION", "10");
            hashMap.put("EJB_CONTAINER", "15");
        } else {
            hashMap.put("WEB_CONTAINER", "20");
            hashMap.put("WEB_APPLICATION", "35");
        }
        if (democount++ >= 3) {
            democount = 0;
        }
        return hashMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallFlowStackTreeDS
    implements TreeDataSource {
        private List<Map> _maps = new ArrayList<Map>();

        public CallFlowStackTreeDS(List<Map> maps) {
            if (maps != null) {
                this._maps = maps;
            }
        }

        @Override
        public Tree createJSFTree(UIComponent parent) {
            Map ms;
            String rowType;
            Map nodeMap = null;
            UIComponent child = null;
            String type = null;
            String methodName = null;
            Tree tree = null;
            Iterator<Map> it = this._maps.iterator();
            if (!it.hasNext()) {
                return null;
            }
            String application = "";
            for (int i = 0; i < this._maps.size() && (!(rowType = (String)(ms = this._maps.get(i)).get("CallStackRowType")).equals("MethodStart") || Util.isEmpty(application = (String)ms.get("ApplicationName"))); ++i) {
            }
            nodeMap = it.next();
            if (!((String)nodeMap.get("CallStackRowType")).equals("RequestStart")) {
                throw new RuntimeException("CallFlow stack should begin with RequestStart, instead got: '" + nodeMap.get("CallStackRowType") + "'.");
            }
            Properties props = new Properties();
            props.put("expanded", Boolean.TRUE);
            if (application == null) {
                application = "";
            }
            props.put("text", application);
            child = ComponentUtil.getChild(parent, "callFlowTree", "com.sun.enterprise.tools.jsfext.component.factory.basic.TreeFactory", props);
            parent.getChildren().add(child);
            tree = (Tree)child;
            tree.setClientSide(false);
            int idx = 0;
            while (it.hasNext()) {
                nodeMap = it.next();
                type = (String)nodeMap.get("CallStackRowType");
                if (type.equals("MethodStart")) {
                    parent = child;
                    methodName = (String)nodeMap.get("MethodName");
                    props = (Properties)props.clone();
                    props.setProperty("text", methodName);
                    child = ComponentUtil.getChild(parent, "node" + ++idx, "com.sun.enterprise.tools.jsfext.component.factory.basic.TreeNodeFactory", props);
                    parent.getChildren().add(child);
                    continue;
                }
                if (type.equals("MethodEnd")) {
                    child = child.getParent();
                    continue;
                }
                if (!type.equals("RequestEnd")) continue;
                break;
            }
            return tree;
        }
    }

    private static interface TreeDataSource {
        public Tree createJSFTree(UIComponent var1);
    }
}

