/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.admingui;

import com.sun.appserv.server.util.Version;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.ErrorManager;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.security.action.GetPropertyAction;

public class PlainFormatter
extends Formatter {
    private HashMap loggerResourceBundleTable;
    private LogManager logManager;
    private Date date = new Date();
    private static String PRODUCTID_CONTEXTID = null;
    private static final String PRODUCT_VERSION = Version.getAbbreviatedVersion();
    private static final int FINE_LEVEL_INT_VALUE = Level.FINE.intValue();
    private static final String LINE_SEPARATOR = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private static final String RECORD_BEGIN_MARKER = "[#|";
    private static final String RECORD_END_MARKER = "|#]" + LINE_SEPARATOR + LINE_SEPARATOR;
    private static final String FIELD_SEPARATOR = "|";
    private static final String NVPAIR_SEPARATOR = ";";
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private static final SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");

    public PlainFormatter() {
        this.loggerResourceBundleTable = new HashMap();
        this.logManager = LogManager.getLogManager();
    }

    public String format(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    public String formatMessage(LogRecord record) {
        return this.uniformLogFormat(record);
    }

    protected String getProductId() {
        return PRODUCT_VERSION;
    }

    protected StringBuffer getNameValuePairs(LogRecord record) {
        Object[] parameters = record.getParameters();
        StringBuffer namevaluePairs = new StringBuffer("");
        try {
            if (parameters == null || parameters.length == 0) {
                return namevaluePairs;
            }
            int lastElement = parameters.length - 1;
            if (parameters[lastElement] instanceof Map) {
                for (Map.Entry entry : ((Map)parameters[lastElement]).entrySet()) {
                    namevaluePairs.append(entry.getKey() + "=" + entry.getValue() + NVPAIR_SEPARATOR);
                }
            }
        }
        catch (Exception e) {
            new ErrorManager().error("Error in extracting Name Value Pairs", e, 5);
        }
        return namevaluePairs;
    }

    private String uniformLogFormat(LogRecord record) {
        try {
            StringBuffer recordBuffer = new StringBuffer();
            String logMessage = record.getMessage();
            ResourceBundle rb = this.getResourceBundle(record.getLoggerName());
            if (rb != null) {
                try {
                    logMessage = MessageFormat.format(rb.getString(logMessage), record.getParameters());
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            recordBuffer.append(logMessage);
            if (record.getThrown() != null) {
                recordBuffer.append(LINE_SEPARATOR);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                recordBuffer.append(sw.toString());
            }
            recordBuffer.append(LINE_SEPARATOR);
            return recordBuffer.toString();
        }
        catch (Exception ex) {
            new ErrorManager().error("Error in formatting Logrecord", ex, 5);
            return new String("");
        }
    }

    private synchronized ResourceBundle getResourceBundle(String loggerName) {
        if (loggerName == null) {
            return null;
        }
        ResourceBundle rb = (ResourceBundle)this.loggerResourceBundleTable.get(loggerName);
        if (rb == null) {
            rb = this.logManager.getLogger(loggerName).getResourceBundle();
            this.loggerResourceBundleTable.put(loggerName, rb);
        }
        return rb;
    }
}

