/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.view.filechooser;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCStateData;
import com.sun.web.ui.model.CCFileChooserModelInterface;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCTextField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CCFileChooserWindow
extends RequestHandlingViewBase
implements CCStateData {
    public static final String MODEL_KEY = "model_key";
    public static final String FIELD_NAME = "field_name";
    public static final String BROWSED_FILE_NAME = "browsetextfield";
    public static final String BROWSER_SERVER_BUTTON = "browseServer";
    private final String STATE_DATA = this.getQualifiedName() + ".stateData";
    private final String SHOW_IN_DIALOG = "showInDialog";
    private final String SHOW_CONTROL_BUTTONS = "showControlBtns";
    private final String FILE_CHOOSER_TYPE = "type";
    private CCFileChooserModelInterface model;

    public CCFileChooserWindow(ContainerView parent, CCFileChooserModelInterface model, String name) {
        super((View)parent, name);
        CCDebug.initTrace();
        RequestContext context = this.getRequestContext();
        this.setModel(model);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(BROWSED_FILE_NAME, CCTextField.class);
        this.registerChild(BROWSER_SERVER_BUTTON, CCButton.class);
    }

    protected View createChild(String name) {
        if (name.equals(BROWSED_FILE_NAME)) {
            return new CCTextField((ContainerView)this, name, null);
        }
        if (name.equals(BROWSER_SERVER_BUTTON)) {
            CCButton child = new CCButton((ContainerView)this, name, "filechooser.title");
            return child;
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.restoreStateData();
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, (Serializable)((HashMap)this.getStateData()));
    }

    public void resetStateData() throws ModelControlException {
        this.setDisplayFieldValue(BROWSED_FILE_NAME, null);
        this.getParentViewBean().setPageSessionAttribute(this.STATE_DATA, null);
    }

    public Map getStateData() throws ModelControlException {
        this.restoreStateData();
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        String[] fileNames = this.model.getSelectedFiles();
        if (fileNames != null) {
            map.put(BROWSED_FILE_NAME, fileNames);
        }
        return map;
    }

    public void restoreStateData() throws ModelControlException {
        String[] fileNames;
        Map map = (Map)this.getParentViewBean().getPageSessionAttribute(this.STATE_DATA);
        if (map == null) {
            return;
        }
        if (this.model.getSelectedFiles() == null && (fileNames = (String[])map.get(BROWSED_FILE_NAME)) != null && fileNames.length != 0) {
            for (int i = 0; i < fileNames.length; ++i) {
                this.model.addSelectedFile(fileNames[i]);
            }
        }
    }

    public void setStateData(Map map) throws ModelControlException {
        if (map == null) {
            CCDebug.trace1("State data map is null");
            return;
        }
        this.resetStateData();
        String[] fileNames = (String[])map.get(BROWSED_FILE_NAME);
        if (fileNames != null && fileNames.length != 0) {
            for (int i = 0; i < fileNames.length; ++i) {
                this.model.addSelectedFile(fileNames[i]);
            }
        }
    }

    public void setModel(CCFileChooserModelInterface model) throws IllegalArgumentException {
        if (model == null) {
            throw new IllegalArgumentException("Invalid parameter.");
        }
        this.model = model;
    }

    public CCFileChooserModelInterface getModel() {
        return this.model;
    }

    public String[] getSelectedResources() {
        String[] tokens = null;
        String selectedResource = ((String)this.getDisplayFieldValue(BROWSED_FILE_NAME)).trim();
        if (selectedResource != null && selectedResource.length() > 0) {
            tokens = selectedResource.split(",");
        }
        return tokens;
    }
}

