/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.wizard;

import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCWizardWindowModelInterface;
import com.sun.web.ui.taglib.html.CCButtonTag;
import com.sun.web.ui.view.wizard.CCWizardWindow;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCWizardWindowTag
extends CCButtonTag {
    private static final String WIZARD_WINDOW_NAME = "wizardWindow";
    private CCWizardWindow wizardWindow;
    private CCWizardWindowModelInterface wizardWindowModel;
    private String bundleID;

    public CCWizardWindowTag() {
        CCDebug.initTrace();
    }

    public void reset() {
        super.reset();
        this.wizardWindow = null;
        this.wizardWindowModel = null;
        this.bundleID = null;
    }

    public String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException, IllegalArgumentException {
        if (parent == null) {
            CCDebug.trace1("Tag parameter is null");
            throw new IllegalArgumentException();
        }
        if (pageContext == null) {
            CCDebug.trace1("PageContext parameter is null");
            throw new IllegalArgumentException();
        }
        if (view == null) {
            CCDebug.trace1("View parameter is null");
            throw new IllegalArgumentException();
        }
        this.checkChildType(view, CCWizardWindow.class);
        this.wizardWindow = (CCWizardWindow)view;
        this.wizardWindowModel = (CCWizardWindowModelInterface)this.wizardWindow.getModel();
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        NonSyncStringBuffer htmlBuf = new NonSyncStringBuffer(8192);
        this.setOnClickOpenWindow();
        htmlBuf.append("\n<!-- beginning of wizard window component -->\n").append(super.getHTMLStringInternal(this.getParent(), pageContext, (View)this.wizardWindow)).append("\n<!-- end of wizard window component -->\n");
        return htmlBuf.toString();
    }

    private void setOnClickOpenWindow() throws JspException {
        NonSyncStringBuffer tmpBuf = new NonSyncStringBuffer(8192);
        String qName = this.wizardWindow.getQualifiedName();
        String cPath = this.getRequestContext().getRequest().getContextPath();
        tmpBuf.append(cPath).append("/wizard/WizardWindow").append("?");
        this.wizardWindowModel.setValue("wizBtnForm", this.getFormName());
        this.appendRequestParams(tmpBuf, this.wizardWindowModel.toRequestParametersString("WizardWindow"));
        this.appendRequestParams(tmpBuf, this.wizardWindowModel.toExtraRequestParameters());
        tmpBuf.append("&amp;").append("WizardWindow").append(".").append("cmdField").append("=").append("&amp;");
        this.appendPageSession(tmpBuf);
        Integer height = (Integer)this.wizardWindowModel.getValue("wizWinHeight");
        Integer width = (Integer)this.wizardWindowModel.getValue("wizWinWidth");
        String useScrollBars = this.isNav4() ? "yes" : "no";
        String openWindowJs = this.getOpenWindowJavascript(tmpBuf.toString(), "wizardWindow_" + HtmlUtil.getUniqueValue(), height == null ? 400 : height, width == null ? 600 : width, "scrollbars=" + useScrollBars + ",resizable");
        NonSyncStringBuffer onclickBuf = new NonSyncStringBuffer(8192);
        String onclick = this.getOnClick();
        if (onclick != null) {
            onclickBuf.append(onclick).append(";");
        }
        onclickBuf.append(openWindowJs).append(";").append(" return true;");
        this.setOnClick(onclickBuf.toString());
    }

    private void appendPageSession(NonSyncStringBuffer buf) {
        boolean passPs = true;
        String ps = "";
        try {
            String doPass = (String)this.wizardWindowModel.getValue("wizPassPageSession");
            if (doPass != null) {
                passPs = Boolean.valueOf(doPass);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (passPs) {
            ps = this.wizardWindow.getParentViewBean().getPageSessionAttributeString(false);
        }
        buf.append("jato.pageSession").append("=").append(ps);
    }

    private void appendRequestParams(NonSyncStringBuffer buffer, String requestParams) throws JspException {
        if (requestParams != null && requestParams.length() > 0) {
            StringTokenizer st = new StringTokenizer(requestParams, "&");
            while (st.hasMoreTokens()) {
                StringTokenizer st2 = new StringTokenizer(st.nextToken(), "=");
                try {
                    if (st2.hasMoreTokens()) {
                        buffer.append("&amp;").append(URLEncoder.encode(st2.nextToken(), "UTF-8"));
                    }
                    if (!st2.hasMoreTokens()) continue;
                    buffer.append("=").append(URLEncoder.encode(st2.nextToken(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    CCDebug.trace3("UTF-8 encoding is not supported.");
                }
            }
        }
    }
}

