/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.version;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.sun.web.ui.common.CCAppDescriptor;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCHelpDescriptor;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCMastheadDescriptor;
import com.sun.web.ui.common.CCServerInterface;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.taglib.common.CCTagBase;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCVersionWindowTag
extends CCTagBase {
    protected static final String ATTRIB_HEIGHT = "height";
    protected static final String ATTRIB_PATHPREFIX = "pathPrefix";
    protected static final String ATTRIB_APPNAME = "appName";
    protected static final String ATTRIB_VERSIONFILE = "versionFile";
    protected static final String ATTRIB_WIDTH = "width";
    protected static final String ATTRIB_WINDOWTITLE = "windowTitle";
    protected static final String ATTRIB_PRODUCTNAME = "productName";
    protected static final String ATTRIB_PRODUCTSRC = "productNameSrc";
    protected static final String ATTRIB_PRODUCTHEIGHT = "productNameHeight";
    protected static final String ATTRIB_PRODUCTWIDTH = "productNameWidth";
    protected static final String ATTRIB_ONCLICK = "onClick";
    private static final String DEFAULT_HEIGHT = "500";
    private static final String DEFAULT_WIDTH = "650";
    private static final String DEFAULT_HELPDIR = "html";
    private static final String DEFAULT_TARGET = "versionWindow";
    private static final String DISPLAY_URL = "/ccversion/Version";

    public int doEndTag() throws JspException {
        try {
            if (this.fireBeginDisplayEvent()) {
                this.writeOutput(this.fireEndDisplayEvent(this.getHTMLString(this.getParent(), this.pageContext, null)));
            }
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    public void reset() {
        super.reset();
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.setParent(parent);
        this.setPageContext(pageContext);
        this.setAttributes();
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        try {
            this.appendOpeningTag(buffer);
        }
        catch (UnsupportedEncodingException e) {
            CCDebug.trace3(this.encoding + " encoding is not supported.");
        }
        buffer.append(this.getTagMessage("masthead.versionLabel"));
        buffer.append("</a>");
        return buffer.toString();
    }

    private void appendOpeningTag(NonSyncStringBuffer buffer) throws JspException, UnsupportedEncodingException {
        String appContext = this.getRequestContext().getRequest().getContextPath();
        buffer.append("<a href=\"").append(appContext + DISPLAY_URL).append("?");
        CCDebug.trace3("VERSIONFILE: " + this.getVersionFile());
        String file = this.getLocalizedTextFile(this.getVersionFile());
        CCDebug.trace3("LOCALIZEDFILE: " + file);
        if (file != null) {
            buffer.append("&amp;versionFile=").append(URLEncoder.encode(file, this.encoding));
        }
        if (this.getProductNameSrc() != null) {
            buffer.append("&amp;productNameSrc=").append(this.getProductNameSrc());
        }
        if (this.getProductNameHeight() != null) {
            buffer.append("&amp;productNameHeight=").append(this.getProductNameHeight());
        }
        if (this.getProductNameWidth() != null) {
            buffer.append("&amp;productNameWidth=").append(this.getProductNameWidth());
        }
        String windowTitle = this.getTagMessage("masthead.versionWindowTitle");
        if (this.getProductName() != null) {
            windowTitle = windowTitle + this.getTagMessage(this.getProductName());
        }
        buffer.append("&amp;windowTitle=").append(URLEncoder.encode(windowTitle, this.encoding));
        buffer.append("\"");
        String styleClass = this.getStyleClass();
        if (styleClass == null || styleClass.equals("")) {
            CCVersionWindowTag.appendAttribute(buffer, "class", "MstLnk");
        } else {
            CCVersionWindowTag.appendAttribute(buffer, "class", styleClass);
        }
        String defaultTarget = null;
        defaultTarget = CCSystem.isAppInConsole() ? DEFAULT_TARGET : "versionWindow_" + this.getAppName();
        CCVersionWindowTag.appendAttribute(buffer, "target", defaultTarget);
        CCVersionWindowTag.appendAttribute(buffer, "title", this.getTagMessage("masthead.versionTooltip"));
        NonSyncStringBuffer tmpBuffer = new NonSyncStringBuffer();
        tmpBuffer.append("javascript:").append("window.status='").append(CCVersionWindowTag.escapeJsQuotes(this.getTagMessage("masthead.versionStatus"))).append("'; return true");
        CCVersionWindowTag.appendAttribute(buffer, "onmouseover", tmpBuffer.toString());
        CCVersionWindowTag.appendAttribute(buffer, "onfocus", tmpBuffer.toString());
        tmpBuffer = new NonSyncStringBuffer("javascript: window.status=''; return true");
        CCVersionWindowTag.appendAttribute(buffer, "onmouseout", tmpBuffer.toString());
        CCVersionWindowTag.appendAttribute(buffer, "onblur", tmpBuffer.toString());
        tmpBuffer = new NonSyncStringBuffer();
        if (this.getOnClick() != null) {
            tmpBuffer.append(this.getOnClick());
        }
        tmpBuffer.append(this.getOpenWindowJavascript("", defaultTarget, Integer.parseInt(this.getHeight() != null ? this.getHeight() : DEFAULT_HEIGHT), Integer.parseInt(this.getWidth() != null ? this.getWidth() : DEFAULT_WIDTH), "scrollbars,resizable"));
        CCVersionWindowTag.appendAttribute(buffer, "onclick", tmpBuffer.toString());
        if (this.getTabIndex() != null) {
            CCVersionWindowTag.appendAttribute(buffer, "tabindex", this.getTabIndex());
        }
        buffer.append(">");
    }

    private String getLocalizedTextFile(String file) {
        if (file == null) {
            return null;
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(256);
        NonSyncStringBuffer buffer1 = new NonSyncStringBuffer(256);
        String localizedFile = null;
        String temp = this.getPathPrefix();
        if (temp != null && temp.length() > 0) {
            if (!temp.startsWith("/")) {
                buffer.append("/");
            }
            buffer.append(temp);
        } else {
            buffer.append("/").append(this.getAppName()).append("/").append(DEFAULT_HELPDIR);
        }
        CCDebug.trace3("PathPrefix: " + buffer.toString());
        HttpServletRequest request = this.getRequestContext().getRequest();
        String localAppName = request.getContextPath();
        String prefixedPath = buffer.toString();
        String urlStart = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(CCI18N.getTagsLocale(this.pageContext.getRequest()));
        locales.add(Locale.ENGLISH);
        if ((prefixedPath + "/").startsWith(localAppName + "/")) {
            CCDebug.trace3("version file in same app");
            prefixedPath = prefixedPath.substring(localAppName.length());
            ServletContext appContext = this.getRequestContext().getServletContext();
            for (int i = 0; i < locales.size(); ++i) {
                String urlPath = prefixedPath + "/" + (Locale)locales.get(i) + "/" + file;
                CCDebug.trace3("URLPATH 1 : " + urlPath);
                try {
                    if (appContext.getResource(urlPath) == null) continue;
                    localizedFile = urlStart + localAppName + urlPath;
                    CCDebug.trace3("LOCALIZED VERSION FILE: " + localizedFile);
                    break;
                }
                catch (MalformedURLException muex) {
                    CCDebug.trace2("getResource failed for " + urlPath);
                }
            }
        } else {
            String host = CCSystem.getUnsecureServerName();
            String port = CCSystem.getUnsecurePort();
            if ((port == null || host == null || host.length() == 0) && request.getScheme().equalsIgnoreCase("http")) {
                host = request.getServerName();
                port = Integer.toString(request.getServerPort());
            }
            if (host == null || port == null) {
                CCDebug.trace3("Unable to form http URL to find version file");
                return null;
            }
            String urlHdr = "http://" + host + ":" + port;
            String urlTemp = buffer.toString() + "/";
            for (int i = 0; i < locales.size(); ++i) {
                String urlPath = urlTemp + (Locale)locales.get(i) + "/" + file;
                CCDebug.trace3("URLPATH 2 : " + urlPath);
                try {
                    URL url = new URL(urlHdr + urlPath);
                    InputStream is = url.openStream();
                    is.close();
                    localizedFile = urlStart + urlPath;
                    break;
                }
                catch (FileNotFoundException e) {
                    continue;
                }
                catch (MalformedURLException e) {
                    CCDebug.trace1("MalformedURLException", e);
                    continue;
                }
                catch (IOException e) {
                    CCDebug.trace1("IOE", e);
                }
            }
        }
        return localizedFile;
    }

    protected void setAttributes() {
        HttpServletRequest request = this.getRequestContext().getRequest();
        String appName = this.getAppName();
        String pluginName = null;
        if (appName.startsWith("/")) {
            pluginName = appName.substring(1).trim();
        }
        Object appDir = null;
        CCHelpDescriptor help = null;
        CCMastheadDescriptor masthead = null;
        try {
            CCServerInterface server = CCSystem.getServerInterface();
            if (server == null) {
                CCDebug.trace3("SERVER IS NULL...");
            }
            if (appName != null) {
                String appDisplayName;
                CCAppDescriptor app = server.getCCAppDescriptor(this.getRequestContext().getRequest());
                CCI18N i18n = new CCI18N(this.pageContext.getRequest(), this.pageContext.getResponse(), app.getBundle(), null, null);
                String key = app.getNameContent();
                String string = appDisplayName = app.isNameLocalizable() ? i18n.getMessage(key) : key;
                if (this.getProductName() == null) {
                    this.setProductName(appDisplayName);
                }
                masthead = server.getCCMastheadDescriptor(request);
                help = server.getCCHelpDescriptor(appName);
            }
        }
        catch (Exception e) {
            CCDebug.trace3("Version related info not found ");
        }
        if (help != null && masthead != null) {
            if (this.getBundleID() == null) {
                this.setBundleID(pluginName);
            }
            if (this.getPathPrefix() == null) {
                this.setPathPrefix(help.getPathPrefix());
            }
            if (this.getVersionFile() == null) {
                this.setVersionFile(help.getVersionFileName());
            }
            if (this.getWidth() == null) {
                this.setWidth(help.getWidth());
            }
            if (this.getVersionFile() == null) {
                this.setVersionFile(help.getVersionFileName());
            }
            if (this.getProductNameSrc() == null) {
                String logo = this.getMessage(masthead.getVersionLogo());
                if (logo == null) {
                    this.setProductNameSrc(this.getMessage(masthead.getLogo()));
                } else {
                    this.setProductNameSrc(logo);
                }
            }
            if (this.getProductNameHeight() == null) {
                String height = this.getMessage(masthead.getVersionLogoHeight());
                if (height == null) {
                    this.setProductNameHeight(this.getMessage(masthead.getLogoHeight()));
                } else {
                    this.setProductNameHeight(height);
                }
            }
            if (this.getProductNameWidth() == null) {
                String width = this.getMessage(masthead.getVersionLogoWidth());
                if (width == null) {
                    this.setProductNameWidth(masthead.getLogoWidth());
                } else {
                    this.setProductNameWidth(width);
                }
            }
        } else {
            CCDebug.trace1("Unable to obtain version information");
        }
    }

    public String getAppName() {
        String appName = (String)this.getValue(ATTRIB_APPNAME);
        if (appName == null) {
            appName = this.getRequestContext().getRequest().getContextPath();
            if (appName.startsWith("/")) {
                appName = appName.substring(1).trim();
            }
            if (appName == null) {
                CCDebug.trace1("Unable to obtain app name from Request URI.");
            }
        }
        return appName;
    }

    public void setAppName(String value) {
        this.setValue(ATTRIB_APPNAME, value);
    }

    public String getHeight() {
        return (String)this.getValue(ATTRIB_HEIGHT);
    }

    public void setHeight(String value) {
        this.setValue(ATTRIB_HEIGHT, value);
    }

    public String getPathPrefix() {
        return (String)this.getValue(ATTRIB_PATHPREFIX);
    }

    public void setPathPrefix(String value) {
        this.setValue(ATTRIB_PATHPREFIX, value);
    }

    public String getVersionFile() {
        return (String)this.getValue(ATTRIB_VERSIONFILE);
    }

    public void setVersionFile(String value) {
        this.setValue(ATTRIB_VERSIONFILE, value);
    }

    public String getWidth() {
        return (String)this.getValue(ATTRIB_WIDTH);
    }

    public void setWidth(String value) {
        this.setValue(ATTRIB_WIDTH, value);
    }

    public String getProductName() {
        return (String)this.getValue(ATTRIB_PRODUCTNAME);
    }

    public void setProductName(String value) {
        this.setValue(ATTRIB_PRODUCTNAME, value);
    }

    public String getProductNameSrc() {
        return (String)this.getValue(ATTRIB_PRODUCTSRC);
    }

    public void setProductNameSrc(String value) {
        this.setValue(ATTRIB_PRODUCTSRC, value);
    }

    public String getProductNameHeight() {
        return (String)this.getValue(ATTRIB_PRODUCTHEIGHT);
    }

    public void setProductNameHeight(String value) {
        this.setValue(ATTRIB_PRODUCTHEIGHT, value);
    }

    public String getProductNameWidth() {
        return (String)this.getValue(ATTRIB_PRODUCTWIDTH);
    }

    public void setProductNameWidth(String value) {
        this.setValue(ATTRIB_PRODUCTWIDTH, value);
    }

    public String getOnClick() {
        return (String)this.getValue(ATTRIB_ONCLICK);
    }

    public void setOnClick(String value) {
        this.setValue(ATTRIB_ONCLICK, value);
    }
}

