/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.html;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.ViewBeanBase;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.header.CCHtmlHeaderTag;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class CCFormTag
extends CCTagBase
implements BodyTag {
    protected static final String ATTRIB_METHOD = "method";
    protected static final String ATTRIB_TARGET = "target";
    protected static final String ATTRIB_DFLTCMDCHILD = "defaultCommandChild";
    protected static final String ATTRIB_ACCEPT = "accept";
    protected static final String ATTRIB_ACCEPTCHARSET = "acceptCharset";
    protected static final String ATTRIB_ENCTYPE = "encType";
    protected static final String ATTRIB_ONRESET = "onReset";
    protected static final String ATTRIB_ONSUBMIT = "onSubmit";
    private BodyContent bodyContent = null;

    public int doStartTag() throws JspException {
        this.reset();
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.fireBeginDisplayEvent()) {
                this.writeOutput(this.fireEndDisplayEvent(this.getHTMLStringInternal(this.getParent(), this.pageContext, null)));
            }
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public void doInitBody() throws JspException {
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        buffer.append("<form");
        this.appendAttributes(buffer);
        buffer.append(">");
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            buffer.append(bodyContent.getString());
        }
        this.appendHiddenFields(buffer);
        buffer.append("\n</form>");
        return buffer.toString();
    }

    private void appendAttributes(NonSyncStringBuffer buffer) throws JspException {
        CCFormTag.appendAttribute(buffer, "name", this.getName());
        CCFormTag.appendAttribute(buffer, ATTRIB_METHOD, this.getMethod() != null ? this.getMethod() : "post");
        ViewBean viewBean = this.getParentViewBean();
        CCFormTag.appendAttribute(buffer, "action", ((HttpServletResponse)this.pageContext.getResponse()).encodeURL(viewBean.getModuleURL() + "/" + viewBean.getRequestInvocationName()));
        CCFormTag.appendAttribute(buffer, ATTRIB_TARGET, this.getTarget());
        CCFormTag.appendAttribute(buffer, "enctype", this.getEncType());
        CCFormTag.appendAttribute(buffer, ATTRIB_ACCEPT, this.getAccept());
        CCFormTag.appendAttribute(buffer, "accept-charset", this.getAcceptCharset());
        CCFormTag.appendAttribute(buffer, "onreset", this.getOnReset());
        CCFormTag.appendAttribute(buffer, "onsubmit", this.getOnSubmit());
        this.appendStyleAttributes(buffer);
    }

    private void appendHiddenFields(NonSyncStringBuffer buffer) throws JspException {
        ViewBean viewBean = this.getParentViewBean();
        if (this.getDefaultCommandChild() != null) {
            CCFormTag.appendHiddenFieldHTMLString(buffer, "jato.defaultCommand", this.getDefaultCommandChild());
            buffer.append("\n");
        }
        CCFormTag.appendHiddenFieldHTMLString(buffer, "jato.pageSession", viewBean.getPageSessionAttributeString(false));
        CCHtmlHeaderTag tag = (CCHtmlHeaderTag)CCFormTag.findAncestorWithClass((Tag)this, (Class)CCHtmlHeaderTag.class);
        if (tag != null && this.isTrue(tag.getIsPopup())) {
            buffer.append("\n");
            CCFormTag.appendHiddenFieldHTMLString(buffer, "com_sun_web_ui_popup", "true");
        }
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    public String getMethod() {
        return (String)this.getValue(ATTRIB_METHOD);
    }

    public void setMethod(String value) {
        this.setValue(ATTRIB_METHOD, value);
    }

    public String getTarget() {
        return (String)this.getValue(ATTRIB_TARGET);
    }

    public void setTarget(String value) {
        this.setValue(ATTRIB_TARGET, value);
    }

    public String getDefaultCommandChild() {
        return (String)this.getValue(ATTRIB_DFLTCMDCHILD);
    }

    public void setDefaultCommandChild(String value) {
        this.setValue(ATTRIB_DFLTCMDCHILD, value);
    }

    public String getAccept() {
        return (String)this.getValue(ATTRIB_ACCEPT);
    }

    public void setAccept(String value) {
        this.setValue(ATTRIB_ACCEPT, value);
    }

    public String getAcceptCharset() {
        return (String)this.getValue(ATTRIB_ACCEPTCHARSET);
    }

    public void setAcceptCharset(String value) {
        this.setValue(ATTRIB_ACCEPTCHARSET, value);
    }

    public String getEncType() {
        return (String)this.getValue(ATTRIB_ENCTYPE);
    }

    public void setEncType(String value) {
        this.setValue(ATTRIB_ENCTYPE, value);
    }

    public String getOnReset() {
        return (String)this.getValue(ATTRIB_ONRESET);
    }

    public void setOnReset(String value) {
        this.setValue(ATTRIB_ONRESET, value);
    }

    public String getOnSubmit() {
        return (String)this.getValue(ATTRIB_ONSUBMIT);
    }

    public void setOnSubmit(String value) {
        this.setValue(ATTRIB_ONSUBMIT, value);
    }
}

