/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.header;

import com.iplanet.jato.CompleteRequestException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBeanBase;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCI18N;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.common.CCJavascript;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.style.CCStylesheetTag;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;

public class CCHtmlHeaderTag
extends CCTagBase
implements BodyTag {
    protected static final String ATTRIB_PAGETITLE = "PageTitle";
    protected static final String ATTRIB_BASENAME = "BaseName";
    protected static final String ATTRIB_ONLOAD = "OnLoad";
    protected static final String ATTRIB_ONUNLOAD = "Unload";
    protected static final String ATTRIB_ONRESIZE = "OnResize";
    protected static final String ATTRIB_BGCOLOR = "BgColor";
    protected static final String ATTRIB_COPYRIGHT = "Copyright";
    protected static final String ATTRIB_PRESERVE_FOCUS = "preserveFocus";
    protected static final String ATTRIB_PRESERVE_SCROLL = "preserveScroll";
    protected static final String ATTRIB_STYLE = "StyleClass";
    protected static final String ATTRIB_SHOWFAVICON = "showFavicon";
    protected static final String ATTRIB_IS_POPUP = "isPopup";
    private BodyContent bodyContent = null;
    private boolean isBundleInit = false;
    private boolean resetFocus = false;
    private boolean resetScroll = false;
    public static final String FOCUS_COOKIE = "ccFocus";
    public static final String SCROLL_COOKIE = "ccScroll";

    public int doStartTag() throws JspException {
        this.reset();
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            if (this.fireBeginDisplayEvent()) {
                this.writeOutput(this.fireEndDisplayEvent(this.getHTMLStringInternal(this.getParent(), this.pageContext, null)));
            }
        }
        catch (CompleteRequestException e) {
            this.getRequestContext().getRequest().setAttribute(ViewBeanBase.DISPLAY_EVENT_COMPLETED_REQUEST_ATTRIBUTE_NAME, (Object)e);
            return 5;
        }
        return 6;
    }

    public int doAfterBody() throws JspException {
        return 0;
    }

    public void doInitBody() throws JspException {
        this.isBundleInit = this.initBundle();
    }

    public BodyContent getBodyContent() {
        return this.bodyContent;
    }

    public void setBodyContent(BodyContent value) {
        this.bodyContent = value;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        if (parent == null) {
            throw new IllegalArgumentException("parent cannot be null");
        }
        if (pageContext == null) {
            throw new IllegalArgumentException("pageContext cannot be null");
        }
        super.getHTMLStringInternal(parent, pageContext, view);
        this.setParent(parent);
        this.setPageContext(pageContext);
        if (!this.isBundleInit) {
            this.initBundle();
        }
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(3072);
        CCStylesheetTag stylesheetTag = new CCStylesheetTag();
        if (!this.isNav4()) {
            buffer.append("<!DOCTYPE html").append(" PUBLIC \"").append("-//W3C//DTD XHTML 1.0 Transitional//EN\"").append(" \"").append("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"").append(">");
        }
        buffer.append("\n<html");
        if (!this.isNav4()) {
            CCHtmlHeaderTag.appendAttribute(buffer, "xmlns", "http://www.w3.org/1999/xhtml");
        }
        buffer.append(">");
        buffer.append("\n<head>\n<title>").append(HtmlUtil.escape((String)this.getMessage(this.getPageTitle()))).append("</title>\n").append(stylesheetTag.getHTMLString(this.getParent(), pageContext, null)).append("\n<meta");
        CCHtmlHeaderTag.appendAttribute(buffer, "name", ATTRIB_COPYRIGHT);
        NonSyncStringBuffer tmpBuffer = new NonSyncStringBuffer();
        tmpBuffer.append("Copyright &copy; ").append(this.getCopyrightYear() != null ? this.getCopyrightYear() : "2005").append(" Sun Microsystems, Inc. All Rights Reserved.").append(" Use is subject to license terms.");
        CCHtmlHeaderTag.appendAttribute(buffer, "content", tmpBuffer.toString());
        buffer.append(" />");
        this.appendCookieJavascript(buffer);
        if (this.isTrue(this.getShowFavicon())) {
            buffer.append("<link rel=\"shortcut icon\" ").append("href=\"" + CCImage.FAVICON_IMAGE + "\" ").append("type=\"image/x-icon\"></link>");
        }
        buffer.append("\n</head>").append("\n<body class=\"" + this.getStyleClass() + "\"");
        CCHtmlHeaderTag.appendAttribute(buffer, "onload", this.getOnLoad());
        CCHtmlHeaderTag.appendAttribute(buffer, "onunload", this.getOnUnload());
        CCHtmlHeaderTag.appendAttribute(buffer, "onresize", this.getOnResize());
        buffer.append(">\n");
        BodyContent bodyContent = this.getBodyContent();
        if (bodyContent != null) {
            buffer.append(bodyContent.getString());
        }
        buffer.append("</body>\n</html>");
        return buffer.toString();
    }

    private void appendCookieJavascript(NonSyncStringBuffer buffer) {
        if (this.isNav4()) {
            return;
        }
        boolean preserveFocus = this.isTrue(this.getPreserveFocus());
        boolean preserveScroll = this.isTrue(this.getPreserveScroll());
        String context = null;
        if (!preserveFocus && !preserveScroll) {
            return;
        }
        buffer.append("\n<script type=\"text/javascript\" src=\"").append(CCJavascript.COOKIE_JS).append("\"></script>");
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        context = request.getContextPath();
        if (preserveFocus) {
            buffer.append("\n<script type=\"text/javascript\" src=\"").append(CCJavascript.FOCUS_COOKIE_JS).append("\"></script>");
        }
        if (preserveScroll) {
            buffer.append("\n<script type=\"text/javascript\" src=\"").append(CCJavascript.SCROLL_COOKIE_JS).append("\"></script>");
        }
        buffer.append("\n<script").append(" type=\"text/javascript\"").append(">");
        if (preserveFocus) {
            buffer.append("\nvar ").append(FOCUS_COOKIE).append(" = new ccFocusCookie(\"").append(FOCUS_COOKIE).append("\", \"").append(context).append("\");");
        }
        if (preserveScroll) {
            buffer.append("\nvar ").append(SCROLL_COOKIE).append(" = new ccScrollCookie(\"").append(SCROLL_COOKIE).append("\", \"").append(context).append("\");");
        }
        buffer.append("</script>");
        NonSyncStringBuffer tmpBuffer = new NonSyncStringBuffer();
        if (preserveFocus) {
            tmpBuffer = new NonSyncStringBuffer();
            if (this.getOnLoad() != null) {
                tmpBuffer.append(this.getOnLoad()).append(";");
            }
            tmpBuffer.append("javascript: ").append(FOCUS_COOKIE).append(this.resetFocus ? ".reset()" : ".restore()");
            this.setOnLoad(tmpBuffer.toString());
        }
        if (preserveScroll) {
            tmpBuffer = new NonSyncStringBuffer();
            if (this.getOnLoad() != null) {
                tmpBuffer.append(this.getOnLoad()).append(";");
            }
            if (!preserveFocus) {
                tmpBuffer.append("javascript: ");
            }
            tmpBuffer.append(SCROLL_COOKIE).append(this.resetScroll ? ".reset()" : ".restore()");
            this.setOnLoad(tmpBuffer.toString());
            tmpBuffer = new NonSyncStringBuffer();
            if (this.getOnUnload() != null) {
                tmpBuffer.append(this.getOnUnload()).append(";");
            }
            tmpBuffer.append("javascript: ").append(SCROLL_COOKIE).append(".set()");
            this.setOnUnload(tmpBuffer.toString());
        }
    }

    private boolean initBundle() {
        boolean result = false;
        if (this.getBaseName() != null) {
            CCI18N.setResourceBundle(this.pageContext.getRequest(), this.pageContext.getResponse(), this.getBaseName(), this.getBundleID(), null);
            result = true;
        }
        return result;
    }

    public void resetFocus(boolean value) {
        this.resetFocus = value;
    }

    public void resetScroll(boolean value) {
        this.resetScroll = value;
    }

    public String getPageTitle() {
        return (String)this.getValue(ATTRIB_PAGETITLE);
    }

    public void setPageTitle(String value) {
        this.setValue(ATTRIB_PAGETITLE, value);
    }

    public void setBaseName(String value) {
        this.setValue(ATTRIB_BASENAME, value);
    }

    public String getBaseName() {
        return (String)this.getValue(ATTRIB_BASENAME);
    }

    public void setOnLoad(String value) {
        this.setValue(ATTRIB_ONLOAD, value);
    }

    public String getOnLoad() {
        return (String)this.getValue(ATTRIB_ONLOAD);
    }

    public void setOnUnload(String value) {
        this.setValue(ATTRIB_ONUNLOAD, value);
    }

    public String getOnUnload() {
        return (String)this.getValue(ATTRIB_ONUNLOAD);
    }

    public void setOnResize(String value) {
        this.setValue(ATTRIB_ONRESIZE, value);
    }

    public String getOnResize() {
        return (String)this.getValue(ATTRIB_ONRESIZE);
    }

    public void setBgColor(String value) {
        this.setValue(ATTRIB_BGCOLOR, value);
    }

    public String getBgColor() {
        return (String)this.getValue(ATTRIB_BGCOLOR);
    }

    public void setCopyrightYear(String value) {
        this.setValue(ATTRIB_COPYRIGHT, value);
    }

    public String getCopyrightYear() {
        return (String)this.getValue(ATTRIB_COPYRIGHT);
    }

    public void setPreserveFocus(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_PRESERVE_FOCUS, value);
    }

    public String getPreserveFocus() {
        return (String)this.getValue(ATTRIB_PRESERVE_FOCUS);
    }

    public void setPreserveScroll(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_PRESERVE_SCROLL, value);
    }

    public String getPreserveScroll() {
        return (String)this.getValue(ATTRIB_PRESERVE_SCROLL);
    }

    public void setStyleClass(String value) {
        this.setValue(ATTRIB_STYLE, value);
    }

    public String getStyleClass() {
        if (this.getValue(ATTRIB_STYLE) != null) {
            return (String)this.getValue(ATTRIB_STYLE);
        }
        return "DefBdy";
    }

    public void setShowFavicon(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SHOWFAVICON, value);
    }

    public String getShowFavicon() {
        if (this.getValue(ATTRIB_SHOWFAVICON) != null) {
            return (String)this.getValue(ATTRIB_SHOWFAVICON);
        }
        return "true";
    }

    public void setIsPopup(String value) {
        if (value != null && !value.toLowerCase().equals("true") && !value.toLowerCase().equals("false")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_IS_POPUP, value);
    }

    public String getIsPopup() {
        return (String)this.getValue(ATTRIB_IS_POPUP);
    }
}

