/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.taglib.alert;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCImage;
import com.sun.web.ui.taglib.common.CCTagBase;
import com.sun.web.ui.taglib.html.CCImageTag;
import com.sun.web.ui.view.alert.CCAlert;
import com.sun.web.ui.view.html.CCImageField;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class CCAlertTag
extends CCTagBase {
    protected static final String ATTRIB_ALT = "alt";
    protected static final String ATTRIB_DEFAULTVALUE = "defaultValue";
    protected static final String ATTRIB_HSPACE = "hspace";
    protected static final String ATTRIB_SIZE = "size";
    protected static final String ATTRIB_TITLE = "title";
    protected static final String ATTRIB_VSPACE = "vspace";
    protected static final String ALERT_ERROR_IMAGE_ALT_TEXT = "alert.errorImageAltText";
    protected static final String ALERT_HELP_IMAGE_ALT_TEXT = "alert.helpImageAltText";
    protected static final String ALERT_INFO_IMAGE_ALT_TEXT = "alert.infoImageAltText";
    protected static final String ALERT_WARNING_IMAGE_ALT_TEXT = "alert.warningImageAltText";
    protected static final String SIZE_DEFAULT = "medium";
    protected static final String TYPE_DEFAULT = "info";
    private static final String DEFAULT_HSPACE = "3";
    private CCAlert container;
    private String image;
    private String imageHeight;
    private String imageWidth;
    private String imageAltText;

    public void reset() {
        super.reset();
        this.container = null;
        this.image = null;
        this.imageHeight = null;
        this.imageWidth = null;
        this.imageAltText = null;
    }

    protected String getHTMLStringInternal(Tag parent, PageContext pageContext, View view) throws JspException {
        this.checkAndSetParent(parent, pageContext, view);
        super.getHTMLStringInternal(parent, pageContext, view);
        this.checkChildType(view, CCAlert.class);
        this.container = (CCAlert)view;
        this.setAttributes();
        if (this.container.getValue() == null) {
            this.container.setValue(this.getDefaultValue());
        }
        this.initProperties();
        return this.getAlertImageHTML();
    }

    protected void checkAndSetParent(Tag parent, PageContext pageContext, View view) throws JspException {
        String errMsg = null;
        if (parent == null) {
            errMsg = "parent cannot be null";
        } else if (pageContext == null) {
            errMsg = "pageContext cannot be null";
        } else if (view == null) {
            errMsg = "view cannot be null";
        }
        if (errMsg != null) {
            throw new IllegalArgumentException(errMsg);
        }
        this.setParent(parent);
        this.setPageContext(pageContext);
    }

    private void initProperties() {
        String type = this.getType();
        String size = this.getSize();
        if (type.equalsIgnoreCase("error")) {
            if (size.equals("small")) {
                this.image = CCImage.ALERT_ERROR_SMALL;
                this.imageHeight = "14";
                this.imageWidth = "11";
            } else if (size.equals(SIZE_DEFAULT)) {
                this.image = CCImage.ALERT_ERROR_MEDIUM;
                this.imageHeight = "17";
                this.imageWidth = "17";
            } else if (size.equals("large")) {
                this.image = CCImage.ALERT_ERROR_LARGE;
                this.imageHeight = "21";
                this.imageWidth = "21";
            }
            this.imageAltText = ALERT_ERROR_IMAGE_ALT_TEXT;
        } else if (type.equalsIgnoreCase("help")) {
            if (size.equals("small")) {
                this.image = CCImage.ALERT_HELP_SMALL;
                this.imageHeight = "11";
                this.imageWidth = "11";
            } else if (size.equals(SIZE_DEFAULT)) {
                this.image = CCImage.ALERT_HELP_MEDIUM;
                this.imageHeight = "17";
                this.imageWidth = "17";
            } else if (size.equals("large")) {
                this.image = CCImage.ALERT_HELP_LARGE;
                this.imageHeight = "21";
                this.imageWidth = "21";
            }
            this.imageAltText = ALERT_HELP_IMAGE_ALT_TEXT;
        } else if (type.equalsIgnoreCase(TYPE_DEFAULT)) {
            if (size.equals("small")) {
                this.image = CCImage.ALERT_INFO_SMALL;
                this.imageHeight = "11";
                this.imageWidth = "11";
            } else if (size.equals(SIZE_DEFAULT)) {
                this.image = CCImage.ALERT_INFO_MEDIUM;
                this.imageHeight = "17";
                this.imageWidth = "17";
            } else if (size.equals("large")) {
                this.image = CCImage.ALERT_INFO_LARGE;
                this.imageHeight = "21";
                this.imageWidth = "21";
            }
            this.imageAltText = ALERT_INFO_IMAGE_ALT_TEXT;
        } else if (type.equalsIgnoreCase("warning")) {
            if (size.equals("small")) {
                this.image = CCImage.ALERT_WARNING_SMALL;
                this.imageHeight = "11";
                this.imageWidth = "11";
            } else if (size.equals(SIZE_DEFAULT)) {
                this.image = CCImage.ALERT_WARNING_MEDIUM;
                this.imageHeight = "17";
                this.imageWidth = "17";
            } else if (size.equals("large")) {
                this.image = CCImage.ALERT_WARNING_LARGE;
                this.imageHeight = "21";
                this.imageWidth = "21";
            }
            this.imageAltText = ALERT_WARNING_IMAGE_ALT_TEXT;
        }
    }

    private String getAlertImageHTML() throws JspException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer(8192);
        View child = this.container.getChild("AlertImage");
        this.checkChildType(child, CCImageField.class);
        CCImageField ccImageField = (CCImageField)child;
        CCImageTag ccImageTag = new CCImageTag();
        ccImageTag.setBundleID("com.sun.web.ui");
        ccImageTag.setAlt(this.getTagMessage(this.imageAltText));
        ccImageTag.setDefaultValue(this.image);
        ccImageTag.setHeight(this.imageHeight);
        ccImageTag.setHspace(this.getHspace() != null ? this.getHspace() : DEFAULT_HSPACE);
        ccImageTag.setTitle(this.getTitle());
        ccImageTag.setVspace(this.getVspace());
        ccImageTag.setWidth(this.imageWidth);
        return ccImageTag.getHTMLString(this.getParent(), this.pageContext, (View)ccImageField);
    }

    protected void setAttributes() {
        if (this.container instanceof CCAlert) {
            if (this.container.getValue() != null) {
                this.setDefaultValue(this.container.getType());
            }
            if (this.container.getAlt() != null) {
                this.setAlt(this.container.getAlt());
            }
            if (this.container.getHspace() != null) {
                this.setHspace(this.container.getHspace());
            }
            if (this.container.getSize() != null) {
                this.setSize(this.container.getSize());
            }
            if (this.container.getTitle() != null) {
                this.setTitle(this.container.getTitle());
            }
            if (this.container.getVspace() != null) {
                this.setVspace(this.container.getVspace());
            }
        }
    }

    public String getDefaultValue() {
        return this.getValue(ATTRIB_DEFAULTVALUE) != null ? (String)this.getValue(ATTRIB_DEFAULTVALUE) : TYPE_DEFAULT;
    }

    public void setDefaultValue(String value) {
        if (value == null || !value.equalsIgnoreCase("error") && !value.equalsIgnoreCase("help") && !value.equalsIgnoreCase(TYPE_DEFAULT) && !value.equalsIgnoreCase("warning")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_DEFAULTVALUE, value);
    }

    public String getAlt() {
        return (String)this.getValue(ATTRIB_ALT);
    }

    public void setAlt(String value) {
        this.setValue(ATTRIB_ALT, value);
    }

    public String getHspace() {
        return (String)this.getValue(ATTRIB_HSPACE);
    }

    public void setHspace(String value) {
        this.setValue(ATTRIB_HSPACE, value);
    }

    public String getSize() {
        return this.getValue(ATTRIB_SIZE) != null ? (String)this.getValue(ATTRIB_SIZE) : SIZE_DEFAULT;
    }

    public void setSize(String value) {
        if (value == null || !value.equals("small") && !value.equals(SIZE_DEFAULT) && !value.equals("large")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.setValue(ATTRIB_SIZE, value);
    }

    public String getTitle() {
        return (String)this.getValue(ATTRIB_TITLE);
    }

    public void setTitle(String value) {
        this.setValue(ATTRIB_TITLE, value);
    }

    public String getType() {
        return this.getDefaultValue();
    }

    public void setType(String value) {
        this.setDefaultValue(value);
    }

    public String getVspace() {
        return (String)this.getValue(ATTRIB_VSPACE);
    }

    public void setVspace(String value) {
        this.setValue(ATTRIB_VSPACE, value);
    }
}

