/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import com.sun.web.ui.servlet.topology.CCTopologyServlet;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;

class CCTopologyImageData {
    private static final int TYPE = 0;
    private static final int BYTES = 1;
    private final CCTopologyRenderer renderer;
    private final Rectangle clipRegion;
    private final String imageFormat;
    private final Object[] imageData;

    public CCTopologyImageData(CCTopologyRenderer renderer, Rectangle clipRegion, String imageFormat) {
        if (renderer == null) {
            throw new IllegalArgumentException("renderer == null");
        }
        if (!CCTopologyServlet.isValidImageFormat(imageFormat)) {
            throw new IllegalArgumentException("Unsupported format: " + imageFormat);
        }
        this.renderer = renderer;
        this.clipRegion = clipRegion;
        this.imageFormat = imageFormat;
        this.imageData = new Object[2];
    }

    private CCTopologyImageData(Object[] imageData) {
        this.renderer = null;
        this.clipRegion = null;
        this.imageFormat = null;
        this.imageData = imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CCTopologyImageData createFromPrimitives(Object primitives) {
        Object[] data = null;
        try {
            data = (Object[])primitives;
            Object o = (String)data[0];
            o = (byte[])data[1];
        }
        catch (Exception cce) {
            return null;
        }
        CCTopologyImageData imageData = new CCTopologyImageData(data);
        if (imageData.isEncoded()) {
            return imageData;
        }
        CCTopologyImageData cCTopologyImageData = imageData;
        synchronized (cCTopologyImageData) {
            long waitTime = 100L;
            while (waitTime < 160000L) {
                Object object = primitives;
                synchronized (object) {
                    if (imageData.isEncoded()) {
                        return imageData;
                    }
                }
                try {
                    imageData.wait(waitTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                waitTime = (long)((double)waitTime * 1.3);
            }
        }
        return null;
    }

    public Object asPrimitives() {
        return this.imageData;
    }

    public String getImageType() {
        return (String)this.imageData[0];
    }

    private void setImageType(String imageType) {
        this.imageData[0] = imageType;
    }

    public byte[] getImageBytes() {
        return (byte[])this.imageData[1];
    }

    private void setImageBytes(byte[] bytes) {
        this.imageData[1] = bytes;
    }

    public boolean isEncoded() {
        return this.getImageBytes() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void encodeImage() {
        Object primitives;
        BufferedImage image = null;
        Object object = primitives = this.asPrimitives();
        synchronized (object) {
            this.setImageType("image/" + this.imageFormat);
            byte[] imageBytes = new byte[]{};
            try {
                image = this.renderer.getImage(this.clipRegion);
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, this.imageFormat, byteStream);
                imageBytes = byteStream.toByteArray();
            }
            catch (Exception e) {
                CCDebug.trace1("Image creation/encoding failed", e);
            }
            this.setImageBytes(imageBytes);
        }
        if (image != null) {
            image.flush();
        }
    }
}

