/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.topology;

import com.sun.web.ui.servlet.topology.CCTopologyImageData;
import com.sun.web.ui.servlet.topology.CCTopologyRenderer;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;

class CCSessionImageCache
implements HttpSessionBindingListener {
    private static final String CACHE_ATTR = "CCTopologyServlet.imageCache";
    private static final int MAX_IMAGE_LOAD_WAIT = 500;
    private static long lastPutKey;
    private static String lastGetKey;
    private static final Map instanceCache;
    private final Map imageCache;
    private BackgroundRenderer bgRenderer;
    private CacheReaper cacheReaper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CCSessionImageCache(HttpSession session) {
        if (!(session.getAttribute(CACHE_ATTR) instanceof Map)) {
            HttpSession httpSession = session;
            synchronized (httpSession) {
                if (!(session.getAttribute(CACHE_ATTR) instanceof Map)) {
                    session.setAttribute(CACHE_ATTR, new HashMap());
                }
            }
        }
        this.imageCache = (Map)session.getAttribute(CACHE_ATTR);
        session.setAttribute("com.sun.web.ui.servlet.topology.CCSessionImageCache:" + this.hashCode(), (Object)this);
    }

    public static CCSessionImageCache getInstance(HttpSession session) {
        CCSessionImageCache instance = null;
        Object attr = instanceCache.get(session.getId());
        if (attr instanceof CCSessionImageCache) {
            instance = (CCSessionImageCache)attr;
        } else {
            instance = new CCSessionImageCache(session);
            instanceCache.put(session.getId(), instance);
        }
        return instance;
    }

    public void valueBound(HttpSessionBindingEvent event) {
    }

    public void valueUnbound(HttpSessionBindingEvent event) {
        if (this.bgRenderer != null) {
            this.bgRenderer.stop();
            this.bgRenderer = null;
        }
        if (this.cacheReaper != null) {
            this.cacheReaper.stop();
            this.cacheReaper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackgroundRenderer getBackgroundRenderer() {
        if (this.bgRenderer == null) {
            CCSessionImageCache cCSessionImageCache = this;
            synchronized (cCSessionImageCache) {
                if (this.bgRenderer == null) {
                    this.bgRenderer = new BackgroundRenderer();
                    new Thread((Runnable)this.bgRenderer, "CCSessionImageCache.BackgroundRenderer " + this.bgRenderer.hashCode()).start();
                    this.cacheReaper = new CacheReaper();
                    new Thread((Runnable)this.cacheReaper, "CCSessionImageCache.CacheReaper " + this.cacheReaper.hashCode()).start();
                }
            }
        }
        return this.bgRenderer;
    }

    public String cacheImage(CCTopologyRenderer renderer, Rectangle clipRegion, String imageFormat) {
        long key;
        lastPutKey = key = Math.max(System.currentTimeMillis(), lastPutKey + 1L);
        String keyString = Long.toString(key);
        CCTopologyImageData imageData = new CCTopologyImageData(renderer, clipRegion, imageFormat);
        this.imageCache.put(keyString, imageData.asPrimitives());
        this.getBackgroundRenderer().renderImage(imageData);
        return keyString;
    }

    public CCTopologyImageData takeImageData(String key) {
        if (lastGetKey != null && !lastGetKey.equals(key)) {
            this.imageCache.remove(lastGetKey);
        }
        lastGetKey = key;
        Object primitives = this.imageCache.get(lastGetKey);
        return CCTopologyImageData.createFromPrimitives(primitives);
    }

    static {
        instanceCache = new WeakHashMap();
    }

    private class BackgroundRenderer
    implements Runnable {
        private List queue = new ArrayList();
        private boolean isStopped;

        public synchronized void stop() {
            this.isStopped = true;
            this.notifyAll();
        }

        public synchronized void renderImage(CCTopologyImageData imageData) {
            this.queue.add(imageData);
            this.notifyAll();
        }

        public synchronized void run() {
            while (true) {
                if (this.queue.size() > 0) {
                    ((CCTopologyImageData)this.queue.remove(0)).encodeImage();
                    continue;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isStopped) break;
            }
            this.queue.clear();
        }
    }

    private class CacheReaper
    implements Runnable {
        private static final long REAP_INTERVAL = 60000L;
        private static final long STALE_DURATION = 120000L;
        private boolean isStopped;

        public void stop() {
            this.isStopped = true;
        }

        public synchronized void run() {
            do {
                long wakeTime = System.currentTimeMillis() + 60000L;
                while (System.currentTimeMillis() < wakeTime) {
                    try {
                        this.wait(wakeTime - System.currentTimeMillis());
                    }
                    catch (InterruptedException ie) {}
                }
                String staleTime = Long.toString(System.currentTimeMillis() - 120000L);
                Iterator keys = CCSessionImageCache.this.imageCache.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    if (key == null || staleTime.compareTo(key) <= 0 && !this.isStopped) continue;
                    keys.remove();
                }
            } while (!this.isStopped);
            CCSessionImageCache.this.imageCache.clear();
        }
    }
}

