/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.servlet.badging;

import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.common.CCSystem;
import com.sun.web.ui.servlet.common.TagsServletBase;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BadgingServlet
extends TagsServletBase {
    protected BufferedImage bufferedImage1 = null;
    private String contextPath = null;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.contextPath = request.getContextPath();
        ServletOutputStream servletOutput = response.getOutputStream();
        String src1 = request.getParameter("img1");
        String src2 = request.getParameter("img2");
        int x = Integer.parseInt(request.getParameter("x"));
        int y = Integer.parseInt(request.getParameter("y"));
        try {
            BufferedImage badgedImage = this.doBadge(src1, src2, x, y);
            response.setContentType("image/png");
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)badgedImage, "png", byteOutput);
            servletOutput.write(byteOutput.toByteArray());
            servletOutput.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected BufferedImage doBadge(String src1, String src2, int x, int y) throws IOException {
        BufferedImage image1 = this.getImage(src1);
        BufferedImage image2 = this.getImage(src2);
        int image1Width = image1.getWidth(null);
        int image1Height = image1.getHeight(null);
        int image2Width = image2.getWidth(null);
        int image2Height = image2.getHeight(null);
        int xOverhang = 0;
        int yOverhang = 0;
        if (x + image2Width > image1Width) {
            xOverhang = image2Width + x - image1Width;
        }
        if (y + image2Height > image1Height) {
            yOverhang = image2Height + y - image1Height;
        }
        int destWidth = image1Width + xOverhang;
        int destHeight = image1Height + yOverhang;
        BufferedImage finalImage = new BufferedImage(destWidth, destHeight, 2);
        Graphics2D g2 = finalImage.createGraphics();
        g2.drawImage((Image)image1, 0, 0, null);
        g2.drawImage((Image)image2, x, y, null);
        g2.dispose();
        return finalImage;
    }

    private BufferedImage getImage(String src) {
        BufferedImage image = CCSystem.getResourceImage(src);
        if (image == null) {
            try {
                ServletContext sc = this.getServletContext();
                if (src.startsWith(this.contextPath + "/")) {
                    src = src.substring(this.contextPath.length() + 1);
                }
                image = ImageIO.read(sc.getResourceAsStream(src));
            }
            catch (Exception ex) {
                CCDebug.trace1("Error reading image resource " + src + ": " + ex.getMessage());
            }
        }
        return image;
    }
}

