/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCManageChildrenModel;
import com.sun.web.ui.model.CCPropertySheetModelInterface;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCPropertySheetModel
extends CCManageChildrenModel
implements CCPropertySheetModelInterface {
    private HashMap childMap = new HashMap();
    private HashSet errors = new HashSet();
    private HashSet hiddenElements = new HashSet();

    public CCPropertySheetModel() {
        CCDebug.initTrace();
    }

    public CCPropertySheetModel(String value) {
        this();
        this.setDocument(value);
    }

    public CCPropertySheetModel(ServletContext sc, String file) {
        this();
        String value = this.getXMLFileAsString(sc.getResourceAsStream(file));
        this.setDocument(value);
    }

    public CCPropertySheetModel(InputStream is) {
        this();
        this.setDocument(is);
    }

    public void setDocument(InputStream is) {
        super.setDocument(is);
        this.createChildMaps();
    }

    protected void createDocument(InputStream is) throws IllegalArgumentException {
        if (is == null) {
            throw new IllegalArgumentException("Invalid parameter: The InputStream is null in CCPropertySheetModel.");
        }
        super.createDocument(is);
    }

    private void createChildMaps() {
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        this.parseNodeList(document.getElementsByTagName("label"), this.childMap, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
        this.parseNodeList(document.getElementsByTagName("cc"), this.childMap, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
        this.parseNodeList(document.getElementsByTagName("section"), this.childMap, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
        this.parseNodeList(document.getElementsByTagName("subsection"), this.childMap, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
        this.parseNodeList(document.getElementsByTagName("fieldhelp"), this.childMap, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
    }

    private void parseNodeList(NodeList nodeList, HashMap map, String tagclassName) {
        if (nodeList == null) {
            CCDebug.trace1("NodeList parameter is null in CCPropertySheet.parseNodeList().");
            return;
        }
        int length = nodeList.getLength();
        for (int i = 0; i < length; ++i) {
            String v;
            Node node = nodeList.item(i);
            if (!node.hasAttributes()) continue;
            NamedNodeMap nodeAttrs = node.getAttributes();
            Node nameNode = nodeAttrs.getNamedItem("name");
            Node tagclassNode = nodeAttrs.getNamedItem("tagclass");
            if (nameNode == null) continue;
            if (tagclassNode != null && (v = tagclassNode.getNodeValue()) != null && !v.equals("")) {
                tagclassName = v;
            }
            map.put(nameNode.getNodeValue(), tagclassName);
        }
    }

    public void registerChildren(ContainerViewBase view) {
        Iterator it = this.childMap.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            try {
                super.registerChildren(view, name, (String)this.childMap.get(name));
            }
            catch (IllegalArgumentException e) {
                CCDebug.trace1("CCPropertySheetModel cannot register tag class:" + name + "\n" + "This class must be registered in the parent view bean.");
            }
        }
    }

    public View createChild(View parent, String name) {
        String tagclass = (String)this.childMap.get(name);
        return super.createChild(parent, this, name, tagclass);
    }

    public boolean isChildSupported(String name) {
        boolean supported = this.childMap.containsKey(name);
        if (supported) {
            return true;
        }
        return super.isChildSupported(name);
    }

    public void setVisible(String name, boolean visible) {
        if (visible) {
            this.hiddenElements.remove(name);
        } else {
            this.hiddenElements.add(name);
        }
    }

    public boolean isVisible(String name) {
        return !this.hiddenElements.contains(name);
    }

    public void setErrorProperty(String name, boolean error) {
        if (error) {
            this.errors.add(name);
        } else {
            this.errors.remove(name);
        }
    }

    public boolean isErrorProperty(String name) {
        return this.errors.contains(name);
    }
}

