/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.model;

import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.html.CheckBox;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.HiddenField;
import com.iplanet.jato.view.html.ImageField;
import com.iplanet.jato.view.html.ListBox;
import com.iplanet.jato.view.html.RadioButtonGroup;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import com.sun.web.ui.common.CCDebug;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCManageChildrenModel;
import com.sun.web.ui.view.alarm.CCAlarm;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import com.sun.web.ui.view.alert.CCAlert;
import com.sun.web.ui.view.html.CCButton;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCActionTableModel
extends CCManageChildrenModel
implements CCActionTableModelInterface {
    private static final long serialVersionUID = 283552106283568446L;
    private String advancedSortName = null;
    private String advancedSortOrder = null;
    private String primarySortName = null;
    private String primarySortOrder = null;
    private String secondarySortName = null;
    private String secondarySortOrder = null;
    private int[] sortIndex = null;
    private Boolean showAdvancedSortIcon = null;
    private Boolean showLowerActions = null;
    private Boolean showSelectionIcons = null;
    private Boolean showSelectionSortIcon = null;
    private Boolean showPaginationIcon = null;
    private Boolean showPaginationControls = null;
    private boolean advancedFilterActive = false;
    private boolean advancedFilterAvailable = false;
    private boolean basicFilterActive = false;
    private String basicFilterLabel = null;
    private String selectionType = null;
    private String empty = null;
    private String summary = null;
    private String title = null;
    private String titleLabel = null;
    private int page = -1;
    private int maxRows = -1;
    private int availableRows = -1;
    private int firstRow = -1;
    private int lastRow = -1;
    private int firstRowIndex = -1;
    private int lastRowIndex = -1;
    private String advancedFilterChild = null;
    private String preferencesChild = null;
    private int advancedFilterHeight = -1;
    private int advancedFilterWidth = -1;
    private int preferencesHeight = -1;
    private int preferencesWidth = -1;
    private String productNameAlt = null;
    private String productNameHeight = null;
    private String productNameSrc = null;
    private String productNameWidth = null;
    private HashMap childMap = new HashMap();
    private HashMap actionChildMap = new HashMap();
    private DefaultModel actionModel = new DefaultModel();
    private ResourceBundle bundle = null;
    private static final String SELECTION_VISIBLE = "selectionVisible";
    private Boolean showSortingRow = null;

    public CCActionTableModel() {
        CCDebug.initTrace();
    }

    public CCActionTableModel(String value) {
        this();
        this.setDocument(value);
    }

    public CCActionTableModel(ServletContext sc, String file) {
        this();
        String value = this.getXMLFileAsString(sc.getResourceAsStream(file));
        this.setDocument(value);
    }

    public CCActionTableModel(InputStream is) {
        this();
        this.setDocument(is);
    }

    public void setDocument(InputStream is) {
        super.setDocument(is);
        this.createChildMaps();
    }

    protected void createDocument(InputStream is) {
        super.createDocument(is);
    }

    private void createChildMaps() {
        Document document = this.getDocument();
        if (document == null) {
            CCDebug.trace1("Model document is null");
            return;
        }
        this.parseNodeList(document.getElementsByTagName("actions"), this.actionChildMap);
        this.parseNodeList(document.getElementsByTagName("filters"), this.actionChildMap);
        this.parseNodeList(document.getElementsByTagName("column"), this.childMap);
    }

    private void parseNodeList(NodeList nodeList, HashMap map) {
        if (nodeList == null) {
            CCDebug.trace1("NodeList parameter is null.");
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.hasChildNodes()) {
                this.parseNodeList(node.getChildNodes(), map);
            }
            if (!node.hasAttributes()) continue;
            NamedNodeMap nodeAttrs = node.getAttributes();
            Node nameNode = nodeAttrs.getNamedItem("name");
            Node tagclassNode = nodeAttrs.getNamedItem("tagclass");
            if (nameNode == null) continue;
            String nodeName = node.getNodeName();
            String name = nameNode.getNodeValue();
            if (nodeName.equals("column")) {
                this.actionChildMap.put(name, "com.sun.web.ui.taglib.html.CCStaticTextFieldTag");
                continue;
            }
            if (!nodeName.equals("cc")) continue;
            map.put(name, tagclassNode.getNodeValue());
        }
    }

    public void registerChildren(ContainerViewBase view) {
        String name;
        Iterator i = this.childMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            try {
                super.registerChildren(view, name, (String)this.childMap.get(name));
            }
            catch (IllegalArgumentException e) {
                CCDebug.trace1("Cannot register tag class: " + name);
            }
        }
        i = this.actionChildMap.keySet().iterator();
        while (i.hasNext()) {
            name = (String)i.next();
            try {
                super.registerChildren(view, name, (String)this.actionChildMap.get(name));
            }
            catch (IllegalArgumentException e) {
                CCDebug.trace1("Cannot register tag class: " + name);
            }
        }
    }

    public View createChild(View view, String name) {
        String tagclass = (String)this.childMap.get(name);
        CCActionTableModel model = this;
        if (tagclass == null) {
            tagclass = (String)this.actionChildMap.get(name);
            model = this.actionModel;
        }
        if (tagclass == null) {
            throw new IllegalArgumentException("Invalid child name: " + name);
        }
        return super.createChild(view, (Model)model, name, tagclass);
    }

    public boolean isChildSupported(String name) {
        boolean result = this.childMap.containsKey(name);
        return result ? result : this.actionChildMap.containsKey(name);
    }

    public int getAvailableRows() {
        return this.availableRows;
    }

    public void setAvailableRows(int value) {
        this.availableRows = value;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public void setFirstRow(int value) {
        this.firstRow = value;
    }

    public int getLastRow() {
        return this.lastRow;
    }

    public void setLastRow(int value) {
        this.lastRow = value;
    }

    public int getFirstRowIndex() {
        return this.firstRowIndex;
    }

    public void setFirstRowIndex(int value) {
        this.firstRowIndex = value;
    }

    public int getLastRowIndex() {
        return this.lastRowIndex;
    }

    public void setLastRowIndex(int value) {
        this.lastRowIndex = value;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int value) {
        this.maxRows = value;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int value) {
        this.page = value;
    }

    public String getAdvancedFilterChild() {
        return this.advancedFilterChild;
    }

    public void setAdvancedFilterChild(String value) {
        this.advancedFilterChild = value;
    }

    public String getPreferencesChild() {
        return this.preferencesChild;
    }

    public void setPreferencesChild(String value) {
        this.preferencesChild = value;
    }

    public String getProductNameAlt() {
        return this.productNameAlt;
    }

    public void setProductNameAlt(String value) {
        this.productNameAlt = value;
    }

    public String getProductNameHeight() {
        return this.productNameHeight;
    }

    public void setProductNameHeight(String value) {
        this.productNameHeight = value;
    }

    public String getProductNameSrc() {
        return this.productNameSrc;
    }

    public void setProductNameSrc(String value) {
        this.productNameSrc = value;
    }

    public String getProductNameWidth() {
        return this.productNameWidth;
    }

    public void setProductNameWidth(String value) {
        this.productNameWidth = value;
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public void setSelectionType(String value) {
        if (!(value == null || value.equals("multiple") || value.equals("single") || value.equals("none"))) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.selectionType = value;
    }

    public boolean isRowSelected() {
        return this.isRowSelected(this.getRowIndex());
    }

    public boolean isRowSelected(int row) {
        Object value;
        boolean result = false;
        if (this.getSelectionType() != null && this.getSelectionType().equals("multiple")) {
            Object value2 = this.getActionValue("SelectionCheckbox" + row);
            if (value2 != null) {
                result = new Boolean(value2.toString());
            }
        } else if (this.getSelectionType() != null && this.getSelectionType().equals("single") && (value = this.getActionValue("SelectionRadiobutton")) != null && value.toString().equals(Integer.toString(row))) {
            result = true;
        }
        return result;
    }

    public Integer[] getSelectedRows() {
        int i;
        ArrayList<Integer> list1 = new ArrayList<Integer>();
        Integer[] list2 = null;
        for (i = 0; i < this.getNumRows(); ++i) {
            if (!this.isRowSelected(i)) continue;
            list1.add(new Integer(i));
        }
        list2 = new Integer[list1.size()];
        for (i = 0; i < list1.size(); ++i) {
            list2[i] = (Integer)list1.get(i);
        }
        return list2;
    }

    public void setRowSelected(boolean value) {
        int index = this.getRowIndex();
        if (index >= 0) {
            this.setActionValue("SelectionCheckbox" + index, Boolean.toString(value));
            this.setActionValue("SelectionRadiobutton", value ? Integer.toString(index) : null);
        }
    }

    public void setRowSelected(int row, boolean value) {
        this.setRowIndex(row);
        this.setRowSelected(value);
    }

    public boolean isSelectionVisible() {
        return this.isSelectionVisible(this.getRowIndex());
    }

    public boolean isSelectionVisible(int row) {
        Object value;
        boolean result = true;
        if (this.getSelectionType() != null && (value = this.getActionValue(SELECTION_VISIBLE + row)) != null) {
            result = new Boolean(value.toString());
        }
        return result;
    }

    public void setSelectionVisible(boolean value) {
        int index = this.getRowIndex();
        if (this.getRowIndex() >= 0) {
            this.setActionValue(SELECTION_VISIBLE + index, new Boolean(value));
        }
    }

    public void setSelectionVisible(int row, boolean value) {
        this.setRowIndex(row);
        this.setSelectionVisible(value);
    }

    public void removeRow(int row) {
        this.getRowList().remove(row);
    }

    public Boolean getShowAdvancedSortIcon() {
        return this.showAdvancedSortIcon;
    }

    public void setShowAdvancedSortIcon(boolean value) {
        this.showAdvancedSortIcon = new Boolean(value);
    }

    public Boolean getShowLowerActions() {
        return this.showLowerActions;
    }

    public void setShowLowerActions(boolean value) {
        this.showLowerActions = new Boolean(value);
    }

    public Boolean getShowSelectionIcons() {
        return this.showSelectionIcons;
    }

    public void setShowSelectionIcons(boolean value) {
        this.showSelectionIcons = new Boolean(value);
    }

    public Boolean getShowSelectionSortIcon() {
        return this.showSelectionSortIcon;
    }

    public void setShowSelectionSortIcon(boolean value) {
        this.showSelectionSortIcon = new Boolean(value);
    }

    public Boolean getShowPaginationIcon() {
        return this.showPaginationIcon;
    }

    public void setShowPaginationIcon(boolean value) {
        this.showPaginationIcon = new Boolean(value);
    }

    public Boolean getShowPaginationControls() {
        return this.showPaginationControls;
    }

    public void setShowPaginationControls(boolean value) {
        this.showPaginationControls = new Boolean(value);
    }

    private void initSortIndex() {
        this.sortIndex = new int[this.getNumRows()];
        for (int i = 0; i < this.getNumRows(); ++i) {
            this.sortIndex[i] = i;
        }
    }

    public int[] getSortIndex() {
        if (this.sortIndex == null) {
            this.sort();
        }
        return this.sortIndex;
    }

    public void sort() {
        this.initSortIndex();
        if (this.getAdvancedSortName() != null && this.getAdvancedSortOrder() != null && this.getAdvancedSortName().trim().length() > 0 && this.getAdvancedSortOrder().trim().length() > 0) {
            this.mergesort(this.sortIndex, 0, this.sortIndex.length - 1, this.getAdvancedSortName(), this.getAdvancedSortOrder());
        } else {
            CCDebug.trace3("Could not obtain advanced sort info.");
        }
        if (this.getSecondarySortName() != null && this.getSecondarySortOrder() != null && this.getSecondarySortName().trim().length() > 0 && this.getSecondarySortOrder().trim().length() > 0) {
            this.mergesort(this.sortIndex, 0, this.sortIndex.length - 1, this.getSecondarySortName(), this.getSecondarySortOrder());
        } else {
            CCDebug.trace3("Could not obtain secondary sort info.");
        }
        if (this.getPrimarySortName() != null && this.getPrimarySortOrder() != null && this.getPrimarySortName().trim().length() > 0 && this.getPrimarySortOrder().trim().length() > 0) {
            this.mergesort(this.sortIndex, 0, this.sortIndex.length - 1, this.getPrimarySortName(), this.getPrimarySortOrder());
        } else {
            CCDebug.trace3("Could not obtain primary sort info.");
        }
    }

    private void mergesort(int[] a, int first, int last, String name, String order) {
        if (first < last) {
            int mid = (first + last) / 2;
            this.mergesort(a, first, mid, name, order);
            this.mergesort(a, mid + 1, last, name, order);
            this.merge(a, first, mid, last, name, order);
        }
    }

    private void merge(int[] a, int first, int mid, int last, String name, String order) {
        int i;
        int length = last - first + 1;
        int[] tmp = new int[length];
        int index1 = 0;
        int index2 = mid - first + 1;
        for (i = 0; i < length; ++i) {
            tmp[i] = a[first + i];
        }
        for (i = 0; i < length; ++i) {
            if (index2 <= last - first) {
                if (index1 <= mid - first) {
                    if (order.equals("ascending") ? this.compare(tmp[index1], tmp[index2], name) > 0 : this.compare(tmp[index1], tmp[index2], name) < 0) {
                        a[first + i] = tmp[index2++];
                        continue;
                    }
                    a[first + i] = tmp[index1++];
                    continue;
                }
                a[first + i] = tmp[index2++];
                continue;
            }
            a[first + i] = tmp[index1++];
        }
    }

    private int compare(int index1, int index2, String name) {
        if (name.indexOf("SelectionCheckbox") == 0 || name.equals("SelectionRadiobutton")) {
            this.setRowIndex(index1);
            boolean b1 = this.isRowSelected();
            this.setRowIndex(index2);
            boolean b2 = this.isRowSelected();
            if (b1 == b2) {
                return 0;
            }
            if (b2) {
                return -1;
            }
            return 1;
        }
        this.setRowIndex(index1);
        Object o1 = this.getValue(name);
        this.setRowIndex(index2);
        Object o2 = this.getValue(name);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 instanceof Comparator && o2 instanceof Comparator) {
            return ((Comparator)o1).compare(o1, o2);
        }
        if (o1 instanceof CCAlarmObject && o2 instanceof CCAlarmObject) {
            return ((CCAlarmObject)o1).compareTo(o2);
        }
        if (o1 instanceof Character && o2 instanceof Character) {
            return ((Character)o1).compareTo(o2);
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            return ((Date)o1).compareTo(o2);
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            Double d1 = new Double(((Number)o1).doubleValue());
            Double d2 = new Double(((Number)o2).doubleValue());
            return d1.compareTo(d2);
        }
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            boolean b2;
            boolean b1 = (Boolean)o1;
            if (b1 == (b2 = ((Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return -1;
            }
            return 1;
        }
        if (o1 instanceof String && o2 instanceof String && this.bundle != null) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            try {
                s1 = this.bundle.getString((String)o1);
                s2 = this.bundle.getString((String)o2);
            }
            catch (MissingResourceException e) {
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            Collator collator = Collator.getInstance(this.bundle.getLocale());
            collator.setStrength(3);
            return collator.compare(s1, s2);
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        return s1.compareTo(s2);
    }

    public String getAdvancedSortName() {
        return this.advancedSortName;
    }

    public String getAdvancedSortOrder() {
        return this.advancedSortOrder;
    }

    public String getPrimarySortName() {
        return this.primarySortName;
    }

    public String getPrimarySortOrder() {
        return this.primarySortOrder;
    }

    public String getSecondarySortName() {
        return this.secondarySortName;
    }

    public String getSecondarySortOrder() {
        return this.secondarySortOrder;
    }

    public void setAdvancedSortName(String value) {
        this.advancedSortName = value;
    }

    public void setPrimarySortName(String value) {
        this.primarySortName = value;
    }

    public void setSecondarySortName(String value) {
        this.secondarySortName = value;
    }

    public void setAdvancedSortOrder(String value) {
        if (value != null && !value.equals("ascending") && !value.equals("descending")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.advancedSortOrder = value;
    }

    public void setPrimarySortOrder(String value) {
        if (value != null && !value.equals("ascending") && !value.equals("descending")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.primarySortOrder = value;
    }

    public void setSecondarySortOrder(String value) {
        if (value != null && !value.equals("ascending") && !value.equals("descending")) {
            CCDebug.trace1("Invalid parameter: " + value);
            return;
        }
        this.secondarySortOrder = value;
    }

    public boolean isAdvancedFilterActive() {
        return this.advancedFilterActive;
    }

    public void setAdvancedFilterActive(boolean value) {
        this.advancedFilterActive = value;
        if (value) {
            this.setBasicFilterActive(false);
            this.setAdvancedFilterAvailable(true);
        }
    }

    public boolean isAdvancedFilterAvailable() {
        return this.advancedFilterAvailable;
    }

    public void setAdvancedFilterAvailable(boolean value) {
        this.advancedFilterAvailable = value;
    }

    public boolean isBasicFilterActive() {
        return this.basicFilterActive;
    }

    public void setBasicFilterActive(boolean value) {
        this.basicFilterActive = value;
        if (value) {
            this.setAdvancedFilterActive(false);
        }
    }

    public String getBasicFilterLabel() {
        return this.basicFilterLabel;
    }

    public void setBasicFilterLabel(String value) {
        this.basicFilterLabel = value;
    }

    public String getEmpty() {
        return this.empty;
    }

    public void setEmpty(String value) {
        this.empty = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getTitleLabel() {
        return this.titleLabel;
    }

    public void setTitleLabel(String value) {
        this.titleLabel = value;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String value) {
        this.summary = value;
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }

    public void setResourceBundle(ResourceBundle value) {
        this.bundle = value;
    }

    public Object getActionValue(String name) {
        return this.actionModel.getValue(name);
    }

    public void setActionValue(String name, Object value) {
        this.actionModel.setValue(name, value);
    }

    public Object[] getValues(String name) {
        Object[] values = new Object[]{};
        values = name.indexOf("SelectionCheckbox") == 0 || name.equals("SelectionRadiobutton") ? this.actionModel.getValues(name) : super.getValues(name);
        return values;
    }

    public void setValues(String name, Object[] values) {
        if (name.indexOf("SelectionCheckbox") == 0 || name.equals("SelectionRadiobutton")) {
            this.actionModel.setValues(name, values);
        } else {
            super.setValues(name, values);
        }
    }

    public void clear() {
        super.clear();
    }

    public void clearAll() {
        this.clear();
        this.actionModel.clear();
    }

    public int getAdvancedFilterHeight() {
        return this.advancedFilterHeight;
    }

    public void setAdvancedFilterHeight(int value) {
        this.advancedFilterHeight = value;
    }

    public int getAdvancedFilterWidth() {
        return this.advancedFilterWidth;
    }

    public void setAdvancedFilterWidth(int value) {
        this.advancedFilterWidth = value;
    }

    public int getPreferencesHeight() {
        return this.preferencesHeight;
    }

    public void setPreferencesHeight(int value) {
        this.preferencesHeight = value;
    }

    public int getPreferencesWidth() {
        return this.preferencesWidth;
    }

    public void setPreferencesWidth(int value) {
        this.preferencesWidth = value;
    }

    public void beginDisplay() {
    }

    public View getChild(String name) {
        return (View)this.childMap.get(name);
    }

    protected void setChildMapValue(String name, String tagclass, HashMap map) {
        if (name == null) {
            CCDebug.trace1("name parameter is null.");
            return;
        }
        if (tagclass == null) {
            CCDebug.trace1("tagclass parameter is null.");
            return;
        }
        if (tagclass.equals("com.sun.web.ui.taglib.alarm.CCAlarmTag")) {
            map.put(name, CCAlarm.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.alert.CCAlertTag")) {
            map.put(name, CCAlert.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCButtonTag")) {
            map.put(name, CCButton.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCCheckBoxTag")) {
            map.put(name, CheckBox.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCDropDownMenuTag")) {
            map.put(name, ComboBox.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.table.CCEmbeddedActionTag")) {
            map.put(name, HREF.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCHiddenTag")) {
            map.put(name, HiddenField.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCHrefTag")) {
            map.put(name, HREF.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCImageTag")) {
            map.put(name, ImageField.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCPasswordTag")) {
            map.put(name, TextField.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCRadioButtonTag")) {
            map.put(name, RadioButtonGroup.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCSelectableListTag")) {
            map.put(name, ListBox.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCStaticTextFieldTag")) {
            map.put(name, StaticTextField.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCTextAreaTag")) {
            map.put(name, TextField.class);
        } else if (tagclass.equals("com.sun.web.ui.taglib.html.CCTextFieldTag")) {
            map.put(name, TextField.class);
        } else {
            CCDebug.trace1("Unknown tag class: " + tagclass);
        }
    }

    public boolean isMaxRowsSet() {
        return this.maxRows != -1;
    }

    public int getStartRow() {
        return this.getFirstRowIndex();
    }

    public int getEndRow() {
        return this.getLastRowIndex();
    }

    public boolean isPageSet() {
        return this.page != -1;
    }

    public int getMaxPages() {
        int result = 0;
        if (this.getMaxRows() > 0) {
            result = this.getNumRows() / this.getMaxRows();
            if (this.getNumRows() % this.getMaxRows() > 0) {
                ++result;
            }
        }
        return result;
    }

    public boolean isShowAdvancedSortingIconSet() {
        return this.showAdvancedSortIcon != null;
    }

    public boolean showAdvancedSortingIcon() {
        return this.isShowAdvancedSortingIconSet() ? this.showAdvancedSortIcon : true;
    }

    public boolean isShowLowerActionsSet() {
        return this.showLowerActions != null;
    }

    public boolean showLowerActions() {
        boolean result = false;
        if (this.showActions()) {
            result = this.isShowLowerActionsSet() ? this.showLowerActions : true;
        }
        return result;
    }

    public boolean isShowSelectionIconsSet() {
        return this.showSelectionIcons != null;
    }

    public boolean showSelectionIcons() {
        return this.isShowSelectionIconsSet() ? this.showSelectionIcons : true;
    }

    public boolean isShowPaginationIconSet() {
        return this.showPaginationIcon != null;
    }

    public boolean showPaginationIcon() {
        return this.isShowPaginationIconSet() ? this.showPaginationIcon : true;
    }

    public boolean isShowPaginationControlsSet() {
        return this.showPaginationControls != null;
    }

    public boolean showPaginationControls() {
        return this.showPaginationIcon() ? (this.isShowPaginationControlsSet() ? this.showPaginationControls : true) : false;
    }

    public boolean isShowSortingRowSet() {
        return this.showSortingRow != null;
    }

    public boolean showSortingRow() {
        return this.isShowSortingRowSet() ? this.showSortingRow : true;
    }

    public boolean showActions() {
        boolean result = false;
        NodeList nodeList = this.getDocument().getElementsByTagName("actions");
        if (nodeList != null && nodeList.getLength() > 0) {
            result = true;
        }
        return result;
    }

    public boolean showSettings() {
        boolean result = false;
        NodeList nodeList = this.getDocument().getElementsByTagName("settings");
        if (nodeList != null && nodeList.getLength() > 0) {
            result = true;
        }
        return result;
    }

    public Boolean getShowSortingRow() {
        return this.showSortingRow;
    }

    public void setShowSortingRow(boolean value) {
        this.showSortingRow = new Boolean(value);
    }

    public boolean isRowSelectionTypeSet() {
        return this.selectionType != null;
    }

    public String getRowSelectionType() {
        return this.getSelectionType();
    }

    public void setRowSelectionType(String value) {
        this.setSelectionType(value);
    }

    public boolean showRowSelectionColumn() {
        return !this.getSelectionType().equals("none");
    }

    public Boolean getShowAdvancedSortingIcon() {
        return this.getShowAdvancedSortIcon();
    }

    public void setShowAdvancedSortingIcon(boolean value) {
        this.setShowAdvancedSortIcon(value);
    }
}

