/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.renderkit.html_basic.HtmlBasicRenderer;
import com.sun.faces.util.MessageUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
extends HtmlBasicRenderer {
    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding component " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No encoding necessary " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("table", (UIComponent)data);
        this.writeIdAttributeIfNecessary(context, writer, component);
        String styleClass = (String)data.getAttributes().get("styleClass");
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        RenderKitUtils.renderPassThruAttributes(context, writer, component, new String[]{"rows"});
        writer.writeText((Object)"\n", component, null);
        UIComponent caption = this.getFacet((UIComponent)data, "caption");
        if (caption != null) {
            String captionClass = (String)data.getAttributes().get("captionClass");
            String captionStyle = (String)data.getAttributes().get("captionStyle");
            writer.startElement("caption", (UIComponent)data);
            if (captionClass != null) {
                writer.writeAttribute("class", (Object)captionClass, "captionClass");
            }
            if (captionStyle != null) {
                writer.writeAttribute("style", (Object)captionStyle, "captionStyle");
            }
            this.encodeRecursive(context, caption);
            writer.endElement("caption");
        }
        List<UIColumn> columns = this.getColumns(data);
        UIComponent header = this.getFacet((UIComponent)data, "header");
        int headerFacets = this.getFacetCount("header", columns);
        String headerClass = (String)data.getAttributes().get("headerClass");
        if (header != null || headerFacets > 0) {
            writer.startElement("thead", (UIComponent)data);
            writer.writeText((Object)"\n", component, null);
        }
        if (header != null) {
            writer.startElement("tr", header);
            writer.startElement("th", header);
            if (headerClass != null) {
                writer.writeAttribute("class", (Object)headerClass, "headerClass");
            }
            writer.writeAttribute("colspan", (Object)("" + columns.size()), null);
            writer.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(context, header);
            writer.endElement("th");
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        if (headerFacets > 0) {
            writer.startElement("tr", (UIComponent)data);
            writer.writeText((Object)"\n", component, null);
            for (UIColumn column : columns) {
                String columnHeaderClass = (String)column.getAttributes().get("headerClass");
                writer.startElement("th", (UIComponent)column);
                if (columnHeaderClass != null) {
                    writer.writeAttribute("class", (Object)columnHeaderClass, "columnHeaderClass");
                } else if (headerClass != null) {
                    writer.writeAttribute("class", (Object)headerClass, "headerClass");
                }
                writer.writeAttribute("scope", (Object)"col", null);
                UIComponent facet = this.getFacet((UIComponent)column, "header");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("th");
                writer.writeText((Object)"\n", component, null);
            }
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        if (header != null || headerFacets > 0) {
            writer.endElement("thead");
            writer.writeText((Object)"\n", component, null);
        }
        UIComponent footer = this.getFacet((UIComponent)data, "footer");
        int footerFacets = this.getFacetCount("footer", columns);
        String footerClass = (String)data.getAttributes().get("footerClass");
        if (footer != null || footerFacets > 0) {
            writer.startElement("tfoot", (UIComponent)data);
            writer.writeText((Object)"\n", component, null);
        }
        if (footer != null) {
            writer.startElement("tr", footer);
            writer.startElement("td", footer);
            if (footerClass != null) {
                writer.writeAttribute("class", (Object)footerClass, "footerClass");
            }
            writer.writeAttribute("colspan", (Object)("" + columns.size()), null);
            this.encodeRecursive(context, footer);
            writer.endElement("td");
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        if (footerFacets > 0) {
            writer.startElement("tr", (UIComponent)data);
            writer.writeText((Object)"\n", component, null);
            for (UIColumn column : columns) {
                String columnFooterClass = (String)column.getAttributes().get("footerClass");
                writer.startElement("td", (UIComponent)column);
                if (columnFooterClass != null) {
                    writer.writeAttribute("class", (Object)columnFooterClass, "columnFooterClass");
                } else if (footerClass != null) {
                    writer.writeAttribute("class", (Object)footerClass, "footerClass");
                }
                UIComponent facet = this.getFacet((UIComponent)column, "footer");
                if (facet != null) {
                    this.encodeRecursive(context, facet);
                }
                writer.endElement("td");
                writer.writeText((Object)"\n", component, null);
            }
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        if (footer != null || footerFacets > 0) {
            writer.endElement("tfoot");
            writer.writeText((Object)"\n", component, null);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Begin encoding children " + component.getId());
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No encoding necessary " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        UIData data = (UIData)component;
        String[] columnClasses = this.getColumnClasses(data);
        int numColumnClasses = columnClasses.length;
        String[] rowClasses = this.getRowClasses(data);
        int numRowClasses = rowClasses.length;
        ResponseWriter writer = context.getResponseWriter();
        int processed = 0;
        int rowIndex = data.getFirst() - 1;
        int rows = data.getRows();
        int rowStyle = 0;
        writer.startElement("tbody", component);
        writer.writeText((Object)"\n", component, null);
        while (rows <= 0 || ++processed <= rows) {
            data.setRowIndex(++rowIndex);
            if (!data.isRowAvailable()) break;
            writer.startElement("tr", (UIComponent)data);
            if (numRowClasses > 0) {
                writer.writeAttribute("class", (Object)rowClasses[rowStyle++], "rowClasses");
                if (rowStyle >= numRowClasses) {
                    rowStyle = 0;
                }
            }
            writer.writeText((Object)"\n", component, null);
            int columnStyleIdx = 0;
            List<UIColumn> columns = this.getColumns(data);
            int numberOfColumnClasses = columnClasses.length;
            for (UIColumn column : columns) {
                writer.startElement("td", (UIComponent)column);
                if (numberOfColumnClasses > 0) {
                    writer.writeAttribute("class", (Object)columnClasses[columnStyleIdx++], "columnClasses");
                    if (columnStyleIdx >= numberOfColumnClasses) {
                        columnStyleIdx = 0;
                    }
                }
                Iterator<UIComponent> gkids = this.getChildren((UIComponent)column);
                while (gkids.hasNext()) {
                    this.encodeRecursive(context, gkids.next());
                }
                writer.endElement("td");
                writer.writeText((Object)"\n", component, null);
            }
            writer.endElement("tr");
            writer.writeText((Object)"\n", component, null);
        }
        writer.endElement("tbody");
        writer.writeText((Object)"\n", component, null);
        data.setRowIndex(-1);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding children " + component.getId());
        }
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context"));
        }
        if (component == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "component"));
        }
        if (!component.isRendered()) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("No encoding necessary " + component.getId() + " since " + "rendered attribute is set to false ");
            }
            return;
        }
        UIData data = (UIData)component;
        data.setRowIndex(-1);
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("table");
        writer.writeText((Object)"\n", component, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "End encoding component " + component.getId());
        }
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    private String[] getColumnClasses(UIData data) {
        String values = (String)data.getAttributes().get("columnClasses");
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }

    private List<UIColumn> getColumns(UIData data) {
        int childCount = data.getChildCount();
        if (childCount > 0) {
            ArrayList<UIColumn> results = new ArrayList<UIColumn>(childCount);
            for (UIComponent kid : data.getChildren()) {
                if (!(kid instanceof UIColumn) || !kid.isRendered()) continue;
                results.add((UIColumn)kid);
            }
            return results;
        }
        return Collections.emptyList();
    }

    private int getFacetCount(String name, List<UIColumn> columns) {
        int n = 0;
        if (!columns.isEmpty()) {
            for (UIColumn column : columns) {
                if (this.getFacet((UIComponent)column, name) == null) continue;
                ++n;
            }
        }
        return n;
    }

    private String[] getRowClasses(UIData data) {
        String values = (String)data.getAttributes().get("rowClasses");
        if (values == null) {
            return new String[0];
        }
        values = values.trim();
        ArrayList<String> list = new ArrayList<String>();
        while (values.length() > 0) {
            int comma = values.indexOf(",");
            if (comma >= 0) {
                list.add(values.substring(0, comma).trim());
                values = values.substring(comma + 1);
                continue;
            }
            list.add(values.trim());
            values = "";
        }
        String[] results = new String[list.size()];
        return list.toArray(results);
    }
}

