/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.el.FacesResourceBundleELResolver;
import com.sun.faces.el.ImplicitObjectELResolverForJsp;
import com.sun.faces.el.ManagedBeanELResolver;
import com.sun.faces.el.PropertyResolverChainWrapper;
import com.sun.faces.el.VariableResolverChainWrapper;
import com.sun.faces.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.CompositeELResolver;
import javax.el.ELResolver;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

public class ELResolverInitPhaseListener
implements PhaseListener {
    private static Logger LOGGER = Util.getLogger("javax.enterprise.resource.webcontainer.jsf.lifecycle");
    boolean preInitCompleted;
    boolean postInitCompleted;

    public synchronized void afterPhase(PhaseEvent event) {
        if (!this.postInitCompleted) {
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            Iterator i = factory.getLifecycleIds();
            while (i.hasNext()) {
                Lifecycle lifecycle = factory.getLifecycle((String)i.next());
                lifecycle.removePhaseListener((PhaseListener)this);
            }
            this.postInitCompleted = true;
        }
    }

    public synchronized void beforePhase(PhaseEvent event) {
        if (!this.preInitCompleted) {
            this.populateFacesELResolverForJsp(event.getFacesContext());
            this.preInitCompleted = true;
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }

    protected void populateFacesELResolverForJsp(FacesContext context) {
        ApplicationAssociate appAssociate = ApplicationAssociate.getInstance(context.getExternalContext());
        CompositeELResolver compositeELResolverForJsp = appAssociate.getFacesELResolverForJsp();
        if (compositeELResolverForJsp == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "jsf.lifecycle.initphaselistener.resolvers_not_registered", new Object[]{appAssociate.getContextName()});
            }
            return;
        }
        compositeELResolverForJsp.add((ELResolver)new ImplicitObjectELResolverForJsp());
        compositeELResolverForJsp.add((ELResolver)new ManagedBeanELResolver());
        compositeELResolverForJsp.add((ELResolver)new FacesResourceBundleELResolver());
        List<ELResolver> elResolversFromFacesConfig = appAssociate.geELResolversFromFacesConfig();
        if (elResolversFromFacesConfig != null) {
            for (ELResolver resolver : elResolversFromFacesConfig) {
                compositeELResolverForJsp.add(resolver);
            }
        }
        if (appAssociate.getLegacyVariableResolver() != null) {
            compositeELResolverForJsp.add((ELResolver)new VariableResolverChainWrapper(appAssociate.getLegacyVariableResolver()));
        } else if (appAssociate.getLegacyVRChainHead() != null) {
            compositeELResolverForJsp.add((ELResolver)new VariableResolverChainWrapper(appAssociate.getLegacyVRChainHead()));
        }
        if (appAssociate.getLegacyPropertyResolver() != null) {
            compositeELResolverForJsp.add((ELResolver)new PropertyResolverChainWrapper(appAssociate.getLegacyPropertyResolver()));
        } else if (appAssociate.getLegacyPRChainHead() != null) {
            compositeELResolverForJsp.add((ELResolver)new PropertyResolverChainWrapper(appAssociate.getLegacyPRChainHead()));
        }
        List<ELResolver> elResolversFromApplication = appAssociate.getApplicationELResolvers();
        if (elResolversFromApplication != null) {
            for (ELResolver resolver : elResolversFromApplication) {
                compositeELResolverForJsp.add(resolver);
            }
        }
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.FINE, "jsf.lifecycle.initphaselistener.resolvers_registered", new Object[]{appAssociate.getContextName()});
        }
    }
}

