/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.renderer;

import com.sun.web.ui.component.Breadcrumbs;
import com.sun.web.ui.component.Hyperlink;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.LogUtil;
import com.sun.web.ui.util.MessageUtil;
import com.sun.web.ui.util.RenderingUtilities;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;

public class BreadcrumbsRenderer
extends Renderer {
    public static final String BREADCRUMBS_ID = "_bcpage";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (null == context || null == component) {
            throw new NullPointerException();
        }
        if (!(component instanceof Breadcrumbs)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Breadcrumbs.class.getName()};
            String message = MessageUtil.getMessage("com.sun.web.ui.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        if (!component.isRendered()) {
            return;
        }
        if (component.getChildCount() <= 0) {
            if (LogUtil.infoEnabled(BreadcrumbsRenderer.class)) {
                LogUtil.info((Object)BreadcrumbsRenderer.class, "Breadcrumbs.noChildren", component.getId());
            }
            return;
        }
        Breadcrumbs breadcrumbs = (Breadcrumbs)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        String bcID = breadcrumbs.getClientId(context);
        this.renderContainingDiv(context, breadcrumbs, theme, writer);
        Iterator kids = breadcrumbs.getChildren().iterator();
        int i = 0;
        while (kids.hasNext()) {
            Hyperlink crumb = (Hyperlink)kids.next();
            if (crumb.getId() == null) {
                String bcid = BREADCRUMBS_ID + i++;
                crumb.setId(bcid);
            }
            if (kids.hasNext()) {
                this.renderBreadcrumbsLink(context, crumb, theme);
                this.renderBreadcrumbsSeparator(context, breadcrumbs, theme, writer);
                continue;
            }
            this.renderBreadcrumbsText(context, crumb, theme, writer);
        }
    }

    protected void renderContainingDiv(FacesContext context, Breadcrumbs breadcrumbs, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)breadcrumbs);
        writer.writeAttribute("id", (Object)breadcrumbs.getClientId(context), "id");
        String tdStyle = theme.getStyleClass("BREADCRUMB_WHITE_DIV");
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)breadcrumbs, tdStyle);
        if (breadcrumbs.getStyle() != null) {
            writer.writeAttribute("style", (Object)breadcrumbs.getStyle(), "style");
        }
        writer.writeText((Object)"\n", null);
    }

    protected void renderBreadcrumbsSeparator(FacesContext context, Breadcrumbs breadcrumbs, Theme theme, ResponseWriter writer) throws IOException {
        writer.startElement("span", (UIComponent)breadcrumbs);
        String separatorStyle = theme.getStyleClass("BREADCRUMB_SEPARATOR");
        writer.writeAttribute("class", (Object)separatorStyle, null);
        writer.write("&gt;");
        writer.endElement("span");
    }

    protected void renderBreadcrumbsLink(FacesContext context, Hyperlink crumb, Theme theme) throws IOException {
        String crumbStyle = theme.getStyleClass("BREADCRUMB_LINK");
        Map attributes = crumb.getAttributes();
        if (attributes != null && attributes.get("styleClass") == null) {
            attributes.put("styleClass", crumbStyle);
        }
        RenderingUtilities.renderComponent((UIComponent)crumb, context);
    }

    protected void renderBreadcrumbsText(FacesContext context, Hyperlink crumb, Theme theme, ResponseWriter writer) throws IOException {
        String pageName = crumb.getText();
        if (pageName == null || pageName.length() <= 0) {
            return;
        }
        writer.startElement("span", (UIComponent)crumb);
        String textStyle = theme.getStyleClass("BREADCRUMB_TEXT");
        writer.writeAttribute("class", (Object)textStyle, null);
        writer.writeText((Object)pageName, null);
        writer.endElement("span");
        writer.endElement("div");
    }
}

