/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.ui.component;

import com.sun.web.ui.component.AlarmBase;
import com.sun.web.ui.theme.Theme;
import com.sun.web.ui.util.ThemeUtilities;
import java.io.IOException;
import java.util.Comparator;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

public class Alarm
extends AlarmBase
implements Comparator {
    public static final String SEVERITY_DOWN = "down";
    public static final String SEVERITY_CRITICAL = "critical";
    public static final String SEVERITY_MAJOR = "major";
    public static final String SEVERITY_MINOR = "minor";
    public static final String SEVERITY_OK = "ok";
    public static final String DEFAULT_SEVERITY = "ok";
    private final int SEVERITY_LEVEL_DOWN = 1;
    private final int SEVERITY_LEVEL_CRITICAL = 2;
    private final int SEVERITY_LEVEL_MAJOR = 3;
    private final int SEVERITY_LEVEL_MINOR = 4;
    private final int SEVERITY_LEVEL_OK = 5;
    private static final String CRITICAL_ALT_TEXT_KEY = "Alarm.criticalImageAltText";
    private static final String MAJOR_ALT_TEXT_KEY = "Alarm.majorImageAltText";
    private static final String MINOR_ALT_TEXT_KEY = "Alarm.minorImageAltText";
    private static final String DOWN_ALT_TEXT_KEY = "Alarm.downImageAltText";

    public Alarm() {
    }

    public Alarm(String severity) {
        this.setSeverity(severity);
    }

    public int compare(Object o1, Object o2) throws ClassCastException {
        int s2;
        int s1 = this.getSeverityLevel((Alarm)o1);
        return s1 > (s2 = this.getSeverityLevel((Alarm)o2)) ? -1 : (s1 == s2 ? 0 : 1);
    }

    public boolean equals(Object o) throws ClassCastException {
        int s2;
        int s1 = this.getSeverityLevel(this);
        return s1 == (s2 = this.getSeverityLevel((Alarm)o));
    }

    private int getSeverityLevel(Alarm alarm) {
        int severity = 5;
        String alarmSeverity = alarm.getSeverity();
        if (alarmSeverity == null) {
            return severity;
        }
        if (alarmSeverity.equals(SEVERITY_DOWN)) {
            severity = 1;
        } else if (alarmSeverity.equals(SEVERITY_CRITICAL)) {
            severity = 2;
        } else if (alarmSeverity.equals(SEVERITY_MAJOR)) {
            severity = 3;
        } else if (alarmSeverity.equals(SEVERITY_MINOR)) {
            severity = 4;
        }
        return severity;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (context == null) {
            throw new NullPointerException();
        }
        this.setAlarmProperties(context);
        if (!this.isRendered()) {
            return;
        }
        String rendererType = this.getRendererType();
        if (rendererType != null) {
            this.getRenderer(context).encodeBegin(context, (UIComponent)this);
        }
    }

    private void setAlarmProperties(FacesContext context) {
        String severity = this.getSeverity();
        if (severity == null || severity.trim().length() == 0) {
            this.setIcon(null);
            this.setAlt(null);
            this.setToolTip(null);
            return;
        }
        Theme theme = ThemeUtilities.getTheme(context);
        if (severity.equalsIgnoreCase(SEVERITY_CRITICAL)) {
            this.setIcon("ALARM_CRITICAL_MEDIUM");
            this.setAlt(theme.getMessage(CRITICAL_ALT_TEXT_KEY));
            this.setToolTip(theme.getMessage(CRITICAL_ALT_TEXT_KEY));
        } else if (severity.equalsIgnoreCase(SEVERITY_MAJOR)) {
            this.setIcon("ALARM_MAJOR_MEDIUM");
            this.setAlt(theme.getMessage(MAJOR_ALT_TEXT_KEY));
            this.setToolTip(theme.getMessage(MAJOR_ALT_TEXT_KEY));
        } else if (severity.equalsIgnoreCase(SEVERITY_MINOR)) {
            this.setIcon("ALARM_MINOR_MEDIUM");
            this.setAlt(theme.getMessage(MINOR_ALT_TEXT_KEY));
            this.setToolTip(theme.getMessage(MINOR_ALT_TEXT_KEY));
        } else if (severity.equalsIgnoreCase(SEVERITY_DOWN)) {
            this.setIcon("ALARM_DOWN_MEDIUM");
            this.setAlt(theme.getMessage(DOWN_ALT_TEXT_KEY));
            this.setToolTip(theme.getMessage(DOWN_ALT_TEXT_KEY));
        } else {
            this.setIcon(null);
            this.setAlt(null);
            this.setToolTip(null);
        }
    }
}

