/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.tomcat.util.net.ServerSocketFactory;

public abstract class JSSESocketFactory
extends ServerSocketFactory {
    static String defaultProtocol = "TLS";
    static String defaultAlgorithm = "SunX509";
    static boolean defaultClientAuth = false;
    static String defaultKeystoreType = "JKS";
    private static final String defaultKeystoreFile = System.getProperty("user.home") + "/.keystore";
    private static final String defaultKeyPass = "changeit";
    protected boolean initialized;
    protected boolean clientAuth = false;
    protected SSLServerSocketFactory sslProxy = null;
    protected String[] enabledCiphers;

    public ServerSocket createSocket(int port) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog);
        this.initServerSocket(socket);
        return socket;
    }

    public ServerSocket createSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        if (!this.initialized) {
            this.init();
        }
        ServerSocket socket = this.sslProxy.createServerSocket(port, backlog, ifAddress);
        this.initServerSocket(socket);
        return socket;
    }

    public Socket acceptSocket(ServerSocket socket) throws IOException {
        SSLSocket asock = null;
        try {
            asock = (SSLSocket)socket.accept();
            asock.setNeedClientAuth(this.clientAuth);
        }
        catch (SSLException e) {
            throw new SocketException("SSL handshake error" + e.toString());
        }
        return asock;
    }

    public void handshake(Socket sock) throws IOException {
        ((SSLSocket)sock).startHandshake();
    }

    protected String[] getEnabledCiphers(String requestedCiphers, String[] supportedCiphers) {
        Object[] enabledCiphers = null;
        if (requestedCiphers != null) {
            Vector<String> vec = null;
            String cipher = requestedCiphers;
            int index = requestedCiphers.indexOf(44);
            if (index != -1) {
                int fromIndex = 0;
                while (index != -1) {
                    cipher = requestedCiphers.substring(fromIndex, index).trim();
                    if (cipher.length() > 0) {
                        for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                            if (!supportedCiphers[i].equals(cipher)) continue;
                            if (vec == null) {
                                vec = new Vector();
                            }
                            vec.addElement(cipher);
                            break;
                        }
                    }
                    fromIndex = index + 1;
                    index = requestedCiphers.indexOf(44, fromIndex);
                }
                cipher = requestedCiphers.substring(fromIndex);
            }
            if (cipher != null && (cipher = cipher.trim()).length() > 0) {
                for (int i = 0; supportedCiphers != null && i < supportedCiphers.length; ++i) {
                    if (!supportedCiphers[i].equals(cipher)) continue;
                    if (vec == null) {
                        vec = new Vector<String>();
                    }
                    vec.addElement(cipher);
                    break;
                }
            }
            if (vec != null) {
                enabledCiphers = new String[vec.size()];
                vec.copyInto(enabledCiphers);
            }
        }
        return enabledCiphers;
    }

    protected String getKeystorePassword() {
        String keystorePass;
        String keyPass = (String)this.attributes.get("keypass");
        if (keyPass == null) {
            keyPass = defaultKeyPass;
        }
        if ((keystorePass = (String)this.attributes.get("keystorePass")) == null) {
            keystorePass = keyPass;
        }
        return keystorePass;
    }

    protected KeyStore getKeystore(String type, String pass) throws IOException {
        String keystoreFile = (String)this.attributes.get("keystore");
        if (keystoreFile == null) {
            keystoreFile = defaultKeystoreFile;
        }
        return this.getStore(type, keystoreFile, pass);
    }

    protected KeyStore getTrustStore(String keystoreType) throws IOException {
        KeyStore trustStore = null;
        String trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        String trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        if (trustStoreFile != null && trustStorePassword != null) {
            trustStore = this.getStore(keystoreType, trustStoreFile, trustStorePassword);
        }
        return trustStore;
    }

    private KeyStore getStore(String type, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = KeyStore.getInstance(type);
            File keyStoreFile = new File(path);
            if (!keyStoreFile.isAbsolute()) {
                keyStoreFile = new File(System.getProperty("catalina.base"), path);
            }
            istream = new FileInputStream(keyStoreFile);
            ks.load(istream, pass.toCharArray());
            istream.close();
            istream = null;
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new IOException("Exception trying to load keystore " + path + ": " + ex.getMessage());
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException ioe) {}
            }
        }
        return ks;
    }

    abstract void init() throws IOException;

    protected abstract String[] getEnabledProtocols(SSLServerSocket var1, String var2);

    protected abstract void setEnabledProtocols(SSLServerSocket var1, String[] var2);

    private void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        if (this.attributes.get("ciphers") != null) {
            socket.setEnabledCipherSuites(this.enabledCiphers);
        }
        String requestedProtocols = (String)this.attributes.get("protocols");
        this.setEnabledProtocols(socket, this.getEnabledProtocols(socket, requestedProtocols));
        socket.setNeedClientAuth(this.clientAuth);
    }
}

