/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;

public class FileDirContext
extends BaseDirContext {
    protected static final int BUFFER_SIZE = 2048;
    protected File base = null;
    protected WeakHashMap fileCache = new WeakHashMap();
    protected String absoluteBase = null;
    protected boolean caseSensitive = true;
    protected boolean allowLinking = false;

    public FileDirContext() {
    }

    public FileDirContext(Hashtable env) {
        super(env);
    }

    public void setDocBase(String docBase) {
        if (docBase == null) {
            throw new IllegalArgumentException(this.sm.getString("resources.null"));
        }
        this.base = (File)this.fileCache.get(docBase);
        if (this.base == null) {
            this.base = new File(docBase);
            this.fileCache.put(docBase, this.base);
        }
        try {
            this.base = this.base.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!(this.base.exists() && this.base.isDirectory() && this.base.canRead())) {
            throw new IllegalArgumentException(this.sm.getString("fileResources.base", docBase));
        }
        this.absoluteBase = this.base.getAbsolutePath();
        super.setDocBase(docBase);
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setAllowLinking(boolean allowLinking) {
        this.allowLinking = allowLinking;
    }

    public boolean getAllowLinking() {
        return this.allowLinking;
    }

    public void release() {
        this.caseSensitive = true;
        this.allowLinking = false;
        this.absoluteBase = null;
        this.base = null;
        super.release();
    }

    public Object lookup(String name) throws NamingException {
        Object result = null;
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        if (file.isDirectory()) {
            FileDirContext tempContext = new FileDirContext(this.env);
            tempContext.setDocBase(file.getPath());
            tempContext.setAllowLinking(this.getAllowLinking());
            tempContext.setCaseSensitive(this.isCaseSensitive());
            result = tempContext;
        } else {
            result = new FileResource(file);
        }
        return result;
    }

    public void unbind(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        this.fileCache.remove(name);
        if (!file.delete()) {
            throw new NamingException(this.sm.getString("resources.unbindFailed", name));
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        File file = this.file(oldName);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", oldName));
        }
        File newFile = (File)this.fileCache.get(newName);
        if (newFile == null) {
            newFile = new File(this.base, newName);
        }
        file.renameTo(newFile);
    }

    public NamingEnumeration list(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        Vector entries = this.list(file);
        return new NamingContextEnumeration(entries);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        Vector entries = this.list(file);
        return new NamingContextBindingsEnumeration(entries);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.unbind(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    public String getNameInNamespace() throws NamingException {
        return this.docBase;
    }

    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        File file = this.file(name);
        if (file == null) {
            throw new NamingException(this.sm.getString("resources.notFound", name));
        }
        return new FileResourceAttributes(file);
    }

    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
    }

    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
    }

    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", name));
        }
        this.rebind(file, obj, attrs);
    }

    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        this.rebind(file, obj, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(File file, Object obj, Attributes attrs) throws NamingException {
        InputStream is = null;
        String name = file.getName();
        if (obj instanceof Resource) {
            try {
                is = ((Resource)obj).streamContent();
            }
            catch (IOException e) {}
        } else if (obj instanceof InputStream) {
            is = (InputStream)obj;
        } else if (obj instanceof DirContext) {
            if (file.exists() && !file.delete()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", name));
            }
            if (!file.mkdir()) {
                throw new NamingException(this.sm.getString("resources.bindFailed", name));
            }
        }
        if (is == null) {
            throw new NamingException(this.sm.getString("resources.bindFailed", name));
        }
        try {
            FileOutputStream os = null;
            byte[] buffer = new byte[2048];
            int len = -1;
            try {
                os = new FileOutputStream(file);
                while ((len = is.read(buffer)) != -1) {
                    os.write(buffer, 0, len);
                }
            }
            finally {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
        }
        catch (IOException e) {
            throw new NamingException(this.sm.getString("resources.bindFailed", e));
        }
    }

    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        File file = new File(this.base, name);
        if (file.exists()) {
            throw new NameAlreadyBoundException(this.sm.getString("resources.alreadyBound", name));
        }
        if (!file.mkdir()) {
            throw new NamingException(this.sm.getString("resources.bindFailed", name));
        }
        return (DirContext)this.lookup(name);
    }

    public DirContext getSchema(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, Attributes matchingAttributes) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String filter, SearchControls cons) throws NamingException {
        return null;
    }

    public NamingEnumeration search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return null;
    }

    protected String normalize(String path) {
        int index;
        String normalized = path;
        if (File.separatorChar == '\\' && normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected File file(String name) {
        File file = (File)this.fileCache.get(name);
        if (file == null) {
            file = new File(this.base, name);
        }
        if (file.exists() && file.canRead()) {
            if (!this.caseSensitive && this.allowLinking) {
                this.fileCache.put(name, file);
                return file;
            }
            String canPath = null;
            try {
                canPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (canPath == null) {
                return null;
            }
            if (!this.allowLinking && !canPath.startsWith(this.absoluteBase)) {
                return null;
            }
            if (this.caseSensitive) {
                String fileAbsPath = file.getAbsolutePath();
                if (fileAbsPath.endsWith(".")) {
                    fileAbsPath = fileAbsPath + "/";
                }
                String absPath = this.normalize(fileAbsPath);
                if (canPath != null) {
                    canPath = this.normalize(canPath);
                }
                if (this.absoluteBase.length() < absPath.length() && this.absoluteBase.length() < canPath.length()) {
                    absPath = absPath.substring(this.absoluteBase.length() + 1);
                    if (canPath == null || absPath == null) {
                        return null;
                    }
                    if (absPath.equals("")) {
                        absPath = "/";
                    }
                    if ((canPath = canPath.substring(this.absoluteBase.length() + 1)).equals("")) {
                        canPath = "/";
                    }
                    if (!(canPath.equals(absPath) || !canPath.equalsIgnoreCase(absPath) && this.allowLinking)) {
                        return null;
                    }
                }
            }
        } else {
            return null;
        }
        this.fileCache.put(name, file);
        return file;
    }

    protected Vector list(File file) {
        Vector<NamingEntry> entries = new Vector<NamingEntry>();
        if (!file.isDirectory()) {
            return entries;
        }
        Object[] names = file.list();
        Arrays.sort(names);
        if (names == null) {
            return entries;
        }
        NamingEntry entry = null;
        for (int i = 0; i < names.length; ++i) {
            File currentFile = (File)this.fileCache.get(names[i]);
            if (currentFile == null) {
                currentFile = new File(file, (String)names[i]);
                this.fileCache.put(names[i], currentFile);
            }
            Object object = null;
            if (currentFile.isDirectory()) {
                FileDirContext tempContext = new FileDirContext(this.env);
                tempContext.setDocBase(file.getPath());
                tempContext.setAllowLinking(this.getAllowLinking());
                tempContext.setCaseSensitive(this.isCaseSensitive());
                object = tempContext;
            } else {
                object = new FileResource(currentFile);
            }
            entry = new NamingEntry((String)names[i], object, 0);
            entries.addElement(entry);
        }
        return entries;
    }

    protected class FileResourceAttributes
    extends ResourceAttributes {
        protected File file;
        protected boolean accessed = false;

        public FileResourceAttributes(File file) {
            this.file = file;
        }

        public boolean isCollection() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.isCollection();
        }

        public long getContentLength() {
            if (this.contentLength != -1L) {
                return this.contentLength;
            }
            this.contentLength = this.file.length();
            return this.contentLength;
        }

        public long getCreation() {
            if (this.creation != -1L) {
                return this.creation;
            }
            this.creation = this.file.lastModified();
            return this.creation;
        }

        public Date getCreationDate() {
            if (this.creation == -1L) {
                this.creation = this.file.lastModified();
            }
            return super.getCreationDate();
        }

        public long getLastModified() {
            if (this.lastModified != -1L) {
                return this.lastModified;
            }
            this.lastModified = this.file.lastModified();
            return this.lastModified;
        }

        public Date getLastModifiedDate() {
            if (this.lastModified == -1L) {
                this.lastModified = this.file.lastModified();
            }
            return super.getLastModifiedDate();
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.file.getName();
            }
            return this.name;
        }

        public String getResourceType() {
            if (!this.accessed) {
                this.collection = this.file.isDirectory();
                this.accessed = true;
            }
            return super.getResourceType();
        }
    }

    protected class FileResource
    extends Resource {
        protected File file;
        protected long length = -1L;

        public FileResource(File file) {
            this.file = file;
        }

        public InputStream streamContent() throws IOException {
            if (this.binaryContent == null) {
                this.inputStream = new FileInputStream(this.file);
            }
            return super.streamContent();
        }
    }
}

