/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.sun.org.apache.commons.logging.Log;
import com.sun.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Auditor;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
Lifecycle {
    private static Log log = LogFactory.getLog(AuthenticatorBase.class);
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected boolean cache = true;
    protected Context context = null;
    protected int debug = 0;
    protected MessageDigest digest = null;
    protected String entropy = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected boolean disableProxyCaching = true;
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    protected boolean started = false;
    protected boolean securePagesWithPragma = true;

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public Container getContainer() {
        return this.context;
    }

    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String entropy) {
        this.entropy = entropy;
    }

    public String getInfo() {
        return info;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    public boolean getDisableProxyCaching() {
        return this.disableProxyCaching;
    }

    public void setDisableProxyCaching(boolean nocache) {
        this.disableProxyCaching = nocache;
    }

    public boolean getSecurePagesWithPragma() {
        return this.securePagesWithPragma;
    }

    public void setSecurePagesWithPragma(boolean securePagesWithPragma) {
        this.securePagesWithPragma = securePagesWithPragma;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Session session;
        Principal principal;
        Wrapper wrapper = request.getWrapper();
        if (wrapper == null) {
            try {
                ((HttpServletResponse)response.getResponse()).sendError(404);
            }
            catch (IllegalStateException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
            return 2;
        }
        HttpRequest hrequest = (HttpRequest)request;
        HttpResponse hresponse = (HttpResponse)response;
        if (log.isDebugEnabled()) {
            log.debug("Security checking request " + ((HttpServletRequest)request.getRequest()).getMethod() + " " + ((HttpServletRequest)request.getRequest()).getRequestURI());
        }
        LoginConfig config = this.context.getLoginConfig();
        if (this.cache && (principal = ((HttpServletRequest)request.getRequest()).getUserPrincipal()) == null && (session = this.getSession(hrequest)) != null && (principal = session.getPrincipal()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("We have cached auth type " + session.getAuthType() + " for principal " + session.getPrincipal());
            }
            hrequest.setAuthType(session.getAuthType());
            hrequest.setUserPrincipal(principal);
        }
        String contextPath = this.context.getPath();
        String requestURI = hrequest.getDecodedRequestURI();
        if (requestURI.startsWith(contextPath) && requestURI.endsWith("/j_security_check") && !this.authenticate(hrequest, hresponse, config)) {
            if (log.isDebugEnabled()) {
                log.debug(" Failed authenticate() test ??" + requestURI);
            }
            return 2;
        }
        Realm realm = this.context.getRealm();
        SecurityConstraint[] constraints = realm.findSecurityConstraints(hrequest, this.context);
        if (constraints == null) {
            if (log.isDebugEnabled()) {
                log.debug(" Not subject to any constraint");
            }
            return 1;
        }
        if (log.isDebugEnabled()) {
            log.debug(" Calling hasUserDataPermission()");
        }
        if (!realm.hasUserDataPermission(hrequest, hresponse, constraints)) {
            if (log.isDebugEnabled()) {
                log.debug(" Failed hasUserDataPermission() test");
            }
            return 2;
        }
        int preAuthenticateCheckResult = realm.preAuthenticateCheck(hrequest, hresponse, constraints, this.disableProxyCaching, this.securePagesWithPragma);
        if (preAuthenticateCheckResult == 0) {
            return 1;
        }
        if (preAuthenticateCheckResult == 1) {
            boolean authenticateResult;
            if (log.isDebugEnabled()) {
                log.debug(" Calling authenticate()");
            }
            if (!(authenticateResult = realm.invokeAuthenticateDelegate(hrequest, hresponse, this.context, this))) {
                if (log.isDebugEnabled()) {
                    log.debug(" Failed authenticate() test");
                }
                return 2;
            }
        } else if (preAuthenticateCheckResult == -1) {
            return 2;
        }
        if (log.isDebugEnabled()) {
            log.debug(" Calling accessControl()");
        }
        if (!realm.hasResourcePermission(hrequest, hresponse, constraints, this.context)) {
            Auditor[] auditors;
            if (log.isDebugEnabled()) {
                log.debug(" Failed accessControl() test");
            }
            if ((auditors = this.context.getAuditors()) != null) {
                for (int j = 0; j < auditors.length; ++j) {
                    auditors[j].webInvocation(hrequest, false);
                }
            }
            return 2;
        }
        Auditor[] auditors = this.context.getAuditors();
        if (auditors != null) {
            boolean success = true;
            for (int j = 0; j < auditors.length; ++j) {
                try {
                    auditors[j].webInvocation(hrequest, true);
                    continue;
                }
                catch (Exception e) {
                    success = false;
                }
            }
            if (!success) {
                return 2;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(" Successfully passed all security constraints");
        }
        return 1;
    }

    protected void associate(String ssoId, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(ssoId, session);
    }

    public abstract boolean authenticate(HttpRequest var1, HttpResponse var2, LoginConfig var3) throws IOException;

    protected synchronized String generateSessionId() {
        Random random = this.getRandom();
        byte[] bytes = new byte[16];
        this.getRandom().nextBytes(bytes);
        bytes = this.getDigest().digest(bytes);
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b1 = (byte)((bytes[i] & 0xF0) >> 4);
            byte b2 = (byte)(bytes[i] & 0xF);
            if (b1 < 10) {
                result.append((char)(48 + b1));
            } else {
                result.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                result.append((char)(48 + b2));
                continue;
            }
            result.append((char)(65 + (b2 - 10)));
        }
        return result.toString();
    }

    protected synchronized MessageDigest getDigest() {
        if (this.digest == null) {
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException f) {
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    protected synchronized Random getRandom() {
        if (this.random == null) {
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                long seed = System.currentTimeMillis();
                char[] entropy = this.getEntropy().toCharArray();
                for (int i = 0; i < entropy.length; ++i) {
                    long update = (byte)entropy[i] << i % 8 * 8;
                    seed ^= update;
                }
                this.random.setSeed(seed);
            }
            catch (Exception e) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    protected Session getSession(HttpRequest request) {
        return this.getSession(request, false);
    }

    protected Session getSession(HttpRequest request, boolean create) {
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpSession hses = hreq.getSession(create);
        if (hses == null) {
            return null;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(hses.getId());
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void log(String message) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + message, throwable);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void register(HttpRequest request, HttpResponse response, Principal principal, String authType, String username, String password) {
        Session session;
        if (log.isDebugEnabled()) {
            log.debug("Authenticated '" + principal.getName() + "' with type '" + authType + "'");
        }
        request.setAuthType(authType);
        request.setUserPrincipal(principal);
        if (this.cache && (session = this.getSession(request, false)) != null) {
            session.setAuthType(authType);
            session.setPrincipal(principal);
            if (username != null) {
                session.setNote("org.apache.catalina.session.USERNAME", username);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (password != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", password);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        String value = this.generateSessionId();
        Cookie cookie = new Cookie("JSESSIONIDSSO", value);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        hres.addCookie(cookie);
        String realm = this.context.getRealm().getRealmName();
        assert (realm != null);
        this.sso.register(value, principal, authType, username, password, realm);
        request.setNote("org.apache.catalina.request.SSOID", value);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        if ("org.apache.catalina.core.StandardContext".equals(this.context.getClass().getName())) {
            try {
                Class[] paramTypes = new Class[]{};
                Object[] paramValues = new Object[]{};
                Method method = this.context.getClass().getMethod("getDebug", paramTypes);
                Integer result = (Integer)method.invoke((Object)this.context, paramValues);
                this.setDebug(result);
            }
            catch (Exception e) {
                log.error("Exception getting debug value", e);
            }
        }
        this.started = true;
        Container parent = this.context.getParent();
        while (this.sso == null && parent != null) {
            if (!(parent instanceof Pipeline)) {
                parent = parent.getParent();
                continue;
            }
            Valve[] valves = ((Pipeline)((Object)parent)).getValves();
            for (int i = 0; i < valves.length; ++i) {
                if (!(valves[i] instanceof SingleSignOn)) continue;
                this.sso = (SingleSignOn)valves[i];
                break;
            }
            if (this.sso != null) continue;
            parent = parent.getParent();
        }
        if (log.isDebugEnabled()) {
            if (this.sso != null) {
                log.debug("Found SingleSignOn Valve at " + this.sso);
            } else {
                log.debug("No SingleSignOn Valve is present");
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.sso = null;
    }

    public void setRealmName(String name) {
    }

    public String getRealmName() {
        return null;
    }
}

