/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.KeyInfoHeaderBlock;
import com.sun.xml.wss.core.SecurityToken;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import java.security.Key;
import javax.crypto.SecretKey;
import javax.xml.soap.SOAPElement;
import org.w3c.dom.Element;

public class EncryptedKeyToken
extends SecurityHeaderBlockImpl
implements SecurityToken {
    EncryptedKey encryptedKey = null;
    SOAPElement elem = null;

    public EncryptedKeyToken(SOAPElement elem) {
        this.elem = elem;
    }

    public Key getSecretKey(Key privKey) throws XWSSecurityException {
        try {
            XMLCipher xmlc = null;
            if (this.encryptedKey == null) {
                xmlc = XMLCipher.getInstance();
                this.encryptedKey = xmlc.loadEncryptedKey((Element)this.elem);
            }
            xmlc.init(4, privKey);
            SecretKey symmetricKey = (SecretKey)xmlc.decryptKey(this.encryptedKey);
            return symmetricKey;
        }
        catch (Exception ex) {
            throw new XWSSecurityException("Error while getting SecretKey from EncryptedKey");
        }
    }

    public SOAPElement getAsSoapElement() {
        throw new UnsupportedOperationException("Not supported");
    }

    public String getId() {
        try {
            XMLCipher xmlc = null;
            if (this.encryptedKey == null) {
                xmlc = XMLCipher.getInstance();
                this.encryptedKey = xmlc.loadEncryptedKey((Element)this.elem);
            }
            return this.encryptedKey.getId();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while extracting ID");
        }
    }

    public KeyInfoHeaderBlock getKeyInfo() {
        try {
            XMLCipher xmlc = null;
            if (this.encryptedKey == null) {
                xmlc = XMLCipher.getInstance();
                this.encryptedKey = xmlc.loadEncryptedKey((Element)this.elem);
            }
            return new KeyInfoHeaderBlock(this.encryptedKey.getKeyInfo());
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while extracting KeyInfo");
        }
    }
}

