/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.apache.catalina.security.SecurityUtil;

public class SelectorThreadConfig {
    private static final String SELECTOR_TIMEOUT = "com.sun.enterprise.web.connector.grizzly.selector.timeout";
    private static final String MIN_THREAD = "com.sun.enterprise.web.connector.grizzly.minWorkerThreads";
    private static final String NON_BLOCKING_MODE = "com.sun.enterprise.web.connector.grizzly.useNioNonBlocking";
    private static final String DISPLAY_CONFIGURATION = "com.sun.enterprise.web.connector.grizzly.displayConfiguration";
    private static final String MAX_KEEP_ALIVE_REQUEST = "com.sun.enterprise.web.connector.grizzly.maxKeepAliveRequests";
    private static final String DIRECT_BYTE_BUFFER_READ = "com.sun.enterprise.web.connector.grizzly.useDirectByteBuffer";
    private static final String PIPELINE_CLASS = "com.sun.enterprise.web.connector.grizzly.pipelineClass";
    private static final String MAX_SELECTOR_READ_THREAD = "com.sun.enterprise.web.connector.grizzly.maxSelectorReadThread";
    private static final String HTTP_HEADER_BUFFER_SIZE = "com.sun.enterprise.web.connector.grizzly.maxHttpHeaderSize";
    private static final String BYTE_BUFFER_VIEW = "com.sun.enterprise.web.connector.grizzly.useByteBufferView";
    private static final String ALGORITHM_CLASS_NAME = "com.sun.enterprise.web.connector.grizzly.algorithmClassName";
    private static final String MAX_SELECTOR = "com.sun.enterprise.web.connector.grizzly.maxSelectors";
    private static final String FACTORY_TIMEOUT = "com.sun.enterprise.web.connector.grizzly.factoryTimeout";
    private static final String ASYNCH_HANDLER_CLASS = "com.sun.enterprise.web.connector.grizzly.asyncHandlerClass";
    private static final String ASYNCH_HANDLER_PORT = "com.sun.enterprise.web.connector.grizzly.asyncHandler.ports";

    protected static void configureProperties(SelectorThread selectorThread) {
        if (System.getProperty(SELECTOR_TIMEOUT) != null) {
            try {
                SelectorThread.selectorTimeout = Integer.parseInt(System.getProperty(SELECTOR_TIMEOUT));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidSelectorTimeout");
            }
        }
        if (System.getProperty(MIN_THREAD) != null) {
            try {
                selectorThread.minWorkerThreads = Integer.parseInt(System.getProperty(MIN_THREAD));
            }
            catch (NumberFormatException ex) {
                SelectorThread.logger().log(Level.WARNING, "selectorThread.invalidMinThreads");
            }
        }
        if (System.getProperty(NON_BLOCKING_MODE) != null) {
            selectorThread.useNioNonBlocking = Boolean.valueOf(System.getProperty(NON_BLOCKING_MODE));
        }
        if (System.getProperty(DISPLAY_CONFIGURATION) != null) {
            selectorThread.displayConfiguration = Boolean.valueOf(System.getProperty(DISPLAY_CONFIGURATION));
        }
        if (System.getProperty(ASYNCH_HANDLER_PORT) != null) {
            String ports = System.getProperty(ASYNCH_HANDLER_PORT);
            StringTokenizer st = new StringTokenizer(ports, ",");
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equals(String.valueOf(selectorThread.getPort())) || System.getProperty(ASYNCH_HANDLER_CLASS) == null) continue;
                selectorThread.asyncHandler = (AsyncHandler)SelectorThreadConfig.loadClassAndInstanciate(System.getProperty(ASYNCH_HANDLER_CLASS));
                selectorThread.asyncExecution = true;
            }
        }
        if (System.getProperty(DIRECT_BYTE_BUFFER_READ) != null) {
            selectorThread.useDirectByteBuffer = Boolean.valueOf(System.getProperty(DIRECT_BYTE_BUFFER_READ));
        }
        if (System.getProperty(MAX_KEEP_ALIVE_REQUEST) != null) {
            try {
                selectorThread.maxKeepAliveRequests = Integer.parseInt(System.getProperty(MAX_KEEP_ALIVE_REQUEST));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(PIPELINE_CLASS) != null) {
            selectorThread.pipelineClassName = System.getProperty(PIPELINE_CLASS);
        }
        if (System.getProperty(ALGORITHM_CLASS_NAME) != null) {
            selectorThread.algorithmClassName = System.getProperty(ALGORITHM_CLASS_NAME);
        }
        if (System.getProperty(BYTE_BUFFER_VIEW) != null) {
            selectorThread.useByteBufferView = Boolean.valueOf(System.getProperty(BYTE_BUFFER_VIEW));
        }
        if (System.getProperty(MAX_SELECTOR_READ_THREAD) != null) {
            try {
                selectorThread.selectorReadThreadsCount = Integer.parseInt(System.getProperty(MAX_SELECTOR_READ_THREAD));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(MAX_SELECTOR) != null) {
            try {
                SelectorFactory.maxSelectors = Integer.parseInt(System.getProperty(MAX_SELECTOR));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (System.getProperty(FACTORY_TIMEOUT) != null) {
            try {
                SelectorFactory.timeout = Integer.parseInt(System.getProperty(FACTORY_TIMEOUT));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.getProperty("com.sun.enterprise.web.SubjectDoAs") != null) {
            SecurityUtil.executeUnderSubjectDoAs = Boolean.valueOf(System.getProperty("com.sun.enterprise.web.SubjectDoAs"));
        }
    }

    public static void configure(SelectorThread selectorThread) {
        SelectorThreadConfig.configureProperties(selectorThread);
    }

    private static Object loadClassAndInstanciate(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.newInstance();
        }
        catch (Throwable ex) {
            SelectorThread.logger().log(Level.SEVERE, ex.getMessage() + ":" + className, ex);
            return null;
        }
    }
}

