/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.ara.rules;

import com.sun.enterprise.web.ara.rules.ThreadRatioRule;
import com.sun.enterprise.web.connector.grizzly.LinkedListPipeline;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ReadTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.Task;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import com.sun.enterprise.web.connector.grizzly.WorkerThread;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public class HeapMemoryRule
extends ThreadRatioRule
implements TaskListener {
    protected static ConcurrentHashMap<String, Long> memoryAllowed = new ConcurrentHashMap();
    private static long availableMemory = -1L;
    protected static ConcurrentHashMap<String, Long> appMemoryUsage = new ConcurrentHashMap();
    protected static ConcurrentHashMap<ReadTask, String> contextRootyCache = new ConcurrentHashMap();
    private static HeapMemoryRulePipeline hmrPipeline;
    private static Pipeline defaultPipeline;
    private static ConcurrentHashMap<String, Long> consolidatedMemoryUsed;

    public Integer call() throws Exception {
        if (availableMemory == -1L) {
            availableMemory = HeapMemoryRule.usedMemory();
        }
        if (hmrPipeline == null) {
            hmrPipeline = new HeapMemoryRulePipeline();
            hmrPipeline.initPipeline();
            hmrPipeline.startPipeline();
        }
        String token = this.getContextRoot();
        Long memoryAllowedSize = memoryAllowed.get(token);
        Double allowedRatio = (Double)privilegedTokens.get(token);
        Pipeline pipeline = (Pipeline)pipelines.get(token);
        if (pipeline == null) {
            if (defaultPipeline == null) {
                defaultPipeline = this.newPipeline(this.readTask.getPipeline().getMaxThreads(), this.readTask.getPipeline());
            }
            pipelines.put(token, defaultPipeline);
            this.readTask.setPipeline(defaultPipeline);
        } else {
            this.readTask.setPipeline(pipeline);
        }
        if (memoryAllowedSize == null && allowedRatio == null) {
            if (this.countReservedMemory() <= availableMemory) {
                return 3;
            }
            if (allocationPolicy.equals("reserve")) {
                return 2;
            }
            if (allocationPolicy.equals("ceiling")) {
                return 1;
            }
        }
        boolean isAllowed = this.isAllowedToExecute(token, memoryAllowedSize, allowedRatio);
        pipeline = (Pipeline)pipelines.get(token);
        if (pipeline != null) {
            this.readTask.setPipeline(pipeline);
        }
        if (!isAllowed) {
            if (allocationPolicy.equals("reserve")) {
                return 2;
            }
            if (allocationPolicy.equals("ceiling")) {
                return 1;
            }
        }
        return 3;
    }

    protected boolean isAllowedToExecute(String token, Long memoryAllowedSize, Double allowedRatio) throws Exception {
        long currentMemory = HeapMemoryRule.usedMemory();
        if (memoryAllowedSize == null) {
            memoryAllowedSize = availableMemory * allowedRatio.longValue() / 100L;
            memoryAllowed.put(token, memoryAllowedSize);
        }
        if (memoryAllowedSize > currentMemory) {
            return false;
        }
        Long usage = appMemoryUsage.get(token);
        contextRootyCache.put(this.readTask, token);
        if (usage == null) {
            pipelines.put(token, hmrPipeline);
            return true;
        }
        Long currentAppUsage = consolidatedMemoryUsed.get(token);
        if (currentAppUsage == null) {
            currentAppUsage = 0L;
        }
        if ((usage = Long.valueOf(currentAppUsage + usage)) > currentMemory) {
            return false;
        }
        if (usage > memoryAllowedSize) {
            return false;
        }
        consolidatedMemoryUsed.put(token, usage);
        this.readTask.addTaskListener(this);
        return true;
    }

    private long countReservedMemory() {
        Iterator<Long> iterator = memoryAllowed.values().iterator();
        long count = 0L;
        while (iterator.hasNext()) {
            count += iterator.next().longValue();
        }
        return count;
    }

    private static long usedMemory() {
        Runtime.getRuntime().gc();
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public void taskEvent(TaskEvent event) {
        String token;
        if (event.getStatus() == 2 && (token = contextRootyCache.remove(event.attachement())) != null) {
            Long count = consolidatedMemoryUsed.get(token);
            count = count - appMemoryUsage.get(token);
            consolidatedMemoryUsed.put(token, count);
        }
    }

    static {
        consolidatedMemoryUsed = new ConcurrentHashMap();
    }

    private static class HeapMemoryRulePipeline
    extends LinkedListPipeline {
        private HeapMemoryRulePipeline() {
        }

        public void initPipeline() {
            this.workerThreads = new WorkerThread[1];
            WorkerThread workerThread = new WorkerThread(this, "HeapMemoryRuleThread"){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                ReadTask t;
                                if ((t = (ReadTask)HeapMemoryRulePipeline.this.getTask()) == null) {
                                    continue;
                                }
                                long current = HeapMemoryRule.usedMemory();
                                t.run();
                                long usage = HeapMemoryRule.usedMemory() - current;
                                if (usage <= 0L) continue;
                                String token = contextRootyCache.get(t);
                                appMemoryUsage.put(token, usage);
                                ThreadRatioRule.pipelines.remove(token);
                            }
                        }
                        catch (Throwable t) {
                            SelectorThread.logger().log(Level.SEVERE, "workerThread.httpException", t);
                            continue;
                        }
                        break;
                    }
                }
            };
            workerThread.setPriority(this.priority);
            this.workerThreads[0] = workerThread;
            ++this.threadCount;
        }

        public void startPipeline() {
            if (!this.isStarted) {
                this.workerThreads[0].start();
                this.isStarted = true;
            }
        }

        public void stopPipeline() {
            if (this.isStarted) {
                this.workerThreads[0].terminate();
                this.isStarted = false;
            }
        }

        public synchronized void addTask(Task task) {
            this.addLast(task);
            this.notify();
        }
    }
}

