/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web;

import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEvent;
import com.sun.enterprise.web.ConnectionShutdownUtil;
import com.sun.enterprise.web.DeployHistoryEntry;
import com.sun.enterprise.web.EmbeddedWebContainer;
import com.sun.enterprise.web.SessionPurgeUtil;
import com.sun.enterprise.web.WebContainerAdminEventProcessor;
import com.sun.logging.LogDomains;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class EEWebContainerAdminEventProcessor
implements WebContainerAdminEventProcessor {
    protected static Logger _logger = null;
    protected static ResourceBundle _rb = null;
    protected EmbeddedWebContainer _embedded = null;
    private static Hashtable _deployHistory = new Hashtable();

    public EEWebContainerAdminEventProcessor() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
    }

    public EEWebContainerAdminEventProcessor(EmbeddedWebContainer embedded) {
        this._embedded = embedded;
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
    }

    public void init(EmbeddedWebContainer embedded) {
        this._embedded = embedded;
    }

    public void applicationDeployed(ApplicationDeployEvent deployEvent) {
        String deployedAppName = deployEvent.getApplicationName();
        _logger.finest("applicationDeployed:" + deployedAppName);
        String key = "App_" + deployedAppName;
        boolean deployedRecently = this.checkDeployHistoryEntry(key, "deployed");
        this.setDeployHistoryEntry(key, "deployed", System.currentTimeMillis());
        if (deployedRecently) {
            _logger.finest("Returning from MIDDLE of applicationDeployed");
            return;
        }
        SessionPurgeUtil purgeUtil = new SessionPurgeUtil(this._embedded);
        _logger.finest("about to call SessionPurgeUtil for" + deployedAppName);
        deployedAppName = "/" + deployedAppName;
        System.gc();
        _logger.finest("Returning from END of applicationDeployed");
    }

    public void applicationDisabled(ApplicationDeployEvent deployEvent) {
    }

    public void applicationEnabled(ApplicationDeployEvent deployEvent) {
    }

    public void applicationRedeployed(ApplicationDeployEvent deployEvent) {
        String deployedAppName = deployEvent.getApplicationName();
        _logger.finest("applicationRedeployed:" + deployedAppName);
        String key = "App_" + deployedAppName;
        boolean redeployedRecently = this.checkDeployHistoryEntry(key, "redeployed");
        this.setDeployHistoryEntry(key, "redeployed", System.currentTimeMillis());
        if (redeployedRecently) {
            _logger.finest("Returning from MIDDLE of applicationRedeployed");
            return;
        }
        SessionPurgeUtil purgeUtil = new SessionPurgeUtil(this._embedded);
        _logger.finest("about to call SessionPurgeUtil for" + deployedAppName);
        deployedAppName = "/" + deployedAppName;
        purgeUtil.purgeSessionsForApp(deployedAppName);
        System.gc();
        _logger.finest("Returning from END of applicationRedeployed");
    }

    public void applicationUndeployed(ApplicationDeployEvent deployEvent) {
        String deployedAppName = deployEvent.getApplicationName();
        _logger.finest("applicationUndeployed:" + deployedAppName);
        String key = "App_" + deployedAppName;
        boolean undeployedRecently = this.checkDeployHistoryEntry(key, "undeployed");
        this.setDeployHistoryEntry(key, "undeployed", System.currentTimeMillis());
        if (undeployedRecently) {
            _logger.finest("Returning from MIDDLE of applicationUndeployed");
            return;
        }
        SessionPurgeUtil purgeUtil = new SessionPurgeUtil(this._embedded);
        _logger.finest("about to call SessionPurgeUtil for" + deployedAppName);
        deployedAppName = "/" + deployedAppName;
        purgeUtil.purgeSessionsForApp(deployedAppName);
        System.gc();
    }

    public void moduleDeployed(ModuleDeployEvent deployEvent) {
        String deployedModuleName = deployEvent.getModuleName();
        _logger.finest("moduleDeployed:" + deployedModuleName);
        String key = "Mod_" + deployedModuleName;
        boolean deployedRecently = this.checkDeployHistoryEntry(key, "deployed");
        this.setDeployHistoryEntry(key, "deployed", System.currentTimeMillis());
        if (deployedRecently) {
            _logger.finest("Returning from MIDDLE of moduleDeployed");
            return;
        }
        ConnectionShutdownUtil shutdownUtil = new ConnectionShutdownUtil(this._embedded);
        shutdownUtil.runCloseAllConnections();
        System.gc();
        _logger.finest("Returning from END of moduleDeployed");
    }

    public void moduleDisabled(ModuleDeployEvent deployEvent) {
    }

    public void moduleEnabled(ModuleDeployEvent deployEvent) {
    }

    public void moduleRedeployed(ModuleDeployEvent deployEvent) {
        String deployedModuleName = deployEvent.getModuleName();
        _logger.finest("moduleRedeployed:" + deployedModuleName);
        String key = "Mod_" + deployedModuleName;
        boolean redeployedRecently = this.checkDeployHistoryEntry(key, "redeployed");
        this.setDeployHistoryEntry(key, "redeployed", System.currentTimeMillis());
        if (redeployedRecently) {
            _logger.finest("Returning from MIDDLE of moduleRedeployed");
            return;
        }
        ConnectionShutdownUtil shutdownUtil = new ConnectionShutdownUtil(this._embedded);
        shutdownUtil.runCloseAllConnections();
        System.gc();
        _logger.finest("Returning from END of moduleRedeployed");
    }

    public void moduleUndeployed(ModuleDeployEvent deployEvent) {
        String deployedModuleName = deployEvent.getModuleName();
        _logger.finest("moduleUndeployed:" + deployedModuleName);
        String key = "Mod_" + deployedModuleName;
        boolean undeployedRecently = this.checkDeployHistoryEntry(key, "undeployed");
        this.setDeployHistoryEntry(key, "undeployed", System.currentTimeMillis());
        if (undeployedRecently) {
            _logger.finest("Returning from MIDDLE of moduleUndeployed");
            return;
        }
        ConnectionShutdownUtil shutdownUtil = new ConnectionShutdownUtil(this._embedded);
        System.out.println("IN WebContainer>>moduleUndeployed: " + deployedModuleName + "about to close all connections");
        shutdownUtil.runCloseAllConnections();
        System.gc();
        _logger.finest("Returning from END of moduleUndeployed");
    }

    private void setDeployHistoryEntry(String key, String value, long lat) {
        DeployHistoryEntry entry = (DeployHistoryEntry)_deployHistory.get(key);
        if (entry == null) {
            _deployHistory.put(key, new DeployHistoryEntry(value, lat));
        } else {
            entry.value = value;
            entry.lat = lat;
        }
    }

    private boolean checkDeployHistoryEntry(String key, String deployStatus) {
        DeployHistoryEntry entry = (DeployHistoryEntry)_deployHistory.get(key);
        if (entry == null) {
            return false;
        }
        String val = entry.value;
        return val.equals(deployStatus) && System.currentTimeMillis() - entry.lat < 60000L;
    }
}

