/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.deploy.shared.FileArchive;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;

public class FormErrorPage
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getLoginConfiguration() != null) {
            boolean foundIt = false;
            FileArchive arch = null;
            String formErrorPage = descriptor.getLoginConfiguration().getFormErrorPage();
            if (formErrorPage.length() > 0) {
                try {
                    File fep;
                    String uri = this.getAbstractArchiveUri(descriptor);
                    arch = new FileArchive();
                    arch.open(uri);
                    if (formErrorPage.startsWith("/")) {
                        formErrorPage = formErrorPage.substring(1);
                    }
                    if ((fep = new File(arch.getArchiveUri() + File.separator + formErrorPage)).exists()) {
                        foundIt = true;
                    }
                    fep = null;
                }
                catch (Exception ex) {
                    foundIt = false;
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The form-error-page [ {0} ] value defines the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{formErrorPage, descriptor.getName()}));
                } else {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: The form-error-page [ {0} ] value does not define the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{formErrorPage, descriptor.getName()}));
                }
            } else {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

