/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.provider;

import com.sun.enterprise.security.provider.PolicyConfigurationImpl;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class PolicyConfigurationFactoryImpl
extends PolicyConfigurationFactory {
    static Map polConfTable = new HashMap();
    private static Logger logger = Logger.getLogger("javax.enterprise.system.core.security");

    public PolicyConfiguration getPolicyConfiguration(String contextId, boolean remove) throws PolicyContextException {
        PolicyConfiguration pc;
        PolicyConfigurationImpl.checkSetPolicyPermission();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JACC Policy Provider: Getting PolicyConfiguration object with id = " + contextId);
        }
        if ((pc = (PolicyConfiguration)polConfTable.get(contextId)) == null) {
            pc = PolicyConfigurationFactoryImpl.getPolicyConfigurationImplFromDirectory(contextId, true, remove);
            if (pc == null) {
                pc = new PolicyConfigurationImpl(contextId);
                polConfTable.put(contextId, pc);
            }
        } else {
            ((PolicyConfigurationImpl)pc).initialize(true, remove, false);
        }
        return pc;
    }

    public boolean inService(String contextID) throws PolicyContextException {
        PolicyConfigurationImpl.checkSetPolicyPermission();
        PolicyConfiguration pc = (PolicyConfiguration)polConfTable.get(contextID);
        if (pc == null) {
            pc = PolicyConfigurationFactoryImpl.getPolicyConfigurationImplFromDirectory(contextID, false, false);
        }
        return pc == null ? false : pc.inService();
    }

    private static PolicyConfigurationImpl getPolicyConfigurationImplFromDirectory(String contextId, boolean open, boolean remove) {
        PolicyConfigurationImpl pci = null;
        File f = new File(PolicyConfigurationImpl.getContextDirectoryName(contextId));
        if (f.exists() && (pci = new PolicyConfigurationImpl(f, open, remove)) != null) {
            polConfTable.put(contextId, pci);
        }
        return pci;
    }

    protected static Collection getPolicyConfigurationImpls() {
        return polConfTable.values();
    }

    protected static PolicyConfigurationImpl putPolicyConfigurationImpl(String contextID, PolicyConfigurationImpl pc) {
        return polConfTable.put(contextID, pc);
    }

    protected static PolicyConfigurationImpl getPolicyConfigurationImpl(String contextId) {
        PolicyConfigurationImpl pci = (PolicyConfigurationImpl)polConfTable.get(contextId);
        if (pci == null && (pci = PolicyConfigurationFactoryImpl.getPolicyConfigurationImplFromDirectory(contextId, false, false)) == null) {
            logger.log(Level.WARNING, "pc.unknown_policy_context", new Object[]{contextId});
        }
        return pci;
    }
}

