/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.ServerConfiguration;
import com.sun.enterprise.deployment.PrincipalImpl;
import com.sun.enterprise.security.AbstractSecurityContext;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public final class ClientSecurityContext
extends AbstractSecurityContext {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
    private static final boolean isPerThreadAuth = Boolean.getBoolean("com.sun.appserv.iiopclient.perthreadauth");
    private static Object csc = isPerThreadAuth ? new ThreadLocal() : null;

    public ClientSecurityContext(String userName, Subject s) {
        this.initiator = new PrincipalImpl(userName);
        this.subject = s;
    }

    public static ClientSecurityContext init() {
        ClientSecurityContext sc = ClientSecurityContext.getCurrent();
        if (sc == null) {
            sc = ClientSecurityContext.generateDefaultSecurityContext();
        }
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClientSecurityContext generateDefaultSecurityContext() {
        String PRINCIPAL_NAME = "auth.default.principal.name";
        String PRINCIPAL_PASS = "auth.default.principal.password";
        ServerConfiguration config = ServerConfiguration.getConfiguration();
        String username = config.getProperty("auth.default.principal.name", "guest");
        String password = config.getProperty("auth.default.principal.password", "guest123");
        Class<ClientSecurityContext> clazz = ClientSecurityContext.class;
        synchronized (ClientSecurityContext.class) {
            try {
                final Subject subject = new Subject();
                final PasswordCredential pc = new PasswordCredential(username, password, "default");
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        subject.getPrivateCredentials().add(pc);
                        return null;
                    }
                });
                ClientSecurityContext defaultCSC = new ClientSecurityContext(username, subject);
                ClientSecurityContext.setCurrent(defaultCSC);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return defaultCSC;
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "java_security.gen_security_context", e);
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return null;
            }
        }
    }

    public static void reset(ClientSecurityContext sc) {
        if (isPerThreadAuth) {
            ((ThreadLocal)csc).set(sc);
        } else {
            csc = sc;
        }
    }

    public static ClientSecurityContext getCurrent() {
        if (isPerThreadAuth) {
            return (ClientSecurityContext)((ThreadLocal)csc).get();
        }
        return (ClientSecurityContext)csc;
    }

    public static void setCurrent(ClientSecurityContext sc) {
        if (isPerThreadAuth) {
            ((ThreadLocal)csc).set(sc);
        } else {
            csc = sc;
        }
    }

    public Principal getCallerPrincipal() {
        return this.initiator;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String toString() {
        return "ClientSecurityContext[ Initiator: " + this.initiator + "Subject " + this.subject + " ]";
    }
}

