/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.archivist;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.annotation.AnnotatedElementHandler;
import com.sun.enterprise.deployment.annotation.AnnotationProcessor;
import com.sun.enterprise.deployment.annotation.AnnotationProcessorException;
import com.sun.enterprise.deployment.annotation.ErrorHandler;
import com.sun.enterprise.deployment.annotation.ProcessingContext;
import com.sun.enterprise.deployment.annotation.ProcessingResult;
import com.sun.enterprise.deployment.annotation.ResultType;
import com.sun.enterprise.deployment.annotation.Scanner;
import com.sun.enterprise.deployment.annotation.factory.AnnotatedElementHandlerFactory;
import com.sun.enterprise.deployment.annotation.factory.SJSASFactory;
import com.sun.enterprise.deployment.annotation.factory.ScannerFactory;
import com.sun.enterprise.deployment.annotation.impl.AnnotationUtils;
import com.sun.enterprise.deployment.annotation.impl.DefaultErrorHandler;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.PluggableArchivists;
import com.sun.enterprise.deployment.backend.OptionalPkgDependency;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchiveFactory;
import com.sun.enterprise.deployment.deploy.shared.Archive;
import com.sun.enterprise.deployment.deploy.shared.JarArchiveFactory;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.PersistenceDeploymentDescriptorFile;
import com.sun.enterprise.deployment.io.WebServicesDeploymentDescriptorFile;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.deployment.util.TracerVisitor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.shared.ArchivistUtils;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ModuleType;
import org.xml.sax.SAXParseException;

public abstract class Archivist {
    protected static final Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    public static String MANIFEST_VERSION_VALUE;
    protected String path;
    protected boolean handleRuntimeInfo = true;
    protected boolean annotationProcessingRequested = false;
    protected Manifest manifest;
    protected AbstractArchiveFactory abstractArchiveFactory = new JarArchiveFactory();
    protected PluggableArchivists pa = null;
    private static LocalStringManagerImpl localStrings;
    protected ClassLoader classLoader = null;
    private boolean isValidatingXML = true;
    private boolean isValidatingRuntimeXML = false;
    private String validationLevel = "parsing";
    private String runtimeValidationLevel = "parsing";
    private ErrorHandler annotationErrorHandler = new DefaultErrorHandler();
    private static String WSDL;
    private static String XML;
    private static String XSD;
    protected static String APPLICATION_EXTENSION;
    protected static String APPCLIENT_EXTENSION;
    protected static String WEB_EXTENSION;
    protected static String EJB_EXTENSION;
    protected static String CONNECTOR_EXTENSION;
    protected static String UPLOAD_EXTENSION;
    private static String PROCESS_ANNOTATION_FOR_OLD_DD;
    private static boolean processAnnotationForOldDD;

    protected void initializeContext(Archivist other) {
        this.handleRuntimeInfo = other.isHandlingRuntimeInfo();
        this.annotationProcessingRequested = other.isAnnotationProcessingRequested();
        this.isValidatingXML = other.isValidatingXML;
        this.validationLevel = other.validationLevel;
        this.abstractArchiveFactory = other.getAbstractArchiveFactory();
        this.classLoader = other.classLoader;
        this.annotationErrorHandler = other.annotationErrorHandler;
    }

    public void setAbstractArchiveFactory(AbstractArchiveFactory aa) {
        this.abstractArchiveFactory = aa;
    }

    public AbstractArchiveFactory getAbstractArchiveFactory() {
        return this.abstractArchiveFactory;
    }

    public RootDeploymentDescriptor open(AbstractArchive archive) throws IOException, SAXParseException {
        this.setManifest(archive.getManifest());
        RootDeploymentDescriptor descriptor = this.readDeploymentDescriptors(archive);
        if (descriptor != null) {
            this.postOpen(descriptor, archive);
        }
        return descriptor;
    }

    public RootDeploymentDescriptor open(String path) throws IOException, SAXParseException {
        this.path = path;
        File file = new File(path);
        if (!file.exists()) {
            throw new FileNotFoundException(path);
        }
        AbstractArchive abstractArchive = this.abstractArchiveFactory.openArchive(path);
        RootDeploymentDescriptor descriptor = this.open(abstractArchive);
        abstractArchive.close();
        this.validate(null);
        return descriptor;
    }

    public RootDeploymentDescriptor open(File file) throws IOException, SAXParseException {
        return this.open(file.getAbsolutePath());
    }

    protected void postStandardDDsRead(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
    }

    protected void postAnnotationProcess(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
    }

    protected void postRuntimeDDsRead(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
    }

    protected void postOpen(RootDeploymentDescriptor descriptor, AbstractArchive archive) throws IOException {
    }

    public RootDeploymentDescriptor readDeploymentDescriptors(AbstractArchive abstractArchive) throws IOException, SAXParseException {
        BundleDescriptor descriptor = (BundleDescriptor)this.readStandardDeploymentDescriptor(abstractArchive);
        ModuleDescriptor newModule = this.createModuleDescriptor(descriptor);
        newModule.setArchiveUri(abstractArchive.getArchiveUri());
        this.readWebServicesDescriptor(abstractArchive, descriptor);
        this.readPersistenceDeploymentDescriptors(abstractArchive, this.getDescriptor());
        this.postStandardDDsRead(descriptor, abstractArchive);
        this.readAnnotations(abstractArchive, descriptor);
        this.postAnnotationProcess(descriptor, abstractArchive);
        this.readRuntimeDeploymentDescriptor(abstractArchive, descriptor);
        this.postRuntimeDDsRead(descriptor, abstractArchive);
        return descriptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readAnnotations(AbstractArchive abstractArchive, BundleDescriptor descriptor) throws IOException {
        boolean isFull = false;
        isFull = processAnnotationForOldDD ? descriptor.isFullAttribute() : descriptor.isFullFlag();
        if (!isFull && this.annotationProcessingRequested && this.classLoader != null) {
            try {
                ProcessingResult result = this.processAnnotations(descriptor, abstractArchive);
                if (result == null || !ResultType.FAILED.equals((Object)result.getOverallResult())) return;
                DOLUtils.getDefaultLogger().severe(localStrings.getLocalString("enterprise.deployment.archivist.annotationprocessingfailed", "Annotations processing failed for {0}", new Object[]{abstractArchive.getArchiveUri()}));
                return;
            }
            catch (NoClassDefFoundError err) {
                if (!DOLUtils.getDefaultLogger().isLoggable(Level.WARNING)) return;
                DOLUtils.getDefaultLogger().warning("Error in annotation processing: " + err);
                return;
            }
            catch (AnnotationProcessorException ex) {
                DOLUtils.getDefaultLogger().severe(ex.getMessage());
                DOLUtils.getDefaultLogger().log(Level.FINE, ex.getMessage(), ex);
                throw new IllegalStateException(ex);
            }
        } else {
            if (!DOLUtils.getDefaultLogger().isLoggable(Level.FINE)) return;
            DOLUtils.getDefaultLogger().fine("Annotation is not processed for this archive.");
        }
    }

    public void readPersistenceDeploymentDescriptors(AbstractArchive archive, Descriptor descriptor) throws IOException, SAXParseException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessingResult processAnnotations(BundleDescriptor bundleDesc, AbstractArchive abstractArchive) throws AnnotationProcessorException, IOException {
        AnnotatedElementHandler aeHandler = AnnotatedElementHandlerFactory.createAnnotatedElementHandler(bundleDesc);
        if (aeHandler == null) {
            return null;
        }
        Scanner scanner = ScannerFactory.createScanner(bundleDesc, this, abstractArchive, this.classLoader);
        if (!scanner.getElements().isEmpty()) {
            if (bundleDesc.isDDWithNoAnnotationAllowed()) {
                String ddName = this.getStandardDDFile().getDeploymentDescriptorPath();
                String explodedArchiveName = new File(abstractArchive.getArchiveUri()).getName();
                String archiveName = FileUtils.revertFriendlyFilenameExtension(explodedArchiveName);
                throw new AnnotationProcessorException(localStrings.getLocalString("enterprise.deployment.oldDDwithAnnotation", "{0} in archive {1} is of version {2}, which cannot support annotations in an application.  Please upgrade the deployment descriptor to be a version supported by Java EE 5.0 (or later).", new Object[]{ddName, archiveName, bundleDesc.getSpecVersion()}));
            }
            AnnotationProcessor ap = SJSASFactory.getAnnotationProcessor();
            ProcessingContext ctx = ap.createContext();
            if (this.annotationErrorHandler != null) {
                ctx.setErrorHandler(this.annotationErrorHandler);
            }
            ctx.setProcessingInput(scanner);
            ctx.pushHandler(aeHandler);
            ClassLoader originalBundleClassLoader = null;
            try {
                originalBundleClassLoader = bundleDesc.getClassLoader();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (originalBundleClassLoader == null) {
                bundleDesc.setClassLoader(this.classLoader);
            }
            try {
                ProcessingResult processingResult = ap.process(ctx);
                return processingResult;
            }
            finally {
                if (originalBundleClassLoader == null) {
                    bundleDesc.setClassLoader(null);
                }
            }
        }
        bundleDesc.setFullFlag(true);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Descriptor readStandardDeploymentDescriptor(AbstractArchive abstractArchive) throws IOException, SAXParseException {
        InputStream is = null;
        try {
            is = abstractArchive.getEntry(this.getStandardDDFile().getDeploymentDescriptorPath());
            if (is != null) {
                Descriptor result;
                DeploymentDescriptorFile ddFile = this.getStandardDDFile();
                ddFile.setXMLValidation(this.getXMLValidation());
                ddFile.setXMLValidationLevel(this.validationLevel);
                if (abstractArchive.getArchiveUri() != null) {
                    ddFile.setErrorReportingString(abstractArchive.getArchiveUri());
                }
                Descriptor descriptor = result = ddFile.read(is);
                return descriptor;
            }
            Descriptor descriptor = this.getDefaultBundleDescriptor();
            return descriptor;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readRuntimeDeploymentDescriptor(AbstractArchive abstractArchive, Descriptor descriptor) throws IOException, SAXParseException {
        String ddFileEntryName = this.getRuntimeDeploymentDescriptorPath();
        if (!this.isHandlingRuntimeInfo() || ddFileEntryName == null) {
            return;
        }
        InputStream is = null;
        try {
            is = abstractArchive.getEntry(ddFileEntryName);
            DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
            if (abstractArchive.getArchiveUri() != null) {
                confDD.setErrorReportingString(abstractArchive.getArchiveUri());
            }
            if (is != null && confDD != null) {
                confDD.setXMLValidation(this.getRuntimeXMLValidation());
                confDD.setXMLValidationLevel(this.runtimeValidationLevel);
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public void readRuntimeDDFromDeploymentPlan(AbstractArchive planArchive, Descriptor descriptor) throws IOException, SAXParseException {
        String runtimeDDPath = this.getRuntimeDeploymentDescriptorPath();
        if (runtimeDDPath == null || planArchive == null) {
            return;
        }
        Vector dpEntries = new Vector();
        Enumeration e = planArchive.entries();
        while (e.hasMoreElements()) {
            dpEntries.add(e.nextElement());
        }
        String entry = runtimeDDPath.substring(runtimeDDPath.lastIndexOf(47) + 1);
        if (dpEntries.contains(entry)) {
            this.readRuntimeDDFromDeploymentPlan(entry, planArchive, descriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readRuntimeDDFromDeploymentPlan(String entry, AbstractArchive planArchive, Descriptor descriptor) throws IOException, SAXParseException {
        InputStream is = null;
        try {
            is = planArchive.getEntry(entry);
            DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
            if (is != null && confDD != null) {
                if (planArchive.getArchiveUri() != null) {
                    confDD.setErrorReportingString(planArchive.getArchiveUri());
                }
                confDD.setXMLValidation(this.getXMLValidation());
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readWebServicesDescriptor(AbstractArchive abstractArchive, Descriptor descriptor) throws IOException, SAXParseException {
        DeploymentDescriptorFile confDD = this.getWebServicesDDFile(descriptor);
        if (abstractArchive.getArchiveUri() != null) {
            confDD.setErrorReportingString(abstractArchive.getArchiveUri());
        }
        InputStream is = null;
        try {
            is = abstractArchive.getEntry(confDD.getDeploymentDescriptorPath());
            if (is != null) {
                confDD.setXMLValidation(this.getXMLValidation());
                confDD.setXMLValidationLevel(this.validationLevel);
                confDD.read(descriptor, is);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public void write() throws IOException {
        this.write(this.path);
    }

    public void write(String outPath) throws IOException {
        AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
        this.write(in, outPath);
        in.close();
    }

    public void write(AbstractArchive in, String outPath) throws IOException {
        AbstractArchive oldArchive = null;
        try {
            oldArchive = this.abstractArchiveFactory.openArchive(outPath);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Archive out = null;
        File fOut = new File(outPath);
        Object bos = null;
        try {
            String tmpName = null;
            if (oldArchive != null && oldArchive.exists() && !oldArchive.supportsElementsOverwriting()) {
                File outputFile = Archivist.getTempFile(outPath);
                tmpName = outputFile.getAbsolutePath();
                outputFile.delete();
                out = this.abstractArchiveFactory.createArchive(tmpName);
                oldArchive.close();
            } else {
                out = this.abstractArchiveFactory.createArchive(outPath);
            }
            this.writeContents(in, (AbstractArchive)out);
            out.close();
            in.close();
            if (tmpName != null) {
                AbstractArchive finalArchive = this.abstractArchiveFactory.openArchive(outPath);
                finalArchive.delete();
                AbstractArchive tmpArchive = this.abstractArchiveFactory.openArchive(tmpName);
                tmpArchive.renameTo(outPath);
            }
        }
        catch (IOException ioe) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException outIoe) {
                    // empty catch block
                }
            }
            throw ioe;
        }
    }

    public void write(AbstractArchive in, AbstractArchive out) throws IOException {
        this.writeContents(in, out);
    }

    protected void writeContents(AbstractArchive out) throws IOException {
        AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
        this.writeContents(in, out);
        in.close();
    }

    protected void writeContents(AbstractArchive in, AbstractArchive out) throws IOException {
        this.writeContents(in, out, null);
    }

    protected void writeContents(AbstractArchive in, AbstractArchive out, Vector entriesToSkip) throws IOException {
        if (in != null && in.exists()) {
            if (entriesToSkip == null) {
                entriesToSkip = this.getListOfFilesToSkip();
            } else {
                entriesToSkip.addAll(this.getListOfFilesToSkip());
            }
            this.copyJarElements(in, out, entriesToSkip);
        }
        this.writeDeploymentDescriptors(out);
        if (this.manifest != null) {
            OutputStream os = out.putNextEntry("META-INF/MANIFEST.MF");
            this.manifest.write(new DataOutputStream(os));
            out.closeEntry();
        }
    }

    public void writeDeploymentDescriptors(AbstractArchive out) throws IOException {
        this.writeStandardDeploymentDescriptors(out);
        this.writeExtraDeploymentDescriptors(out);
    }

    public void writeStandardDeploymentDescriptors(AbstractArchive out) throws IOException {
        OutputStream os = out.putNextEntry(this.getDeploymentDescriptorPath());
        this.writeStandardDeploymentDescriptors(os);
        out.closeEntry();
        Descriptor desc = this.getDescriptor();
        if (desc instanceof BundleDescriptor) {
            this.writeWebServicesDescriptors((BundleDescriptor)desc, out);
        }
    }

    public void writeRuntimeDeploymentDescriptors(AbstractArchive out) throws IOException {
        DeploymentDescriptorFile confDD;
        Descriptor desc = this.getDescriptor();
        if (this.isHandlingRuntimeInfo() && (confDD = this.getConfigurationDDFile()) != null) {
            OutputStream os = out.putNextEntry(this.getRuntimeDeploymentDescriptorPath());
            confDD.write(desc, os);
            out.closeEntry();
        }
    }

    protected void writeExtraDeploymentDescriptors(AbstractArchive out) throws IOException {
        this.writeRuntimeDeploymentDescriptors(out);
    }

    public void writeStandardDeploymentDescriptors(OutputStream os) throws IOException {
        this.getStandardDDFile().write(this.getDescriptor(), os);
    }

    public void writeRuntimeDeploymentDescriptors(OutputStream os) throws IOException {
        DeploymentDescriptorFile confDD = this.getConfigurationDDFile();
        if (confDD != null) {
            confDD.write(this.getDescriptor(), os);
        }
    }

    protected void writeWebServicesDescriptors(BundleDescriptor desc, AbstractArchive out) throws IOException {
        if (desc.hasWebServices()) {
            DeploymentDescriptorFile webServicesDD = this.getWebServicesDDFile(desc);
            OutputStream os = out.putNextEntry(webServicesDD.getDeploymentDescriptorPath());
            webServicesDD.write((Descriptor)desc, os);
            out.closeEntry();
        }
    }

    public String getDeploymentDescriptorPath() {
        return this.getStandardDDFile().getDeploymentDescriptorPath();
    }

    public String getWebServicesDeploymentDescriptorPath() {
        return null;
    }

    public String getRuntimeDeploymentDescriptorPath() {
        DeploymentDescriptorFile ddFile = this.getConfigurationDDFile();
        if (ddFile != null) {
            return ddFile.getDeploymentDescriptorPath();
        }
        return null;
    }

    public boolean containsRuntimeDeploymentDescriptors(AbstractArchive in) {
        String ddFileName = this.getRuntimeDeploymentDescriptorPath();
        if (ddFileName == null) {
            return false;
        }
        Enumeration e = in.entries();
        while (e.hasMoreElements()) {
            String entryName = (String)e.nextElement();
            if (!entryName.equals(ddFileName)) continue;
            return true;
        }
        return false;
    }

    public void setModuleDescriptor(ModuleDescriptor module) {
        this.setDescriptor(module.getDescriptor());
        this.setManifest(module.getManifest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean performOptionalPkgDependenciesCheck(AbstractArchive archive) throws IOException {
        Vector libs;
        boolean dependenciesSatisfied = true;
        Manifest m = archive.getManifest();
        if (m != null) {
            dependenciesSatisfied = OptionalPkgDependency.optionalPkgDependencyLogic(m, archive.getArchiveUri());
        }
        if ((libs = this.getLibraries(archive)) != null) {
            for (String libUri : libs) {
                ZipInputStream jis = null;
                try {
                    jis = new JarInputStream(archive.getEntry(libUri));
                    m = ((JarInputStream)jis).getManifest();
                    if (m == null || OptionalPkgDependency.optionalPkgDependencyLogic(m, libUri)) continue;
                    dependenciesSatisfied = false;
                }
                finally {
                    if (jis != null) {
                        jis.close();
                    }
                }
            }
        }
        return dependenciesSatisfied;
    }

    public abstract void setDescriptor(Descriptor var1);

    public abstract Descriptor getDescriptor();

    public abstract ModuleType getModuleType();

    public abstract DeploymentDescriptorFile getStandardDDFile();

    public abstract DeploymentDescriptorFile getConfigurationDDFile();

    public abstract Descriptor getDefaultBundleDescriptor();

    public DeploymentDescriptorFile getWebServicesDDFile(Descriptor desc) {
        return new WebServicesDeploymentDescriptorFile(desc);
    }

    protected abstract String getArchiveExtension();

    protected abstract boolean postHandles(AbstractArchive var1) throws IOException;

    public boolean hasStandardDeploymentDescriptor(AbstractArchive archive) throws IOException {
        InputStream stIs = archive.getEntry(this.getDeploymentDescriptorPath());
        if (stIs != null) {
            stIs.close();
            return true;
        }
        return false;
    }

    public boolean hasRuntimeDeploymentDescriptor(AbstractArchive archive) throws IOException {
        InputStream runIs;
        if (this.getConfigurationDDFile() != null && (runIs = archive.getEntry(this.getConfigurationDDFile().getDeploymentDescriptorPath())) != null) {
            runIs.close();
            return true;
        }
        return false;
    }

    public ModuleDescriptor createModuleDescriptor(BundleDescriptor descriptor) {
        ModuleDescriptor newModule = new ModuleDescriptor();
        newModule.setModuleType(this.getModuleType());
        newModule.setDescriptor(descriptor);
        this.setDescriptor(descriptor);
        return newModule;
    }

    public void printDescriptor() {
        this.getDescriptor().visit(new TracerVisitor());
    }

    public void setHandleRuntimeInfo(boolean handleRuntimeInfo) {
        this.handleRuntimeInfo = handleRuntimeInfo;
    }

    public boolean isHandlingRuntimeInfo() {
        return this.handleRuntimeInfo;
    }

    public void setAnnotationProcessingRequested(boolean annotationProcessingRequested) {
        this.annotationProcessingRequested = annotationProcessingRequested;
    }

    public boolean isAnnotationProcessingRequested() {
        return this.annotationProcessingRequested;
    }

    public void setAnnotationErrorHandler(ErrorHandler annotationErrorHandler) {
        this.annotationErrorHandler = annotationErrorHandler;
    }

    public ErrorHandler getAnnotationErrorHandler() {
        return this.annotationErrorHandler;
    }

    public void setManifest(Manifest m) {
        this.manifest = m;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void setClassPath(String newClassPath) {
        if (this.manifest == null) {
            this.manifest = new Manifest();
        }
        Attributes atts = this.manifest.getMainAttributes();
        atts.putValue(Attributes.Name.CLASS_PATH.toString(), newClassPath);
    }

    public String getClassPath() {
        if (this.manifest == null) {
            return null;
        }
        Attributes atts = this.manifest.getMainAttributes();
        return atts.getValue(Attributes.Name.CLASS_PATH);
    }

    public Vector getLibraries(AbstractArchive archive) {
        Enumeration entries = archive.entries();
        if (entries == null) {
            return null;
        }
        Vector<String> libs = new Vector<String>();
        while (entries.hasMoreElements()) {
            String entryName = (String)entries.nextElement();
            if (entryName.indexOf(47) != -1 || !entryName.endsWith(".jar")) continue;
            libs.add(entryName);
        }
        return libs;
    }

    protected String getUniqueEntryFilenameFor(AbstractArchive archive, String trialName) throws IOException {
        Vector entriesNames = new Vector();
        Enumeration e = archive.entries();
        while (e != null && e.hasMoreElements()) {
            entriesNames.add(e.nextElement());
        }
        return Descriptor.createUniqueFilenameAmongst(trialName, entriesNames);
    }

    protected ModuleDescriptor addToArchive(ApplicationArchivist appArch, String externalDD) throws IOException, SAXParseException {
        File externalDescriptorFile;
        AbstractArchive archiveToBeAdded = this.abstractArchiveFactory.openArchive(this.path);
        File archiveFile = new File(this.path);
        AbstractArchive appArchive = this.abstractArchiveFactory.openArchive(appArch.getArchiveUri());
        String archiveName = this.getUniqueEntryFilenameFor(appArchive, archiveFile.getName());
        appArchive.close();
        Descriptor descriptor = null;
        if (externalDD != null && !"".equals(externalDD) && (externalDescriptorFile = new File(externalDD)).exists()) {
            FileInputStream fis = new FileInputStream(externalDescriptorFile);
            try {
                DeploymentDescriptorFile ddf = this.getStandardDDFile();
                descriptor = ddf.read(fis);
            }
            catch (SAXParseException pe) {
                archiveToBeAdded.close();
                pe.printStackTrace();
                throw pe;
            }
        }
        if (descriptor == null) {
            descriptor = this.open(archiveToBeAdded);
        }
        archiveToBeAdded.close();
        if (descriptor instanceof BundleDescriptor) {
            ModuleDescriptor newModule = new ModuleDescriptor();
            newModule.setArchiveUri(archiveName);
            newModule.setModuleType(this.getModuleType());
            newModule.setDescriptor((BundleDescriptor)descriptor);
            newModule.setManifest(this.getManifest());
            if (externalDD != null && !"".equals(externalDD)) {
                newModule.setAlternateDescriptor(externalDD);
            }
            return newModule;
        }
        return null;
    }

    protected void prepareForInclusion(AbstractArchive out) throws IOException {
    }

    public void saveRuntimeInfo(File output) throws IOException {
        File outputFile = output;
        if (outputFile == null) {
            outputFile = Archivist.getTempFile(this.path);
        }
        AbstractArchive out = this.abstractArchiveFactory.createArchive(outputFile.getAbsolutePath());
        AbstractArchive in = this.abstractArchiveFactory.openArchive(this.path);
        Vector<String> skipFiles = new Vector<String>();
        skipFiles.add(this.getRuntimeDeploymentDescriptorPath());
        this.copyInto(in, out, skipFiles);
        in.close();
        OutputStream os = out.putNextEntry(this.getRuntimeDeploymentDescriptorPath());
        this.writeRuntimeDeploymentDescriptors(os);
        out.closeEntry();
        out.close();
        if (output == null) {
            AbstractArchive finalArchive = this.abstractArchiveFactory.openArchive(this.path);
            finalArchive.delete();
            AbstractArchive tmpArchive = this.abstractArchiveFactory.openArchive(outputFile.getAbsolutePath());
            tmpArchive.renameTo(this.path);
        }
    }

    public void applyRuntimeInfo(File runtimeDD, File output) throws IOException, SAXParseException {
        this.getConfigurationDDFile().read(this.getDescriptor(), new FileInputStream(runtimeDD));
        this.saveRuntimeInfo(output);
    }

    protected static File getTempFile(String fileOrDirPath) throws IOException {
        if (fileOrDirPath != null) {
            return Archivist.getTempFile(new File(fileOrDirPath));
        }
        return Archivist.getTempFile((File)null);
    }

    public Vector getListOfFilesToSkip() {
        Vector<String> filesToSkip = new Vector<String>();
        filesToSkip.add(this.getDeploymentDescriptorPath());
        if (this.manifest != null) {
            filesToSkip.add("META-INF/MANIFEST.MF");
        }
        if (this.getRuntimeDeploymentDescriptorPath() != null) {
            filesToSkip.add(this.getRuntimeDeploymentDescriptorPath());
        }
        filesToSkip.addAll(WebServicesDeploymentDescriptorFile.getAllDescriptorPaths());
        return filesToSkip;
    }

    protected static File getTempFile(File fileOrDir) throws IOException {
        File dir = null;
        if (fileOrDir == null) {
            dir = new File(System.getProperty("user.dir"));
        } else if (!fileOrDir.isDirectory()) {
            dir = fileOrDir.getParentFile();
            if (dir == null) {
                dir = new File(System.getProperty("user.dir"));
            }
        } else {
            dir = fileOrDir;
        }
        return File.createTempFile("tmp", ".jar", dir);
    }

    protected static void addFileToArchive(AbstractArchive archive, String filePath, String entryName) throws IOException {
        FileInputStream is = new FileInputStream(new File(filePath));
        OutputStream os = archive.putNextEntry(entryName);
        ArchivistUtils.copyWithoutClose(is, os);
        is.close();
        archive.closeEntry();
    }

    protected void copyJarElements(AbstractArchive in, AbstractArchive out, Vector ignoreList) throws IOException {
        Enumeration entries = in.entries();
        Enumeration outEntriesItr = out.entries();
        while (outEntriesItr.hasMoreElements()) {
            if (ignoreList == null) {
                ignoreList = new Vector();
            }
            ignoreList.add(outEntriesItr.nextElement());
        }
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (ignoreList != null && ignoreList.contains(anEntry)) continue;
                InputStream is = in.getEntry(anEntry);
                OutputStream os = out.putNextEntry(anEntry);
                ArchivistUtils.copyWithoutClose(is, os);
                is.close();
                out.closeEntry();
            }
        }
    }

    protected boolean renameTmp(String from, String to) throws IOException {
        AbstractArchive finalArchive = this.abstractArchiveFactory.openArchive(to);
        finalArchive.delete();
        AbstractArchive tmpArchive = this.abstractArchiveFactory.openArchive(from);
        boolean success = tmpArchive.renameTo(to);
        if (!success) {
            throw new IOException("Error renaming JAR");
        }
        return success;
    }

    public void setArchiveUri(String path) {
        this.path = path;
    }

    public String getArchiveUri() {
        return this.path;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setXMLValidation(boolean validate) {
        this.isValidatingXML = validate;
    }

    public boolean getXMLValidation() {
        return this.isValidatingXML;
    }

    public void setRuntimeXMLValidation(boolean validate) {
        this.isValidatingRuntimeXML = validate;
    }

    public boolean getRuntimeXMLValidation() {
        return this.isValidatingRuntimeXML;
    }

    public void setXMLValidationLevel(String level) {
        this.validationLevel = level;
    }

    public String getXMLValidationLevel() {
        return this.validationLevel;
    }

    public void setRuntimeXMLValidationLevel(String level) {
        this.runtimeValidationLevel = level;
    }

    public String getRuntimeXMLValidationLevel() {
        return this.runtimeValidationLevel;
    }

    public void validate(ClassLoader aClassLoader) {
    }

    public void copyInto(AbstractArchive target) throws IOException {
        AbstractArchive source = this.abstractArchiveFactory.openArchive(this.path);
        this.copyInto(source, target);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target) throws IOException {
        this.copyInto(source, target, null, true);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target, boolean overwriteManifest) throws IOException {
        this.copyInto(source, target, null, overwriteManifest);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target, Vector entriesToSkip) throws IOException {
        this.copyInto(source, target, entriesToSkip, true);
    }

    public void copyInto(AbstractArchive source, AbstractArchive target, Vector entriesToSkip, boolean overwriteManifest) throws IOException {
        Manifest m;
        this.copyJarElements(source, target, entriesToSkip);
        if (overwriteManifest && (m = source.getManifest()) != null) {
            OutputStream os = target.putNextEntry("META-INF/MANIFEST.MF");
            m.write(os);
            target.closeEntry();
        }
    }

    public void extractEntry(String entryName, File out) throws IOException {
        AbstractArchive archive = this.abstractArchiveFactory.openArchive(this.path);
        InputStream is = archive.getEntry(entryName);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
        ArchivistUtils.copy(new BufferedInputStream(is), os);
        archive.close();
    }

    public void setPluggableArchivists(PluggableArchivists pa) {
        this.pa = pa;
    }

    public PluggableArchivists getPluggableArchivists() {
        if (this.pa == null) {
            return ArchivistFactory.getPluggableArchivists();
        }
        return this.pa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyAnEntry(AbstractArchive in, AbstractArchive out, String entryName) throws IOException {
        InputStream is = null;
        InputStream is2 = null;
        try {
            is = in.getEntry(entryName);
            is2 = out.getEntry(entryName);
            if (is != null && is2 == null) {
                OutputStream os = out.putNextEntry(entryName);
                ArchivistUtils.copyWithoutClose(is, os);
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (is2 != null) {
                is2.close();
            }
            out.closeEntry();
        }
    }

    public void copyStandardDeploymentDescriptors(AbstractArchive in, AbstractArchive out) throws IOException {
        BundleDescriptor desc2;
        String entryName = this.getDeploymentDescriptorPath();
        Archivist.copyAnEntry(in, out, entryName);
        Descriptor desc = this.getDescriptor();
        if (desc instanceof BundleDescriptor && (desc2 = (BundleDescriptor)desc).hasWebServices()) {
            DeploymentDescriptorFile webServicesDD = this.getWebServicesDDFile(desc2);
            String anEntry = webServicesDD.getDeploymentDescriptorPath();
            Archivist.copyAnEntry(in, out, anEntry);
        }
    }

    public static void copyExtraElements(AbstractArchive in, AbstractArchive out) throws IOException {
        Enumeration entries = in.entries();
        if (entries != null) {
            while (entries.hasMoreElements()) {
                String anEntry = (String)entries.nextElement();
                if (anEntry.endsWith("META-INF/persistence.xml") || anEntry.indexOf(WSDL) == -1 && anEntry.indexOf(XML) == -1 && anEntry.indexOf(XSD) == -1) continue;
                Archivist.copyAnEntry(in, out, anEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPersistenceDeploymentDescriptor(Archive subArchive, String puRoot, Descriptor descriptor) throws IOException, SAXParseException {
        RootDeploymentDescriptor rootDD;
        String subArchiveURI = ((AbstractArchive)AbstractArchive.class.cast(subArchive)).getArchiveUri();
        if (logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PURoot = [{0}] subArchive = {1}", new Object[]{puRoot, subArchiveURI});
        }
        if ((rootDD = (RootDeploymentDescriptor)RootDeploymentDescriptor.class.cast(descriptor)).getPersistenceUnitsDescriptor(puRoot) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "PU has been already read for = {0}", subArchiveURI);
            }
            return;
        }
        PersistenceDeploymentDescriptorFile persistenceDeploymentDescriptorFile = new PersistenceDeploymentDescriptorFile();
        persistenceDeploymentDescriptorFile.setErrorReportingString(subArchiveURI.toString());
        persistenceDeploymentDescriptorFile.setXMLValidation(this.getXMLValidation());
        persistenceDeploymentDescriptorFile.setXMLValidationLevel(this.getXMLValidationLevel());
        InputStream is = subArchive.getEntry(persistenceDeploymentDescriptorFile.getDeploymentDescriptorPath());
        if (is == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, "Archivist", "readPersistenceDeploymentDescriptor", "{0} does not contain {1}, so it is not a PU Root.", new Object[]{subArchiveURI, persistenceDeploymentDescriptorFile.getDeploymentDescriptorPath()});
            }
            return;
        }
        try {
            PersistenceUnitsDescriptor persistenceUnitsDescriptor = (PersistenceUnitsDescriptor)PersistenceUnitsDescriptor.class.cast(persistenceDeploymentDescriptorFile.read((Descriptor)rootDD, is));
            rootDD.addPersistenceUnitsDescriptor(puRoot, persistenceUnitsDescriptor);
        }
        finally {
            is.close();
        }
    }

    static {
        AnnotationUtils.setLogger(logger);
        AnnotationUtils.setLoggerTarget("*");
        MANIFEST_VERSION_VALUE = "1.0";
        localStrings = new LocalStringManagerImpl(Archivist.class);
        WSDL = ".wsdl";
        XML = ".xml";
        XSD = ".xsd";
        APPLICATION_EXTENSION = ".ear";
        APPCLIENT_EXTENSION = ".jar";
        WEB_EXTENSION = ".war";
        EJB_EXTENSION = ".jar";
        CONNECTOR_EXTENSION = ".rar";
        UPLOAD_EXTENSION = ".tmp";
        PROCESS_ANNOTATION_FOR_OLD_DD = "process.annotation.for.old.dd";
        processAnnotationForOldDD = Boolean.getBoolean(PROCESS_ANNOTATION_FOR_OLD_DD);
    }
}

