/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors;

import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.admin.monitor.registry.MonitoringLevel;
import com.sun.enterprise.admin.monitor.registry.MonitoringRegistry;
import com.sun.enterprise.admin.monitor.stats.ConnectorWorkMgmtStats;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.ResourceAdapterConfig;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.connectors.ActiveOutboundResourceAdapter;
import com.sun.enterprise.connectors.AdministeredObjectResource;
import com.sun.enterprise.connectors.BootstrapContextImpl;
import com.sun.enterprise.connectors.ConnectorAdminServiceUtils;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorRegistry;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.connectors.ConnectorRuntimeException;
import com.sun.enterprise.connectors.inflow.MessageEndpointFactoryInfo;
import com.sun.enterprise.connectors.util.ConnectorDDTransformUtils;
import com.sun.enterprise.connectors.util.SetMethodAction;
import com.sun.enterprise.connectors.work.monitor.ConnectorWorkMgmtStatsImpl;
import com.sun.enterprise.connectors.work.monitor.MonitorableWorkManager;
import com.sun.enterprise.deployment.AdminObject;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ResourcesUtil;
import com.sun.enterprise.server.ServerContext;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ResourceAdapterInternalException;

public class ActiveInboundResourceAdapter
extends ActiveOutboundResourceAdapter {
    protected ResourceAdapter resourceadapter_;
    private Hashtable factories_;
    protected String moduleName_;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");
    private StringManager localStrings = StringManager.getManager(ActiveInboundResourceAdapter.class);
    private BootstrapContext bootStrapContextImpl;

    public ActiveInboundResourceAdapter(ResourceAdapter ra, ConnectorDescriptor desc, String moduleName, ClassLoader jcl) throws ConnectorRuntimeException {
        super(desc, moduleName, jcl, false);
        this.resourceadapter_ = ra;
        this.factories_ = new Hashtable();
        this.moduleName_ = moduleName;
        try {
            this.loadRAConfiguration();
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            String poolId = null;
            ResourceAdapterConfig raConfig = registry.getResourceAdapterConfig(this.moduleName_);
            if (raConfig != null) {
                poolId = raConfig.getThreadPoolIds();
            }
            this.bootStrapContextImpl = new BootstrapContextImpl(poolId);
            if (this.moduleName_.equals(ConnectorRuntime.DEFAULT_JMS_ADAPTER)) {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ResourceAdapterInternalException {
                        ActiveInboundResourceAdapter.this.resourceadapter_.start(ActiveInboundResourceAdapter.this.bootStrapContextImpl);
                        return null;
                    }
                });
            } else {
                this.resourceadapter_.start(this.bootStrapContextImpl);
            }
            this.setupMonitoring();
        }
        catch (ResourceAdapterInternalException ex) {
            _logger.log(Level.SEVERE, "rardeployment.start_failed", ex);
            String i18nMsg = this.localStrings.getString("rardeployment.start_failed", ex.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(ex);
            throw cre;
        }
        catch (PrivilegedActionException pex) {
            _logger.log(Level.SEVERE, "rardeployment.start_failed", pex.getException());
            String i18nMsg = this.localStrings.getString("rardeployment.start_failed", pex.getException().getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(pex.getException());
            throw cre;
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "rardeployment.start_failed", t);
            String i18nMsg = this.localStrings.getString("rardeployment.start_failed", t.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(t);
            throw cre;
        }
    }

    private void setupMonitoring() {
        this.registerWorkStats();
    }

    private void unSetupMonitoring() {
        this.unRegisterWorkStats();
    }

    private void unRegisterWorkStats() {
        if (this.getWorkStatsMonitoringLevel() != MonitoringLevel.OFF) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        ServerContext ctxt = ApplicationServer.getServerContext();
                        MonitoringRegistry monRegistry = ctxt.getMonitoringRegistry();
                        String moduleName = ActiveInboundResourceAdapter.this.getModuleName();
                        monRegistry.unregisterConnectorWorkMgmtStats(ConnectorAdminServiceUtils.getApplicationName(moduleName), ConnectorAdminServiceUtils.getConnectorModuleName(moduleName), ConnectorAdminServiceUtils.isJMSRA(moduleName));
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_unreg", mre.getMessage());
                    }
                    return null;
                }
            });
        }
    }

    private void registerWorkStats() {
        if (this.getWorkStatsMonitoringLevel() != MonitoringLevel.OFF) {
            ConnectorWorkMgmtStatsImpl workStatsImpl = new ConnectorWorkMgmtStatsImpl(this);
            ((MonitorableWorkManager)this.getBootStrapContext().getWorkManager()).setMonitoringEnabled(true);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        ServerContext ctxt = ApplicationServer.getServerContext();
                        MonitoringRegistry monRegistry = ctxt.getMonitoringRegistry();
                        String moduleName = ActiveInboundResourceAdapter.this.getModuleName();
                        if (ResourcesUtil.getInstance().belongToSystemRar(moduleName) && !ConnectorAdminServiceUtils.isJMSRA(moduleName)) {
                            return null;
                        }
                        ConnectorWorkMgmtStatsImpl workstatsimpl = new ConnectorWorkMgmtStatsImpl(ActiveInboundResourceAdapter.this);
                        monRegistry.registerConnectorWorkMgmtStats((ConnectorWorkMgmtStats)workstatsimpl, ConnectorAdminServiceUtils.getApplicationName(moduleName), ConnectorAdminServiceUtils.getConnectorModuleName(moduleName), ConnectorAdminServiceUtils.isJMSRA(moduleName), null);
                    }
                    catch (Exception mre) {
                        _logger.log(Level.INFO, "poolmon.cannot_reg", mre.getMessage());
                    }
                    return null;
                }
            });
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("Enabled work monitoring at IBRA creation for " + this.getModuleName());
            }
        }
    }

    private MonitoringLevel getWorkStatsMonitoringLevel() {
        Config cfg = null;
        MonitoringLevel off = MonitoringLevel.OFF;
        MonitoringLevel l = null;
        try {
            cfg = ServerBeansFactory.getConfigBean(ApplicationServer.getServerContext().getConfigContext());
            String lvl = null;
            lvl = cfg.getMonitoringService().getModuleMonitoringLevels().getConnectorService();
            l = MonitoringLevel.instance((String)lvl);
            if (l == null) {
                return off;
            }
            return l;
        }
        catch (Exception e) {
            return off;
        }
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceadapter_;
    }

    public void setup() throws ConnectorRuntimeException {
        if (this.connectionDefs_ == null || this.connectionDefs_.length == 0) {
            return;
        }
        this.obtainServerXMLvalue();
        ResourcesUtil resUtil = ResourcesUtil.getInstance();
        if (this.isServer() && !resUtil.belongToSystemRar(this.moduleName_)) {
            this.createAllConnectorResources();
        }
    }

    private void obtainServerXMLvalue() {
    }

    public void destroy() {
        if (this.isServer() && this.connectionDefs_ != null && this.connectionDefs_.length != 0) {
            this.destroyAllConnectorResources();
            for (MessageEndpointFactoryInfo element : this.getAllEndpointFactoryInfo()) {
                try {
                    this.resourceadapter_.endpointDeactivation(element.getEndpointFactory(), element.getActivationSpec());
                }
                catch (RuntimeException e) {
                    _logger.warning(e.getMessage());
                    _logger.log(Level.FINE, "Error during endpointDeactivation ", e);
                }
            }
        }
        try {
            _logger.fine("Calling Resource Adapter stop" + this.getModuleName());
            this.resourceadapter_.stop();
            _logger.fine("Resource Adapter stop call of " + this.getModuleName() + "returned successfully");
            _logger.log(Level.FINE, "rar_stop_call_successful");
        }
        catch (Throwable t) {
            _logger.log(Level.SEVERE, "rardeployment.stop_warning", t);
        }
    }

    public ManagedConnectionFactory createManagedConnectionFactory(ConnectorConnectionPool pool, ClassLoader jcl) {
        ManagedConnectionFactory mcf = null;
        mcf = super.createManagedConnectionFactory(pool, jcl);
        if (mcf instanceof ResourceAdapterAssociation) {
            try {
                ((ResourceAdapterAssociation)mcf).setResourceAdapter(this.resourceadapter_);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "rardeployment.assoc_failed", ex);
            }
        }
        return mcf;
    }

    private void writePoolResourceToServerXML() {
    }

    public MessageEndpointFactoryInfo getEndpointFactoryInfo(String id) {
        return (MessageEndpointFactoryInfo)this.factories_.get(id);
    }

    public Set getAllEndpointFactoryInfo() {
        Hashtable infos = (Hashtable)this.factories_.clone();
        return infos.entrySet();
    }

    public void addEndpointFactoryInfo(String id, MessageEndpointFactoryInfo info) {
        this.factories_.put(id, info);
    }

    public void removeEndpointFactoryInfo(String id) {
        this.factories_.remove(id);
    }

    public Collection getAllEndpointFactories() {
        return this.factories_.values();
    }

    public void addAdminObject(String appName, String connectorName, String jndiName, String adminObjectType, Properties props) throws ConnectorRuntimeException {
        if (props == null) {
            props = new Properties();
        }
        ConnectorRegistry registry = null;
        try {
            registry = ConnectorRegistry.getInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        ConnectorDescriptor desc = registry.getDescriptor(connectorName);
        AdminObject aoDesc = desc.getAdminObjectByType(adminObjectType);
        AdministeredObjectResource aor = new AdministeredObjectResource(jndiName);
        aor.initialize(aoDesc);
        aor.setResourceAdapter(connectorName);
        Object[] envProps = aoDesc.getConfigProperties().toArray();
        for (int i = 0; i < envProps.length; ++i) {
            EnvironmentProperty environmentProperty = (EnvironmentProperty)envProps[i];
            String name = environmentProperty.getName();
            String userValue = (String)props.remove(name);
            if (userValue != null) {
                aor.addConfigProperty(new EnvironmentProperty(name, userValue, userValue, environmentProperty.getType()));
                continue;
            }
            aor.addConfigProperty(environmentProperty);
        }
        for (String string : props.keySet()) {
            String userValue = props.getProperty(string);
            if (userValue == null) continue;
            aor.addConfigProperty(new EnvironmentProperty(string, userValue, userValue));
        }
        try {
            Reference reference = aor.createAdminObjectReference();
            NamingManager nm = Switch.getSwitch().getNamingManager();
            nm.publishObject(jndiName, (Object)reference, true);
        }
        catch (NamingException namingException) {
            String i18nMsg = this.localStrings.getString("aira.cannot_bind_admin_obj");
            throw new ConnectorRuntimeException(i18nMsg);
        }
    }

    protected void loadRAConfiguration() throws ConnectorRuntimeException {
        try {
            ElementProperty[] raConfigProps = null;
            Set mergedProps = null;
            ConnectorRegistry registry = ConnectorRegistry.getInstance();
            ResourceAdapterConfig raConfig = registry.getResourceAdapterConfig(this.moduleName_);
            if (raConfig != null) {
                raConfigProps = raConfig.getElementProperty();
            }
            mergedProps = raConfigProps != null ? ConnectorDDTransformUtils.mergeProps(raConfigProps, this.getDescriptor().getConfigProperties()) : ConnectorDDTransformUtils.mergeProps(new ElementProperty[0], this.getDescriptor().getConfigProperties());
            if (this.moduleName_.equals(ConnectorRuntime.DEFAULT_JMS_ADAPTER)) {
                ConnectorRuntime.getRuntime();
                if (ConnectorRuntime.isServer()) {
                    this.hackMergedProps(mergedProps);
                }
            }
            this.logMergedProperties(mergedProps);
            SetMethodAction setMethodAction = new SetMethodAction(this.resourceadapter_, mergedProps);
            setMethodAction.run();
        }
        catch (Exception e) {
            String i18nMsg = this.localStrings.getString("ccp_adm.wrong_params_for_create", e.getMessage());
            ConnectorRuntimeException cre = new ConnectorRuntimeException(i18nMsg);
            cre.initCause(e);
            throw cre;
        }
    }

    private void hackMergedProps(Set mergedProps) {
        String brokerType = null;
        for (EnvironmentProperty element : mergedProps) {
            if (!element.getName().equals("BrokerType")) continue;
            brokerType = element.getValue();
        }
        if (brokerType.equals("LOCAL") || brokerType.equals("EMBEDDED")) {
            Iterator iter = mergedProps.iterator();
            while (iter.hasNext()) {
                EnvironmentProperty element;
                element = (EnvironmentProperty)iter.next();
                if (!element.getName().equals("ConnectionURL")) continue;
                iter.remove();
            }
        }
    }

    private void logMergedProperties(Set mergedProps) {
        _logger.fine("Passing in the following properties before calling RA.start of " + this.moduleName_);
        StringBuffer b = new StringBuffer();
        for (EnvironmentProperty element : mergedProps) {
            b.append("\nName: " + element.getName() + " Value: " + element.getValue());
        }
        _logger.fine(b.toString());
    }

    public BootstrapContext getBootStrapContext() {
        return this.bootStrapContextImpl;
    }
}

