/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.mbean.config;

import com.sun.enterprise.admin.util.ArgChecker;
import com.sun.enterprise.config.ConfigBeansFactory;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.IiopListener;
import com.sun.enterprise.config.serverbeans.IiopService;
import com.sun.logging.LogDomains;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public final class ConfigBeanIntrospector {
    private static final Logger sLogger = LogDomains.getLogger("javax.enterprise.system.tools.admin");

    public static Object instantiate(Class bean, Object[] params) throws Exception {
        ArgChecker.checkValid(bean, "bean");
        ArgChecker.checkValid(params, "params");
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        Constructor ctor = bean.getConstructor(paramTypes);
        Object inst = ctor.newInstance(params);
        return inst;
    }

    public static boolean isAttributeSupported(Class beanClass, String attributeName) {
        boolean isSupported = false;
        try {
            PropertyDescriptor pd = ConfigBeanIntrospector.getPropertyDescriptor(beanClass, attributeName);
            isSupported = pd != null;
        }
        catch (Exception e) {
            sLogger.throwing(ConfigBeanIntrospector.class.getName(), "isAttributeSupported", e);
            isSupported = false;
        }
        return isSupported;
    }

    public static boolean isAttributeReadable(Class beanClass, String attributeName) {
        boolean isReadable = false;
        try {
            Method m = ConfigBeanIntrospector.getGetter(beanClass, attributeName);
            isReadable = m != null;
        }
        catch (Exception e) {
            sLogger.throwing(ConfigBeanIntrospector.class.getName(), "isAttributeReadable", e);
            isReadable = false;
        }
        return isReadable;
    }

    public static boolean isAttributeWritable(Class beanClass, String attributeName) {
        boolean isWritable = false;
        try {
            Method m = ConfigBeanIntrospector.getSetter(beanClass, attributeName);
            isWritable = m != null;
        }
        catch (Exception e) {
            sLogger.throwing(ConfigBeanIntrospector.class.getName(), "isAttributeWritable", e);
            isWritable = false;
        }
        return isWritable;
    }

    public static Object invokeGetter(Object target, String attributeName) throws Exception {
        ArgChecker.checkValid(target, "target");
        ArgChecker.checkValid(attributeName, "attributeName");
        Object ret = null;
        Class<?> beanClass = target.getClass();
        Method getter = ConfigBeanIntrospector.getGetter(beanClass, attributeName);
        if (getter != null) {
            ret = getter.invoke(target, null);
        }
        return ret;
    }

    public static void invokeSetter(Object target, String attributeName, Object value) throws Exception {
        ArgChecker.checkValid(target, "target");
        ArgChecker.checkValid(attributeName, "attributeName");
        Class<?> beanClass = target.getClass();
        Method setter = ConfigBeanIntrospector.getSetter(beanClass, attributeName);
        if (setter != null) {
            setter.invoke(target, value);
        }
    }

    private static Method getGetter(Class beanClass, String attributeName) throws Exception {
        Method m = null;
        PropertyDescriptor pd = ConfigBeanIntrospector.getPropertyDescriptor(beanClass, attributeName);
        if (pd != null) {
            m = pd.getReadMethod();
        }
        return m;
    }

    private static Method getSetter(Class beanClass, String attributeName) throws Exception {
        Method m = null;
        PropertyDescriptor pd = ConfigBeanIntrospector.getPropertyDescriptor(beanClass, attributeName);
        if (pd != null) {
            m = pd.getWriteMethod();
        }
        return m;
    }

    private static PropertyDescriptor getPropertyDescriptor(Class beanClass, String attributeName) throws Exception {
        PropertyDescriptor descriptor = null;
        BeanInfo javaBeanInfo = Introspector.getBeanInfo(beanClass);
        PropertyDescriptor[] pds = javaBeanInfo.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            if (!pd.getName().equals(attributeName)) continue;
            descriptor = pd;
            break;
        }
        return descriptor;
    }

    public static void main(String[] args) throws Exception {
        ConfigContext ctx = ConfigFactory.createConfigContext("/u/ramakant/server.xml", true);
        IiopListener obj = null;
        Config config = (Config)ConfigBeansFactory.getConfigBeanByXPath(ctx, "/domain/configs/config[@name='server-config']");
        IiopService iiopService = config.getIiopService();
        obj = iiopService.getIiopListenerById("orb-listener-1");
        Object value = ConfigBeanIntrospector.invokeGetter(obj, "id");
        sLogger.info(value.toString());
        try {
            ConfigBeanIntrospector.invokeGetter(obj, "abcd");
        }
        catch (Exception e) {
            sLogger.info("OK " + e.getMessage());
        }
        ConfigBeanIntrospector.invokeSetter(obj, "id", "surya10");
        ConfigBeanIntrospector.invokeSetter(obj, "port", new Integer(8888).toString());
        ctx.flush(true);
    }
}

