/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.enterprise.admin.server.core.jmx.DomainRepository;
import com.sun.enterprise.admin.server.core.jmx.IRepository;
import com.sun.enterprise.admin.server.core.jmx.InitException;
import com.sun.enterprise.admin.server.core.jmx.Introspector;
import com.sun.enterprise.admin.server.core.jmx.MBeanIntrospector;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.loading.ClassLoaderRepository;

public class MBeanServerImpl
implements MBeanServer {
    protected IRepository mMBeanRepository = new DomainRepository();
    private static boolean kDynamicMBeansOnly = true;
    private static String kGetMBeanInfoMethodName = "getMBeanInfo";
    private static String kAllMBeansPattern = "*";
    private static StringManager localStrings = StringManager.getManager(MBeanServerImpl.class);

    protected MBeanServerImpl(String defaultDomainName) throws InitException {
    }

    protected MBeanServerImpl() throws InitException {
        this("DefaultDomain");
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null || objectName == null) {
            throw new IllegalArgumentException();
        }
        if (this.mMBeanRepository.contains(objectName)) {
            throw new InstanceAlreadyExistsException(objectName.toString());
        }
        this.mMBeanRepository.add(objectName, object);
        return new ObjectInstance(objectName, object.getClass().getName());
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws ReflectionException, InstanceNotFoundException, MBeanException {
        Object implObject = this.mMBeanRepository.find(objectName);
        if (implObject == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> implClass = implObject.getClass();
        Introspector reflector = new Introspector(implClass);
        Object value = null;
        try {
            Method method = reflector.getMethod(operationName, signature);
            value = reflector.invokeMethodOn(method, implObject, params);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionException(nsme);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof MBeanException) {
                throw (MBeanException)t;
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            String msg = localStrings.getString("admin.server.core.jmx.error_from_mbean", t.getMessage());
            RuntimeException re = new RuntimeException(msg);
            throw new MBeanException(re);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return value;
    }

    public Object getAttribute(ObjectName objectName, String attributeName) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        Object implObject = this.mMBeanRepository.find(objectName);
        if (implObject == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> implClass = implObject.getClass();
        Object value = null;
        try {
            MBeanIntrospector introspector = new MBeanIntrospector(implClass);
            if (introspector.isDynamicMBean()) {
                Method method = introspector.getMethod("getAttribute", new String[]{"java.lang.String"});
                value = introspector.invokeMethodOn(method, implObject, new Object[]{attributeName});
            }
        }
        catch (NotCompliantMBeanException e) {
            value = null;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionException(nsme);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
        return value;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException, InvalidAttributeValueException {
        Object implObject = this.mMBeanRepository.find(objectName);
        if (implObject == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> implClass = implObject.getClass();
        Object value = null;
        try {
            MBeanIntrospector introspector = new MBeanIntrospector(implClass);
            if (introspector.isDynamicMBean()) {
                Method method = introspector.getMethod("setAttribute", new String[]{"javax.management.Attribute"});
                value = introspector.invokeMethodOn(method, implObject, new Object[]{attribute});
            }
        }
        catch (NotCompliantMBeanException e) {
            value = null;
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionException(nsme);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            if (t instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)t;
            }
            if (t instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)t;
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae);
        }
        catch (Exception e) {
            throw new MBeanException(e);
        }
    }

    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (!this.mMBeanRepository.contains(objectName)) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        this.mMBeanRepository.remove(objectName);
    }

    public Integer getMBeanCount() {
        return new Integer(this.mMBeanRepository.getTotalCount());
    }

    public Set queryMBeans(ObjectName name, QueryExp exp) {
        Set mbeans = new HashSet();
        mbeans = this.mMBeanRepository.query(name);
        return mbeans;
    }

    public MBeanInfo getMBeanInfo(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        MBeanInfo info = null;
        if (!kDynamicMBeansOnly) {
            String msg = localStrings.getString("admin.server.core.jmx.assert");
            throw new IntrospectionException(msg);
        }
        try {
            String operationName = kGetMBeanInfoMethodName;
            String[] signature = null;
            Object[] params = null;
            info = (MBeanInfo)this.invoke(objName, operationName, params, signature);
        }
        catch (MBeanException e) {
            throw new IntrospectionException(e.getMessage());
        }
        return info;
    }

    public boolean isRegistered(ObjectName name) {
        return this.mMBeanRepository.contains(name);
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_addnotificationlistener");
        throw new UnsupportedOperationException(msg);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName1, NotificationFilter notificationFilter, Object obj) throws InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_addnotificationlistener");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInstance createMBean(String str, ObjectName objectName, ObjectName objectName2, Object[] obj, String[] str4) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_creatembean");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInputStream deserialize(String str, byte[] values) throws OperationsException, ReflectionException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_deserialize");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInputStream deserialize(ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_deserialize");
        throw new UnsupportedOperationException(msg);
    }

    public ObjectInputStream deserialize(String str, ObjectName objectName, byte[] values) throws InstanceNotFoundException, OperationsException, ReflectionException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_deserialize");
        throw new UnsupportedOperationException(msg);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] attrNames) throws InstanceNotFoundException, ReflectionException {
        Object implObject = this.mMBeanRepository.find(objectName);
        if (implObject == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> implClass = implObject.getClass();
        AttributeList list = new AttributeList();
        try {
            MBeanIntrospector introspector = new MBeanIntrospector(implClass);
            if (introspector.isDynamicMBean()) {
                Method method = introspector.getMethod("getAttributes", new String[]{"[Ljava.lang.String;"});
                list = (AttributeList)introspector.invokeMethodOn(method, implObject, new Object[]{attrNames});
            }
        }
        catch (NotCompliantMBeanException e) {
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionException(nsme);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String msg = localStrings.getString("admin.server.core.jmx.getattributes_error_from_mbean", t.getMessage());
            throw new RuntimeException(msg);
        }
        return list;
    }

    public String getDefaultDomain() {
        return "DefaultDomain";
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_getobjectinstance");
        throw new UnsupportedOperationException(msg);
    }

    public Object instantiate(String str) throws ReflectionException, MBeanException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(msg);
    }

    public Object instantiate(String str, ObjectName objectName) throws ReflectionException, MBeanException, InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(msg);
    }

    public Object instantiate(String str, Object[] obj, String[] str2) throws ReflectionException, MBeanException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(msg);
    }

    public Object instantiate(String str, ObjectName objectName, Object[] obj, String[] str3) throws ReflectionException, MBeanException, InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_instantiate");
        throw new UnsupportedOperationException(msg);
    }

    public boolean isInstanceOf(ObjectName objectName, String str) throws InstanceNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_isinstanceof");
        throw new UnsupportedOperationException(msg);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_querynames");
        throw new UnsupportedOperationException(msg);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName1) throws InstanceNotFoundException, ListenerNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_removenotificationlistener");
        throw new UnsupportedOperationException(msg);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        String msg = localStrings.getString("admin.server.core.jmx.mbeanserver_removenotificationlistener");
        throw new UnsupportedOperationException(msg);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        Object implObject = this.mMBeanRepository.find(objectName);
        if (implObject == null) {
            throw new InstanceNotFoundException(objectName.toString());
        }
        Class<?> implClass = implObject.getClass();
        AttributeList list = new AttributeList();
        try {
            MBeanIntrospector introspector = new MBeanIntrospector(implClass);
            if (introspector.isDynamicMBean()) {
                Method method = introspector.getMethod("setAttributes", new String[]{list.getClass().getName()});
                list = (AttributeList)introspector.invokeMethodOn(method, implObject, new Object[]{attributeList});
            }
        }
        catch (NotCompliantMBeanException e) {
        }
        catch (ClassNotFoundException cnfe) {
            throw new ReflectionException(cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new ReflectionException(nsme);
        }
        catch (SecurityException se) {
            throw new ReflectionException(se);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectionException(iae);
        }
        catch (InvocationTargetException ite) {
            Throwable t = ite.getTargetException();
            String msg = localStrings.getString("admin.server.core.jmx.setattributes_error_from_mbean", t.getMessage());
            throw new RuntimeException(msg);
        }
        return list;
    }

    public String[] getDomains() {
        String msg = "getDomains";
        throw new UnsupportedOperationException("getDomains");
    }

    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        String msg = "removeNotificationListener";
        throw new UnsupportedOperationException("removeNotificationListener");
    }

    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        String msg = "removeNotificationListener";
        throw new UnsupportedOperationException("removeNotificationListener");
    }

    public ClassLoader getClassLoaderFor(ObjectName oName) {
        String msg = "getClassLoaderFor";
        throw new UnsupportedOperationException("getClassLoaderFor");
    }

    public ClassLoader getClassLoader(ObjectName oName) {
        String msg = "getClassLoader";
        throw new UnsupportedOperationException("getClassLoader");
    }

    public ClassLoaderRepository getClassLoaderRepository() {
        String msg = "getClassLoaderRepository";
        throw new UnsupportedOperationException("getClassLoaderRepository");
    }
}

