/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.jmx;

import com.sun.enterprise.admin.common.ParamInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;

public class Introspector {
    protected Class mClassReflected = null;

    public Introspector(Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException();
        }
        this.mClassReflected = aClass;
    }

    public boolean implementsInterface(Class aClass) {
        boolean implInterface = false;
        block0: for (Class thisClass = this.mClassReflected; aClass != null && thisClass != null && !implInterface; thisClass = thisClass.getSuperclass()) {
            Class<?>[] interfaces = thisClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> anInterface = interfaces[i];
                if (!anInterface.getName().equals(aClass.getName())) continue;
                implInterface = true;
                continue block0;
            }
        }
        return implInterface;
    }

    public boolean extendsClass(Class aClass) {
        if (aClass == null) {
            return false;
        }
        boolean extendsClass = false;
        for (Class superClass = this.mClassReflected.getSuperclass(); superClass != null && !extendsClass; superClass = superClass.getSuperclass()) {
            if (!superClass.getName().equals(aClass.getName())) continue;
            extendsClass = true;
        }
        return extendsClass;
    }

    public Method getMethod(String operationName, String[] signature) throws ClassNotFoundException, NoSuchMethodException, SecurityException {
        Method method = null;
        Class[] parameterTypes = null;
        if (signature != null) {
            parameterTypes = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                String parameterName = signature[i];
                Class primitiveClass = ParamInfo.getPrimitiveClass(parameterName);
                boolean parameterIsPrimitive = primitiveClass != null;
                parameterTypes[i] = parameterIsPrimitive ? primitiveClass : Class.forName(parameterName);
            }
        }
        method = this.mClassReflected.getMethod(operationName, parameterTypes);
        return method;
    }

    public Object invokeMethodOn(Method method, Object targetObject, Object[] actualParams) throws IllegalAccessException, InvocationTargetException {
        Object result = null;
        if (method == null || targetObject == null) {
            throw new IllegalArgumentException();
        }
        result = method.invoke(targetObject, actualParams);
        return result;
    }

    public Method[] getCallableInstanceMethods(Collection excludeList) {
        boolean includeAll = false;
        if (excludeList == null || excludeList.isEmpty()) {
            includeAll = true;
        }
        ArrayList<Method> methodList = new ArrayList<Method>();
        Method[] methods = null;
        for (Class aClass = this.mClassReflected; aClass != null; aClass = aClass.getSuperclass()) {
            boolean shouldInclude;
            boolean bl = shouldInclude = includeAll || !excludeList.contains(aClass.getName());
            if (!shouldInclude) continue;
            Method[] declMethods = aClass.getDeclaredMethods();
            for (int i = 0; i < declMethods.length; ++i) {
                int modifiers = declMethods[i].getModifiers();
                boolean isCallableInstanceMethod = false;
                boolean isPublicMethod = Modifier.isPublic(modifiers);
                boolean isAbstractMethod = Modifier.isAbstract(modifiers);
                boolean isStaticMethod = Modifier.isStatic(modifiers);
                boolean bl2 = isCallableInstanceMethod = isPublicMethod && !isAbstractMethod && !isStaticMethod;
                if (!isCallableInstanceMethod) continue;
                methodList.add(declMethods[i]);
            }
        }
        methods = new Method[methodList.size()];
        return methodList.toArray(methods);
    }

    public Method[] getDeclaredConcretePublicMethods() {
        Method[] declMethods = this.mClassReflected.getDeclaredMethods();
        ArrayList<Method> publicMethods = new ArrayList<Method>();
        for (int i = 0; i < declMethods.length; ++i) {
            int modifiers = declMethods[i].getModifiers();
            boolean isPublic = Modifier.isPublic(modifiers);
            boolean isAbstract = Modifier.isAbstract(modifiers);
            if (!isPublic || isAbstract) continue;
            publicMethods.add(declMethods[i]);
        }
        Method[] pMethods = new Method[publicMethods.size()];
        return publicMethods.toArray(pMethods);
    }
}

