/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.server.core.channel;

import com.sun.appserv.server.ServerLifecycleException;
import com.sun.enterprise.admin.server.core.channel.AdminChannelServer;
import com.sun.enterprise.admin.server.core.channel.LocalRMIClientSocketFactory;
import com.sun.enterprise.admin.server.core.channel.LocalRMIServerSocketFactory;
import com.sun.enterprise.admin.server.core.channel.RMIClient;
import com.sun.enterprise.admin.server.core.channel.ReconfigHelper;
import com.sun.enterprise.server.J2EEServer;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AdminChannel {
    static Logger logger = Logger.getLogger("javax.enterprise.system.tools.admin");
    static String instanceRoot = null;
    static final String fileSeparator = "/";
    static final int SEED_LENGTH = 16;
    private static AdminChannelServer server = null;
    private static HashMap rmiClientMap = new HashMap();
    private static StringManager localStrings = StringManager.getManager(AdminChannel.class);
    static final String stubFileName = "admch";
    static final String seedFileName = "admsn";
    static final String LOCAL_ONLY_ACCESS = "high";
    static final String ALLOW_ALL_ACCESS = "none";
    static final String ENFORCE = "high";
    static final String REQUIRE_KEY = "medium";
    static final String NO_ENFORCE = "low";
    static final String RECONFIG_ENABLE_ERROR = "channel.reconfig_enable_error";
    static final String SERVER_CREATION_ERRCODE = "channel.creation_error";
    static final String KEY_READ_ERROR = "channel.key_read_error";
    static final String KEY_WRITE_ERROR = "channel.key_write_error";

    public static void createRMIChannel() throws ServerLifecycleException {
        try {
            server = AdminChannel.createServerObject();
            AdminChannel.saveStubToFile(server.getRemoteStub());
        }
        catch (Exception e) {
            AdminChannel.warn(SERVER_CREATION_ERRCODE);
            AdminChannel.debug(e);
            throw new ServerLifecycleException(e);
        }
    }

    public static void destroyRMIChannel() throws ServerLifecycleException {
        if (server != null) {
            server.setChannelStopping();
            try {
                UnicastRemoteObject.unexportObject(server, true);
            }
            catch (NoSuchObjectException nsoe) {
                throw new ServerLifecycleException(nsoe);
            }
        }
        AdminChannel.deleteStubFile();
    }

    public static void createSharedSecret() throws ServerLifecycleException {
        AdminChannel.assertAdminServerChannelNotNull();
        String fileName = AdminChannel.getSeedFileName();
        File seedFile = new File(fileName);
        byte[] prevSeed = AdminChannel.getPreviousSeed(seedFile);
        SecureRandom sr = new SecureRandom(prevSeed);
        byte[] seed = new byte[16];
        sr.nextBytes(seed);
        AdminChannel.saveSeedToFile(seed, seedFile);
        server.setSharedInfo(seed);
        server.setChannelStarting();
    }

    public static void enableWebCoreReconfig() {
        try {
            ReconfigHelper.enableWebCoreReconfig();
        }
        catch (Throwable t) {
            AdminChannel.warn(RECONFIG_ENABLE_ERROR);
            AdminChannel.debug(t);
        }
    }

    public static RMIClient getRMIClient(String instanceName) {
        RMIClient client = (RMIClient)rmiClientMap.get(instanceName);
        if (client == null) {
            client = new RMIClient(AdminChannel.getStubFileName(), AdminChannel.getSeedFileName());
            rmiClientMap.put(instanceName, client);
        }
        return client;
    }

    public static void setRMIChannelReady() {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelReady();
    }

    public static void setRMIChannelStopping() {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelStopping();
    }

    public static void setRMIChannelAborting(int port) {
        AdminChannel.assertAdminServerChannelNotNull();
        server.setChannelAborting(port);
    }

    static String getInstanceRoot() {
        if (instanceRoot == null) {
            instanceRoot = System.getProperty("com.sun.aas.instanceRoot");
        }
        return instanceRoot;
    }

    static String getStubFileName() {
        return AdminChannel.getInstanceRoot() + fileSeparator + "config" + fileSeparator + stubFileName;
    }

    static String getSeedFileName() {
        return AdminChannel.getInstanceRoot() + fileSeparator + "config" + fileSeparator + seedFileName;
    }

    private static AdminChannelServer createServerObject() throws RemoteException {
        AdminChannelServer server = null;
        InetAddress localAddress = AdminChannel.getLocalLoopbackAddress();
        if (localAddress == null) {
            server = new AdminChannelServer();
        } else {
            LocalRMIClientSocketFactory csf = new LocalRMIClientSocketFactory(localAddress);
            LocalRMIServerSocketFactory ssf = new LocalRMIServerSocketFactory(localAddress);
            server = new AdminChannelServer(0, csf, ssf);
            server.setLocalAddress(localAddress);
        }
        return server;
    }

    private static InetAddress getLocalLoopbackAddress() {
        InetAddress localAddr = null;
        try {
            localAddr = InetAddress.getByName(null);
            if (!localAddr.isLoopbackAddress()) {
                localAddr = null;
            }
        }
        catch (Throwable t) {
            localAddr = null;
        }
        return localAddr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static byte[] getPreviousSeed(File seedFile) {
        block14: {
            haveSeed = false;
            prevSeed = new byte[16];
            sr = J2EEServer.secureRandom;
            if (!AdminChannel.$assertionsDisabled && sr == null) {
                throw new AssertionError();
            }
            sr.setSeed(System.currentTimeMillis());
            if (seedFile.exists() && seedFile.canRead()) {
                fis = null;
                try {
                    fis = new FileInputStream(seedFile);
                    fis.read(prevSeed);
                    sr.setSeed(prevSeed);
                    sr.nextBytes(prevSeed);
                    haveSeed = true;
                    var7_5 = null;
                    ** if (fis == null) goto lbl-1000
                }
                catch (Throwable var6_12) {
                    var7_7 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    throw var6_12;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block14;
                    catch (IOException ioe) {
                        AdminChannel.warn("channel.key_read_error");
                        AdminChannel.debug(ioe);
                        var7_6 = null;
                        if (fis != null) {
                            try {
                                fis.close();
                            }
                            catch (IOException ioe) {}
                        }
                    }
                }
            }
        }
        if (!haveSeed) {
            sr.nextBytes(prevSeed);
        }
        return prevSeed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void saveSeedToFile(byte[] seed, File seedFile) {
        FileOutputStream fos = null;
        fos = new FileOutputStream(seedFile);
        fos.write(seed);
        Object var5_3 = null;
        if (fos == null) return;
        try {
            fos.close();
            return;
        }
        catch (IOException ioe2) {}
        return;
        {
            catch (IOException ioe) {
                AdminChannel.warn(KEY_WRITE_ERROR);
                AdminChannel.debug(ioe);
                Object var5_4 = null;
                if (fos == null) return;
                try {
                    fos.close();
                    return;
                }
                catch (IOException ioe2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private static void saveStubToFile(RemoteStub stub) {
        String fileName = AdminChannel.getStubFileName();
        try {
            File file = new File(fileName);
            FileOutputStream fos = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(stub);
            fos.close();
        }
        catch (Exception e) {
            String msg = localStrings.getString("admin.server.core.channel.unable_saving_stub_to_file", fileName);
            throw new RuntimeException(msg, e);
        }
    }

    private static void deleteStubFile() {
        String fileName = AdminChannel.getStubFileName();
        new File(fileName).delete();
    }

    private static final void assertAdminServerChannelNotNull() {
        if (server == null) {
            String msg = localStrings.getString("admin.server.core.channel.admin_server_channel_not_initialized");
            throw new RuntimeException(msg);
        }
    }

    static void warn(String s) {
        logger.warning(s);
    }

    static void warn(String msgkey, String obj1) {
        logger.log(Level.WARNING, msgkey, obj1);
    }

    static void debug(String s) {
        logger.fine(s);
    }

    static void debug(String msgkey, String obj1) {
        logger.log(Level.FINE, msgkey, obj1);
    }

    static void debug(String msgkey, Object[] objarr) {
        logger.log(Level.FINE, msgkey, objarr);
    }

    static void debug(Throwable t) {
        logger.log(Level.FINE, t.getMessage(), t);
    }

    static void trace(Throwable t) {
        logger.log(Level.FINEST, t.getMessage(), t);
    }

    static String getAccessLevel() {
        return "high";
    }

    static String getKeyCheckLevel() {
        return "high";
    }

    static boolean getClientAutoRefreshEnabled() {
        return true;
    }

    static long getClientAutoRefreshInterval() {
        return 60000L;
    }
}

