/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.selfmanagement.event.Event;
import com.sun.enterprise.admin.selfmanagement.event.EventAbstractFactory;
import com.sun.enterprise.admin.selfmanagement.event.EventBuilder;
import com.sun.enterprise.admin.selfmanagement.event.ManagementRulesMBeanHelper;
import com.sun.enterprise.admin.selfmanagement.event.NotificationEvent;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.server.ApplicationServer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class NotificationEventFactory
extends EventAbstractFactory {
    private static NotificationEventFactory instance = new NotificationEventFactory();
    private static String instanceName = ApplicationServer.getServerContext().getInstanceName();

    private NotificationEventFactory() {
        EventBuilder.getInstance().addEventFactory("notification", this);
    }

    public Event instrumentEvent(ElementProperty[] properties, String description) {
        String sourceMbeanObjName = null;
        String sourceMbeanName = null;
        for (int i = 0; i < properties.length; ++i) {
            ElementProperty property = properties[i];
            String propertyName = property.getName().toLowerCase();
            if (propertyName.equals("sourceobjectname")) {
                sourceMbeanObjName = property.getValue();
                continue;
            }
            if (!propertyName.equals("sourcembean")) continue;
            sourceMbeanName = property.getValue();
        }
        if (sourceMbeanName == null && sourceMbeanObjName == null) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "sourceMBean", "notification"));
        }
        String sourceMbean = null;
        if (sourceMbeanObjName != null) {
            Pattern pat = Pattern.compile("\\$\\{instance.name\\}");
            Matcher m = pat.matcher(sourceMbeanObjName);
            sourceMbean = m.find() ? m.replaceAll(instanceName) : sourceMbeanObjName;
        } else if (sourceMbeanName != null) {
            sourceMbean = ManagementRulesMBeanHelper.getObjName(sourceMbeanName);
        }
        try {
            ObjectName oName = new ObjectName(sourceMbean);
            return new NotificationEvent(oName, description);
        }
        catch (MalformedObjectNameException ex) {
            throw new IllegalArgumentException(sm.getString("selfmgmt_event.invalid_event_property", "sourceMBean", "notification"));
        }
    }

    static NotificationEventFactory getInstance() {
        return instance;
    }
}

