/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.selfmanagement.event;

import com.sun.enterprise.admin.common.MBeanServerFactory;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Mbean;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.ServerHelper;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementRulesMBeanHelper {
    private static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.selfmanagement");
    private static String instanceName = ApplicationServer.getServerContext().getInstanceName();
    private static ConfigContext configCtx = ApplicationServer.getServerContext().getConfigContext();

    private static ConfigContext getConfigContext() {
        return AdminService.getAdminService().getAdminContext().getAdminConfigContext();
    }

    public static List<String> getAllActionMBeans(boolean enabled) throws ConfigException {
        ArrayList<String> actionMBeanList = new ArrayList<String>();
        List<Mbean> mbeanList = ServerBeansFactory.getAllMBeanDefinitions(ManagementRulesMBeanHelper.getConfigContext());
        for (Mbean mbean : mbeanList) {
            String implClassName;
            if (enabled && !mbean.isEnabled() || !ManagementRulesMBeanHelper.implementsInterface(implClassName = mbean.getImplClassName(), "javax.management.NotificationListener")) continue;
            actionMBeanList.add(mbean.getName());
        }
        return actionMBeanList;
    }

    private static boolean implementsInterface(String implClassName, String interfaceName) {
        Class<?>[] ifList = null;
        Class<?> class1 = null;
        try {
            ClassLoader mbeanClLoader = ManagementRulesMBeanHelper.getMBeanClassLoader();
            class1 = mbeanClLoader != null ? Class.forName(implClassName, false, mbeanClLoader) : Class.forName(implClassName);
            while (class1 != null) {
                ifList = class1.getInterfaces();
                if (ifList == null) continue;
                for (int i = 0; i < ifList.length; ++i) {
                    String canonicalName = ifList[i].getCanonicalName().trim();
                    if (!canonicalName.equals(interfaceName)) continue;
                    return true;
                }
                class1 = class1.getSuperclass();
            }
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, " An unexpcted exception occurred ", ex);
        }
        return false;
    }

    private static ClassLoader getMBeanClassLoader() {
        try {
            return (ClassLoader)Class.forName("com.sun.enterprise.admin.mbeans.custom.loading.MBeanClassLoader").newInstance();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, " An unexpcted exception occurred ", ex);
            return null;
        }
    }

    public static List<String> getEventTypes(boolean isEE) {
        ArrayList<String> eventTypeList = new ArrayList<String>();
        eventTypeList.add("lifecycle");
        eventTypeList.add("log");
        eventTypeList.add("timer");
        eventTypeList.add("trace");
        eventTypeList.add("monitor");
        eventTypeList.add("notification");
        if (isEE) {
            eventTypeList.add("cluster");
        }
        return eventTypeList;
    }

    public static List<String> getEventProperties(String eventType) {
        if (eventType == null || "".equals(eventType)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> valueList = null;
        if (eventType.equals("lifecycle")) {
            valueList = new ArrayList<String>(1);
            valueList.add("name");
            return valueList;
        }
        if (eventType.equals("monitor")) {
            valueList = new ArrayList();
            valueList.add("observedobject");
            valueList.add("observedmbean");
            valueList.add("observedattribute");
            valueList.add("granularityperiod");
            valueList.add("numbertype");
            valueList.add("differencemode");
            valueList.add("initthreshold");
            valueList.add("offset");
            valueList.add("modulus");
            valueList.add("lowthreshold");
            valueList.add("highthreshold");
            valueList.add("stringtocompare");
            valueList.add("stringnotify");
            return valueList;
        }
        if (eventType.equals("trace")) {
            valueList = new ArrayList(1);
            valueList.add("name");
            return valueList;
        }
        if (eventType.equals("log")) {
            valueList = new ArrayList(2);
            valueList.add("loggernames");
            valueList.add("level");
            return valueList;
        }
        if (eventType.equals("timer")) {
            valueList = new ArrayList(5);
            valueList.add("pattern");
            valueList.add("datestring");
            valueList.add("period");
            valueList.add("numberofoccurrences");
            valueList.add("message");
            return valueList;
        }
        if (eventType.equals("notification")) {
            valueList = new ArrayList(1);
            valueList.add("sourcembean");
            valueList.add("sourceobjectname");
            return valueList;
        }
        if (eventType.equals("cluster")) {
            valueList = new ArrayList(2);
            valueList.add("name");
            valueList.add("servername");
            return valueList;
        }
        return new ArrayList<String>(0);
    }

    public static List<String> getEventPropertyValues(String eventType, String propertyName) throws ConfigException {
        if (eventType == null || "".equals(eventType)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> valueList = null;
        if (eventType.equals("lifecycle") && "name".equals(propertyName)) {
            valueList = new ArrayList<String>(3);
            valueList.add("ready");
            valueList.add("shutdown");
            valueList.add("termination");
            return valueList;
        }
        if (eventType.equals("monitor")) {
            if ("observedobject".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("observedmbean".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("observedattribute".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("granularityperiod".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("monitortype".equals(propertyName)) {
                valueList = new ArrayList(3);
                valueList.add("countermonitor");
                valueList.add("gaugemonitor");
                valueList.add("stringmonitor");
                return valueList;
            }
            if ("numbertype".equals(propertyName)) {
                valueList = new ArrayList(6);
                valueList.add("long");
                valueList.add("int");
                valueList.add("short");
                valueList.add("double");
                valueList.add("float");
                valueList.add("byte");
                return valueList;
            }
            if ("differencemode".equals(propertyName)) {
                valueList = new ArrayList(2);
                valueList.add("true");
                valueList.add("false");
                return valueList;
            }
            if ("initthreshold".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("offset".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("modulus".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("lowthreshold".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("highthreshold".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("stringtocompare".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("stringnotify".equals(propertyName)) {
                valueList = new ArrayList(2);
                valueList.add("notifymatch");
                valueList.add("notifydiffer");
                return valueList;
            }
        }
        if ("trace".equals(eventType) && "name".equals(propertyName)) {
            valueList = new ArrayList(6);
            valueList.add("web_component_method_entry");
            valueList.add("web_component_method_exit");
            valueList.add("request_start");
            valueList.add("request_end");
            valueList.add("ejb_component_method_entry");
            valueList.add("ejb_component_method_exit");
            return valueList;
        }
        if ("log".equals(eventType)) {
            if ("loggernames".equals(propertyName)) {
                valueList = new ArrayList();
                Enumeration<String> loggerNames = LogManager.getLogManager().getLoggerNames();
                while (loggerNames.hasMoreElements()) {
                    valueList.add(loggerNames.nextElement());
                }
                return valueList;
            }
            if ("level".equals(propertyName)) {
                valueList = new ArrayList();
                valueList.add(Level.ALL.getName());
                valueList.add(Level.CONFIG.getName());
                valueList.add(Level.FINE.getName());
                valueList.add(Level.FINER.getName());
                valueList.add(Level.FINEST.getName());
                valueList.add(Level.INFO.getName());
                valueList.add(Level.SEVERE.getName());
                valueList.add(Level.WARNING.getName());
                return valueList;
            }
        }
        if ("timer".equals(eventType) && ("pattern".equals(propertyName) || "datestring".equals(propertyName) || "period".equals(propertyName) || "numberofoccurrences".equals(propertyName) || "message".equals(propertyName))) {
            return new ArrayList<String>(0);
        }
        if ("notification".equals(eventType)) {
            if ("sourcembean".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
            if ("sourceobjectname".equals(propertyName)) {
                return new ArrayList<String>(0);
            }
        }
        if ("cluster".equals(eventType)) {
            if ("name".equals(propertyName)) {
                valueList = new ArrayList(3);
                valueList.add("start");
                valueList.add("stop");
                valueList.add("fail");
                return valueList;
            }
            if ("servername".equals(propertyName)) {
                Server[] servers;
                valueList = new ArrayList();
                for (Server server : servers = ServerHelper.getServersInDomain(ManagementRulesMBeanHelper.getConfigContext())) {
                    valueList.add(server.getName());
                }
                return valueList;
            }
        }
        return new ArrayList<String>(0);
    }

    public static List<String> getAllNotificationEmitterMbeans(boolean enabled) throws ConfigException {
        ArrayList<String> customMBeanList = new ArrayList<String>();
        List<Mbean> mbeanList = ServerBeansFactory.getAllMBeanDefinitions(ManagementRulesMBeanHelper.getConfigContext());
        for (Mbean mbean : mbeanList) {
            String implClassName;
            if (enabled && !mbean.isEnabled() || !ManagementRulesMBeanHelper.implementsInterface(implClassName = mbean.getImplClassName(), "javax.management.NotificationEmitter")) continue;
            customMBeanList.add(mbean.getName());
        }
        return customMBeanList;
    }

    public static Set<ObjectName> getRegisteredMBeans(String filter) throws MalformedObjectNameException {
        ObjectName userFilteredObjectName = null;
        MBeanServer mbeanServer = MBeanServerFactory.getMBeanServer();
        if (filter != null) {
            userFilteredObjectName = new ObjectName(filter);
            return mbeanServer.queryNames(userFilteredObjectName, null);
        }
        String monitoringObjectNameFilter = "com.sun.appserv:category=monitor,*";
        String jsr77ObjectNameFilter = "com.sun.appserv:category=runtime,*";
        ObjectName monitoringFilteredObjectName = null;
        ObjectName jsr77FilteredObjectName = null;
        try {
            monitoringFilteredObjectName = new ObjectName(monitoringObjectNameFilter);
            jsr77FilteredObjectName = new ObjectName(jsr77ObjectNameFilter);
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, " An unexpcted exception occurred ", ex);
        }
        Set<ObjectName> setObjNames = mbeanServer.queryNames(monitoringFilteredObjectName, null);
        setObjNames.addAll(mbeanServer.queryNames(jsr77FilteredObjectName, null));
        return setObjNames;
    }

    public static List<String> getAttributes(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (objName == null) {
            return new ArrayList<String>(0);
        }
        MBeanInfo mbInfo = MBeanServerFactory.getMBeanServer().getMBeanInfo(objName);
        MBeanAttributeInfo[] attrInfoArr = mbInfo.getAttributes();
        ArrayList<String> attributes = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : attrInfoArr) {
            attributes.add(attrInfo.getName());
        }
        return attributes;
    }

    public static List<String> getMBeanAttributes(String objectNameStr) throws MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        ObjectName objName = new ObjectName(objectNameStr);
        return ManagementRulesMBeanHelper.getAttributes(objName);
    }

    public static List<String> getNotificationTypes(ObjectName objName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (objName == null) {
            return new ArrayList<String>(0);
        }
        MBeanInfo mbInfo = MBeanServerFactory.getMBeanServer().getMBeanInfo(objName);
        MBeanNotificationInfo[] notifInfoArr = mbInfo.getNotifications();
        ArrayList<String> notifications = new ArrayList<String>();
        for (MBeanNotificationInfo notifInfo : notifInfoArr) {
            String[] notifTypes;
            for (String notifType : notifTypes = notifInfo.getNotifTypes()) {
                notifications.add(notifType);
            }
        }
        return notifications;
    }

    public static List<String> getNotificationTypes(String objectNameStr) throws MalformedObjectNameException, InstanceNotFoundException, IntrospectionException, ReflectionException {
        ObjectName objName = new ObjectName(objectNameStr);
        return ManagementRulesMBeanHelper.getNotificationTypes(objName);
    }

    public static List<String> getAttributes(String dottedName) {
        return null;
    }

    public static List<String> getDottedNames(String dottedName) {
        return null;
    }

    public static String getObjName(String mBeanName) {
        String objName = null;
        String cascadedObjName = null;
        if (mBeanName != null) {
            try {
                Applications apps;
                Mbean definedMBean;
                Domain domain = ServerBeansFactory.getDomainBean(configCtx);
                ApplicationRef appRef = ManagementRulesMBeanHelper.verifyMBean(mBeanName, domain);
                if (appRef != null && (definedMBean = (apps = domain.getApplications()).getMbeanByName(mBeanName)) != null) {
                    objName = definedMBean.getObjectName();
                    cascadedObjName = ManagementRulesMBeanHelper.getCascadingAwareObjectName(new ObjectName(objName)).toString();
                }
            }
            catch (ConfigException ex) {
                _logger.log(Level.INFO, "An unexpected exception occured.", ex);
            }
            catch (Exception ex) {
                _logger.log(Level.INFO, "An unexpected exception occured.", ex);
            }
        }
        return cascadedObjName;
    }

    public static ObjectName getCascadingAwareObjectName(ObjectName configON) throws RuntimeException {
        try {
            String serverNameKey = "server";
            Hashtable<String, String> properties = configON.getKeyPropertyList();
            properties.put("server", instanceName);
            ObjectName ron = new ObjectName(configON.getDomain(), properties);
            return ron;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static ApplicationRef verifyMBean(String mBeanName, Domain domain) {
        ApplicationRef appRef = null;
        try {
            Applications apps;
            Mbean definedMBean;
            Server instanceBean = ServerBeansFactory.getServerBean(configCtx);
            appRef = instanceBean.getApplicationRefByRef(mBeanName);
            if (appRef == null) {
                Cluster[] cluster;
                Clusters clusters = domain.getClusters();
                for (Cluster val : cluster = clusters.getCluster()) {
                    if (val.getServerRefByRef(instanceName) == null) continue;
                    appRef = val.getApplicationRefByRef(mBeanName);
                    break;
                }
            }
            if (appRef != null && (definedMBean = (apps = domain.getApplications()).getMbeanByName(mBeanName)) == null) {
                appRef = null;
            }
        }
        catch (ConfigException ex) {
            _logger.log(Level.INFO, "smgt.config_error", ex);
        }
        return appRef;
    }
}

