/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.config;

import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.PropertyResolver;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanException;

public class ConfigBeanHelper {
    private static final String XPATH_SEPARATOR = "/";
    public final String PROPERTY_NAME_PREFIX = "property.";
    private ConfigBean m_baseConfigBean;
    private BaseConfigMBean m_mbean;

    public ConfigBeanHelper(BaseConfigMBean mbean, ConfigBean cb) {
        this.m_baseConfigBean = cb;
        this.m_mbean = mbean;
    }

    public String getAttributeValue(String name) throws MBeanException, AttributeNotFoundException {
        if (this.m_baseConfigBean == null) {
            return null;
        }
        if (name.startsWith("property.")) {
            return (String)this.getPropertyElementValue(name.substring("property.".length()));
        }
        return this.m_baseConfigBean.getAttributeValue(name);
    }

    public String setAttributeValue(String name, String value) throws MBeanException, AttributeNotFoundException {
        if (this.m_baseConfigBean == null) {
            return null;
        }
        if (name.startsWith("property.")) {
            this.setPropertyElementValue(new Attribute(name.substring("property.".length()), value), false);
        } else {
            this.m_baseConfigBean.setAttributeValue(name, value);
        }
        return value;
    }

    protected static boolean isDebugEnabled() {
        return true;
    }

    protected static void debug(String s) {
        System.out.println(s);
    }

    protected static void info(String s) {
        System.out.println(s);
    }

    protected static void error(String s) {
        System.out.println(s);
    }

    public Object getPropertyElementValue(String propertyName) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        Class<?> cl = this.m_baseConfigBean.getClass();
        try {
            Method method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)this.m_baseConfigBean, propertyName);
        }
        catch (Exception e) {
            String msg = "admin.server.core.mbean.config.getattribute.undefined_properties_in_base_element" + propertyName;
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null) {
            String msg = "admin.server.core.mbean.config.getattribute_properties_not_found_in_base_element" + propertyName;
            throw new MBeanException(new MBeanConfigException(msg));
        }
        return prop.getValue();
    }

    public void setPropertyElementValue(Attribute attr, boolean bAllowsEmptyValue) throws MBeanException, AttributeNotFoundException {
        ElementProperty prop;
        Method method;
        String propertyName = attr.getName();
        String value = (String)attr.getValue();
        Class<?> cl = this.m_baseConfigBean.getClass();
        try {
            method = cl.getDeclaredMethod("getElementPropertyByName", Class.forName("java.lang.String"));
            prop = (ElementProperty)method.invoke((Object)this.m_baseConfigBean, propertyName);
        }
        catch (Exception e) {
            String msg = "admin.server.core.mbean.config.setattribute_undefined_properties_in_base_element" + propertyName;
            throw new MBeanException(new MBeanConfigException(msg));
        }
        if (prop == null && value != null && (bAllowsEmptyValue || !value.equals(""))) {
            prop = new ElementProperty();
            prop.setName(propertyName);
            prop.setValue(value);
            try {
                method = cl.getDeclaredMethod("addElementProperty", prop.getClass());
                method.invoke((Object)this.m_baseConfigBean, prop);
            }
            catch (Exception e) {
                String msg = "admin.server.core.mbean.config.setproperty_invoke_error" + propertyName;
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else if (value == null || !bAllowsEmptyValue && value.equals("")) {
            try {
                method = cl.getDeclaredMethod("removeElementProperty", prop.getClass());
                method.invoke((Object)this.m_baseConfigBean, prop);
            }
            catch (Exception e) {
                String msg = "admin.server.core.mbean.config.setproperty_could_not_remove_propery" + propertyName;
                throw new MBeanException(new MBeanConfigException(msg));
            }
        } else {
            prop.setValue(value);
        }
    }

    private static ElementProperty[] getElementProperties(ConfigBean element) {
        Class<?> cl = element.getClass();
        ElementProperty[] props = null;
        try {
            Method method = cl.getDeclaredMethod("getElementProperty", new Class[0]);
            props = (ElementProperty[])method.invoke((Object)element, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public static boolean checkIfAttributesAndPropertiesAreResolvable(ConfigBean element, String instanceName) throws ConfigException {
        ElementProperty[] props;
        PropertyResolver resolver = new PropertyResolver(element.getConfigContext(), instanceName);
        StringBuffer buf = new StringBuffer();
        String[] attrNames = element.getAttributeNames();
        if (attrNames != null) {
            for (int i = 0; i < attrNames.length; ++i) {
                String value = element.getAttributeValue(attrNames[i]);
                if (value == null || resolver.isResolvable(value, true)) continue;
                return false;
            }
        }
        if ((props = ConfigBeanHelper.getElementProperties(element)) != null) {
            for (int i = 0; i < props.length; ++i) {
                String value = props[i].getValue();
                if (value == null || resolver.isResolvable(value, true)) continue;
                return false;
            }
        }
        return true;
    }
}

