/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.Invocation;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.interceptors.AroundInvokeChainImpl;
import com.sun.ejb.containers.interceptors.AroundInvokeInterceptor;
import com.sun.ejb.containers.interceptors.BeanAroundInvokeInterceptor;
import com.sun.ejb.containers.interceptors.BeanCallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackChainImpl;
import com.sun.ejb.containers.interceptors.CallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EnterpriseBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterceptorManager {
    private BaseContainer container;
    private EjbDescriptor ejbDesc;
    private ClassLoader loader;
    private Class beanClass;
    private String beanClassName;
    private Logger _logger;
    private Class[] interceptorClasses;
    private Class[] serializableInterceptorClasses;
    private Map<String, Integer> instanceIndexMap = new HashMap<String, Integer>();
    private boolean methodInterceptorsExists;
    private String[] pre30LCMethodNames;
    private Class[] lcAnnotationClasses;
    private CallbackChainImpl[] callbackChain;

    public InterceptorManager(Logger _logger, BaseContainer container, Class[] lcAnnotationClasses, String[] pre30LCMethodNames) throws Exception {
        this._logger = _logger;
        this.container = container;
        this.lcAnnotationClasses = lcAnnotationClasses;
        this.pre30LCMethodNames = pre30LCMethodNames;
        this.ejbDesc = container.getEjbDescriptor();
        this.loader = container.getClassLoader();
        this.beanClassName = this.ejbDesc.getEjbImplClassName();
        this.beanClass = this.loader.loadClass(this.beanClassName);
        this.buildInterceptorChain();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "InterceptorManager: " + this.toString());
        }
    }

    public Object[] createInterceptorInstances() {
        int size = this.serializableInterceptorClasses.length;
        Object[] interceptors = new Object[size];
        for (int index = 0; index < size; ++index) {
            Class clazz = this.serializableInterceptorClasses[index];
            try {
                interceptors[index] = clazz.newInstance();
                continue;
            }
            catch (IllegalAccessException illEx) {
                throw new RuntimeException(illEx);
            }
            catch (InstantiationException instEx) {
                throw new RuntimeException(instEx);
            }
        }
        return interceptors;
    }

    public Invocation.InterceptorChain getAroundInvokeChain(MethodDescriptor mDesc, Method beanMethod) {
        List<EjbInterceptor> list = this.ejbDesc.getAroundInvokeInterceptors(mDesc);
        ArrayList<AroundInvokeInterceptor> interceptors = new ArrayList<AroundInvokeInterceptor>();
        for (EjbInterceptor interceptor : list) {
            String className = interceptor.getInterceptorClassName();
            Set<LifecycleCallbackDescriptor> aroundInvokeDescs = interceptor.getAroundInvokeDescriptors();
            if (aroundInvokeDescs.isEmpty()) continue;
            List<Object> orderedAIInterceptors = new ArrayList();
            try {
                orderedAIInterceptors = interceptor.getOrderedAroundInvokeDescriptors(this.loader);
            }
            catch (Exception e) {
                throw new IllegalStateException("No AroundInvokeIntercetpors found  on class " + className, e);
            }
            for (LifecycleCallbackDescriptor lifecycleCallbackDescriptor : orderedAIInterceptors) {
                int index;
                Method method = null;
                try {
                    method = lifecycleCallbackDescriptor.getLifecycleCallbackMethodObject(this.loader);
                }
                catch (Exception e) {
                    throw new IllegalStateException("No callback method of name " + lifecycleCallbackDescriptor.getLifecycleCallbackMethod() + " found on class " + className, e);
                }
                if (interceptor.getFromBeanClass()) {
                    interceptors.add(new BeanAroundInvokeInterceptor(method));
                    continue;
                }
                Integer bigInt = this.instanceIndexMap.get(className);
                int n = index = bigInt == null ? -1 : bigInt;
                if (index == -1) {
                    throw new IllegalStateException(this.getInternalErrorString(className));
                }
                Class clazz = this.interceptorClasses[index];
                this._logger.log(Level.FINE, "*[md.getDeclaredMethod() => " + method + " FOR CLAZZ: " + clazz);
                interceptors.add(new AroundInvokeInterceptor(index, method));
            }
        }
        AroundInvokeInterceptor[] inter = interceptors.toArray(new AroundInvokeInterceptor[interceptors.size()]);
        return new AroundInvokeChainImpl(this.container, inter);
    }

    public boolean hasInterceptors() {
        return this.methodInterceptorsExists;
    }

    public Object intercept(Invocation inv) throws Throwable {
        return inv.getInterceptorChain().invokeNext(0, inv);
    }

    public boolean intercept(LifecycleCallbackDescriptor.CallbackType eventType, EJBContextImpl ctx) throws Throwable {
        CallbackChainImpl chain = null;
        switch (eventType) {
            case POST_CONSTRUCT: 
            case PRE_PASSIVATE: 
            case POST_ACTIVATE: 
            case PRE_DESTROY: {
                chain = this.callbackChain[eventType.ordinal()];
                CallbackInvocationContext invContext = new CallbackInvocationContext(ctx, chain);
                if (chain == null) break;
                chain.invokeNext(0, invContext);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event type");
            }
        }
        return true;
    }

    private void buildInterceptorChain() throws ClassNotFoundException, Exception {
        this.initInterceptorClassNames();
        this.initCallbackIndices();
    }

    private void initInterceptorClassNames() throws ClassNotFoundException, Exception {
        Set<String> interceptorClassNames = this.ejbDesc.getInterceptorClassNames();
        int size = interceptorClassNames.size();
        this.interceptorClasses = new Class[size];
        this.serializableInterceptorClasses = new Class[size];
        int index = 0;
        for (String className : interceptorClassNames) {
            Class<?> interClass;
            this.interceptorClasses[index] = interClass = this.loader.loadClass(className);
            this.serializableInterceptorClasses[index] = interClass;
            this.instanceIndexMap.put(className, index);
            if (!Serializable.class.isAssignableFrom(interClass)) {
                this.serializableInterceptorClasses[index] = EJBUtils.loadGeneratedSerializableClass(this.loader, className);
            }
            ++index;
        }
        boolean bl = this.methodInterceptorsExists = interceptorClassNames.size() > 0;
        if (this.ejbDesc.hasAroundInvokeMethod()) {
            this.methodInterceptorsExists = true;
        }
        this.instanceIndexMap.put(this.beanClassName, index++);
    }

    private void initCallbackIndices() throws ClassNotFoundException, Exception {
        int index;
        int size = LifecycleCallbackDescriptor.CallbackType.values().length;
        ArrayList[] callbacks = new ArrayList[size];
        boolean scanFor2xLifecycleMethods = true;
        for (LifecycleCallbackDescriptor.CallbackType eventType : LifecycleCallbackDescriptor.CallbackType.values()) {
            index = eventType.ordinal();
            callbacks[index] = new ArrayList();
            boolean scanForCallbacks = true;
            if (!(this.ejbDesc instanceof EjbSessionDescriptor || eventType != LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE && eventType != LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE)) {
                scanForCallbacks = false;
            }
            if (scanForCallbacks) {
                List<EjbInterceptor> callbackList = this.ejbDesc.getCallbackInterceptors(eventType);
                for (EjbInterceptor callback : callbackList) {
                    List<CallbackInterceptor> inters = this.createCallbackInterceptors(eventType, callback);
                    for (CallbackInterceptor inter : inters) {
                        callbacks[index].add(inter);
                    }
                }
            }
            if (callbacks[index].size() <= 0) continue;
            scanFor2xLifecycleMethods = false;
        }
        if (scanFor2xLifecycleMethods) {
            this.load2xLifecycleMethods(callbacks);
        }
        this.callbackChain = new CallbackChainImpl[size];
        for (LifecycleCallbackDescriptor.CallbackType eventType : LifecycleCallbackDescriptor.CallbackType.values()) {
            index = eventType.ordinal();
            CallbackInterceptor[] interceptors = callbacks[index].toArray(new CallbackInterceptor[callbacks[index].size()]);
            this.callbackChain[index] = new CallbackChainImpl(this.container, interceptors);
        }
    }

    private List<CallbackInterceptor> createCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType eventType, EjbInterceptor inter) throws Exception {
        ArrayList<CallbackInterceptor> callbackList = new ArrayList<CallbackInterceptor>();
        List<LifecycleCallbackDescriptor> orderedCallbackMethods = inter.getOrderedCallbackDescriptors(eventType, this.loader);
        String className = inter.getInterceptorClassName();
        for (LifecycleCallbackDescriptor callbackDesc : orderedCallbackMethods) {
            Method method = null;
            try {
                method = callbackDesc.getLifecycleCallbackMethodObject(this.loader);
            }
            catch (Exception e) {
                throw new IllegalStateException("No callback method of name " + callbackDesc.getLifecycleCallbackMethod() + " found on class " + className, e);
            }
            CallbackInterceptor interceptor = null;
            if (inter.getFromBeanClass()) {
                interceptor = new BeanCallbackInterceptor(method);
            } else {
                int index;
                Integer bigInt = this.instanceIndexMap.get(className);
                int n = index = bigInt == null ? -1 : bigInt;
                if (index == -1) {
                    throw new IllegalStateException(this.getInternalErrorString(className));
                }
                interceptor = new CallbackInterceptor(index, method);
            }
            callbackList.add(interceptor);
        }
        return callbackList;
    }

    private void load2xLifecycleMethods(ArrayList<CallbackInterceptor>[] metaArray) {
        if (EnterpriseBean.class.isAssignableFrom(this.beanClass)) {
            int sz = this.lcAnnotationClasses.length;
            for (int i = 0; i < sz; ++i) {
                if (this.pre30LCMethodNames[i] == null) continue;
                try {
                    Method method = this.beanClass.getMethod(this.pre30LCMethodNames[i], null);
                    if (method == null) continue;
                    BeanCallbackInterceptor meta = new BeanCallbackInterceptor(method);
                    metaArray[i].add(meta);
                    this._logger.log(Level.FINE, "**## bean has 2.x LM: " + meta);
                    continue;
                }
                catch (NoSuchMethodException nsmEx) {
                    // empty catch block
                }
            }
        }
    }

    public String toString() {
        StringBuilder sbldr = new StringBuilder();
        sbldr.append("##########################################################\n");
        sbldr.append("InterceptorManager<").append(this.beanClassName).append("> has ").append(this.interceptorClasses.length).append(" interceptors");
        sbldr.append("\n\tbeanClassName: ").append(this.beanClassName);
        sbldr.append("\n\tInterceptors: ");
        for (Class clazz : this.interceptorClasses) {
            sbldr.append("\n\t\t").append(clazz.getName());
        }
        sbldr.append("\n\tCallback Interceptors: ");
        for (int i = 0; i < this.lcAnnotationClasses.length; ++i) {
            CallbackChainImpl chain = this.callbackChain[i];
            sbldr.append("\n\t").append(i).append(": ").append(this.lcAnnotationClasses[i]);
            sbldr.append("\n\t\t").append(chain.toString());
        }
        sbldr.append("\n");
        sbldr.append("##########################################################\n");
        return sbldr.toString();
    }

    private String getInternalErrorString(String className) {
        StringBuilder sbldr = new StringBuilder("Internal error: ");
        sbldr.append(" className: ").append(className).append(" is neither a bean class (").append(this.beanClassName).append(") nor an ").append("interceptor class (");
        for (Class cn : this.interceptorClasses) {
            sbldr.append(cn.getName()).append("; ");
        }
        sbldr.append(")");
        this._logger.log(Level.INFO, "++ : " + sbldr.toString());
        return sbldr.toString();
    }
}

