/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.codegen.Compiler;
import com.sun.ejb.codegen.JavaCompilerException;
import com.sun.ejb.codegen.ProcessExecutorException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import sun.rmi.rmic.Main;

class RMICompiler
extends Compiler {
    private static final String RMIC_EXT_DIRS_OPTION = "-extdirs";
    private File rmicExe;
    private File javaExe;
    private Set generatedFilenames = null;
    private String classpath = null;
    private static int timeout = -1;

    RMICompiler(List theOptions, List theFiles) throws JavaCompilerException {
        super(theOptions, theFiles);
    }

    void setClasspath(String cp) {
        this.classpath = cp;
    }

    protected void internal_compile() throws JavaCompilerException, ProcessExecutorException {
        try {
            if (this.nativeExternalCompile()) {
                return;
            }
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "ejb.rmic_compilation_exception", t);
        }
        this.nativeCompile();
    }

    private boolean nativeExternalCompile() throws ProcessExecutorException {
        if (this.classpath == null || this.javaExe == null) {
            return false;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.javaExe.getPath());
        cmd.add("-classpath");
        cmd.add(this.classpath);
        if (OS.isDarwin()) {
            cmd.add("-Djava.endorsed.dirs=" + System.getProperty("com.sun.aas.installRoot") + File.separatorChar + "lib" + File.separatorChar + "endorsed");
        }
        cmd.add("-Djava.ext.dirs=" + System.getProperty("java.ext.dirs"));
        cmd.add("sun.rmi.rmic.Main");
        cmd.addAll(this.options);
        this.addJavaFiles(cmd);
        String[] cmds = new String[cmd.size()];
        cmds = cmd.toArray(cmds);
        this.runProcess(cmds, RMICompiler.getRmicTimeout() * this.files.size());
        this.logCompilerName("rmic in external JVM");
        return true;
    }

    private void nativeCompile() throws JavaCompilerException {
        this.options.add(RMIC_EXT_DIRS_OPTION);
        this.options.add(System.getProperty("java.ext.dirs"));
        this.options.addAll(this.files);
        String[] cmds = new String[this.options.size()];
        cmds = this.options.toArray(cmds);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Main compiler = new Main(baos, "rmic");
        boolean good = compiler.compile(cmds);
        String output = baos.toString();
        this.parseGeneratedFilenames(output);
        if (!good) {
            throw new JavaCompilerException("rmi_compiler.error", "RMI compiler returned an error: {0}", output);
        }
        this.logCompilerName("native rmic (sun.rmi.rmic.Main)");
    }

    protected void internal_init() {
        String javaName;
        String rmicName;
        this.rmicExe = null;
        this.javaExe = null;
        if (this.jdkDir == null) {
            return;
        }
        if (OS.isWindows()) {
            rmicName = "rmic.exe";
            javaName = "java.exe";
        } else {
            rmicName = "rmic";
            javaName = "java";
        }
        this.rmicExe = new File(this.jdkDir + "/bin/" + rmicName);
        this.rmicExe = this.rmicExe.exists() ? FileUtils.safeGetCanonicalFile(this.rmicExe) : null;
        this.javaExe = new File(this.jdkDir + "/bin/" + javaName);
        this.javaExe = this.javaExe.exists() ? FileUtils.safeGetCanonicalFile(this.javaExe) : null;
        logger.log(Level.FINE, "[RMICompiler] after internal_init: javaExe: " + this.javaExe + "; rmicExe: " + this.rmicExe);
    }

    private static int getRmicTimeout() {
        if (timeout < 0) {
            timeout = RMICompiler.getTimeout("com.sun.aas.deployment.Rmic.TimeoutMS", 40000, 5000, 300000);
        }
        return timeout;
    }

    private void parseGeneratedFilenames(String s) {
        this.generatedFilenames = new HashSet();
        StringTokenizer tk = new StringTokenizer(s);
        while (tk.hasMoreTokens()) {
            String token = tk.nextToken();
            if (!token.equals("[generated") || !tk.hasMoreTokens()) continue;
            String fName = tk.nextToken();
            this.generatedFilenames.add(fName);
            logger.log(Level.FINER, "[RMIC] Generated: " + fName);
        }
    }

    Set getGeneratedFilenames() {
        return this.generatedFilenames;
    }
}

