/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.container.util;

import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.EjbContainer;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.BeanCacheDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.enterprise.server.ApplicationServer;
import com.sun.enterprise.server.ServerContext;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheProperties {
    protected static Logger _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
    private int maxCacheSize;
    private int numberOfVictimsToSelect;
    private int cacheIdleTimeoutInSeconds;
    private int removalTimeoutInSeconds;
    private String victimSelectionPolicy;

    public CacheProperties(EjbDescriptor desc) {
        try {
            BeanCacheDescriptor beanCacheDes = null;
            Config cfg = null;
            IASEjbExtraDescriptors iased = desc.getIASEjbExtraDescriptors();
            if (iased != null) {
                beanCacheDes = iased.getBeanCache();
            }
            EjbContainer ejbContainer = null;
            ServerContext sc = ApplicationServer.getServerContext();
            cfg = ServerBeansFactory.getConfigBean(sc.getConfigContext());
            ejbContainer = cfg.getEjbContainer();
            this.loadProperties(ejbContainer, beanCacheDes);
        }
        catch (ConfigException ex) {
            _logger.log(Level.SEVERE, "", ex);
        }
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public int getNumberOfVictimsToSelect() {
        return this.numberOfVictimsToSelect;
    }

    public int getCacheIdleTimeoutInSeconds() {
        return this.cacheIdleTimeoutInSeconds;
    }

    public int getRemovalTimeoutInSeconds() {
        return this.removalTimeoutInSeconds;
    }

    public String getVictimSelectionPolicy() {
        return this.victimSelectionPolicy;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("maxSize: ").append(this.maxCacheSize).append("; victims: ").append(this.numberOfVictimsToSelect).append("; idleTimeout: ").append(this.cacheIdleTimeoutInSeconds).append("; removalTimeout: ").append(this.removalTimeoutInSeconds).append("; policy: ").append(this.victimSelectionPolicy);
        return sbuf.toString();
    }

    private void loadProperties(EjbContainer ejbContainer, BeanCacheDescriptor beanCacheDes) {
        this.numberOfVictimsToSelect = new Integer(ejbContainer.getCacheResizeQuantity());
        this.maxCacheSize = new Integer(ejbContainer.getMaxCacheSize());
        this.cacheIdleTimeoutInSeconds = new Integer(ejbContainer.getCacheIdleTimeoutInSeconds());
        this.removalTimeoutInSeconds = new Integer(ejbContainer.getRemovalTimeoutInSeconds());
        this.victimSelectionPolicy = ejbContainer.getVictimSelectionPolicy();
        if (beanCacheDes != null) {
            int temp = 0;
            temp = beanCacheDes.getResizeQuantity();
            if (temp != -1) {
                this.numberOfVictimsToSelect = temp;
            }
            if ((temp = beanCacheDes.getMaxCacheSize()) != -1) {
                this.maxCacheSize = temp;
            }
            if ((temp = beanCacheDes.getCacheIdleTimeoutInSeconds()) != -1) {
                this.cacheIdleTimeoutInSeconds = temp;
            }
            if ((temp = beanCacheDes.getRemovalTimeoutInSeconds()) != -1) {
                this.removalTimeoutInSeconds = temp;
            }
            if (beanCacheDes.getVictimSelectionPolicy() != null) {
                this.victimSelectionPolicy = beanCacheDes.getVictimSelectionPolicy();
            }
        }
    }
}

