/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.protocol;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.CodeSetComponentInfo;
import com.sun.corba.ee.impl.encoding.CodeSetConversion;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.logging.ORBUtilSystemException;
import com.sun.corba.ee.impl.orbutil.ORBUtility;
import com.sun.corba.ee.impl.orbutil.newtimer.TimingPoints;
import com.sun.corba.ee.impl.protocol.CorbaInvocationInfo;
import com.sun.corba.ee.pept.broker.Broker;
import com.sun.corba.ee.pept.encoding.InputObject;
import com.sun.corba.ee.pept.encoding.OutputObject;
import com.sun.corba.ee.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.ee.pept.protocol.MessageMediator;
import com.sun.corba.ee.pept.transport.ContactInfo;
import com.sun.corba.ee.pept.transport.OutboundConnectionCache;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.ior.TaggedComponent;
import com.sun.corba.ee.spi.ior.iiop.CodeSetsComponent;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBVersion;
import com.sun.corba.ee.spi.orb.ORBVersionFactory;
import com.sun.corba.ee.spi.protocol.CorbaMessageMediator;
import com.sun.corba.ee.spi.servicecontext.CodeSetServiceContext;
import com.sun.corba.ee.spi.servicecontext.ORBVersionServiceContext;
import com.sun.corba.ee.spi.servicecontext.SendingContextServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.servicecontext.UEInfoServiceContext;
import com.sun.corba.ee.spi.servicecontext.UnknownServiceContext;
import com.sun.corba.ee.spi.transport.CorbaConnection;
import com.sun.corba.ee.spi.transport.CorbaContactInfo;
import com.sun.corba.ee.spi.transport.CorbaContactInfoListIterator;
import java.io.IOException;
import java.util.Iterator;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA.portable.UnknownException;
import org.omg.CORBA_2_3.portable.InputStream;

public class CorbaClientRequestDispatcherImpl
implements ClientRequestDispatcher {
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputObject beginRequest(Object self, String opName, boolean isOneWay, ContactInfo contactInfo) {
        ORB orb = null;
        TimingPoints tp = null;
        try {
            Object connectionCache;
            CorbaContactInfo corbaContactInfo = (CorbaContactInfo)contactInfo;
            orb = (ORB)contactInfo.getBroker();
            tp = orb.getTimerManager().points();
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest->: op/" + opName);
            }
            orb.getPIHandler().initiateClientPIRequest(false);
            CorbaConnection connection = null;
            Object object = this.lock;
            synchronized (object) {
                if (contactInfo.isConnectionBased()) {
                    try {
                        tp.enter_connectionSetup();
                        if (contactInfo.shouldCacheConnection()) {
                            connection = (CorbaConnection)orb.getTransportManager().getOutboundConnectionCache(contactInfo).get(contactInfo);
                        }
                        if (connection != null) {
                            if (orb.subcontractDebugFlag) {
                                this.dprint(".beginRequest: op/" + opName + ": Using cached connection: " + connection);
                            }
                        } else {
                            connection = (CorbaConnection)contactInfo.createConnection();
                            if (orb.subcontractDebugFlag) {
                                this.dprint(".beginRequest: op/" + opName + ": Using created connection: " + connection);
                            }
                            if (connection.shouldRegisterReadEvent()) {
                                orb.getTransportManager().getSelector(0).registerForEvent(connection.getEventHandler());
                                connection.setState("ESTABLISHED");
                            }
                            if (contactInfo.shouldCacheConnection()) {
                                OutboundConnectionCache connectionCache2 = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                                connectionCache2.stampTime(connection);
                                connectionCache2.put(contactInfo, connection);
                            }
                        }
                    }
                    finally {
                        tp.exit_connectionSetup();
                    }
                }
            }
            CorbaMessageMediator messageMediator = (CorbaMessageMediator)contactInfo.createMessageMediator(orb, contactInfo, connection, opName, isOneWay);
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": created message mediator: " + messageMediator);
            }
            orb.getInvocationInfo().setMessageMediator(messageMediator);
            if (connection != null && connection.getCodeSetContext() == null) {
                this.performCodeSetNegotiation(messageMediator);
            }
            this.addServiceContexts(messageMediator);
            OutputObject outputObject = contactInfo.createOutputObject(messageMediator);
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": created output object: " + outputObject);
            }
            this.registerWaiter(messageMediator);
            Object object2 = this.lock;
            synchronized (object2) {
                if (contactInfo.isConnectionBased() && contactInfo.shouldCacheConnection()) {
                    connectionCache = orb.getTransportManager().getOutboundConnectionCache(contactInfo);
                    connectionCache.reclaim();
                }
            }
            orb.getPIHandler().setClientPIInfo(messageMediator);
            try {
                orb.getPIHandler().invokeClientPIStartingPoint();
            }
            catch (RemarshalException e) {
                if (orb.subcontractDebugFlag) {
                    this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": Remarshal");
                }
                if (this.getContactInfoListIterator(orb).hasNext()) {
                    contactInfo = (ContactInfo)this.getContactInfoListIterator(orb).next();
                    connectionCache = this.beginRequest(self, opName, isOneWay, contactInfo);
                    if (orb.subcontractDebugFlag) {
                        this.dprint(".beginRequest<-: op/" + opName);
                    }
                    return connectionCache;
                }
                ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
                throw wrapper.remarshalWithNowhereToGo();
            }
            messageMediator.initializeMessage();
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest: " + this.opAndId(messageMediator) + ": initialized message");
            }
            tp.enter_clientEncoding();
            object2 = outputObject;
            return object2;
        }
        finally {
            if (orb.subcontractDebugFlag) {
                this.dprint(".beginRequest<-: op/" + opName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputObject marshalingComplete(Object self, OutputObject outputObject) throws ApplicationException, RemarshalException {
        ORB orb = null;
        TimingPoints tp = null;
        CorbaMessageMediator messageMediator = null;
        try {
            messageMediator = (CorbaMessageMediator)outputObject.getMessageMediator();
            orb = (ORB)messageMediator.getBroker();
            tp = orb.getTimerManager().points();
            tp.exit_clientEncoding();
            tp.enter_clientTransportAndWait();
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete->: " + this.opAndId(messageMediator));
            }
            InputObject inputObject = this.marshalingComplete1(orb, messageMediator);
            InputObject inputObject2 = this.processResponse(orb, messageMediator, inputObject);
            return inputObject2;
        }
        finally {
            tp.exit_clientTransportAndWait();
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete<-: " + this.opAndId(messageMediator));
            }
        }
    }

    public InputObject marshalingComplete1(ORB orb, CorbaMessageMediator messageMediator) throws ApplicationException, RemarshalException {
        try {
            messageMediator.finishSendingRequest();
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete: " + this.opAndId(messageMediator) + ": finished sending request");
            }
            return messageMediator.waitForResponse();
        }
        catch (RuntimeException e) {
            boolean retry;
            if (orb.subcontractDebugFlag) {
                this.dprint(".marshalingComplete: " + this.opAndId(messageMediator) + ": exception: " + e.toString());
            }
            if (retry = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), e)) {
                Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(2, e);
                if (newException == e) {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                } else {
                    this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
                }
            } else {
                throw e;
            }
            return null;
        }
    }

    protected InputObject processResponse(ORB orb, CorbaMessageMediator messageMediator, InputObject inputObject) throws ApplicationException, RemarshalException {
        TimingPoints tp = orb.getTimerManager().points();
        ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        if (orb.subcontractDebugFlag) {
            this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": response received");
        }
        if (messageMediator.getConnection() != null) {
            ((CorbaConnection)messageMediator.getConnection()).setPostInitialContexts();
        }
        Throwable exception = null;
        if (messageMediator.isOneWay()) {
            this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
            exception = orb.getPIHandler().invokeClientPIEndingPoint(0, (Exception)exception);
            this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
            return null;
        }
        this.consumeServiceContexts(orb, messageMediator);
        ((CDRInputObject)inputObject).performORBVersionSpecificInit();
        if (messageMediator.isSystemExceptionReply()) {
            UEInfoServiceContext usc;
            boolean doRemarshal;
            SystemException se = messageMediator.getSystemExceptionReply();
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received system exception: " + (Object)((Object)se));
            }
            if (doRemarshal = this.getContactInfoListIterator(orb).reportException(messageMediator.getContactInfo(), (RuntimeException)((Object)se))) {
                exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
                if (se == exception) {
                    exception = null;
                    this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
                    throw wrapper.statementNotReachable1();
                }
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                throw wrapper.statementNotReachable2();
            }
            ServiceContexts contexts = messageMediator.getReplyServiceContexts();
            if (contexts != null && (usc = (UEInfoServiceContext)contexts.get(9)) != null) {
                Throwable unknown = usc.getUE();
                UnknownException ue = new UnknownException(unknown);
                exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)ue);
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
                throw wrapper.statementNotReachable3();
            }
            exception = orb.getPIHandler().invokeClientPIEndingPoint(2, (Exception)((Object)se));
            this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
            throw wrapper.statementNotReachable4();
        }
        if (messageMediator.isUserExceptionReply()) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received user exception");
            }
            this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
            String exceptionRepoId = this.peekUserExceptionId(inputObject);
            Exception newException = null;
            if (messageMediator.isDIIRequest()) {
                exception = messageMediator.unmarshalDIIUserException(exceptionRepoId, (InputStream)inputObject);
                newException = orb.getPIHandler().invokeClientPIEndingPoint(1, (Exception)exception);
                messageMediator.setDIIException(newException);
            } else {
                ApplicationException appException = new ApplicationException(exceptionRepoId, (org.omg.CORBA.portable.InputStream)inputObject);
                exception = appException;
                newException = orb.getPIHandler().invokeClientPIEndingPoint(1, (Exception)((Object)appException));
            }
            if (newException != exception) {
                this.continueOrThrowSystemOrRemarshal(messageMediator, newException);
            }
            if (newException instanceof ApplicationException) {
                throw (ApplicationException)((Object)newException);
            }
            return inputObject;
        }
        if (messageMediator.isLocationForwardReply()) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received location forward");
            }
            this.getContactInfoListIterator(orb).reportRedirect((CorbaContactInfo)messageMediator.getContactInfo(), messageMediator.getForwardedIOR());
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(3, null);
            if (!(newException instanceof RemarshalException)) {
                exception = newException;
            }
            if (exception != null) {
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
            }
            this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
            throw wrapper.statementNotReachable5();
        }
        if (messageMediator.isDifferentAddrDispositionRequestedReply()) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received different addressing dispostion request");
            }
            this.getContactInfoListIterator(orb).reportAddrDispositionRetry((CorbaContactInfo)messageMediator.getContactInfo(), messageMediator.getAddrDispositionReply());
            Exception newException = orb.getPIHandler().invokeClientPIEndingPoint(5, null);
            if (!(newException instanceof RemarshalException)) {
                exception = newException;
            }
            if (exception != null) {
                this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
            }
            this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)((Object)new RemarshalException()));
            throw wrapper.statementNotReachable6();
        }
        if (orb.subcontractDebugFlag) {
            this.dprint(".processResponse: " + this.opAndId(messageMediator) + ": received normal response");
        }
        this.getContactInfoListIterator(orb).reportSuccess(messageMediator.getContactInfo());
        messageMediator.handleDIIReply((InputStream)inputObject);
        exception = orb.getPIHandler().invokeClientPIEndingPoint(0, null);
        this.continueOrThrowSystemOrRemarshal(messageMediator, (Exception)exception);
        tp.enter_clientDecoding();
        return inputObject;
    }

    protected void continueOrThrowSystemOrRemarshal(CorbaMessageMediator messageMediator, Exception exception) throws SystemException, RemarshalException {
        ORB orb = (ORB)messageMediator.getBroker();
        if (exception != null) {
            if (exception instanceof RemarshalException) {
                orb.getInvocationInfo().setIsRetryInvocation(true);
                this.unregisterWaiter(orb);
                if (orb.subcontractDebugFlag) {
                    this.dprint(".continueOrThrowSystemOrRemarshal: " + this.opAndId(messageMediator) + ": throwing Remarshal");
                }
                throw (RemarshalException)((Object)exception);
            }
            if (orb.subcontractDebugFlag) {
                this.dprint(".continueOrThrowSystemOrRemarshal: " + this.opAndId(messageMediator) + ": throwing sex:" + exception);
            }
            throw (SystemException)((Object)exception);
        }
    }

    protected CorbaContactInfoListIterator getContactInfoListIterator(ORB orb) {
        return (CorbaContactInfoListIterator)((CorbaInvocationInfo)orb.getInvocationInfo()).getContactInfoListIterator();
    }

    protected void registerWaiter(CorbaMessageMediator messageMediator) {
        if (messageMediator.getConnection() != null) {
            messageMediator.getConnection().registerWaiter(messageMediator);
        }
    }

    protected void unregisterWaiter(ORB orb) {
        MessageMediator messageMediator = orb.getInvocationInfo().getMessageMediator();
        if (messageMediator != null && messageMediator.getConnection() != null) {
            messageMediator.getConnection().unregisterWaiter(messageMediator);
        }
    }

    protected void addServiceContexts(CorbaMessageMediator messageMediator) {
        ORB orb = (ORB)messageMediator.getBroker();
        CorbaConnection c = (CorbaConnection)messageMediator.getConnection();
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        ServiceContexts contexts = messageMediator.getRequestServiceContexts();
        if (ORBUtility.getEncodingVersion() != 0) {
            ORBVersionServiceContext ovsc = ServiceContextDefaults.getORBVersionServiceContext();
            contexts.put(ovsc);
            return;
        }
        this.addCodeSetServiceContext(c, contexts, giopVersion);
        contexts.put(ServiceContextDefaults.getMaxStreamFormatVersionServiceContext());
        ORBVersionServiceContext ovsc = ServiceContextDefaults.makeORBVersionServiceContext(ORBVersionFactory.getORBVersion());
        contexts.put(ovsc);
        if (c != null && !c.isPostInitialContexts()) {
            SendingContextServiceContext scsc = ServiceContextDefaults.makeSendingContextServiceContext(orb.getFVDCodeBaseIOR());
            contexts.put(scsc);
        }
    }

    protected void consumeServiceContexts(ORB orb, CorbaMessageMediator messageMediator) {
        ServiceContexts ctxts = messageMediator.getReplyServiceContexts();
        ORBUtilSystemException wrapper = ORBUtilSystemException.get(orb, "rpc.protocol");
        if (ctxts == null) {
            return;
        }
        ServiceContext sc = ctxts.get(6);
        if (sc != null) {
            SendingContextServiceContext scsc = (SendingContextServiceContext)sc;
            IOR ior = scsc.getIOR();
            try {
                if (messageMediator.getConnection() != null) {
                    ((CorbaConnection)messageMediator.getConnection()).setCodeBaseIOR(ior);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                throw wrapper.badStringifiedIor(t);
            }
        }
        if ((sc = ctxts.get(1313165056)) != null) {
            ORBVersionServiceContext ovsc = (ORBVersionServiceContext)sc;
            ORBVersion version = ovsc.getVersion();
            orb.setORBVersion(version);
        }
        this.getExceptionDetailMessage(messageMediator, wrapper);
    }

    protected void getExceptionDetailMessage(CorbaMessageMediator messageMediator, ORBUtilSystemException wrapper) {
        ServiceContext sc = messageMediator.getReplyServiceContexts().get(14);
        if (sc == null) {
            return;
        }
        if (!(sc instanceof UnknownServiceContext)) {
            throw wrapper.badExceptionDetailMessageServiceContextType();
        }
        byte[] data = ((UnknownServiceContext)sc).getData();
        EncapsInputStream in = new EncapsInputStream((org.omg.CORBA.ORB)((Object)((ORB)messageMediator.getBroker())), data, data.length);
        in.consumeEndian();
        String msg = "----------BEGIN server-side stack trace----------\n" + in.read_wstring() + "\n" + "----------END server-side stack trace----------";
        messageMediator.setReplyExceptionDetailMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(Broker broker, Object self, InputObject inputObject) {
        ORB orb = (ORB)broker;
        TimingPoints tp = orb.getTimerManager().points();
        try {
            MessageMediator messageMediator;
            tp.exit_clientDecoding();
            if (orb.subcontractDebugFlag) {
                this.dprint(".endRequest->:");
            }
            if ((messageMediator = orb.getInvocationInfo().getMessageMediator()) != null) {
                OutputObject outputObj;
                InputObject inputObj;
                ORBUtility.popEncVersionFromThreadLocalState();
                if (messageMediator.getConnection() != null) {
                    ((CorbaMessageMediator)messageMediator).sendCancelRequestIfFinalFragmentNotSent();
                }
                if ((inputObj = messageMediator.getInputObject()) != null) {
                    inputObj.close();
                }
                if ((outputObj = messageMediator.getOutputObject()) != null) {
                    outputObj.close();
                }
            }
            this.unregisterWaiter(orb);
            orb.getPIHandler().cleanupClientPIRequest();
        }
        catch (IOException ex) {
            if (orb.subcontractDebugFlag) {
                this.dprint(".endRequest: ignoring IOException - " + ex.toString());
            }
        }
        finally {
            if (orb.subcontractDebugFlag) {
                this.dprint(".endRequest<-:");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performCodeSetNegotiation(CorbaMessageMediator messageMediator) {
        CorbaConnection conn = (CorbaConnection)messageMediator.getConnection();
        IOR ior = ((CorbaContactInfo)messageMediator.getContactInfo()).getEffectiveTargetIOR();
        GIOPVersion giopVersion = messageMediator.getGIOPVersion();
        if (conn != null && conn.getCodeSetContext() == null && !giopVersion.equals(GIOPVersion.V1_0)) {
            CorbaConnection corbaConnection = conn;
            synchronized (corbaConnection) {
                if (conn.getCodeSetContext() != null) {
                    return;
                }
                IIOPProfileTemplate temp = (IIOPProfileTemplate)ior.getProfile().getTaggedProfileTemplate();
                Iterator<TaggedComponent> iter = temp.iteratorById(1);
                if (!iter.hasNext()) {
                    return;
                }
                CodeSetComponentInfo serverCodeSets = ((CodeSetsComponent)iter.next()).getCodeSetComponentInfo();
                CodeSetComponentInfo.CodeSetContext result = CodeSetConversion.impl().negotiate(conn.getBroker().getORBData().getCodeSetComponentInfo(), serverCodeSets);
                conn.setCodeSetContext(result);
            }
        }
    }

    protected void addCodeSetServiceContext(CorbaConnection conn, ServiceContexts ctxs, GIOPVersion giopVersion) {
        if (giopVersion.equals(GIOPVersion.V1_0) || conn == null) {
            return;
        }
        CodeSetComponentInfo.CodeSetContext codeSetCtx = null;
        if (conn.getBroker().getORBData().alwaysSendCodeSetServiceContext() || !conn.isPostInitialContexts()) {
            codeSetCtx = conn.getCodeSetContext();
        }
        if (codeSetCtx == null) {
            return;
        }
        CodeSetServiceContext cssc = ServiceContextDefaults.makeCodeSetServiceContext(codeSetCtx);
        ctxs.put(cssc);
    }

    protected String peekUserExceptionId(InputObject inputObject) {
        CDRInputObject cdrInputObject = (CDRInputObject)inputObject;
        cdrInputObject.mark(Integer.MAX_VALUE);
        String result = cdrInputObject.read_string();
        cdrInputObject.reset();
        return result;
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaClientRequestDispatcherImpl", msg);
    }

    protected String opAndId(CorbaMessageMediator mediator) {
        return ORBUtility.operationNameAndRequestId(mediator);
    }
}

