/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.FilterableSet;
import com.sun.messaging.jmq.util.lists.Limitable;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.PriorityFifoSet;
import com.sun.messaging.jmq.util.lists.PrioritySetEntry;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SetEntry;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class NFLPriorityFifoSet
extends PriorityFifoSet
implements FilterableSet,
EventBroadcaster,
Limitable {
    public static boolean DEBUG;
    Set gni = new HashSet();
    Map filterSets = null;
    Map comparatorSets = null;
    EventBroadcastHelper ebh = new EventBroadcastHelper();
    private boolean enforceLimits = true;
    private int highWaterCnt = 0;
    private long highWaterBytes = 0L;
    private long largestMessageHighWater = 0L;
    private float averageCount = 0.0f;
    private double averageBytes = 0.0;
    private double messageAverage = 0.0;
    private long numberSamples = 0L;
    protected int maxCapacity = -1;
    protected long maxByteCapacity = -1L;
    protected long bytes = 0L;
    protected long maxBytePerObject = -1L;
    protected boolean orderMaintained = true;
    long currentID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NFLPriorityFifoSet() {
        this(10, false);
    }

    public NFLPriorityFifoSet(int n) {
        this(n, false);
    }

    public NFLPriorityFifoSet(int n, boolean bl) {
        super(n);
        this.orderMaintained = bl;
        this.ebh.setOrderMaintained(bl);
        this.setLock(this);
        this.lookup = Collections.synchronizedMap(this.lookup);
    }

    public void enforceLimits(boolean bl) {
        this.enforceLimits = bl;
    }

    public boolean getEnforceLimits() {
        return this.enforceLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cleanupEntry(SetEntry setEntry) {
        Object object = this.lock;
        synchronized (object) {
            return super.cleanupEntry(setEntry);
        }
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
            this.bytes = 0L;
        }
    }

    public boolean add(Object object) {
        return this.add(this.defaultPriority, object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return super.size();
        }
    }

    public void addAllToFront(Collection collection, int n) {
        this.addAllToFront(collection, n, null);
    }

    public boolean isEmpty() {
        return super.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllToFront(Collection collection, int n, Reason reason) {
        Object object;
        if (collection.isEmpty()) {
            return;
        }
        HashSet<Object> hashSet = null;
        boolean bl = false;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            Object object2;
            Iterator iterator2;
            bl = this.isEmpty();
            object = null;
            if (this.priorities[n] == null) {
                iterator2 = collection.iterator();
                while (iterator2.hasNext()) {
                    object2 = iterator2.next();
                    super.add(n, object2);
                    if (object != null) continue;
                    object = (SetEntry)this.lookup.get(object2);
                }
            } else {
                iterator2 = this.priorities[n];
                object2 = collection.iterator();
                while (object2.hasNext()) {
                    Object e = object2.next();
                    if (this.lookup.get(e) != null) {
                        this.remove(e);
                    }
                    SetEntry setEntry = this.createSetEntry(e, n);
                    SetEntry setEntry2 = this.lookup.put(e, setEntry);
                    ((SetEntry)((Object)iterator2)).insertEntryBefore(setEntry);
                    if (object != null) continue;
                    object = setEntry;
                }
                this.priorities[n] = object;
                if (iterator2 == this.head) {
                    this.head = object;
                }
            }
            if (bl != this.isEmpty()) {
                hashSet = new HashSet<Object>();
            }
            if (this.filterSets != null) {
                iterator2 = this.filterSets.values().iterator();
                while (iterator2.hasNext()) {
                    object2 = (FilterSet)iterator2.next();
                    ((FilterSet)object2).addItem(((SetEntry)object).getData(), true);
                    if (hashSet == null) continue;
                    hashSet.add(object2);
                }
                if (this.comparatorSets != null) {
                    // empty if block
                }
            }
        }
        if (hashSet != null) {
            if (this.hasListeners(EventType.EMPTY)) {
                this.notifyChange(EventType.EMPTY, Boolean.TRUE, Boolean.FALSE, reason);
            }
            iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                object = (FilterSet)iterator.next();
                ((FilterSet)object).notifyEmptyChanged(!bl, reason);
            }
        }
    }

    public boolean add(Object object, Reason reason) {
        return this.add(this.defaultPriority, object, reason);
    }

    public boolean add(int n, Object object) {
        return this.add(n, object, null);
    }

    private void preAdd(Object object, Reason reason) {
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, null, object, reason);
        }
        if (object == null) {
            throw new NullPointerException("Unable to support null  values");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotifyInfo internalAdd(int n, Object object) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        NotifyInfo notifyInfo = null;
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        boolean bl = false;
        if (this.maxByteCapacity != -1L && !(object instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when byteCapacity has been set");
        }
        if (this.maxBytePerObject != -1L && !(object instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when maxByteSize has been set");
        }
        if (this.enforceLimits && this.maxCapacity != -1 && this.maxCapacity - this.size() <= 0) {
            throw new OutOfLimitsException(0, new Integer(this.size()), new Integer(this.maxCapacity));
        }
        if (this.enforceLimits && this.maxByteCapacity != -1L && this.maxByteCapacity - this.bytes <= 0L) {
            throw new OutOfLimitsException(1, new Long(this.bytes), new Long(this.maxByteCapacity));
        }
        if (object instanceof Sized) {
            l2 = ((Sized)object).byteSize();
        }
        if (this.maxBytePerObject != -1L && l2 > this.maxBytePerObject) {
            throw new OutOfLimitsException(2, new Long(l2), new Long(this.maxByteCapacity));
        }
        n2 = this.size();
        l = this.bytes;
        bl = super.add(n, object);
        this.bytes += l2;
        this.averageCount = ((float)this.numberSamples * this.averageCount + (float)this.size()) / ((float)this.numberSamples + 1.0f);
        this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)this.bytes) / ((double)this.numberSamples + 1.0);
        this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)l2) / ((double)this.numberSamples + 1.0);
        ++this.numberSamples;
        if (bl) {
            if (this.size() > this.highWaterCnt) {
                this.highWaterCnt = this.size();
            }
            if (l2 > this.largestMessageHighWater) {
                this.largestMessageHighWater = l2;
            }
            if (this.bytes > this.highWaterBytes) {
                this.highWaterBytes = this.bytes;
            }
            if (this.hasListeners() || this.filterSets != null && !this.filterSets.isEmpty() || this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
                notifyInfo = this.getNI();
                notifyInfo.oldsize = n2;
                notifyInfo.oldbytes = l;
                notifyInfo.objsize = l2;
                notifyInfo.newbytes = l + l2;
                notifyInfo.newsize = this.size();
                notifyInfo.curMaxCapacity = this.maxCapacity;
                notifyInfo.curMaxBytesCapacity = this.maxByteCapacity;
                int n3 = 0;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl2;
                    AbstractSet abstractSet;
                    Iterator iterator;
                    if (this.filterSets != null) {
                        iterator = this.filterSets.values().iterator();
                        while (iterator.hasNext()) {
                            abstractSet = (FilterSet)iterator.next();
                            bl2 = ((FilterSet)abstractSet).isEmpty();
                            ((FilterSet)abstractSet).addItem(object);
                            if (bl2 == ((FilterSet)abstractSet).isEmpty()) continue;
                            if (notifyInfo.filters[n3] == null) {
                                notifyInfo.filters[n3] = new EmptyChanged();
                            }
                            notifyInfo.filters[n3].f = abstractSet;
                            notifyInfo.filters[n3].isEmpty = !bl2;
                            ++n3;
                        }
                    }
                    if (this.comparatorSets != null) {
                        iterator = this.comparatorSets.values().iterator();
                        while (iterator.hasNext()) {
                            abstractSet = (ComparatorSet)iterator.next();
                            bl2 = ((TreeSet)abstractSet).isEmpty();
                            ((ComparatorSet)abstractSet).addItem(object);
                            if (bl2 == ((TreeSet)abstractSet).isEmpty()) continue;
                            if (notifyInfo.filters[n3] == null) {
                                notifyInfo.filters[n3] = new EmptyChanged();
                            }
                            notifyInfo.filters[n3].f = abstractSet;
                            notifyInfo.filters[n3].isEmpty = !bl2;
                            ++n3;
                        }
                    }
                }
                if (n3 < notifyInfo.filters.length && notifyInfo.filters[n3] != null) {
                    notifyInfo.filters[n3].f = null;
                }
            }
        }
        return notifyInfo;
    }

    private void postAdd(Object object, NotifyInfo notifyInfo, Reason reason) {
        if (this.hasListeners(EventType.SIZE_CHANGED) && notifyInfo.oldsize != notifyInfo.newsize) {
            this.notifyChange(EventType.SIZE_CHANGED, new Integer(notifyInfo.oldsize), new Integer(notifyInfo.newsize), reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && notifyInfo.oldbytes != notifyInfo.newbytes) {
            this.notifyChange(EventType.BYTES_CHANGED, new Long(notifyInfo.oldbytes), new Long(notifyInfo.newbytes), reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            this.notifyChange(EventType.SET_CHANGED, null, object, reason);
        }
        if (notifyInfo.oldsize == 0 && notifyInfo.newsize != 0 && this.hasListeners(EventType.EMPTY)) {
            this.notifyChange(EventType.EMPTY, Boolean.TRUE, Boolean.FALSE, reason);
        }
        boolean bl = false;
        long l = 0L;
        if (this.hasListeners(EventType.FULL) && notifyInfo.curMaxBytesCapacity != -1L && notifyInfo.curMaxBytesCapacity - notifyInfo.newbytes <= 0L || (long)notifyInfo.curMaxCapacity != -1L && notifyInfo.curMaxCapacity - notifyInfo.newsize <= 0) {
            this.notifyChange(EventType.FULL, Boolean.FALSE, Boolean.TRUE, reason);
        }
        for (int i = 0; i < notifyInfo.filters.length && notifyInfo.filters[i] != null && notifyInfo.filters[i].f != null; ++i) {
            SubSet subSet = notifyInfo.filters[i].f;
            if (subSet instanceof FilterSet) {
                ((FilterSet)subSet).notifyEmptyChanged(notifyInfo.filters[i].isEmpty, reason);
                continue;
            }
            if (!$assertionsDisabled && !(subSet instanceof ComparatorSet)) {
                throw new AssertionError();
            }
            ((ComparatorSet)subSet).notifyEmptyChanged(notifyInfo.filters[i].isEmpty, reason);
        }
        this.putNI(notifyInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int n, Object object, Reason reason) {
        NotifyInfo notifyInfo = null;
        this.preAdd(object, reason);
        Object object2 = this.lock;
        synchronized (object2) {
            notifyInfo = this.internalAdd(n, object);
        }
        if (notifyInfo != null) {
            this.postAdd(object, notifyInfo, reason);
        }
        return notifyInfo != null;
    }

    public boolean removeAll(Collection collection, Reason reason) {
        boolean bl = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.remove(iterator.next(), reason);
        }
        return bl;
    }

    public boolean remove(Object object) {
        return this.remove(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotifyInfo getNI() {
        NotifyInfo notifyInfo = null;
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            int n;
            if (this.gni.isEmpty()) {
                notifyInfo = new NotifyInfo();
            } else {
                Iterator iterator = this.gni.iterator();
                notifyInfo = (NotifyInfo)iterator.next();
                iterator.remove();
            }
            int n2 = n = this.filterSets == null ? 0 : this.filterSets.size();
            if (notifyInfo.filters == null || notifyInfo.filters.length < n) {
                notifyInfo.filters = new EmptyChanged[n];
            }
        }
        return notifyInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putNI(NotifyInfo notifyInfo) {
        if (notifyInfo == null) {
            return;
        }
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            this.gni.add(notifyInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotifyInfo internalRemove(Object object, Reason reason, Iterator iterator, boolean bl) {
        Object object2 = this.lock;
        synchronized (object2) {
            boolean bl2;
            AbstractSet abstractSet;
            Iterator iterator2;
            nSetEntry nSetEntry2;
            if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
                throw new AssertionError();
            }
            long l = 0L;
            int n = this.size();
            long l2 = this.bytes;
            if (object instanceof Sized) {
                l = ((Sized)object).byteSize();
            }
            if ((nSetEntry2 = (nSetEntry)this.lookup.get(object)) == null) {
                return null;
            }
            boolean bl3 = true;
            if (iterator != null) {
                iterator.remove();
            } else {
                if (!$assertionsDisabled && !Thread.holdsLock(this.lock)) {
                    throw new AssertionError();
                }
                bl3 = super.remove(object);
            }
            if (!bl3) {
                return null;
            }
            if (!(this.hasListeners() || this.filterSets != null && !this.filterSets.isEmpty() || this.comparatorSets != null && !this.comparatorSets.isEmpty())) {
                return null;
            }
            NotifyInfo notifyInfo = this.getNI();
            notifyInfo.oldbytes = l2;
            notifyInfo.oldsize = n;
            notifyInfo.objsize = l;
            notifyInfo.newsize = this.size();
            notifyInfo.newbytes = this.bytes;
            notifyInfo.curMaxCapacity = this.maxCapacity;
            notifyInfo.curMaxBytesCapacity = this.maxByteCapacity;
            int n2 = 0;
            if (this.filterSets != null) {
                iterator2 = this.filterSets.values().iterator();
                while (iterator2.hasNext()) {
                    abstractSet = (FilterSet)iterator2.next();
                    bl2 = ((FilterSet)abstractSet).isEmpty();
                    ((FilterSet)abstractSet).removeItem(object);
                    if (bl2 == ((FilterSet)abstractSet).isEmpty()) continue;
                    if (notifyInfo.filters[n2] == null) {
                        notifyInfo.filters[n2] = new EmptyChanged();
                    }
                    notifyInfo.filters[n2].f = abstractSet;
                    notifyInfo.filters[n2].isEmpty = bl2;
                    ++n2;
                }
            }
            if (this.comparatorSets != null) {
                iterator2 = this.comparatorSets.values().iterator();
                while (iterator2.hasNext()) {
                    abstractSet = (ComparatorSet)iterator2.next();
                    bl2 = ((TreeSet)abstractSet).isEmpty();
                    ((ComparatorSet)abstractSet).removeItem(object);
                    if (bl2 == ((TreeSet)abstractSet).isEmpty()) continue;
                    if (notifyInfo.filters[n2] == null) {
                        notifyInfo.filters[n2] = new EmptyChanged();
                    }
                    notifyInfo.filters[n2].f = abstractSet;
                    notifyInfo.filters[n2].isEmpty = !bl2;
                    ++n2;
                }
            }
            if (n2 < notifyInfo.filters.length && notifyInfo.filters[n2] != null) {
                notifyInfo.filters[n2].f = null;
            }
            if (iterator == null && nSetEntry2 != null) {
                nSetEntry2.clear();
            }
            return notifyInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object object, Reason reason) {
        if (object == null) {
            return false;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!this.contains(object)) {
                return false;
            }
        }
        this.preRemoveNotify(object, reason);
        object2 = this.internalRemove(object, reason, null, this.hasListeners());
        if (object2 != null) {
            this.postRemoveNotify(object, (NotifyInfo)object2, reason);
        }
        Object object3 = this.lock;
        synchronized (object3) {
            return !this.contains(object);
        }
    }

    public Object removeNext() {
        return this.removeNext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeNext(Reason reason) {
        Object object = null;
        NotifyInfo notifyInfo = null;
        Object object2 = this.lock;
        synchronized (object2) {
            object = this.first();
            if (object == null) {
                return null;
            }
            notifyInfo = this.internalRemove(object, reason, null, this.hasListeners());
        }
        this.preRemoveNotify(object, reason);
        if (notifyInfo != null) {
            this.postRemoveNotify(object, notifyInfo, reason);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        Object object = this.lock;
        synchronized (object) {
            return new wrapIterator(super.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubSet subSet(Filter filter) {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = new Object();
            FilterSet filterSet = new FilterSet(object2, filter);
            if (this.filterSets == null) {
                this.filterSets = new WeakValueHashMap("FilterSet");
            }
            this.filterSets.put(object2, filterSet);
            return filterSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SubSet subSet(Comparator comparator) {
        Object object = this.lock;
        synchronized (object) {
            Object object2 = new Object();
            ComparatorSet comparatorSet = new ComparatorSet(object2, comparator);
            if (this.comparatorSets == null) {
                this.comparatorSets = new WeakValueHashMap("ComparatorSet");
            }
            this.comparatorSets.put(object2, comparatorSet);
            return comparatorSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getAll(Filter filter) {
        Object object = this.lock;
        synchronized (object) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (filter != null && !filter.matches(e)) continue;
                linkedHashSet.add(e);
            }
            return linkedHashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyFilterSet(Object object) {
        if (!$assertionsDisabled && this.filterSets == null) {
            throw new AssertionError();
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.filterSets != null) {
                this.filterSets.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyComparatorSet(Object object) {
        if (!$assertionsDisabled && this.comparatorSets == null) {
            throw new AssertionError();
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (this.comparatorSets != null) {
                this.comparatorSets.remove(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.ebh.clear();
        super.clear();
        Object object = this.lock;
        synchronized (object) {
            if (this.filterSets != null) {
                this.filterSets.clear();
            }
            if (this.comparatorSets != null) {
                this.comparatorSets.clear();
            }
        }
        this.gni.clear();
    }

    protected SetEntry createSetEntry(Object object, int n) {
        return new nSetEntry(object, n);
    }

    public synchronized String toDebugString() {
        AbstractSet abstractSet;
        Iterator iterator;
        String string = "NFLPriorityFifoSet: \n";
        if (this.filterSets != null) {
            string = string + "\tfilterSets: " + this.filterSets.size() + "\n";
            iterator = this.filterSets.values().iterator();
            while (iterator.hasNext()) {
                abstractSet = (FilterSet)iterator.next();
                string = string + "\t\tFilterSet " + abstractSet.hashCode() + " filter[" + ((FilterSet)abstractSet).f + "]\n";
            }
        }
        if (this.comparatorSets != null) {
            string = string + "\tComparatorSets: " + this.comparatorSets.size() + "\n";
            iterator = this.comparatorSets.values().iterator();
            while (iterator.hasNext()) {
                abstractSet = (ComparatorSet)iterator.next();
                string = string + "\t\tComparatorSet " + abstractSet.hashCode() + " filter[" + ((TreeSet)abstractSet).comparator() + "]\n";
            }
        }
        string = string + "\n\nSUBCLASS INFO\n";
        string = string + super.toDebugString();
        return string;
    }

    protected void preRemoveNotify(Object object, Reason reason) {
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, object, null, reason);
        }
    }

    protected void postRemoveNotify(Object object, NotifyInfo notifyInfo, Reason reason) {
        if (!this.hasListeners()) {
            return;
        }
        if (notifyInfo.oldsize != notifyInfo.newsize && this.hasListeners(EventType.SIZE_CHANGED)) {
            this.notifyChange(EventType.SIZE_CHANGED, new Integer(notifyInfo.oldsize), new Integer(notifyInfo.newsize), reason);
        }
        if (notifyInfo.newbytes != notifyInfo.oldbytes && this.hasListeners(EventType.BYTES_CHANGED)) {
            this.notifyChange(EventType.BYTES_CHANGED, new Long(notifyInfo.oldbytes), new Long(notifyInfo.newbytes), reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            this.notifyChange(EventType.SET_CHANGED, object, null, reason);
        }
        if (notifyInfo.oldsize != 0 && notifyInfo.newsize == 0 && this.hasListeners(EventType.EMPTY)) {
            this.notifyChange(EventType.EMPTY, Boolean.FALSE, Boolean.TRUE, reason);
        }
        if (this.hasListeners(EventType.FULL) && notifyInfo.curMaxBytesCapacity != -1L && notifyInfo.curMaxBytesCapacity - notifyInfo.oldbytes <= 0L && notifyInfo.curMaxBytesCapacity - notifyInfo.newbytes > 0L || notifyInfo.curMaxCapacity != -1 && notifyInfo.curMaxCapacity - notifyInfo.oldsize <= 0 && notifyInfo.curMaxCapacity - notifyInfo.newsize > 0) {
            this.notifyChange(EventType.FULL, Boolean.TRUE, Boolean.FALSE, reason);
        }
        for (int i = 0; i < notifyInfo.filters.length && notifyInfo.filters[i] != null && notifyInfo.filters[i].f != null; ++i) {
            SubSet subSet = notifyInfo.filters[i].f;
            if (subSet instanceof FilterSet) {
                ((FilterSet)subSet).notifyEmptyChanged(notifyInfo.filters[i].isEmpty, reason);
                continue;
            }
            if (!$assertionsDisabled && !(subSet instanceof ComparatorSet)) {
                throw new AssertionError();
            }
            ((ComparatorSet)subSet).notifyEmptyChanged(notifyInfo.filters[i].isEmpty, reason);
        }
        this.putNI(notifyInfo);
    }

    public int highWaterCount() {
        return this.highWaterCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long highWaterBytes() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.highWaterBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long highWaterLargestMessageBytes() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.largestMessageHighWater;
        }
    }

    public float averageCount() {
        return this.averageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double averageBytes() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.averageBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double averageMessageBytes() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.messageAverage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxByteSize(long l) {
        if (l < -1L) {
            l = -1L;
        }
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            this.maxBytePerObject = l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long maxByteSize() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.maxBytePerObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int n) {
        if (n < -1) {
            n = -1;
        }
        boolean bl = false;
        boolean bl2 = false;
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            bl = !this.isFull() && n != -1 && n <= this.size();
            bl2 = this.isFull() && (n == -1 || n > this.size());
            this.maxCapacity = n;
        }
        if (bl) {
            this.notifyChange(EventType.FULL, Boolean.FALSE, Boolean.TRUE, null);
        } else if (bl2) {
            this.notifyChange(EventType.FULL, Boolean.TRUE, Boolean.FALSE, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setByteCapacity(long l) {
        boolean bl = false;
        boolean bl2 = false;
        if (l < -1L) {
            l = -1L;
        }
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            bl = !this.isFull() && l != -1L && l <= this.byteSize();
            bl2 = this.isFull() && (l == -1L || l > this.byteSize());
            this.maxByteCapacity = l;
        }
        if (bl) {
            this.notifyChange(EventType.FULL, Boolean.FALSE, Boolean.TRUE, null);
        } else if (bl2) {
            this.notifyChange(EventType.FULL, Boolean.TRUE, Boolean.FALSE, null);
        }
    }

    public int capacity() {
        return this.maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long byteCapacity() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.maxByteCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFull() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.freeSpace() == 0 || this.freeBytes() == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int freeSpace() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            if (this.maxCapacity == -1) {
                return -1;
            }
            int n = this.maxCapacity - this.size();
            if (n < 0) {
                return 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long freeBytes() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            if (this.maxByteCapacity == -1L) {
                return -1L;
            }
            long l = this.maxByteCapacity - this.bytes;
            if (l < 0L) {
                return 0L;
            }
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long byteSize() {
        NFLPriorityFifoSet nFLPriorityFifoSet = this;
        synchronized (nFLPriorityFifoSet) {
            return this.bytes;
        }
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Object object) {
        return this.ebh.addEventListener(eventListener, eventType, object);
    }

    public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) {
        return this.ebh.addEventListener(eventListener, eventType, reason, object);
    }

    public Object removeEventListener(Object object) {
        return this.ebh.removeEventListener(object);
    }

    protected boolean hasListeners(EventType eventType) {
        return this.ebh.hasListeners(eventType);
    }

    protected boolean hasListeners() {
        return this.ebh.hasListeners();
    }

    protected void notifyChange(EventType eventType, Object object, Object object2, Reason reason) {
        if (!this.hasListeners()) {
            return;
        }
        this.ebh.notifyChange(eventType, reason, this, object, object2);
    }

    public void sort(Comparator comparator) {
        super.sort(comparator);
        if (this.filterSets != null) {
            Iterator iterator = this.filterSets.values().iterator();
            while (iterator.hasNext()) {
                FilterSet filterSet = (FilterSet)iterator.next();
                filterSet.resetFilterSet((nSetEntry)this.head);
            }
        }
    }

    static {
        $assertionsDisabled = !NFLPriorityFifoSet.class.desiredAssertionStatus();
        DEBUG = false;
    }

    class nSetEntry
    extends PrioritySetEntry {
        long uid;
        static final /* synthetic */ boolean $assertionsDisabled;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public nSetEntry(Object object, int n) {
            super(object, n);
            this.uid = 0L;
            Object object2 = NFLPriorityFifoSet.this.lock;
            synchronized (object2) {
                this.uid = NFLPriorityFifoSet.this.currentID++;
            }
        }

        public long getUID() {
            return this.uid;
        }

        public boolean remove() {
            if (!$assertionsDisabled && !Thread.holdsLock(NFLPriorityFifoSet.this.lock)) {
                throw new AssertionError();
            }
            Object object = this.getData();
            if (!$assertionsDisabled && !this.isValid()) {
                throw new AssertionError();
            }
            this.valid = false;
            boolean bl = super.remove();
            if (object instanceof Sized) {
                long l = ((Sized)object).byteSize();
                NFLPriorityFifoSet.this.bytes -= l;
            }
            NFLPriorityFifoSet.this.averageCount = ((float)NFLPriorityFifoSet.this.numberSamples * NFLPriorityFifoSet.this.averageCount + (float)NFLPriorityFifoSet.this.size()) / ((float)NFLPriorityFifoSet.this.numberSamples + 1.0f);
            NFLPriorityFifoSet.this.averageBytes = ((double)NFLPriorityFifoSet.this.numberSamples * NFLPriorityFifoSet.this.averageBytes + (double)NFLPriorityFifoSet.this.bytes) / ((double)NFLPriorityFifoSet.this.numberSamples + 1.0);
            NFLPriorityFifoSet.this.numberSamples++;
            return bl;
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$util$lists$NFLPriorityFifoSet == null ? (class$com$sun$messaging$jmq$util$lists$NFLPriorityFifoSet = NFLPriorityFifoSet.class$("com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet")) : class$com$sun$messaging$jmq$util$lists$NFLPriorityFifoSet).desiredAssertionStatus();
        }
    }

    class wrapIterator
    implements Iterator {
        Iterator parentIterator;
        Object next = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public wrapIterator(Iterator iterator) {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.parentIterator = iterator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasNext() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                return this.parentIterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.next = this.parentIterator.next();
                return this.next;
            }
        }

        public void remove() {
            NFLPriorityFifoSet.this.preRemoveNotify(this.next, null);
            NotifyInfo notifyInfo = NFLPriorityFifoSet.this.internalRemove(this.next, null, this.parentIterator, NFLPriorityFifoSet.this.hasListeners());
            if (notifyInfo != null) {
                NFLPriorityFifoSet.this.postRemoveNotify(this.next, notifyInfo, null);
            }
            this.next = null;
        }
    }

    class EmptyChanged {
        SubSet f;
        boolean isEmpty = false;

        EmptyChanged() {
        }
    }

    class NotifyInfo {
        long oldbytes = 0L;
        long newbytes = 0L;
        int oldsize = 0;
        int newsize = 0;
        long objsize = 0L;
        int curMaxCapacity = 0;
        long curMaxBytesCapacity = 0L;
        EmptyChanged[] filters = new EmptyChanged[0];
    }

    class FilterSet
    extends AbstractSet
    implements SubSet,
    Prioritized {
        EventBroadcastHelper ebh = new EventBroadcastHelper();
        Object uid;
        Filter f = null;
        long[] lastMatchedIds = new long[NFLPriorityFifoSet.this.getLevels()];
        int currentPriority;
        nSetEntry nextEntry = null;
        nSetEntry currentEntry = null;
        static final /* synthetic */ boolean $assertionsDisabled;

        public String toString() {
            return "FilterSet[" + this.f + "]" + super.toString();
        }

        public void resetFilterSet(nSetEntry nSetEntry2) {
            this.nextEntry = nSetEntry2;
            this.currentEntry = null;
            this.lastMatchedIds = new long[NFLPriorityFifoSet.this.getLevels()];
        }

        public String toDebugString() {
            String string = "FilterSet[" + this.f + "]\n";
            string = string + "\tDumping FilterSet\n";
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                string = string + "\t\t" + iterator.next() + "\n";
            }
            string = string + "\tcurrentPriority " + this.currentPriority + "\n";
            string = string + "\tnextEntry " + this.nextEntry + "\n";
            string = string + "\tcurrentEntry " + this.currentEntry + "\n";
            string = string + NFLPriorityFifoSet.this.toDebugString();
            return string;
        }

        public void addAllToFront(Collection collection, int n) {
            NFLPriorityFifoSet.this.addAllToFront(collection, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FilterSet(Object object, Filter filter) {
            this.ebh.setOrderMaintained(NFLPriorityFifoSet.this.orderMaintained);
            Object object2 = NFLPriorityFifoSet.this.lock;
            synchronized (object2) {
                this.uid = object;
                this.f = filter;
                this.nextEntry = (nSetEntry)(NFLPriorityFifoSet.this.start == null ? NFLPriorityFifoSet.this.head : NFLPriorityFifoSet.this.start);
            }
        }

        public Object getUID() {
            return this.uid;
        }

        private boolean skipToNext() {
            nSetEntry nSetEntry2;
            if (!$assertionsDisabled && !Thread.holdsLock(NFLPriorityFifoSet.this.lock)) {
                throw new AssertionError();
            }
            if (this.currentEntry != null) {
                if (!this.currentEntry.isValid()) {
                    this.nextEntry = (nSetEntry)this.currentEntry.getNext();
                    this.currentEntry = null;
                } else {
                    return true;
                }
            }
            if (this.nextEntry == null) {
                return false;
            }
            for (nSetEntry2 = this.nextEntry; nSetEntry2 != null && !nSetEntry2.isValid(); nSetEntry2 = (nSetEntry)nSetEntry2.getNext()) {
            }
            while (!(nSetEntry2 == null || this.f == null || nSetEntry2.getUID() > this.lastMatchedIds[nSetEntry2.getPriority()] && this.f.matches(nSetEntry2.getData()))) {
                if (nSetEntry2.getUID() > this.lastMatchedIds[nSetEntry2.getPriority()]) {
                    this.lastMatchedIds[nSetEntry2.getPriority()] = nSetEntry2.getUID();
                }
                this.currentPriority = nSetEntry2.getPriority();
                nSetEntry2 = (nSetEntry)nSetEntry2.getNext();
            }
            this.currentEntry = nSetEntry2;
            this.nextEntry = null;
            if (this.currentEntry != null) {
                this.currentPriority = this.currentEntry.getPriority();
            }
            return true;
        }

        void removeItem(Object object) {
            if (!$assertionsDisabled && !Thread.holdsLock(NFLPriorityFifoSet.this.lock)) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && object == null) {
                throw new AssertionError();
            }
            if (this.nextEntry != null && this.nextEntry.getData() == object) {
                this.nextEntry = (nSetEntry)this.nextEntry.getNext();
            }
            if (this.currentEntry != null && this.currentEntry.getData() == object) {
                this.nextEntry = (nSetEntry)this.currentEntry.getNext();
                this.currentEntry = null;
            }
        }

        void addItem(Object object) {
            if (!$assertionsDisabled && !Thread.holdsLock(NFLPriorityFifoSet.this.lock)) {
                throw new AssertionError();
            }
            nSetEntry nSetEntry2 = (nSetEntry)NFLPriorityFifoSet.this.lookup.get(object);
            if (this.currentEntry == null && this.nextEntry == null) {
                this.nextEntry = nSetEntry2;
                this.currentPriority = nSetEntry2.priority;
            } else if (nSetEntry2.getPriority() == this.currentPriority && (this.currentEntry != null && !this.currentEntry.isValid() || this.currentEntry != null && !this.currentEntry.isValid())) {
                this.nextEntry = nSetEntry2;
                this.currentEntry = null;
            } else if (nSetEntry2.getPriority() < this.currentPriority) {
                this.currentPriority = nSetEntry2.getPriority();
                this.nextEntry = nSetEntry2;
                this.currentEntry = null;
            }
        }

        void addItem(Object object, boolean bl) {
            if (!$assertionsDisabled && NFLPriorityFifoSet.this.lock != null && !Thread.holdsLock(NFLPriorityFifoSet.this.lock)) {
                throw new AssertionError();
            }
            nSetEntry nSetEntry2 = (nSetEntry)NFLPriorityFifoSet.this.lookup.get(object);
            if (bl) {
                this.nextEntry = nSetEntry2;
                this.currentEntry = null;
                this.currentPriority = 0;
            } else {
                this.addItem(object);
            }
        }

        public boolean add(Object object) {
            return this.add(object, null);
        }

        public boolean add(int n, Object object) {
            return this.add(n, object, null);
        }

        public boolean add(Object object, Reason reason) {
            if (this.f != null && !this.f.matches(object)) {
                throw new IllegalArgumentException("not part of set");
            }
            return NFLPriorityFifoSet.this.add(object, reason);
        }

        public boolean add(int n, Object object, Reason reason) {
            if (this.f != null && !this.f.matches(object)) {
                throw new IllegalArgumentException("not part of set");
            }
            return NFLPriorityFifoSet.this.add(n, object, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            HashSet hashSet = new HashSet();
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    hashSet.add(iterator.next());
                }
            }
            this.removeAll((Collection)hashSet);
        }

        public boolean remove(Object object) {
            return this.remove(object, null);
        }

        public boolean remove(Object object, Reason reason) {
            if (this.f != null && !this.f.matches(object)) {
                return false;
            }
            return NFLPriorityFifoSet.this.remove(object, reason);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(Object object) {
            Object object2 = NFLPriorityFifoSet.this.lock;
            synchronized (object2) {
                nSetEntry nSetEntry2 = (nSetEntry)NFLPriorityFifoSet.this.lookup.get(object);
                if (nSetEntry2 == null) {
                    return false;
                }
                if (this.f == null) {
                    return true;
                }
                long l = this.lastMatchedIds[nSetEntry2.getPriority()];
                if (nSetEntry2.getUID() < l) {
                    return false;
                }
                if (nSetEntry2.getUID() == l) {
                    return this.f.matches(object);
                }
                return this.f.matches(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int size() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                int n = 0;
                Iterator iterator = this.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++n;
                }
                return n;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retainAll(Collection collection) {
            HashSet hashSet = new HashSet();
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                Iterator iterator = NFLPriorityFifoSet.this.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (collection.contains(e)) continue;
                    hashSet.add(e);
                }
            }
            return NFLPriorityFifoSet.this.removeAll(hashSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isEmpty() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                boolean bl = !this.skipToNext();
                return bl;
            }
        }

        public boolean removeAll(Collection collection) {
            return NFLPriorityFifoSet.this.removeAll(collection);
        }

        public void destroy() {
            NFLPriorityFifoSet.this.destroyFilterSet(this.uid);
        }

        public Iterator iterator() {
            return new filterIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeNext() {
            Object object = null;
            NotifyInfo notifyInfo = null;
            Object object2 = NFLPriorityFifoSet.this.lock;
            synchronized (object2) {
                if (!this.skipToNext()) {
                    return null;
                }
                if (this.currentEntry == null) {
                    return null;
                }
                this.lastMatchedIds[this.currentEntry.getPriority()] = this.currentEntry.getUID();
                object = this.currentEntry.getData();
                this.nextEntry = (nSetEntry)this.currentEntry.getNext();
                this.currentEntry = null;
                notifyInfo = NFLPriorityFifoSet.this.internalRemove(object, null, null, NFLPriorityFifoSet.this.hasListeners());
            }
            NFLPriorityFifoSet.this.preRemoveNotify(object, null);
            if (notifyInfo != null) {
                NFLPriorityFifoSet.this.postRemoveNotify(object, notifyInfo, null);
            }
            if (DEBUG && this.f == null && this.currentEntry == null && this.nextEntry == null && NFLPriorityFifoSet.this.lookup.size() != 0) {
                System.err.println("CORRUPTION");
                System.err.println(this.toDebugString());
            }
            return object;
        }

        public Object addEventListener(EventListener eventListener, EventType eventType, Object object) throws UnsupportedOperationException {
            if (eventType != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + eventType + " not supported");
            }
            return this.ebh.addEventListener(eventListener, eventType, object);
        }

        public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) throws UnsupportedOperationException {
            if (eventType != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + eventType + " not supported");
            }
            return this.ebh.addEventListener(eventListener, eventType, reason, object);
        }

        public Object removeEventListener(Object object) {
            return this.ebh.removeEventListener(object);
        }

        public void notifyEmptyChanged(boolean bl, Reason reason) {
            if (this.ebh.hasListeners(EventType.EMPTY)) {
                this.ebh.notifyChange(EventType.EMPTY, reason, this, bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.FALSE : Boolean.TRUE);
            }
        }

        static {
            $assertionsDisabled = !(class$com$sun$messaging$jmq$util$lists$NFLPriorityFifoSet == null ? (class$com$sun$messaging$jmq$util$lists$NFLPriorityFifoSet = NFLPriorityFifoSet.class$("com.sun.messaging.jmq.util.lists.NFLPriorityFifoSet")) : class$com$sun$messaging$jmq$util$lists$NFLPriorityFifoSet).desiredAssertionStatus();
        }

        class filterIterator
        implements Iterator {
            nSetEntry current = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public filterIterator() {
                Object object = ((FilterSet)FilterSet.this).NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    this.current = FilterSet.this.currentEntry;
                    if (this.current == null) {
                        this.current = FilterSet.this.nextEntry;
                        this.findNext();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void findNext() {
                Object object = ((FilterSet)FilterSet.this).NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    while (this.current != null && (this.current == null || !this.current.isValid() || FilterSet.this.f != null && !FilterSet.this.f.matches(this.current.getData()))) {
                        this.current = (nSetEntry)this.current.getNext();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean hasNext() {
                Object object = ((FilterSet)FilterSet.this).NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    return this.current != null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object next() {
                Object object = ((FilterSet)FilterSet.this).NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    Object object2 = this.current.getData();
                    this.current = (nSetEntry)this.current.getNext();
                    this.findNext();
                    return object2;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException("remove is not supported on this iterator");
            }
        }
    }

    class ComparatorSet
    extends TreeSet
    implements SubSet {
        EventBroadcastHelper ebh;
        Object uid;

        public ComparatorSet(Object object, Comparator comparator) {
            super(comparator);
            this.ebh = new EventBroadcastHelper();
            this.uid = object;
        }

        public String toDebugString() {
            return "ComparatorSet [" + this.comparator() + "]" + NFLPriorityFifoSet.this.toDebugString();
        }

        public void destroy() {
            NFLPriorityFifoSet.this.destroyComparatorSet(this.uid);
        }

        void addItem(Object object) {
            super.add(object);
        }

        void removeItem(Object object) {
            super.remove(object);
        }

        public boolean add(Object object) {
            return this.add(object, null);
        }

        public boolean add(Object object, Reason reason) {
            boolean bl = super.add(object);
            NFLPriorityFifoSet.this.add(object, reason);
            return bl;
        }

        public boolean remove(Object object) {
            return this.remove(object, null);
        }

        public boolean remove(Object object, Reason reason) {
            boolean bl = super.remove(object);
            NFLPriorityFifoSet.this.remove(object, reason);
            return bl;
        }

        public Object removeNext() {
            boolean bl = false;
            Object var2_2 = null;
            var2_2 = this.first();
            if (var2_2 != null) {
                NFLPriorityFifoSet.this.remove(var2_2);
            }
            return var2_2;
        }

        public Object getUID() {
            return this.uid;
        }

        public Object addEventListener(EventListener eventListener, EventType eventType, Object object) throws UnsupportedOperationException {
            if (eventType != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + eventType + " not supported");
            }
            return this.ebh.addEventListener(eventListener, eventType, object);
        }

        public Object addEventListener(EventListener eventListener, EventType eventType, Reason reason, Object object) throws UnsupportedOperationException {
            if (eventType != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + eventType + " not supported");
            }
            return this.ebh.addEventListener(eventListener, eventType, reason, object);
        }

        public Object removeEventListener(Object object) {
            return this.ebh.removeEventListener(object);
        }

        public void notifyEmptyChanged(boolean bl, Reason reason) {
            if (this.ebh.hasListeners(EventType.EMPTY)) {
                this.ebh.notifyChange(EventType.EMPTY, reason, this, bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.FALSE : Boolean.TRUE);
            }
        }
    }
}

