/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.cli.framework;

import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandFactory;
import com.sun.enterprise.cli.framework.CommandLineParser;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandValidator;
import com.sun.enterprise.cli.framework.HelpException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.ValidCommand;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;

public class CLIMain {
    private static final String HelpCommandAndOptions = "help|--help|-[?]";
    private static final String VERSION_OPTION = "-V";
    private static final String VERSION_COMMAND = "version";

    public static void invokeCLI(String cmdline, InputsAndOutputs io) throws CommandException, CommandValidationException {
        InputsAndOutputs.setInstance(io);
        String[] args = CLIMain.splitStringToArray(cmdline);
        CLIMain.invokeCommand(args);
    }

    public static void main(String[] args) {
        long startTime = 0L;
        boolean time = false;
        if (System.getProperty("com.sun.appserv.cli.timing") != null) {
            time = true;
            startTime = System.currentTimeMillis();
        }
        try {
            CLIMain.invokeCommand(args);
            if (time) {
                CLILogger.getInstance().printDebugMessage("Command execution time: " + (System.currentTimeMillis() - startTime) + " ms");
            }
            System.exit(0);
        }
        catch (CommandValidationException cve) {
            CLILogger.getInstance().printExceptionStackTrace(cve);
            CLILogger.getInstance().printError(cve.getLocalizedMessage());
            System.exit(1);
        }
        catch (CommandException ce) {
            CLILogger.getInstance().printExceptionStackTrace(ce);
            CLILogger.getInstance().printError(ce.getLocalizedMessage());
            System.exit(1);
        }
        catch (Throwable ex) {
            CLILogger.getInstance().printExceptionStackTrace(ex);
            CLILogger.getInstance().printError(ex.getLocalizedMessage());
            System.exit(1);
        }
    }

    public static void invokeCommand(String[] args) throws CommandException, CommandValidationException {
        ValidCommand validCommand = null;
        try {
            CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
            if (args.length < 1) {
                cliDescriptorsReader.setSerializeDescriptorsProperty(CLIDescriptorsReader.DONT_SERIALIZE);
                validCommand = cliDescriptorsReader.getCommand(null);
                args = new String[]{cliDescriptorsReader.getDefaultCommand()};
            } else {
                if (args[0].equals(VERSION_OPTION)) {
                    args[0] = VERSION_COMMAND;
                }
                cliDescriptorsReader.setSerializeDescriptorsProperty(CLIDescriptorsReader.SERIALIZE_COMMANDS_TO_FILES);
                validCommand = cliDescriptorsReader.getCommand(args[0]);
            }
            CLIMain.setCommandLocalizedProperty(cliDescriptorsReader.getProperties());
            if (args[0].matches(HelpCommandAndOptions)) {
                throw new HelpException(args);
            }
            CLIMain.checkValidCommand(validCommand, args[0]);
            CommandLineParser clp = new CommandLineParser(args, validCommand);
            CommandValidator commandValidator = new CommandValidator();
            commandValidator.validateCommandAndOptions(validCommand, clp.getOptionsList(), clp.getOperands());
            Command command = CommandFactory.createCommand(validCommand, clp.getOptionsList(), clp.getValidEnvironmentOptions(), clp.getOperands());
            command.runCommand();
            return;
        }
        catch (HelpException he) {
            CLIMain.invokeHelpClass(he.getHelpClassName(), he.getCommandName(), he.getUsageText(), he.isShell());
        }
        catch (CommandValidationException cve) {
            throw new CommandValidationException(CLIMain.getUsageTextFromValidCommand(validCommand) + "\n" + cve.getLocalizedMessage());
        }
    }

    private static void invokeHelpClass(String helpClassName, String helpCommandName, String commandUsageText, boolean isShell) throws CommandException {
        try {
            Command helpCommand = null;
            Class<?> helpClass = Class.forName(helpClassName);
            helpCommand = (Command)helpClass.newInstance();
            helpCommand.setName(helpCommandName);
            if (helpCommandName != null) {
                helpCommand.setOperands(new Vector<String>(Arrays.asList(helpCommandName)));
            }
            if (isShell) {
                helpCommand.setOption("isMultiMode", "true");
                String interactiveVal = (String)CommandEnvironment.getInstance().getEnvironments().get("interactive");
                helpCommand.setOption("interactive", interactiveVal == null ? "true" : interactiveVal);
            }
            helpCommand.runCommand();
        }
        catch (Exception e) {
            if (commandUsageText == null) {
                throw new CommandException(CLIMain.getLocalizedString("NoUsageText", new Object[]{helpCommandName}));
            }
            CLILogger.getInstance().printMessage(CLIMain.getLocalizedString("Usage", new Object[]{commandUsageText}));
        }
    }

    private static String getUsageTextFromValidCommand(ValidCommand validCommand) {
        if (validCommand != null && validCommand.getUsageText() != null) {
            return CLIMain.getLocalizedString("Usage", new Object[]{validCommand.getUsageText()});
        }
        return "";
    }

    private static void checkValidCommand(ValidCommand validCommand, String commandName) throws CommandValidationException {
        if (validCommand == null) {
            throw new CommandValidationException(CLIMain.getLocalizedString("InvalidCommand", new Object[]{commandName}));
        }
    }

    private static void setCommandLocalizedProperty(Iterator localizePropertiesIter) throws CommandValidationException {
        LocalStringsManagerFactory.setCommandLocalStringsManagerProperties(localizePropertiesIter);
    }

    private static String getLocalizedString(String key, Object[] toInsert) {
        try {
            LocalStringsManager lsm = LocalStringsManagerFactory.getFrameworkLocalStringsManager();
            if (toInsert == null) {
                return lsm.getString(key);
            }
            return lsm.getString(key, toInsert);
        }
        catch (CommandValidationException cve) {
            return LocalStringsManager.DEFAULT_STRING_VALUE;
        }
    }

    private static String[] splitStringToArray(String line) throws CommandException {
        CLITokenizer cliTokenizer = new CLITokenizer(line, " ");
        String[] strArray = new String[cliTokenizer.countTokens()];
        int ii = 0;
        while (cliTokenizer.hasMoreTokens()) {
            strArray[ii++] = cliTokenizer.nextTokenWithoutEscapeAndQuoteChars();
            CLILogger.getInstance().printDebugMessage("CLIToken = [" + strArray[ii - 1] + "]");
        }
        return strArray;
    }
}

